package ibase.dashboard.scm.servlet;
import ibase.dashboard.scm.ejb.StateWiseStockRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.json.simple.JSONObject;

public class StateWiseStockServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		StateWiseStockRemote stateWiseStock = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String month = "";
		String brand = "";
		String division = "";
		String linkMetadata = "";
		String viewOptionSelectd ="";
		try
		{
			response.setContentType("application/xml");
			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");

			dataSourceName    = request.getParameter("dataSourceName"); 
			month             = request.getParameter("month");
			brand             = request.getParameter("brand");
			division          = request.getParameter("division");
			linkMetadata      = request.getParameter("reportName"); 
			viewOptionSelectd = request.getParameter("viewOptionSelectd");
			
			
			System.out.println(" in StateWiseStockServlet  month--"+month+"---brand--"+brand+"----division------"+division+"-------linkMetadata---"+linkMetadata);
			
			context = new InitialContext(appConnectParm.getProperty());
			stateWiseStock = (StateWiseStockRemote) context.lookup("ibase/StateWiseStock/remote");
			/*setUserInfo(userInfo) for DB connection on dated:14062016*/
			stateWiseStock.setUserInfo(userInfo);
			JSONObject jsonObjData      = (JSONObject)stateWiseStock.getIndiaMap(dataSourceName,month,brand,division,viewOptionSelectd);			
			OutputStream outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			
			System.out.println(" Final data set for StateWiseStockServlet build the Graph is===" + jsonObjData);	
			
		} catch (Exception e)
		{
			System.out.println("Exception : StateWiseStockServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
			  throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}