package ibase.webitm.ejb.adm;


import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.ejb.Stateless;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless
public class SiteStanPayTbl extends ValidatorEJB implements SiteStanPayTblLocal ,SiteStanPayTblRemote
{

	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}

	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 1 wfValData:::");
		GenericUtility genericUtility = GenericUtility.getInstance();

		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = "";
		System.out.println("xmlString ["+xmlString+"]");
		System.out.println("xmlString1["+xmlString1+"]");
		System.out.println("xmlString2["+xmlString2+"]");
		try
		{
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = parseString(xmlString); 
			}
			else
			{
				System.out.println("xmlstring is null");
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = parseString(xmlString1); 
			}
			else
			{
				System.out.println("xmlstring1 is null");
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = parseString(xmlString2);
			}
			else
			{
				System.out.println("xmlstring2 is null");
			}
			System.out.println("Before call valdata");
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [SiteStanPayTbl][wfValData(String xmlString)] : ==>\n"+e.getMessage());
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
			
		}
		return (errString); 
	}

	public String wfValData( Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		System.out.println("Came Inside 2 wfValData:::");
		String errString = "";
		Connection conn = null;
		
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);
			
			errString = wfValData( dom, dom1, dom2, objContext, editFlag, xtraParams,conn);
		}
		catch ( Exception e )
		{
			e.printStackTrace();
			errString = genericUtility.createErrorString(e);
		}
		finally
		{
			try
			{
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e1)
			{
				System.out.println( "Exception : [SiteStanPayTbl][wfValData(String xmlString)] : ==>\n"+e1.getMessage());
				throw new ITMException(e1);
			}
		}
		return errString;
	}

	public String wfValData(Document dom, Document dom1,Document dom2, String objContext, String editFlag, String xtraParams,Connection conn) throws RemoteException,ITMException
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String errString = "";
		String childNodeName = null; 
		String userId = "";
		String loginSiteCode = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int count = 0;
		int ctr,currentFormNo=0;
		int childNodeListLength;

		String siteCode = "";
		String stateCode = "";
		String stanCode = "";
		String payTable = "";


		GenericUtility genericUtility = GenericUtility.getInstance(); 

		try
		{	
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			System.out.println("loginSiteCode"+ loginSiteCode);

			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			switch(currentFormNo)
			{
				case 1:
					parentNodeList = dom.getElementsByTagName("Detail1");
					parentNode = parentNodeList.item(0);
					childNodeList = parentNode.getChildNodes();
					childNodeListLength = childNodeList.getLength();

					for(ctr = 0; ctr < childNodeListLength; ctr++)
					{
						childNode = childNodeList.item(ctr);
						childNodeName = childNode.getNodeName();
						if (childNodeName.equalsIgnoreCase("site_code"))
						{
							siteCode = getColumnValue("site_code",dom1,objContext);
							System.out.println("value of site_code:::: "+siteCode);
							System.out.println("Inside validation of site_code ");
							if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null))
							{
								System.out.println("site code null");
								errString = getErrorString("site_code","VMSITENULL",userId);
								break;
							}
							else
							{
								// To check site code is present or not
								sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?" ;
								pstmt = conn.prepareStatement(sql);					
								pstmt.setString(1,siteCode);
								rs = pstmt.executeQuery();					
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("value of count in site_code:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Site_code is not valid");
									errString = getErrorString("site_code","VMSITEINVD",userId);
									break;
								}
							}
	
						} //END IF (site_code)
						else if (childNodeName.equalsIgnoreCase("state_code"))
						{
							stateCode = getColumnValue("state_code",dom1,objContext);
							System.out.println("value of state_code:::: "+stateCode);
							System.out.println("Inside validation of state_code ");
							if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null))
							{
								System.out.println("state code null");
								errString = getErrorString("state_code","VMSTATNULL",userId);
								break;
							}
							else
							{
								// To check state code is present or not
								sql = "SELECT COUNT(*) AS COUNT FROM STATE WHERE STATE_CODE = ?" ;
								pstmt = conn.prepareStatement(sql);					
								pstmt.setString(1,stateCode);
								rs = pstmt.executeQuery();					
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("value of count in state_code:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("State_code is not valid");
									errString = getErrorString("state_code","VMSTATINVD",userId);
									break;
								}
							}
	
						} //END IF (state_code)
						else if (childNodeName.equalsIgnoreCase("stan_code"))
						{
							stanCode = getColumnValue("stan_code",dom1,objContext);
							stateCode = getColumnValue("state_code",dom1,objContext);
							System.out.println("value of stan_code:::: "+stanCode);
							System.out.println("value of state_code:::: "+stateCode);
							System.out.println("Inside validation of stan_code ");
							if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null))
							{
								System.out.println("station code null");
								errString = getErrorString("stan_code","VMSTANNULL",userId);
								break;
							}
							else if(stateCode != null && (stanCode != null && stanCode.trim().length()>0))
							{
								// To check stan code is present or not
								sql = "SELECT COUNT(*) AS COUNT FROM STATION WHERE STAN_CODE = ?" ;
								pstmt = conn.prepareStatement(sql);					
								pstmt.setString(1,stanCode);
								rs = pstmt.executeQuery();					
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("value of count in stan_code:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Stan_code is not valid");
									errString = getErrorString("stan_code","VMSTANINVD",userId);
									break;
								}
							
								sql = "SELECT COUNT(*) AS COUNT FROM STATION WHERE STAN_CODE = ? AND STATE_CODE = ?" ;
								pstmt = conn.prepareStatement(sql);					
								pstmt.setString(1,stanCode);
								pstmt.setString(2,stateCode);
								rs = pstmt.executeQuery();					
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("value of count in stan_code:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Stan_code is not valid");
									errString = getErrorString("stan_code","VMSTANSTCD",userId);
									break;
								}
							}
							//Added by Hemlata[17/07/2014][to validate duplicate entry for SITE_STAN_PAYTBL][start]
								//Added by Radheshyam[01/03/2014][to validate duplicate entry for SITE_STAN_PAYTBL][start]
								siteCode = getColumnValue("site_code",dom1,objContext);
								stateCode = getColumnValue("state_code",dom1,objContext);
								stanCode = getColumnValue("stan_code",dom1,objContext);
								System.out.println("value of count in siteCode:::: "+siteCode);
								System.out.println("value of count in stateCode:::: "+stateCode);
								System.out.println("value of count in stan_code:::: "+stanCode);
								sql = "SELECT COUNT(*) AS COUNT FROM SITE_STAN_PAYTBL WHERE site_code = ? AND STATE_CODE = ? AND STAN_CODE = ? ";
								pstmt = conn.prepareStatement(sql);					
								pstmt.setString(1,siteCode);
								pstmt.setString(2,stateCode);
								pstmt.setString(3,stanCode);
								rs = pstmt.executeQuery();					
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("value of count :::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count > 0)
								{
									System.out.println("Duplicate Entries");
									//errString = getErrorString("stan_code","VMSTANDUPL",userId);
									errString = getErrorString("stan_code","VMSTNPTBL1",userId);
									break;
								}
								
								//Added by Radheshyam[01/03/2014][to validate duplicate entry for SITE_STAN_PAYTBL][End]
//								Added by Hemlata[17/07/2014][to validate duplicate entry for SITE_STAN_PAYTBL][End]
							}
	
						 //END IF (stan_code)
						else if (childNodeName.equalsIgnoreCase("pay_table"))
						{
							payTable = getColumnValue("pay_table",dom1,objContext);
							System.out.println("value of pay_table:::: "+payTable);
							System.out.println("Inside validation of pay_table ");
							if ((childNode.getFirstChild() == null)||(childNode.getFirstChild() != null && childNode.getFirstChild().getNodeValue() == null))
							{
								System.out.println("pay_tabel null");
								errString = getErrorString("pay_table","VMPAYTBNUL",userId);
								break;
							}
							else
							{
								// To check stan code is present or not
								sql = "SELECT COUNT(*) AS COUNT FROM PAYTABLE WHERE PAY_TABLE = ?" ;
								pstmt = conn.prepareStatement(sql);					
								pstmt.setString(1,payTable);
								rs = pstmt.executeQuery();					
								if( rs.next() )
								{
									count  = rs.getInt("COUNT");
								}
								System.out.println("value of count in paytable:::: "+count);
								if ( rs != null )
								{
									rs.close();
									rs = null;
								}
								if ( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}
								if(count == 0)
								{
									System.out.println("Pay table is not valid");
									errString = getErrorString("pay_table","VMPTBLINVD",userId);
									break;
								}
							}
	
						} //END IF (pay_table)
						
						}//END FOR
						break;
				}//END SWITCH
			}//END TRY
			catch(Exception e)
			{
				System.out.println("Exception ::"+ e.getMessage());
				throw new ITMException(e);
			}
			finally
			{
				try
				{

				}
				catch(Exception d)
				{
					
				}
			}
			System.out.println("ErrString ::"+ errString);
			return errString;
		}//END OF VALIDATION 

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String errString = null;
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			System.out.println("xmlString ["+xmlString+"]");
			System.out.println("xmlString1 ["+xmlString1+"]");
			System.out.println("xmlString2 ["+xmlString2+"]");
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			errString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :SiteStanPayTbl :" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from SiteStanPayTbl " );
		return errString;
	}
	
	public String itemChanged(Document dom, Document dom1,Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String siteDescr = "";
		String stateDescr = "";
		String stanDescr = "";
		String payTableDescr = "";
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		GenericUtility genericUtility = GenericUtility.getInstance();
		
		try
		{	
			conn = connDriver.getConnectDB("Driver");
			conn.setAutoCommit(false);

			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			System.out.println("[SiteStanPayTbl] [itemChanged] :currentFormNo ....." +currentFormNo);
			valueXmlString = new StringBuffer("<?xml version=\"1.0\"?><Root><header><editFlag>");
			valueXmlString.append(editFlag).append("</editFlag></header>");
			
			System.out.println("In Detail1");
			System.out.println("Current Form No ["+currentFormNo+"]");	
			System.out.println("Current column is["+currentColumn+"]");
			System.out.println("xtraparam is ["+xtraParams+"]");
			
			
			String objNameDefault = "";
			switch (currentFormNo)
			{
				case 1:	
						// Modifide by Piyush on 25/03/2013 to make workable from ITM
						//valueXmlString.append("<Detail1 domID='1' dbID='' objContext='1' objName='"+objNameDefault+"' selected='Y'>\r\n");
						valueXmlString.append("<Detail1>\r\n");
						if(currentColumn.trim().equalsIgnoreCase("itm_default"))
						{
							String loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSite");
							sql = null;
							siteDescr = "";
							sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
							
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,loginSite);							
							rs = pstmt.executeQuery();
							
							if( rs.next())
							{
								siteDescr = checkNull(rs.getString("DESCR"));				
							}
							
							if( rs != null )
							{
								rs.close();
								rs = null;
							}
							if( pstmt != null )
							{
								pstmt.close();
								pstmt = null;
							}	
										
							valueXmlString.append("<site_code><![CDATA[").append(loginSite).append("]]></site_code>\r\n");
							valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append("]]></site_descr>\r\n");
							valueXmlString.append("<stan_code><![CDATA[").append(" ").append("]]></stan_code>\r\n");
						}
						else if (currentColumn.trim().equalsIgnoreCase("site_code"))
						{	
							System.out.println("Current column is"+currentColumn);					
							System.out.println("INSIDE site_code");
							String siteCode = getColumnValue("site_code",dom,"1");
							System.out.println("value of site_code:::::"+siteCode);
					
							if(siteCode != null && siteCode.length() > 0)
							{
								sql = null;
								sql = "SELECT DESCR FROM SITE WHERE SITE_CODE = ?";
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,siteCode);							
								rs = pstmt.executeQuery();
								
								if( rs.next())
								{
									siteDescr = checkNull(rs.getString("DESCR"));				
								}
								
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}	
											
								valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append("]]></site_descr>\r\n");
							}
							else
							{
								valueXmlString.append("<site_descr><![CDATA[").append("").append("]]></site_descr>\r\n");
							}
						}
						else if (currentColumn.trim().equalsIgnoreCase("state_code"))
						{	
							System.out.println("Current column is"+currentColumn);					
							System.out.println("INSIDE state_code");
							String stateCode = getColumnValue("state_code",dom,"1");
							System.out.println("value of state_code:::::"+stateCode);
						
							if(stateCode != null && stateCode.length() > 0)
							{
								sql = null;
								sql = "SELECT DESCR FROM STATE WHERE STATE_CODE = ?";
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,stateCode);							
								rs = pstmt.executeQuery();
								
								if( rs.next())
								{
									stateDescr = checkNull(rs.getString("DESCR"));				
								}
								
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}	
									
								valueXmlString.append("<state_descr><![CDATA[").append(stateDescr).append("]]></state_descr>\r\n");
							}
							else
							{
								valueXmlString.append("<state_descr><![CDATA[").append("").append("]]></state_descr>\r\n");
							}
						}
							
							
						else if (currentColumn.trim().equalsIgnoreCase("stan_code"))
						{	
							System.out.println("Current column is"+currentColumn);					
							System.out.println("INSIDE stan_code");
							String stanCode = getColumnValue("stan_code",dom,"1");
							System.out.println("value of site_code:::::"+stanCode);
						
							if(stanCode != null && stanCode.length() > 0)
							{
								sql = null;
								sql = "SELECT DESCR FROM STATION WHERE STAN_CODE = ?";
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,stanCode);							
								rs = pstmt.executeQuery();
								
								if( rs.next())
								{
									stanDescr = checkNull(rs.getString("DESCR"));				
								}
								
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}	
										
								valueXmlString.append("<station_descr><![CDATA[").append(stanDescr).append("]]></station_descr>\r\n");
							}
							else
							{
								valueXmlString.append("<station_descr><![CDATA[").append("").append("]]></station_descr>\r\n");
							}

						}
						
						else if (currentColumn.trim().equalsIgnoreCase("pay_table"))
						{	
							System.out.println("Current column is"+currentColumn);					
							System.out.println("INSIDE pay_table");
							String payTable = getColumnValue("pay_table",dom,"1");
							System.out.println("value of site_code:::::"+payTable);
													
							if(payTable != null && payTable.length() > 0)
							{
								sql = null;
								sql = "SELECT DESCR FROM PAYTABLE WHERE PAY_TABLE = ?";
								
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,payTable);							
								rs = pstmt.executeQuery();
								
								if( rs.next())
								{
									payTableDescr = checkNull(rs.getString("DESCR"));				
								}
								
								if( rs != null )
								{
									rs.close();
									rs = null;
								}
								if( pstmt != null )
								{
									pstmt.close();
									pstmt = null;
								}	
								valueXmlString.append("<paytable_descr><![CDATA[").append(payTableDescr).append("]]></paytable_descr>\r\n");
							}
							else
							{
								valueXmlString.append("<paytable_descr><![CDATA[").append("").append("]]></paytable_descr>\r\n");
							}

						}
						valueXmlString.append("</Detail1>\r\n");
				
					break;	
			}//END OF SWITCH
		}//END OF TRY		
		catch(Exception e)
		{
			System.out.println("Exception in SiteStanPayTbl::"+ e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( conn != null )
				{
					conn.close();
					conn = null;
				}

			}
			catch(Exception e1)
			{
				System.out.println("Exception in SiteStanPayTbl::"+ e1.getMessage());
				throw new ITMException(e1);
			}			
		}
		valueXmlString.append("</Root>\r\n");
		System.out.println("valueXmlString"+valueXmlString.toString());
		return valueXmlString.toString();
		
	}//END OF ITEMCHANGE

	private String checkNull( String input )
	{
		if (input == null)
		{
			input = "";
		}
		else
		{
			input = input.trim();
		}
		return input;
	}

}
