package ibase.webitm.ejb.fin;

import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ITMDBAccessLocal;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.ActionHandlerEJB;
import java.sql.*;
import java.util.StringTokenizer;

import javax.ejb.Stateless;
import java.rmi.RemoteException;

@Stateless
public class StrgCustBankConf extends ActionHandlerEJB implements StrgCustBankConfLocal,StrgCustBankConfRemote
{

	public String confirm(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------confirm method of StrgCustBankConf ------------- : "+tranId);
		String retString = "";		
		try
		{
						
				retString = confirmSCBank(tranId,xtraParams,forcedFlag);
			
		}
		catch(Exception e)
		{
			System.out.println("Exception :StrgCustBankConf :confirm():" + e.getMessage() + ":");
			retString = GenericUtility.getInstance().createErrorString(e);
			e.printStackTrace();
		}
		
		return retString;
	}
	
	private String confirmSCBank(String tranId,String xtraParams,String forcedFlag) 
	{
		System.out.println("---------Class : StrgCustBankConf-->> confirm method called-----------");   
		String scCode = null;
		String bankcode = null;
		ResultSet rs=null;
		Connection conn=null;
		ConnDriver ConnDriver = new ConnDriver();
		PreparedStatement pstmt=null;
		String errString="",sql="",loginSite="",ActiveYN="",itemCode="",regulatedPrice="";
		String itmCodeDt2="",lotNo="",lotSl="", detail2xmlString="";
		double invRate=0.0,invQty=0.0,PODrate=0.0,PODqty=0.0,allowedAmt=0.0,stockistAmt=0.0,debitNoteAmtAct=0.0;
		int updCnt=0,lineNo=0;
		ITMDBAccessLocal itmdbAccess=new ITMDBAccessEJB();
		try
		{		
			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverValidator");			
			conn.setAutoCommit(false);
			String confirmed="";
			String[] pkValuesArr = string2StringArray(tranId, ":");
			scCode = pkValuesArr[0].trim();
			bankcode = pkValuesArr[1].trim();
			
			sql = "select confirmed,active_yn from strg_cust_bank WHERE sc_code = ? and bank_code__ben = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, scCode);
			pstmt.setString(2, bankcode);
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =rs.getString(1)==null ? "N":rs.getString(1);
				ActiveYN=rs.getString(2)==null ? "Y" : rs.getString(2);
			}	
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			
			if( confirmed != null && confirmed.equalsIgnoreCase("Y") )
			{
				
				System.out.println("transaction is already confirmmmm");
				//if already confirm then show error
				errString = itmdbAccess.getErrorString("", "VTALCONF", "", "", conn);
				return errString;
			}	
			if( ActiveYN != null && ActiveYN.equalsIgnoreCase("N") )
			{
				//right
				System.out.println("deactivated transaction can not be confirmmm");
				//Deactivated transaction can not confirm
				errString = itmdbAccess.getErrorString("", "VMDECTRA", "", "", conn);
				return errString;
			}	
			
			
			
			GenericUtility genericUtility=new GenericUtility();
			String loginCode=genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("Login Code ------->> "+loginCode);
			sql="update strg_cust_bank set confirmed = ?,conf_date = ?, emp_code__aprv = ? where sc_code = ? and bank_code__ben = ? ";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, "Y");
			pstmt.setDate(2, new java.sql.Date(System.currentTimeMillis()));
			pstmt.setString(3,loginCode);		
			pstmt.setString(4, scCode);
			pstmt.setString(5, bankcode);
			updCnt=pstmt.executeUpdate();
			
			if (updCnt > 0)
			{	
				System.out.println("successfully confirmed");
				
				conn.commit();
				errString = itmdbAccess.getErrorString("", "VTCONSUCC", "", "", conn);
				return errString;
			}
			
		}
		catch(SQLException se)
		{
			System.out.println("SQLException : class StrgCustBankConf : ");
			se.printStackTrace();
			try
			{
			  conn.rollback();
			}
			catch(Exception e){
				System.out.println("Exception : Occure during rollback........");e.printStackTrace();
				}
		}
		catch(Exception e)
		{
			try
			{
				conn.rollback();
			}
			catch (Exception e1)
			{
			}
			e.printStackTrace();
			System.out.println("Exception Class [StrgCustBankConf]::"+e.getMessage());
			
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}	
				if (conn!=null)
				{
					conn.close();
					conn=null;
				}
							
			}
			catch(Exception e)
			{
				System.out.println(e.getMessage());
				e.printStackTrace();
				
			}
		}
		System.out.println("[StrgCustBankConf]errstring :"+errString);
		return errString;
	
}
	private String[] string2StringArray(String str1 , String delimeter)
	{
		StringTokenizer st = new StringTokenizer(str1,delimeter);
		int count = st.countTokens() ;
		System.out.println("TOKEN COUNT"+count);
		String[] arry1 = new String[count];
		int i =  0;
		while(st.hasMoreTokens()) 
		{
			arry1[i] = st.nextToken();
			System.out.println("Token "+i+" :["+arry1[i]+"]");
			i++;
		}
		return arry1 ;	
	}
	
}
