package ibase.webitm.servlet.gst;
import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.gst.GSTPurcUploadExcelTemplate;
import ibase.webitm.ejb.gst.GSTUploadExcelTemplate;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import com.oreilly.servlet.multipart.FilePart;
import com.oreilly.servlet.multipart.MultipartParser;
import com.oreilly.servlet.multipart.ParamPart;
import com.oreilly.servlet.multipart.Part;

import jxl.Cell;
import jxl.Range;
import jxl.Sheet;
import jxl.Workbook;
import jxl.read.biff.BiffException;

@WebServlet("/GSTExcel")
public class UploadGstExcelServlet extends HttpServlet {
	GSTUploadExcelTemplate Ec = new GSTUploadExcelTemplate();
	GSTPurcUploadExcelTemplate purc = new GSTPurcUploadExcelTemplate();
	
	InitialContext ctx = null;
	private static final long serialVersionUID = 1L;
	
	public static File DUMP_DIR;
	
	private static File LOG_DUMP_DIR;
	
	private static int MAX_UPLOAD_SIZE = 10*1024*1024;
	ServletContext servletContext = null;
	ServletConfig servletConfig = null;
	public void init(ServletConfig servletConfig) throws ServletException
	{
		try
		{
			this.servletConfig = servletConfig;
			this.servletContext = servletConfig.getServletContext();
					
			if( CommonConstants.UPLOAD_LOC == null && CommonConstants.J2EE_VERSION.equals( "1" ))
			{
				System.out.println("UPLOAD_LOC is null");
				DUMP_DIR = new File(( new File( CommonConstants.APPLICATION_CONTEXT ) ).getParentFile().getParent() + File.separator + "dump" );				
				LOG_DUMP_DIR = new File( DUMP_DIR .getParent()  + File.separator + "logs") ;
			}
			else
			{
				 System.out.println("DUMP LOG::");
				DUMP_DIR = new File( ( new File( CommonConstants.UPLOAD_LOC ) ) + File.separator + "dump" );
				if ( ! DUMP_DIR.exists() )
				{
					DUMP_DIR.mkdir();
				}
				
				LOG_DUMP_DIR = new File( ( new File( CommonConstants.UPLOAD_LOC ) ) + File.separator + "logs" );
				if ( ! LOG_DUMP_DIR.exists() )
				{
					LOG_DUMP_DIR.mkdir();
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
    public UploadGstExcelServlet() {
        super();
    }
    
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException 
	{
		
	//	MultipartParser parser = new MultipartParser(request,10 * 1024 * 1024);
		
		String errorMessage="",responseTemp="",excelFilePath="";
		String objName= request.getParameter("requestType");
		System.out.println("objName in servlet :" +objName);
		boolean isError = false;
		try
		{
			UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute("USER_INFO");
			DiskFileItemFactory factory = new DiskFileItemFactory();
			ServletFileUpload upload = new ServletFileUpload(factory);
			List<FileItem> items = upload.parseRequest(request);
			Iterator<FileItem> iter = items.iterator();
			File uploadDir = new File(CommonConstants.TEMP_FOLDER);
			uploadDir.mkdir();
			String fileName =  "",fileValue="";
			while (iter.hasNext()) 
			{
				FileItem item = iter.next();
				if (!item.isFormField()) 
				{
					fileName = item.getName();
					if (fileName != null)
					{
						excelFilePath = uploadDir + File.separator+ fileName;
						File excelFile = new File(excelFilePath);
						item.write(excelFile);
						System.out.println("excelFilePath : " + excelFile);
					}
				}
				else
				{
					String Name = item.getFieldName();
					System.out.println("Name :"+Name);
				    fileValue = item.getString();
			     	//String fileValue = item.getString();
				    if(Name.equalsIgnoreCase("submitValue"))
				    {
				    	objName = fileValue;
				    	System.out.println("fName :"+fileValue);
				    }
				}
			}
			excelFilePath = uploadDir + File.separator+ fileName;
			File excelFile = new File(excelFilePath);
			System.out.println("filename: " + excelFile);
			Workbook workbook = Workbook.getWorkbook(excelFile);
			{
				System.out.println("Inside workbook :");
				if("gstr".equalsIgnoreCase(objName))
				{
					System.out.println("objName :" +objName);
				//	retArray = loadFile(request, userInfo.getLoginCode());
					
					String header ="<HTML><BODY BGCOLOR=\"WHITE\"><DIV ID=\"Section1\" STYLE=\"background: #3bb3c3 ;top=7%;left=1%;position=absolute;WIDTH =100%\">  Upload Status</DIV><DIV ID=\"Section3\" STYLE=\"background: WHITE;overflow:auto;height:88%;width:88%;position:absolute;WIDTH =100%\"><CENTER><TABLE WIDTH=700 BORDER=1 CELLPADDING=2 CELLSPACING=0 STYLE=\"page-break-before: always\"><COL WIDTH=350>";
					
					String footer = "</TABLE></CENTER></DIV></TABLE></DIV><br><a href=\"/ibase/jsp/UploadeGstTemplate.jsp\">Back</a></BODY></HTML>";
					
					
					responseTemp= Ec.readExcelfile(workbook, userInfo,DUMP_DIR,fileName,objName);
					
					responseTemp=header+responseTemp+footer;
				}
				else if ("gstr_purc".equalsIgnoreCase(objName))
				{
					System.out.println("objName :" +objName);
					
                    String header ="<HTML><BODY BGCOLOR=\"WHITE\"><DIV ID=\"Section1\" STYLE=\"background: #3bb3c3 ;top=7%;left=1%;position=absolute;WIDTH =100%\">  Upload Status</DIV><DIV ID=\"Section3\" STYLE=\"background: WHITE;overflow:auto;height:99%;width:88%;position:absolute;WIDTH =100%\"><CENTER><TABLE WIDTH=700 BORDER=1 CELLPADDING=2 CELLSPACING=0 STYLE=\"page-break-before: always\"><COL WIDTH=350>";
					
					String footer = "</TABLE></CENTER></DIV></TABLE></DIV><br><a href=\"/ibase/jsp/UploadeGstTemplate.jsp\">Back</a></BODY></HTML>";
					
					
					responseTemp= purc.readExcelfile(workbook, userInfo,DUMP_DIR,fileName,objName);
					
					responseTemp=header+responseTemp+footer;
				}
				if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(responseTemp.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(responseTemp.getBytes());
					outStream.flush();
					outStream.close();
				}
				System.out.println("Sheets Upload.." );
			}
		}catch(Exception  e1)
		{
			isError=true;
			errorMessage=e1.getMessage();
		}
		finally
		{
			if(isError)
			{
				if(CommonConstants.CONTENT_ENCODING != null && CommonConstants.CONTENT_ENCODING.equalsIgnoreCase("gzip"))
				{
					response.setHeader("Content-Encoding", "gzip");
					GZIPOutputStream gzOutStream = new GZIPOutputStream(response.getOutputStream());
					gzOutStream.write(errorMessage.getBytes());
					gzOutStream.flush();
					gzOutStream.close();
				}
				else
				{
					response.setHeader("Content-Encoding", "");
					OutputStream outStream = response.getOutputStream();
					outStream.write(errorMessage.getBytes());
					outStream.flush();
					outStream.close();
				}
			}
			
		}
		
		
	}
	
	//private String[] loadFile( HttpServletRequest request, String loginCode )throws Exception 
	{/*
		String newFileName = null;
		//Changed by Danish on 11/07/07 in case of xsl file provided
		//String [] retArray = new String[3];
		//Changed by Swapnil on 05-Aug-2010 [AD90SUP002] To allow file uploading of given OBJ_NAME
		//String [] retArray = new String[4];
		//Changed by Yogesh on 20/04/11[FARONOV001 | to get checkbox status from UploadFile.jsp]
		//String [] retArray = new String[5];
		//String [] retArray = new String[6];
	
		try
		{

		    this.servletContext.log( "["+loginCode+"]Uploading file......" );
			MultipartParser mp = new MultipartParser( request, MAX_UPLOAD_SIZE );
			Part part;
			while ( ( part = mp.readNextPart() ) != null )
			{
				String name = part.getName();	
				if ( part.isParam() )
				{
				  // it's a parameter part
				  ParamPart paramPart = (ParamPart) part;
				  String value = paramPart.getStringValue();
				  if( ( part.getName().trim()).equals("IS_INTERACTIVE" ) )
				  {
						retArray[0] = value;
				  }
				  else if( ( part.getName().trim()).equals( "OBJ_NAME" ) )
				  {
						retArray[2] = value;
				  }
				  //Added By Yogesh on 19/04/11 [FARONOV001| to check whether checkbox is checked for Excel Driver ]start
				  else if( ( part.getName().trim()).equals( "is_ExcelDriver" ) )
				  {
						retArray[5] = value;						
				  }
				  //Added By Yogesh on 19/04/11 [FARONOV001| to check whether checkbox is checked for Excel Driver ]end
				  //Changed by Swapnil on 05-Aug-2010 [AD90SUP002] To allow file uploading of given OBJ_NAME only starts
				  else if( ( part.getName().trim()).equals( "menuObjName" ) )
				  {
					  System.out.println("ITMUploadFileServletpart.getName().trim()).equals( menuObjName ).value["+value+"]");
					  retArray[4] = value;
				  }
				  //Changed by Swapnil on 05-Aug-2010 [AD90SUP002] To allow file uploading of given OBJ_NAME only ends
				  //Added By Pankaj T on 16-06-17 [F16KSUN001| to check whether checkbox is checked for Retain Primary Key from xml] - Start
				  else if( ( part.getName().trim()).equals( "is_retainPkValue" ) )
				  {
						retArray[6] = value;
				  }
				  //Added By Pankaj T on 16-06-17 [F16KSUN001| to check whether checkbox is checked for Retain Primary Key from xml] - End
				}
				else if ( part.isFile() )
				{
					//it's a file part
					FilePart filePart = (FilePart) part;
					String oriFileName = filePart.getFileName();
					newFileName = System.currentTimeMillis() + "_" + loginCode + "_" + oriFileName;
					//Changed by Danish on 11/07/07 in case of xsl file provided
					//retArray[1] = newFileName;
					if ( "filefieldXSL".equals( part.getName() ) )
					{
						retArray[3] = oriFileName;
					}
					else
					{
						retArray[1] = newFileName;
					}
					//Changed by Danish on 11/07/07 in case of xsl file provided
					long size = filePart.writeTo( DUMP_DIR );
					File oriFileObj = new File( DUMP_DIR + File.separator + oriFileName );
					if(oriFileObj.exists())
					{
						oriFileObj.renameTo( new File( DUMP_DIR + File.separator + newFileName ) );
					}
				}
			}

		    this.servletContext.log("["+loginCode+"]File uploaded");

		}
		catch (IOException lEx)
		{
			this.servletContext.log("["+loginCode+"]Exception :ITMUploadFileServlet :loadFile :==>IOException");
			throw lEx;
		}
		catch (Exception e)
		{
			this.servletContext.log("["+loginCode+"]Exception :ITMUploadFileServlet :loadFile :==>Exception");
			throw e;
		}		
		return retArray;
	*/}
	
	

}
