/********************************************************
	Title 	 : SorderCancel
	Date  	 : 27/SEP/16
	Developer: Nasruddin Khan.
 ********************************************************/

package ibase.webitm.ejb.dis.adv;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.ejb.dis.StockUpdate;
import ibase.webitm.utility.ITMException;
import javax.ejb.Stateless;



@Stateless
public class SorderCancel extends ActionHandlerEJB implements SorderCancelLocal, SorderCancelRemote
{
	E12GenericUtility genericUtility= new  E12GenericUtility();
	ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
	String userId = "";
	String termId = "";
	public String confirm(String tranId,String xtraParams,String forcedFlag) throws RemoteException,ITMException
	{
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		String sql = "";
		Date currDate = new Date();
		SimpleDateFormat sdf = null;
		String currDateStr = null;
		String DB = CommonConstants.DB_NAME;
		DateFormat dateFormat = null;
		String confirmed = "";
		String status = "";
		String contractNo = "";
		String errString = "";
		boolean isError = false;
		String mItemFlag = "";
		String mLineNoContr = "";
		String mLineNo = "";
		String mItemCodeOrd = "";
		double lcSordQty = 0.0, mQtyOrd = 0.0;
		int effectRow = 0, lcStat = 0;
		String  mQuatNo = "";
		String ls_gf_auto_close_excecuted = "N";
		String mStat = "";
		String mstatrem = "";
		Timestamp toDay = null;
		SaleOrderRelease orderRelease = new SaleOrderRelease();
		boolean isTranExist = false;
	
		try
		{
			dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			System.out.println("dateFormat ["+dateFormat+"]");
			String applDateFormat = genericUtility.getApplDateFormat();
			sdf = new SimpleDateFormat(applDateFormat);
			currDateStr = sdf.format(currDate);
			System.out.println("currDateStr ["+ currDateStr + "]");
			termId = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
			userId = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode"));
			conn = getConnection();						toDay = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
			toDay = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
			if( DB.equalsIgnoreCase("db2") || DB.equalsIgnoreCase("mysql"))
			{
				sql = "SELECT CONFIRMED, STATUS, CONTRACT_NO FROM SORDER WHERE SALE_ORDER = ? FOR UPDATE";

			}
			else if( DB.equalsIgnoreCase("mssql") )
			{
				sql = "SELECT CONFIRMED, STATUS, CONTRACT_NO FROM SORDER  (UPDLOCK) WHERE SALE_ORDER = ? ";

			}
			else
			{

				sql = "SELECT CONFIRMED, STATUS, CONTRACT_NO FROM SORDER WHERE SALE_ORDER = ? FOR UPDATE NOWAIT";
			}
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId.trim());
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed =	checkNull(rs.getString("CONFIRMED"));
				status =	checkNull(rs.getString("STATUS"));
				contractNo =	checkNull(rs.getString("CONTRACT_NO"));
				isTranExist = true;
			}
			pstmt.close();
			pstmt = null;
			rs.close();
			rs = null;
			if(!isTranExist)
			{
				errString = itmDBAccessLocal.getErrorString("", "VTLCKERR", "");
				return errString;
			}

			System.out.println("confirmed ==>["+confirmed+"] status ==>["+status+" ]contractNo==> [ " +contractNo+"]");
			if( status.equalsIgnoreCase("X"))
			{
				errString = itmDBAccessLocal.getErrorString("", "VTCANC2", "");
				return errString;	
			}
			else if( status.equalsIgnoreCase("C") )
			{
				errString = itmDBAccessLocal.getErrorString("", "VTCANC5", "");
				return errString;
			}

			sql = "	SELECT ITEM_FLG, LINE_NO__CONTR, LINE_NO , ITEM_CODE  , QUANTITY FROM SORDDET WHERE SALE_ORDER = ?  ORDER BY LINE_NO";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId.trim());
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				mItemFlag = checkNull(rs.getString("ITEM_FLG"));
				mLineNoContr = checkNull(rs.getString("LINE_NO__CONTR"));
				mLineNo = checkNull(rs.getString("LINE_NO"));
				mItemCodeOrd = checkNull(rs.getString("ITEM_CODE"));
				lcSordQty = (Double)rs.getDouble("QUANTITY") == null ? 0.0 : rs.getDouble("QUANTITY")  ;

				System.out.println("mItemFlag ==>"+mItemFlag);
				System.out.println("mLineNoContr ==>"+mLineNoContr);
				System.out.println("mLineNo ==>"+mLineNo);
				System.out.println("mItemCodeOrd ==>"+mItemCodeOrd);
				System.out.println("lcSordQty ==>"+lcSordQty);

				if( !("I").equalsIgnoreCase(mItemFlag))
				{
					errString = itmDBAccessLocal.getErrorString("", "VTCANC4", "");
					return errString;
				}
				else
				{
					sql = "SELECT QUANTITY - QTY_DESP AS QTYORD FROM SORDITEM  WHERE SALE_ORDER = ? AND LINE_NO = ?";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, tranId.trim());
					pstmt1.setString(2, mLineNo);
					rs1 = pstmt1.executeQuery();
					if( rs1.next() )
					{
						mQtyOrd = (Double)rs1.getDouble("QTYORD") == null ? 0 : rs1.getDouble("QTYORD")  ;
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if( mQtyOrd != 0)
					{
						sql = "UPDATE SCONTRACTDET SET REL_QTY = REL_QTY - ? WHERE CONTRACT_NO = ? 	AND LINE_NO = ?";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setDouble(1, mQtyOrd);
						pstmt1.setString(2, contractNo);
						pstmt1.setString(3, mLineNoContr);
						effectRow = pstmt.executeUpdate();
						System.out.println("Number Of Effected Row SCONTRACTDET table ["+ effectRow + "]" );
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
					}
					sql = "SELECT QUOT_NO  FROM SORDER WHERE SALE_ORDER = ?";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, tranId.trim());
					rs1 = pstmt1.executeQuery();
					if( rs1.next() )
					{
						mQuatNo = checkNull(rs.getString("QUOT_NO"));
					}
					if(pstmt1 != null)
					{
						pstmt1.close();
						pstmt1 = null;
					}
					if(rs1 != null)
					{
						rs1.close();
						rs1 = null;
					}
					if( mQuatNo != null && mQuatNo.length() > 0)
					{
						sql = " UPDATE SALES_QUOTDET	 " +
								" SET  	REL_QTY = (CASE WHEN REL_QTY IS NULL THEN 0 ELSE REL_QTY END)  - ?,	" +
								" REL_DATE = ?,	  " +
								" BAL_QTY = (CASE WHEN BAL_QTY IS NULL THEN 0 ELSE BAL_QTY END)  + ? " +
								" WHERE QUOT_NO = ? " +
								" and item_code = ? ";
						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setDouble(1, lcSordQty);
						pstmt1.setTimestamp(2, toDay);
						pstmt1.setDouble(3, lcSordQty);
						pstmt1.setString(4, mQuatNo);
						pstmt1.setString(5, mItemCodeOrd);
						effectRow = pstmt.executeUpdate();
						System.out.println("Number Of Effected Row SALES_QUOTDET table ["+ effectRow + "]" );
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}
			}
			if(errString.trim().length() > 0)
			{
				if("N".equalsIgnoreCase(confirmed))
				{
					ls_gf_auto_close_excecuted = "N";
					System.out.println("ls_gf_auto_close_excecuted ["+ls_gf_auto_close_excecuted);
					mStat = "X";
				}
				else
				{
					ls_gf_auto_close_excecuted = "Y";
					errString = gfAutoClose(tranId, mStat);
				}
				if(errString != null && errString.trim().length() > 0)
				{
					if( ls_gf_auto_close_excecuted.equalsIgnoreCase("Y"))
					{
						sql = " UPDATE SORDER " +
								" SET STATUS = ?, " +
								" STATUS_REMARKS = ?," +
								" ALLOC_FLAG = 'N'	" +
								" WHERE SALE_ORDER 	= ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, mStat);
						pstmt.setString(2, mstatrem);
						pstmt.setString(3, tranId);
						effectRow = pstmt.executeUpdate();
						System.out.println("Number Of Effected Row SORDER table ["+ effectRow + "]" );
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
					}
					/*DateFormat df = new SimpleDateFormat("dd-mm-yy");
				lsDate = df.format((currDateStr));*/
					if( mStat.equalsIgnoreCase("C"))
					{
						lcStat = 1;	
					}
					else
					{
						lcStat = 2;
					}
					toDay = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
					errString = orderRelease.sorderStatusLog(tranId, toDay, lcStat, xtraParams, mLineNo, "", "", "", conn);
					if( errString != null && errString.trim().length() > 0)
					{
						sql = "UPDATE SORDITEM SET STATUS = ?	WHERE SALE_ORDER =  ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, mStat);
						pstmt.setString(2, tranId.trim());
						effectRow = pstmt.executeUpdate();
						System.out.println("Effected Rows effectRow:::"+effectRow);
					}
					sql = "  UPDATE SORDER " +
							" SET STATUS = ?, " +
							" STATUS_REMARKS = ?," +
							" ALLOC_FLAG = 'N'	" +
							" WHERE SALE_ORDER 	= ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, mStat);
					pstmt.setString(2, mstatrem);
					pstmt.setString(3, tranId);
					effectRow = pstmt.executeUpdate();
					System.out.println("Number Of Effected Row SORDER table ["+ effectRow + "]" );
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}

		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("SorderCancel.confirm()==>>"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch( Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return errString;
	}

	@SuppressWarnings("resource")
	public String gfAutoClose(String mSaleOrder, String mStat) 
	{
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		double ldQtyAlloc = 0, ldQtyDesp = 0, mQtyAlloc = 0 , mQtyDesp = 0;
		Date mtday = null;
		int	llCnt = 0;
		SimpleDateFormat sdf = null;
		String currDateStr = null;
		String sql = "";
		String confirmed = "";
		int cnt = 0;
		String errString = "";
		boolean isError = false;
		Timestamp currDate = null;
		try
		{
			mStat = "";
			mtday = new Date();
			System.out.println("dateFormat ["+mtday+"]");
			String applDateFormat = genericUtility.getApplDateFormat();
			sdf = new SimpleDateFormat(applDateFormat);
			currDateStr = sdf.format(mtday);
			currDate = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
			System.out.println("currDateStr ["+ currDateStr + "]");
			sql = "SELECT CONFIRMED  FROM SORDER where sale_order = ?";
			conn = getConnection();
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, mSaleOrder.trim());
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				confirmed = rs.getString("CONFIRMED");
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( confirmed == null )
			{
				confirmed = "N";
			}
			if( confirmed == "N")
			{
				mStat = "C";
			}
			else
			{
				sql = "SELECT COUNT(1)  FROM SORDALLOC WHERE SALE_ORDER = ? AND CASE WHEN STATUS IS NULL THEN 'P' ELSE STATUS END <> 'D' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, mSaleOrder.trim());
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					cnt = rs.getInt(1);
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if(cnt > 0)
				{
					errString = itmDBAccessLocal.getErrorString("", "VTALLOC02", "");
					return errString;	
				}
				sql = "SELECT SUM(QTY_ALLOC) AS LD_QTY_ALLOC, SUM(QTY_DESP) AS LD_QTY_DESP 	FROM SORDITEM WHERE SALE_ORDER = ?  AND LINE_TYPE = 'I'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, mSaleOrder.trim());
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					ldQtyAlloc = rs.getDouble("LD_QTY_ALLOC");
					ldQtyDesp = rs.getDouble("LD_QTY_DESP");
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( ldQtyAlloc == 0 && ldQtyDesp == 0 )
				{
					mStat = "X";
				}
				else
				{
					sql = "select QTY_ALLOC, QTY_DESP from SORDITEM where SALE_ORDER = ? and LINE_TYPE = 'I'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, mSaleOrder.trim());
					rs = pstmt.executeQuery();
					while( rs.next() )
					{
						mQtyAlloc = rs.getDouble("QTY_ALLOC");
						mQtyDesp = rs.getDouble("QTY_DESP");
						if( mQtyAlloc <= mQtyDesp)
						{
							mStat = "C";
						}

						errString = gfAutoCloseExt(mSaleOrder, mStat);
						if( errString.trim().length() == 0 )
						{
							if( confirmed == "M")
							{
								sql = "UPDATE SORDER	SET STATUS = ?, STATUS_DATE = ? 	WHERE SALE_ORDER = ?";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, mStat.trim());
								pstmt1.setTimestamp(2, currDate);
								pstmt1.setString(3, mSaleOrder.trim());
								llCnt = pstmt.executeUpdate();
								System.out.println("Number od effect rows in SORDER table =====>"+llCnt);
								if( pstmt1 != null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
							}
							else
							{
								sql = "UPDATE SORDITEM SET STATUS = ? WHERE SALE_ORDER = ?";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, mStat.trim());
								pstmt1.setString(2, mSaleOrder.trim());
								llCnt = pstmt1.executeUpdate();
								System.out.println("Number od effect rows in else block SORDER table =====>"+llCnt);
								if( pstmt1 != null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								cnt = 0;
								sql = "SELECT COUNT(1)  FROM SORDITEM 	WHERE SALE_ORDER = ? AND (STATUS NOT IN ('C','X') OR STATUS IS NULL)";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setString(1, mSaleOrder.trim());
								rs1 = pstmt1.executeQuery();
								if( rs1.next() )
								{
									cnt = rs1.getInt(1);
								}
								if( pstmt1 != null )
								{
									pstmt1.close();
									pstmt1 = null;
								}
								if ( rs1 != null )
								{
									rs1.close();
									rs1 = null;
								}
								if( cnt == 0)
								{
									sql = "UPDATE SORDER	SET STATUS = ?, STATUS_DATE = ? 	WHERE SALE_ORDER = ?";
									pstmt1 = conn.prepareStatement(sql);
									pstmt1.setString(1, mStat.trim());
									pstmt1.setTimestamp(2, currDate);
									pstmt1.setString(3, mSaleOrder.trim());
									llCnt = pstmt1.executeUpdate();
									System.out.println("Number od effect rows in 2nd if  SORDER table =====>"+llCnt);
									if( pstmt1 != null )
									{
										pstmt1.close();
										pstmt1 = null;
									}	
								}
								else
								{
									errString = itmDBAccessLocal.getErrorString("", "VTSOSTAUS", "");
									return errString;	
								}
								if(errString != null && errString.trim().length() > 0)
								{
									return errString;
								}
							}
						}
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
				}
			}
		}
		catch(Exception	e)
		{
			isError = true;
			System.out.println("SorderCancel.gfAutoClose()==>>"+e.getMessage());
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch( Exception e)
			{
				System.out.println("SorderCancel.gfAutoClose() ====>"+e.getMessage());
				e.printStackTrace();
			}
		}
		return errString;
	}

	@SuppressWarnings("resource")
	public String  gfAutoCloseExt(String mSaleOrder, String mStat) 
	{
		String errString = "";
		String lsSaleOrder = "";
		String asLineNo = "";
		String lsExpLev = "";
		String lsUnit = "";
		String lsSiteCode = "";
		String lsStatus = "";
		String lsItemCode = "";
		String lsItemCodeOrd = "";
		String lsLotNo = "";
		String lsLotSl = "";
		String lsLocCode = "";
		double  ldDespatchetQty = 0.0 , ldUserQty = 0.0, ldQtyChk = 0.0 ;
		double ldAllocatedQty = 0.0, ldOrdQty = 0.0;
		Date   mtday = null;
		SimpleDateFormat sdf = null;
		String currDateStr = null;
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		ResultSet rs = null, rs1 = null;
		try
		{
			conn = getConnection();
			mtday = new Date();
			System.out.println("dateFormat ["+mtday+"]");
			String applDateFormat = genericUtility.getApplDateFormat();
			sdf = new SimpleDateFormat(applDateFormat);
			currDateStr = sdf.format(mtday);
			System.out.println("currDateStr ["+ currDateStr + "]");
			sql = "SUM(QUANTITY) - SUM(QTY_DESP) AS LD_QTY_CHK, SUM(QTY_DESP) AS LD_DESPATCHED_QTY, SUM(QTY_ALLOC) AS LD_ALLOCATED_QTY FROM SORDITEM WHERE  SALE_ORDER = ? AND LINE_TYPE = 'I'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, mSaleOrder.trim());
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				ldQtyChk = (Double) rs.getDouble("LD_QTY_CHK") == null ? 0 : rs.getDouble("LD_QTY_CHK");	
				ldDespatchetQty	= rs.getDouble("LD_DESPATCHED_QTY");
				ldAllocatedQty	= rs.getDouble("LD_ALLOCATED_QTY");
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
			if( ldQtyChk > 0 )
			{
				if( ldDespatchetQty > 0 )
				{
					mStat = "C";
				}
				else
				{
					mStat = "X";
				}
			}
			else
			{
				mStat = "C";
			}
			sql = " SELECT SALE_ORDER, LINE_NO, EXP_LEV FROM SORDITEM WHERE  SALE_ORDER = ? AND 	  LINE_TYPE = 'I'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, mSaleOrder.trim());
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				lsSaleOrder = rs.getString(" SALE_ORDER ");
				asLineNo = rs.getString(" LINE_NO ");
				lsExpLev = rs.getString(" EXP_LEV ");
				
				sql = " Select 	SORDITEM.SALE_ORDER, SORDITEM.LINE_NO,	SORDITEM.EXP_LEV," +
						  "	SORDALLOC.ITEM_CODE, SORDALLOC.ITEM_CODE__ORD, SORDALLOC.LOT_SL, " +
						  " SORDALLOC.LOT_NO,  SORDALLOC.LOC_CODE, SORDALLOC.QUANTITY, ORDALLOC.QTY_ALLOC, " +
						  " SORDALLOC.UNIT,  SORDALLOC.STATUS, SORDALLOC.SITE_CODE		 " +
						  " from SORDALLOC, " +
						  " SORDITEM  		" +
						  " where ( SORDALLOC.SALE_ORDER = SORDITEM.SALE_ORDER )" +
						  "  and  ( SORDALLOC.LINE_NO = SORDITEM.LINE_NO ) " +
						  "  and  ( SORDALLOC.EXP_LEV = SORDITEM.EXP_LEV ) " +
						  "  and  ( SORDALLOC.ITEM_CODE__ORD = SORDITEM.ITEM_CODE__ORD ) " +
						  "  and  ( SORDALLOC.ITEM_CODE = SORDITEM.ITEM_CODE )  " +
						  "  and  ( SORDITEM.SALE_ORDER = ?) " +
						  "  and  ( SORDITEM.LINE_NO	= ?)" +
						  "  and  ( SORDITEM.EXP_LEV	= ?)";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, lsSaleOrder.trim());
					pstmt1.setString(2, asLineNo);
					pstmt1.setString(3, lsExpLev);
					rs1 = pstmt1.executeQuery();
					while( rs1.next() )
					{
						lsSaleOrder = rs.getString("SALE_ORDER");
						asLineNo = rs.getString("LINE_NO");
						lsExpLev = rs.getString("EXP_LEV");
						lsItemCode = rs.getString("ITEM_CODE");
						lsItemCodeOrd = rs.getString("ITEM_CODE__ORD");
						lsLotSl = rs.getString("LOT_SL");
						lsLotNo = rs.getString("LOT_NO");
						lsLocCode = rs.getString("LOC_CODE");
						ldOrdQty = rs.getDouble("QUANTITY");
						ldAllocatedQty = (Double)rs.getDouble("QTY_ALLOC") == null ? 0 : rs.getDouble("QTY_ALLOC");
						lsUnit = rs.getString("UNIT");
						lsStatus = rs.getString("STATUS");
						lsSiteCode = rs.getString("SITE_CODE");
						
						System.out.println("lsSaleOrder ==>"+lsSaleOrder);
						System.out.println("asLineNo ==>"+asLineNo);
						System.out.println("lsItemCode ==>"+lsItemCode);
						System.out.println("lsItemCodeOrd ==>"+lsItemCodeOrd);
						System.out.println("lsLotSl ==>"+lsLotSl);
						System.out.println("lsLotNo ==>"+lsLotNo);
						System.out.println("lsLocCode ==>"+lsLocCode);
						System.out.println("ldOrdQty ==>"+ldOrdQty);
						System.out.println("ldAllocatedQty ==>"+ldAllocatedQty);
						System.out.println("lsUnit ==>"+lsUnit);
						System.out.println("lsStatus ==>"+lsStatus);
						System.out.println("SITE_CODE ==>"+lsSiteCode);
						
						if( ldAllocatedQty == 0 || ldAllocatedQty < 0)
						{
							ldUserQty = ldAllocatedQty * -1 ;
							errString = gbfAllocated(lsSaleOrder,asLineNo, lsSiteCode, lsItemCode, lsLocCode, lsLotNo, lsLotSl, ldUserQty, lsExpLev, lsItemCodeOrd);
						  if( errString != null && errString.trim().length() > 0)
						  {
							  return errString;
						  }
						}
					}
					if( pstmt1 != null )
					{
						pstmt1.close();
						pstmt1 = null;
					}
					if ( rs1 != null )
					{
						rs1.close();
						rs1 = null;
					}
			}
			if( pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			if ( rs != null )
			{
				rs.close();
				rs = null;
			}
		
		}
		catch(Exception e)
		{
			System.out.println("SorderCancel.gfAutoCloseExt()===>"+e.getMessage());
		}
		finally
		{
			try
			{
				if( conn != null)
				{
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
		return errString;
	}
	private String checkNull(String input)
	{
		if (input == null) 
		{
			input = "";
		}
		return input.trim();
	}
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public String gbfAllocated(String lsSaleOrder,String asLineNo, String lsSiteCode,String lsItemCode, String lsLocCode, String lsLotNo, String lsLotSl,double adQty, String lsExpLev, String lsItemCodeOrd)
	{
		String  errCode = "",    lsGrade = "",    lssiteCodeMfg = "", munitStd =  "", ldtExpDateStr = "",
				lsCustCode = "", lsLocGroup = "", lsAllocFlag = "", sql = "", ldtMfgDateStr = "";
		double  ldQtyAllocated = 0,  mconvQtyStduom = 0,   mqtyStk = 0, mallocQty = 0, minputQty, mnetQty = 0, lcHoldQty = 0;
		Date ldToday ;
		Timestamp ldtExpDate = null, ldtMfgDate = null, currDate = null;
		int count = 0, effRow = 0;
		boolean isError = false;
		SimpleDateFormat sdf = null;
		String currDateStr = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		HashMap invallocTraceMap = new HashMap();
		InvAllocTraceBean allocTraceBean = new InvAllocTraceBean();
		try
		{
			ldToday = new Date();
			String applDateFormat = genericUtility.getApplDateFormat();
			sdf = new SimpleDateFormat(applDateFormat);
			currDateStr = sdf.format(ldToday);
			System.out.println("currDateStr ["+ currDateStr + "]");
			currDate = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
			conn = getConnection();
			if( adQty < 0)
			{
				sql = " SELECT COUNT(1) " +
						" FROM   SORDALLOC	" +
						" WHERE	 SALE_ORDER	=	? " +
						" AND	 LINE_NO		=	? " +
						" AND	 SITE_CODE	=	?	  " +
						" AND	 ITEM_CODE	=	?	" +
						" AND	 LOC_CODE	=	?	" +
						"	AND	 LOT_NO		=	?	" +
						"	AND	 LOT_SL		=	?	" +
						"	AND	 EXP_LEV	=	?	" +
						"	AND	 ITEM_CODE__ORD = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsSaleOrder);
				pstmt.setString(2, asLineNo);
				pstmt.setString(3, lsSiteCode);
				pstmt.setString(4, lsItemCode);
				pstmt.setString(5, lsLocCode);
				pstmt.setString(6, lsLotNo);
				pstmt.setString(7, lsLotSl);
				pstmt.setString(8, lsExpLev);
				pstmt.setString(9, lsItemCodeOrd);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					count = rs.getInt(1);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( count == 0)
				{
					errCode = itmDBAccessLocal.getErrorString("", "VALCERR", "");
					return errCode;
				}
				sql = " UPDATE SORDITEM " +
						" SET	QTY_ALLOC	= 	QTY_ALLOC + ? " +
						" WHERE	SALE_ORDER	= ? " +
						" AND	LINE_NO	= ? " +
						" AND	 EXP_LEV =	? " +
						" AND   LINE_TYPE   = 'I'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, adQty);
				pstmt.setString(2, lsSaleOrder);
				pstmt.setString(3, asLineNo);
				pstmt.setString(4, lsExpLev);
				effRow = pstmt.executeUpdate();
				System.out.println("Update Sorder Item "+effRow);
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				sql = " SELECT QTY_ALLOC AS LD_QTY_ALLOCATED" +
						" FROM	SORDALLOC" +
						" WHERE	SALE_ORDER	=	? " +
						" AND	  LINE_NO		=	? " +
						" AND	 SITE_CODE	=	? " +
						" AND	 ITEM_CODE	=	? " +
						" AND	 LOC_CODE	=	? " +
						" AND	 LOT_NO		=	?  " +
						" AND	 LOT_SL		=	? " +
						" AND	 EXP_LEV	=	? " +
						" AND	 ITEM_CODE__ORD = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsSaleOrder);
				pstmt.setString(2, asLineNo);
				pstmt.setString(3, lsSiteCode);
				pstmt.setString(4, lsItemCode);
				pstmt.setString(5, lsLocCode);
				pstmt.setString(6, lsLotNo);
				pstmt.setString(7, lsLotSl);
				pstmt.setString(8, lsExpLev);
				pstmt.setString(9, lsItemCodeOrd);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					ldQtyAllocated = rs.getDouble("LD_QTY_ALLOCATED");
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if((ldQtyAllocated + adQty) == 0)
				{
					sql = " DELETE FROM	SORDALLOC" +
							" WHERE	 SALE_ORDER	=	? " +
							" AND	 LINE_NO =	? " +
							" AND	 SITE_CODE =	? " +
							" AND	 ITEM_CODE	=	? " +
							" AND	 LOC_CODE	=	? " +
							" AND	 LOT_NO		=	?  " +
							" AND	 LOT_SL		=	? " +
							" AND	 EXP_LEV	=	? " +
							" AND	 ITEM_CODE__ORD = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsSaleOrder);
					pstmt.setString(2, asLineNo);
					pstmt.setString(3, lsSiteCode);
					pstmt.setString(4, lsItemCode);
					pstmt.setString(5, lsLocCode);
					pstmt.setString(6, lsLotNo);
					pstmt.setString(7, lsLotSl);
					pstmt.setString(8, lsExpLev);
					pstmt.setString(9, lsItemCodeOrd);
					effRow = pstmt.executeUpdate();
					System.out.println("Delete record from sordalloc ==> "+effRow);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				else
				{
					sql = " UPDATE	SORDALLOC  " +
							" SET	 QTY_ALLOC	= 	QTY_ALLOC + ? " +
							" WHERE	 SALE_ORDER	=	? " +
							" AND	 LINE_NO		=	? " +
							" AND	 SITE_CODE	=	? " +
							" AND	 ITEM_CODE	=	? " +
							" AND	 LOC_CODE	=	? " +
							" AND	 LOT_NO		=	?  " +
							" AND	 LOT_SL		=	? " +
							" AND	 EXP_LEV	=	? " +
							" AND	 ITEM_CODE__ORD = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, adQty);
					pstmt.setString(2, lsSaleOrder);
					pstmt.setString(3, asLineNo);
					pstmt.setString(4, lsSiteCode);
					pstmt.setString(5, lsItemCode);
					pstmt.setString(6, lsLocCode);
					pstmt.setString(7, lsLotNo);
					pstmt.setString(8, lsLotSl);
					pstmt.setString(9, lsExpLev);
					pstmt.setString(10, lsItemCodeOrd);
					effRow = pstmt.executeUpdate();
					System.out.println("Update record from sordalloc ==> "+effRow);
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
				sql = "SELECT CUST_CODE,LOC_GROUP  FROM SORDER	WHERE SALE_ORDER = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsSaleOrder);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					lsCustCode = rs.getString("CUST_CODE");
					lsLocGroup = rs.getString("LOC_GROUP");
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				System.out.println("lsCustCode ==>"+lsCustCode);
				System.out.println("lsLocGroup ==>"+lsLocGroup);
				if( lsLocGroup == null || lsLocGroup.trim().length() == 0)
				{
					sql = " SELECT A.EXP_DATE AS LDT_EXP_DATE, A.GRADE AS LS_GRADE, A.MFG_DATE AS LDT_MFG_DATE, " +
							" A.SITE_CODE__MFG AS LS_SITE_CODE__MFG, A.QUANTITY AS MQTY_STK, A.ALLOC_QTY AS MALLOC_QTY, " +
							" A.HOLD_QTY AS LC_HOLD_QTY		" +
							" FROM STOCK A 		" +
							" WHERE A.ITEM_CODE = ? " +
							" AND   A.SITE_CODE = ? " +
							"	AND	A.LOC_CODE	= ?	" +
							"	AND	A.LOT_NO = ?	" +
							"	AND	A.LOT_SL = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsItemCode);
					pstmt.setString(2, lsSiteCode);
					pstmt.setString(3, lsLocCode);
					pstmt.setString(4, lsLotNo);
					pstmt.setString(5, lsLotSl);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						ldtExpDateStr = rs.getString("LDT_EXP_DATE");
						lsGrade = checkNull(rs.getString("LS_GRADE"));
						ldtMfgDateStr = rs.getString("LDT_MFG_DATE");
						lssiteCodeMfg = rs.getString("LS_SITE_CODE__MFG");
						mqtyStk	=  rs.getDouble("MQTY_STK");
						mallocQty = rs.getDouble("MALLOC_QTY");
						lcHoldQty = rs.getDouble("LC_HOLD_QTY");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}
				else
				{
					sql = " SELECT A.EXP_DATE AS LDT_EXP_DATE, A.GRADE AS LS_GRADE, A.MFG_DATE AS LDT_MFG_DATE, " +
							" A.SITE_CODE__MFG AS LS_SITE_CODE__MFG, A.QUANTITY AS MQTY_STK, A.ALLOC_QTY AS MALLOC_QTY," +
							" A.HOLD_QTY AS LC_HOLD_QTY	" +
							" FROM STOCK A ,	 LOCATION B " +
							" WHERE A.LOC_CODE  =  B.LOC_CODE	" +
							"	AND	B.LOC_GROUP = ?		" +
							" AND	A.ITEM_CODE = ?		" +
							" AND A.SITE_CODE = ?		" +
							" AND	A.LOC_CODE	= ?		" +
							" AND	A.LOT_NO	= ?		" +
							" AND	A.LOT_SL	= ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsLocGroup);
					pstmt.setString(2, lsItemCode);
					pstmt.setString(3, lsSiteCode);
					pstmt.setString(4, lsLocCode);
					pstmt.setString(5, lsLotNo);
					pstmt.setString(6, lsLotSl);
					rs = pstmt.executeQuery();
					if( rs.next() )
					{
						ldtExpDateStr = rs.getString("LDT_EXP_DATE");
						lsGrade = checkNull(rs.getString("LS_GRADE"));
						ldtMfgDateStr = rs.getString("LDT_MFG_DATE");
						lssiteCodeMfg = rs.getString("LS_SITE_CODE__MFG");
						mqtyStk	=  rs.getDouble("MQTY_STK");
						mallocQty = rs.getDouble("MALLOC_QTY");
						lcHoldQty = (Double) rs.getDouble("LC_HOLD_QTY") == null ? 0 : rs.getDouble("LC_HOLD_QTY");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}
				sql = "SELECT UNIT__STD, CONV__QTY_STDUOM 	FROM SORDDET	WHERE SALE_ORDER = ?	AND LINE_NO = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsSaleOrder);
				pstmt.setString(2, asLineNo);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					munitStd = rs.getString("UNIT__STD");
					mconvQtyStduom = rs.getInt("CONV__QTY_STDUOM");
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				sql = " SELECT QUANTITY FROM	SORDITEM 	WHERE	SALE_ORDER	= ?	AND	LINE_NO	= ? 	AND	 EXP_LEV	=	 ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsSaleOrder);
				pstmt.setString(2, asLineNo);
				pstmt.setString(3, lsExpLev);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					mnetQty = rs.getDouble("QUANTITY");
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}

				if( (mqtyStk - mallocQty - lcHoldQty) <=  mnetQty)
				{
					minputQty = mqtyStk - mallocQty - lcHoldQty;
				}
				else
				{
					minputQty = mnetQty;
				}

				ldtMfgDate = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( ldtMfgDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
				ldtExpDate = java.sql.Timestamp.valueOf( genericUtility.getValidDateString( ldtExpDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()+ " 00:00:00.00"));
				sql = " INSERT INTO SORDALLOC(SALE_ORDER,	LINE_NO,   EXP_LEV,   ITEM_CODE__ORD,   ITEM_CODE,  " +
						" LOT_NO,   LOT_SL,   LOC_CODE,  ITEM_REF,   QUANTITY,   UNIT,   QTY_ALLOC,   DATE_ALLOC,  " +
						" STATUS,   ALLOC_MODE,   SITE_CODE,	ITEM_GRADE,	EXP_DATE,	MFG_DATE,	SITE_CODE__MFG,	" +
						" UNIT__STD,CONV__QTY_STDUOM,	QUANTITY__STDUOM  ) " +
						" SELECT SORDITEM.SALE_ORDER, SORDITEM.LINE_NO,   SORDITEM.EXP_LEV,  SORDITEM.ITEM_CODE__ORD, " +
						" SORDITEM.ITEM_CODE,	? , ?, ?, SORDITEM.ITEM_REF, SORDITEM.QUANTITY,   SORDITEM.UNIT,   ?, ?, 'P','M', " +
						" ?, ?, ?,	?, ?,	?, ?, ?	" +
						" FROM  sorditem	WHERE sale_order = ?	" +
						" and	line_no	 = ?" +
						"	AND EXP_LEV	 = ?" +
						"	and line_type = 'I'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsLotNo);
				pstmt.setString(2, lsLotSl);
				pstmt.setString(3, lsLocCode);
				pstmt.setDouble(4, adQty);
				pstmt.setTimestamp(5, currDate);
				pstmt.setString(6, lsSiteCode);
				pstmt.setString(7, lsGrade);
				pstmt.setTimestamp(8, ldtExpDate);
				pstmt.setTimestamp(9, ldtMfgDate);
				pstmt.setString(10, lssiteCodeMfg);
				pstmt.setString(11, munitStd);
				pstmt.setDouble(12, mconvQtyStduom);
				pstmt.setDouble(13, minputQty);
				effRow = pstmt.executeUpdate();
				System.out.println("SorderCancel.gbfAllocated() Insert no of row [ "+ effRow + "] in SORDALLOC table");
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			if( adQty != 0 || adQty != 0.0) 
			{
				invallocTraceMap.put("tran_date", currDate);
				invallocTraceMap.put("ref_ser", "S-ORD");
				invallocTraceMap.put("ref_id", lsSaleOrder);
				invallocTraceMap.put("ref_line", asLineNo);
				invallocTraceMap.put("site_code", lsSiteCode);
				invallocTraceMap.put("item_code", lsItemCode);
				invallocTraceMap.put("loc_code", lsLocCode);
				invallocTraceMap.put("lot_no", lsLotNo);
				invallocTraceMap.put("lot_sl", lsLotSl);
				invallocTraceMap.put("alloc_qty", adQty);
				invallocTraceMap.put("chg_user", userId);
				invallocTraceMap.put("chg_term", termId);
				invallocTraceMap.put("chg_win", "W_SORDER");
				System.out.println("invallocTraceMap =====> ["+invallocTraceMap);
				errCode	= allocTraceBean.updateInvallocTrace(invallocTraceMap, conn);
				System.out.println("AsnConf.confirm() error_Code  ::"+errCode);
				invallocTraceMap.clear();
				if(errCode == null)
				{
					isError = true;
				}
				else if ( errCode.trim().length() == 0 )
				{
					isError = false;
				}
				else
				{
					isError = true;
				}
				count = 0;
				sql = "select COUNT(1) SORDITEM where	SALE_ORDER	=	? and	(case when QTY_ALLOC is null then 0 else QTY_ALLOC end) > 0";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsSaleOrder);
				rs = pstmt.executeQuery();
				if( rs.next() )
				{
					count =	rs.getInt(1);
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if( count > 0)
				{
					lsAllocFlag = "Y";
				}
				else if( count == 0 )
				{
					lsAllocFlag = null;
				}
				sql = "UPDATE SORDER SET ALLOC_FLAG = ? WHERE SALE_ORDER = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, lsAllocFlag);
				pstmt.setString(2, lsSaleOrder);
				effRow = pstmt.executeUpdate();
				System.out.println("Effected row in Sorder  ["+effRow+"] in Table");
			}
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("SorderCancel.gbfAllocated() ["+e.getMessage()+"]");
		}
		finally
		{
			try
			{
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if( conn != null)
				{
					if ( rs != null )
					{
						rs.close();
						rs = null;
					}
					if( pstmt != null )
					{
						pstmt.close();
						pstmt = null;
					}
					conn.close();
				}
				conn = null;
			}
			catch( Exception e)
			{
				System.out.println("SorderCancel.gfAutoClose() ====>"+e.getMessage());
				e.printStackTrace();
			}
		}
		return errCode;
	}
}
	