/*
 * Author:Wasim Ansari
 * Date:02-FEB-15
 * Request ID:D14IKAT004 (PO Wizard)
 */

package ibase.webitm.bean.wms;

import java.io.File;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.wms.DDPorderWizEJBRemote;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;

public class PorderDetailBean 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public String getList(String field,String[] values,String extra,String details) throws ITMException
	{
		String itemTypeList = "";
		
		DDPorderWizEJBRemote ddPorderWizRemote = null;
		
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddPorderWizRemote = (ibase.webitm.ejb.wms.DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			itemTypeList = ddPorderWizRemote.getList(field,values,extra,details);

			String xslFileName = getXSLFileName( "porderWiz_ItemDetails_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			
			itemTypeList = (genericUtility).transformToString( xslFileName, itemTypeList, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddPorderWizRemote != null )
			{
				ddPorderWizRemote = null;
			}
		}
		return itemTypeList;
	}
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			//File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD" + File.separator + "Galaxy");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}
	
	public String nextForm( String formNo, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;
		
		try
		{
			System.out.println("*******In Method : [nextForm]************");
			
			System.out.println("xmlString : ["+ xmlData +"]");
			
			//InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			//DDPorderWizEJBRemote ddPorderWizRemote = null;
			//ddPorderWizRemote = (ibase.webitm.ejb.wms.DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			//details = ddPorderWizRemote.getPorderDetails(xmlData);
			
			//Changed by Samadhan on 14/07/2015 D15CKAT026 for dynamic form no Start
			//String xslFileName = getXSLFileName( "porderWiz1_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );
			String xslFileName = getXSLFileName( "porderWiz"+formNo+"_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );
			//Changed by Samadhan on 14/07/2015 D15CKAT026 dynamic form no End
			
			retHtmlData = (genericUtility).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
		}
		return retHtmlData;
	}
	
	public String getPoDetails( String objName, String random ) throws ITMException 
	{
		String details = null;
		DDPorderWizEJBRemote ddPorderWizRemote = null;
		try
		{
			System.out.println("*******In Method : [nextForm]************");
			
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			ddPorderWizRemote = (ibase.webitm.ejb.wms.DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = ddPorderWizRemote.getPoDetails(objName,random);

			String xslFileName = getXSLFileName( "porderWiz_Finish_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			details = (genericUtility).transformToString( xslFileName, details, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( ddPorderWizRemote != null )
			{
				ddPorderWizRemote = null;
			}
		}
		return details;
	}	
	
	
	
	
	//Changed by wasim to lookup for EJB [START]
	public String getSKUDetail(String itemParent,String itemDLVDate,String paraData,String otherDetails) throws ITMException 
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.getSKUDetail(itemParent,itemDLVDate,paraData,otherDetails);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	public String getPurcDetail1(String purcOrder,String flag) throws ITMException 
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.getPurcDetail1(purcOrder,flag);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	public String  getPorderDetail2(String siteCode,String empCodeFrmReq,String purcOrder,String flag) throws ITMException 
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.getPorderDetail2(siteCode,empCodeFrmReq,purcOrder,flag);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	public String  validatePorder(String purcOrder) throws ITMException 
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.validatePorder(purcOrder);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if(porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	public String resetPorderHeader(String str) throws ITMException 
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.resetPorderHeader(str);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if(porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	public String savePorderHeader(String str,String siteCode)throws ITMException
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.savePorderHeader(str,siteCode);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if(porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	public String savePorderDetail(String str)throws ITMException
	{
		String details = null;
		DDPorderWizEJBRemote porderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			porderWizRemote = (DDPorderWizEJBRemote) ctx.lookup("ibase/DDPorderWizEJB/remote");
			details = porderWizRemote.savePorderDetail(str);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if(porderWizRemote != null )
			{
				porderWizRemote = null;
			}
		}
		return details;
	}
	//Changed by wasim to lookup for EJB [END]
}
