package ibase.dashboard.ssc.ejb;
import ibase.system.config.ConnDriver;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class AcctPayable extends ValidatorEJB implements AcctPayableLocal, AcctPayableRemote
{
	public AcctPayable() {
        // TODO Auto-generated constructor stub
    }
	GenericUtility genericUtility = GenericUtility.getInstance();
	@SuppressWarnings("unchecked")
    public JSONObject getPaymentEfficiency(String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataAcctPayableDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside AcctPayable for getPaymentEfficiency Data Soruc Name ="+dataSourceName);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			int delayCount = 0;	
			double delayAmount = 0.0;
			int paymentCount = 0;
			double totalCount = 0.0;
			double paymentAmount = 0.0;
			double paidAmount = 0.0;	
			double delayTotalAmount = 0.0;
			double delayDays = 0.0;
			double delayIndex = 0.0;
			double percntVal = 0.0;
			double percntValForAmountPaid = 0.0; 
			double totalAmount = 0.0;			
		
			sql = "select count(1) delay_Invoice , round(sum(d.pay_amt)) delay_Inv_payment " +
				  "from misc_payment h, misc_paydet d, misc_payables m, period p where d.tran_id = h.tran_id " +
				  "and m.tran_ser  = d.tran_ser and m.ref_no  = d.vouch_no and to_date(h.conf_date) > m.due_date " +
				 "and to_date(h.conf_date) between p.fr_date and p.to_date " +
				  "and h.confirmed = 'Y'" + 
				  "and to_date(sysdate) between p.fr_date and p.to_date" ;
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				delayCount = rs.getInt("delay_Invoice");
				delayAmount = Double.parseDouble(checkZero(rs.getString("delay_Inv_payment")));
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			sql="select count(1) as paymentcount, round(sum(d.pay_amt)) as paymentamt " +
				"from misc_payment h, misc_paydet d, misc_payables m, " +
				"period p where d.tran_id = h.tran_id and m.tran_ser  = d.tran_ser " +
				"and m.ref_no  = d.vouch_no and to_date(h.conf_date) <= m.due_date " +
				"and to_date(h.conf_date) between p.fr_date and p.to_date " +
				"and h.confirmed = 'Y'" +
				"and to_date(sysdate) between p.fr_date and p.to_date";
				
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				paymentCount = rs.getInt("paymentcount");
				paymentAmount = Double.parseDouble(checkZero(rs.getString("paymentamt")));
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			sql="select  sum(d.pay_amt) as paid_amount, sum(m.tot_amt) total_amount, " +
				"sum(to_date(h.conf_date) - m.due_date) delayed_days from misc_payment h, " +
				"misc_paydet d, misc_payables m, period p where d.tran_id = h.tran_id " +
				"and m.tran_ser  = d.tran_ser and m.ref_no  = d.vouch_no " +
				"and to_date(h.conf_date) <= m.due_date and " +
				"to_date(h.conf_date) between p.fr_date and p.to_date and " +
				"h.confirmed = 'Y'" +
				"and to_date(sysdate) between p.fr_date and p.to_date";
						
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				paidAmount = Double.parseDouble(checkZero(rs.getString("paid_amount")));			
				delayDays = Double.parseDouble(checkZero(rs.getString("delayed_days")));
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			sql="select sum(d.pay_amt) delay_Total_Amount from misc_payment h, misc_paydet d, " +
				"misc_payables m, period p where d.tran_id = h.tran_id and m.tran_ser = d.tran_ser " +
				"and m.ref_no = d.vouch_no and " +
				"to_date(h.conf_date) between p.fr_date and p.to_date and " +
				"h.confirmed = 'Y'   and to_date(sysdate) between p.fr_date and p.to_date";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				delayTotalAmount = Double.parseDouble(checkZero(rs.getString("delay_Total_Amount")));
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			   
		    System.out.println("paymentCount :"+paymentCount + "-- delayCount :"+delayCount);
		    totalCount = paymentCount + delayCount;
		    System.out.println("totalCount :"+totalCount);
		    if(totalCount != 0)
		    {
		    	percntVal = (((double)paymentCount / totalCount) * 100) ; 
		    }
		    totalAmount = paymentAmount + delayAmount;
		    System.out.println("totalAmount :"+totalAmount);
		    if(totalAmount != 0)
		    {
		    	percntValForAmountPaid = ((paymentAmount / (paymentAmount+delayAmount)) * 100);
		    }
		    
		    System.out.println("twoDecFormat.format percntValForAmountPaid :"+(percntValForAmountPaid));
		    
		    rowData = new JSONObject();
		    rowData.put("descr", "No of voucher paid");
		    rowData.put("percentage", Math.round(percntVal));
		    rowData.put("spanvalue", Math.round(percntVal)+"%");
		    rowData.put("ontimeval", paymentCount);
		    rowData.put("delayval", delayCount );
		    rowData.put("totalval", (paymentCount + delayCount));
		    rowData.put("tbldisplay", "style='display: visible;'");
		    rowData.put("circledisplay", "c100"); 
		    rowData.put("data","style='display: none;'");
		    rawDataAcctPayableDtlJson.put(count, rowData);
		    count++;
			    
		    rowData = new JSONObject();
		    rowData.put("descr", "Value of payment in (INR)");
		    rowData.put("percentage", Math.round(percntValForAmountPaid));
		    rowData.put("spanvalue", Math.round(percntValForAmountPaid)+"%");
		    rowData.put("ontimeval", paymentAmount);
		    rowData.put("delayval",  delayAmount );
		    rowData.put("totalval", (paymentAmount+delayAmount));
		    rowData.put("tbldisplay", "style='display: visible;'");
		    rowData.put("circledisplay", "c100");
		    rowData.put("data","style='display: none;'");
		    rawDataAcctPayableDtlJson.put(count, rowData);
		    count++;
		    System.out.println("paidAmount :"+paidAmount + "-- delayDays :"+delayDays + "delayTotalAmount :"+delayTotalAmount);
		    if(delayDays <0)
		    {
		    	delayIndex = (paidAmount * delayDays) *(-1) / delayTotalAmount;
		    }else
		    {
		    	delayIndex = (paidAmount * delayDays) / delayTotalAmount;
		    }
			rowData = new JSONObject();
		    rowData.put("descr", "Delay index");
		    rowData.put("percentage", "0");
		    rowData.put("spanvalue", Math.round(delayIndex));
		    rowData.put("ontimeval", "0");
		    rowData.put("delayval",  "0");
		    rowData.put("totalval",  "0");
		    rowData.put("tbldisplay", "style='display: none;'");
		    rowData.put("circledisplay", "circleNotDisplay");
		    rowData.put("data","style='display: visible;'");
		    rawDataAcctPayableDtlJson.put(count, rowData);
			    
			    
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getPaymentEfficiency:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataAcctPayableDtlJson;
		
	}
	@SuppressWarnings("unchecked")
    @Override
    public JSONObject getPayableProfit(String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataPayableProfitJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside AcctPayable for getPayableProfit Data Soruc Name ="+dataSourceName);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;							
			sql = "select sum(1) invoice_number, sum(m.tot_amt - m.adj_amt) invoice_val,'7 Days' as descr "+
				" from misc_payables m where m.due_date > to_date(sysdate) and m.due_date - to_date(sysdate) <= 7 "+
				" and m.tot_amt - m.adj_amt <> 0 "+
				" union all "+
				" select sum(1) invoice_number, sum(m.tot_amt - m.adj_amt) invoice_val,'15 Days' as descr "+
				" from misc_payables m where m.due_date > to_date(sysdate) and m.due_date - to_date(sysdate) <= 15 "+
				" and m.tot_amt - m.adj_amt <> 0 "+
				" union all "+
				" select sum(1) invoice_number, sum(m.tot_amt - m.adj_amt) invoice_val,'30 Days' as descr "+
				" from misc_payables m where m.due_date > to_date(sysdate) and m.due_date - to_date(sysdate) <= 30 "+
				" and m.tot_amt - m.adj_amt <> 0 "+
				" union all "+
				" select sum(1) invoice_number, sum(m.tot_amt - m.adj_amt) invoice_val,'60 Days' as descr "+
				" from misc_payables m where m.due_date > to_date(sysdate) and m.due_date - to_date(sysdate) <= 60 "+
				" and m.tot_amt - m.adj_amt <> 0";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
           while (rs.next())
			{
        	   	rowData = new JSONObject();
				rowData.put("invoice_number", checkNull(rs.getString("invoice_number")));
				rowData.put("invoice_val", checkNull(rs.getString("invoice_val")));
				rowData.put("descr", rs.getString("descr"));
				rawDataPayableProfitJson.put(count, rowData);
				count++;
			}
           rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getPayableProfit:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPayableProfitJson;
		
	}
	
	@SuppressWarnings("unchecked")
    @Override
    public JSONObject getSavingOpportunity(String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataSavingOpporntyJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println(" Inside AcctPayable for getSavingOpportunity Data Soruc Name ="+dataSourceName);
			SimpleDateFormat gridDateFormat = new SimpleDateFormat( genericUtility.getApplDateFormat());
			SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			sql=" select v.bill_no, s.sh_name, v.net_amt, round(case when c.FCHG_TYPE ='F' " +
					" then c.FIN_CHG else (v.net_amt * c.FIN_CHG / 100) end,0) as disc_amt , " +
					" v.due_date from voucher v, supplier s, crtermfc c, misc_payables m " +
					" where v.supp_code = s.supp_code and v.cr_term = c.cr_term and c.max_day < 0 " +
					" and m.tran_ser = 'VOUCH' and m.ref_no = v.tran_id and m.adj_amt = 0 " +
					" and m.due_date > to_date(sysdate)" +
					" "; 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
           while (rs.next())
			{
        	   	rowData = new JSONObject();
				rowData.put("bill_no", checkNull(rs.getString("bill_no")));
				rowData.put("sh_name", checkNull(rs.getString("sh_name")));
				rowData.put("net_amt", checkNull(rs.getString("net_amt")));
				rowData.put("disc_amt", checkNull(rs.getString("disc_amt")));
				rowData.put("due_date", gridDateFormat.format(convrtToTimStmDate.parse(rs.getString("due_date"))));
				
				rawDataSavingOpporntyJson.put(count, rowData);
				count++;
			}
           rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getSavingOpportunity:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataSavingOpporntyJson;
		
	}
	
	
	@SuppressWarnings("unchecked")
    @Override
    public JSONObject getEfficiencyTrend(String dataSourceName) throws RemoteException, ITMException
    {
		JSONObject rawDataEfficiencyTrendJson = new JSONObject();
		JSONObject rowData = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println(" Inside AcctPayable for getEfficiencyTrend Data Soruc Name ="+dataSourceName);
			SimpleDateFormat gridDateFormat = new SimpleDateFormat( "yyyy-MM-dd");
			SimpleDateFormat convrtToTimStmDate= new SimpleDateFormat(genericUtility.getDBDateFormat());
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			HashMap<String, ArrayList<String>> onTimeMap = new HashMap<String,ArrayList<String>>();
			HashMap<String, String> delayTimeMap = new HashMap<String, String>();
			ArrayList<String> valueList =null;
	        TreeMap<String, ArrayList<String>> finalHashMap = new TreeMap<String, ArrayList<String>>();
	        ArrayList<String> tempList = null;
	        TreeMap<String, String> onTimeDataMap  = new  TreeMap<String, String>();
            TreeMap<String, String> delayTimeDataMap  = new  TreeMap<String, String>();
            TreeMap<String, String> onTimeDataMapLine1  = new  TreeMap<String, String>();
            TreeMap<String, String> onTimeDataMapLine2  = new  TreeMap<String, String>();
	        String conf_date = "";
			int count = 0;
			int sumOfOnTimeInv = 0;
			sql=" select to_date(h.conf_date) as conf_date, sum(d.pay_amt) paid_amount, sum(m.tot_amt) total_amount, " +
				" sum(to_date(h.conf_date) - m.due_date) delayed_days, count(1) no_inv " +
				" from misc_payment h, misc_paydet d, misc_payables m, period p " +
				" where d.tran_id = h.tran_id and m.tran_ser  = d.tran_ser and m.ref_no  = d.vouch_no and h.confirmed = 'Y'" +
				" and to_date(h.conf_date) <= m.due_date and " +
				"to_date(h.conf_date) between p.fr_date and p.to_date and" +
				" to_date(sysdate) between p.fr_date and p.to_date " +
				" group by to_date(h.conf_date) order by to_date(h.conf_date) ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
            while (rs.next())
			{
        	   	valueList = new ArrayList<String>();
        	    sumOfOnTimeInv = sumOfOnTimeInv + rs.getInt("no_inv");
				conf_date = gridDateFormat.format(convrtToTimStmDate.parse(rs.getString("conf_date")));
				valueList.add(checkZero(rs.getString("no_inv")));
				valueList.add(checkZero(rs.getString("paid_amount")));
				valueList.add(checkZero(rs.getString("total_amount")));
				onTimeMap.put(conf_date, valueList);
			}
            rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
           sql="select to_date(h.conf_date) as conf_date, sum(d.pay_amt) paid_amount, sum(m.tot_amt) total_amount, " +
           		" sum(to_date(h.conf_date) - m.due_date) delayed_days, count(1) no_inv " +
           		" from misc_payment h, misc_paydet d, misc_payables m, period p " +
           		" where d.tran_id = h.tran_id and m.tran_ser  = d.tran_ser and m.ref_no  = d.vouch_no and h.confirmed = 'Y'" +
           		" and to_date(h.conf_date) > m.due_date and" +
           		" to_date(h.conf_date) between p.fr_date and p.to_date and" +
           		" to_date(sysdate) between p.fr_date and p.to_date" +
           		" group by to_date(h.conf_date) order by to_date(h.conf_date)";
           pstmt = null;
           rs = null;
           pstmt = conn.prepareStatement(sql);
           rs = pstmt.executeQuery();
           conf_date = "";
           while (rs.next())
		   {
	       	   	conf_date = gridDateFormat.format(convrtToTimStmDate.parse(rs.getString("conf_date")));
				delayTimeMap.put(conf_date, checkZero(rs.getString("no_inv")));
		   }
           rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
         for (Map.Entry<String, String> entry : delayTimeMap.entrySet()) 
		 {
			if(onTimeMap.containsKey(entry.getKey()))
			{
				valueList = new ArrayList<String>();
				tempList = new ArrayList<String>();
				tempList = onTimeMap.get(entry.getKey());			
				valueList.add(tempList.get(0));
				valueList.add(""+delayTimeMap.get(entry.getKey()));
				valueList.add(""+((Double.parseDouble(tempList.get(0)))/sumOfOnTimeInv) * 100);
				valueList.add(""+((Double.parseDouble(tempList.get(1)))/(Double.parseDouble(tempList.get(2)))) * 100);
				finalHashMap.put(entry.getKey(), valueList);	
			}else if(!onTimeMap.containsKey(entry.getKey()))
			{
				valueList = new ArrayList<String>();
				valueList.add("0");
				valueList.add(""+delayTimeMap.get(entry.getKey()));
				valueList.add("0");
				valueList.add("0");
				finalHashMap.put(entry.getKey(), valueList);
			}
		}
         
        for (Map.Entry<String, ArrayList<String>> entry : onTimeMap.entrySet()) 
		{
			if(!finalHashMap.containsKey(entry.getKey()))
			{
				valueList = new ArrayList<String>();
				tempList = new ArrayList<String>();
				tempList = onTimeMap.get(entry.getKey());
				valueList.add(tempList.get(0));				
				valueList.add("0");
				valueList.add(""+((Double.parseDouble(tempList.get(0)))/sumOfOnTimeInv) * 100);
				valueList.add(""+((Double.parseDouble(tempList.get(1)))/(Double.parseDouble(tempList.get(2)))) * 100);
				
				finalHashMap.put(entry.getKey(), valueList);
			}
		}
         
           System.out.println("finalHashMap :"+finalHashMap);
           ArrayList<String> tempData = null;
           for (Map.Entry<String, ArrayList<String>> entry : finalHashMap.entrySet()) 
		   {
        	   tempData = new ArrayList<String>();
        	   tempData = entry.getValue();	  
        	   onTimeDataMap.put(entry.getKey(), tempData.get(0));
        	   delayTimeDataMap.put(entry.getKey(), tempData.get(1));
        	   onTimeDataMapLine1.put(entry.getKey(), tempData.get(2));
        	   onTimeDataMapLine2.put(entry.getKey(), tempData.get(3));
        	   
        	   rowData = new JSONObject();
               rowData.put("conf_date", entry.getKey());
               
               rowData.put("inv_paid_ontime", tempData.get(0));
               rowData.put("inv_paid_delay", tempData.get(1));
               rowData.put("inv_paid_perc", tempData.get(2));
               rowData.put("amt_paid_perc", tempData.get(3));
               
               rawDataEfficiencyTrendJson.put(count, rowData);
               count++;
		   }
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getEfficiencyTrend:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataEfficiencyTrendJson;
		
	}
	
	
	
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str;
		}
	}
	private String checkZero(String str)
	{
		if (str == null)
		{
			return "0";
		} else
		{
			return str;
		}
	}
	
	
}
