package ibase.webitm.ejb.wms;

import ibase.utility.CommonConstants;
import ibase.utility.EMail;
import ibase.webitm.utility.*;
import ibase.webitm.utility.wms.CommonWmsUtil;
import ibase.system.config.*;
import ibase.webitm.bean.wms.ShipmentStatus;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.dis.*;
import ibase.webitm.ejb.fin.*;
import java.rmi.RemoteException;
import java.util.*;
import java.text.*;
import java.sql.*;
import javax.ejb.*;
import ibase.webitm.ejb.MasterStatefulLocal;
import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;


import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import ibase.utility.E12GenericUtility;



@Stateless
public class SalesReturnConf extends ActionHandlerEJB implements SalesReturnConfLocal, SalesReturnConfRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	E12GenericUtility genericUtility1 = new E12GenericUtility(); //Changed by Sneha on 02/07/2015, for Auto Confirm Payment, Request ID: D15DKAT001
	@Override

	public String confirm( String tranId, String xtraParams, String forcedFlag ) throws RemoteException,ITMException
	{	
		System.out.println("SalesReturnConf Called........"+tranId);

		Connection conn = null;
		String errString = "",retStr = "",sql = "",tranType = "",siteCode = "",sorderRtrStr = "",
		refundReturnStr = "",invoiceId = "",tranIdCrn = "";	
		String finparamCcterm = "", tranIdPayment = ""; //Changed by Sneha on 02/07/2015, for Auto Confirm Payment, Request ID: D15DKAT001
		CommonWmsUtil common = new  CommonWmsUtil(); //Changed by Sneha on 02/07/2015, for Auto Confirm Payment, Request ID: D15DKAT001
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmdbAccess = new ITMDBAccessEJB();
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		boolean isError = false;


		//Changed by samadhan on 16/6/2015 for status tracking update in magento system.start	
		String confString="";
		String despId = "";
		String saleOrder="";
		String ptcn="";
		//Changed by samadhan on 16/6/2015 for status tracking update in magento system. end						
		Map<String,String> sreturnDetail = new HashMap<String,String>();		
		try
		{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			tranId = tranId == null ? "" : tranId.trim();
			if(tranId.length() > 0)
			{
				//Check transaction type RF(Refund) or RP (Replacement)
				sql = "SELECT TRAN_TYPE,SITE_CODE,INVOICE_ID,TRAN_ID__CRN FROM SRETURN WHERE TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if ( rs.next() )
				{
					tranType = checkNull(rs.getString("TRAN_TYPE"));	
					siteCode = checkNull(rs.getString("SITE_CODE"));
					invoiceId = checkNull(rs.getString("INVOICE_ID"));					
				}
				System.out.println("TranType--------->>["+tranType+"]");
				System.out.println("invoiceId--------->>["+invoiceId+"]");				

				//Changed by samadhan on 16/6/2015 for status tracking update in magento system.start	
				pstmt.close();
				rs.close();

				ShipmentStatus objShipment = new ShipmentStatus();
				CommonWmsUtil wmsUtil = new CommonWmsUtil();
				String apiShipUrl = wmsUtil.getDDSalesConfig("SHIP_STATUS_URL");
				//Changed by wasim on 14-08-2015 to set api Key for magento [START]
				String apiKey = wmsUtil.getDDSalesConfig("API_KEY");
				objShipment.setApiKey(apiKey);
				//Changed by wasim on 14-08-2015 to set api Key for magento [END]

				sql="select desp_id,sale_order from invoice where invoice_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, invoiceId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					despId = rs.getString(1);	
					saleOrder = rs.getString(2);
				}
				pstmt.close();
				rs.close();
				sql="select ptcn from despatch where desp_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, despId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					ptcn = rs.getString(1);
				}
				pstmt.close();
				rs.close();
				//Changed by samadhan on 16/6/2015 for status tracking update in magento system. end	
				errString = confirmSalesReturn("salesreturn_retn", tranId, xtraParams, "", conn);
				System.out.println("After confirmSalesReturn---->>["+errString+"]");
				//Changed by samadhan on 11022016 for rcpmode other than P and S
				confString = errString;
				sreturnDetail.put("TRAN_ID",tranId);
				sreturnDetail.put("INVOICE_ID",invoiceId);
				sreturnDetail.put("SITE_CODE",siteCode);				
				sreturnDetail.put("XTRA_PARAM",xtraParams);
				System.out.println("After sreturnDetail---->>["+sreturnDetail+"]");				
				if( (errString != null && errString.indexOf("VTSUCC1") > -1) )
				{
					sql="SELECT TRAN_ID__CRN FROM SRETURN WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						tranIdCrn = checkNull(rs.getString("TRAN_ID__CRN"));
					}
					pstmt.close();
					rs.close();
					sreturnDetail.put("TRAN_ID__CRN",tranIdCrn);
					//if tran_type is RP then we need create new sale order		
					//otherwise transfer receivable to payable and make unconfirmed payment.
					if("RP".equalsIgnoreCase(tranType))
					{
						sorderRtrStr =  saveSaleOrderDataNew(sreturnDetail,conn);
						System.out.println("sorderRtrStr after saveSaleOrderData------->>["+sorderRtrStr+"]");
						//Changed by samadhan on 16/6/2015 for status tracking update in magento system.start						
						if( "success".equalsIgnoreCase(sorderRtrStr))
						{							
							objShipment.setOrderID(saleOrder);
							objShipment.setStatus("return");
							objShipment.setTrackingNumbers(wmsUtil.getTrackingNo(ptcn, conn));
							objShipment.setComment("Sale Order return");
							wmsUtil.CallTrackShipStatus(objShipment, apiShipUrl);		
						}
						//Changed by samadhan on 16/16/2015 for status tracking update in magento system. end
					}
					else if("RF".equalsIgnoreCase(tranType))
					{						
						refundReturnStr = ReceivableToPayableTrf(sreturnDetail, conn);
						System.out.println("After ReceivableToPayableTrf---->>["+refundReturnStr+"]");
						//Changed by Samadhan on 10/02/2016 for invoice id is blank Start
						if(invoiceId.length() != 0 && invoiceId != null)
						{
							//Changed by Samadhan on 10/02/2016 for invoice id is blank end
							if("success".equalsIgnoreCase(refundReturnStr))
							{
								//Changed by samadhan on 16/6/2015 for status tracking update in magento system.start
								objShipment.setOrderID(saleOrder);
								objShipment.setStatus("refund");
								objShipment.setTrackingNumbers(wmsUtil.getTrackingNo(ptcn, conn));
								objShipment.setComment("Sale Order refund");
								wmsUtil.CallTrackShipStatus(objShipment, apiShipUrl);	
								//Changed by samadhan on 16/6/2015 for status tracking update in magento system.end   
								conn.commit();	
							}

							refundReturnStr = generateAutoPayment(sreturnDetail, conn);
							System.out.println("After refundReturnStr---->>["+refundReturnStr+"]");

							//Changed by Sneha on 02/07/2015, for Auto Confirm Payment, Request ID: D15DKAT001
							finparamCcterm = common.getfinparm("999999", "REC_PAY_AUTOCNF", conn);
							if("Y".equalsIgnoreCase(finparamCcterm))
							{
								Document headerDom = null;
								headerDom = genericUtility1.parseString(refundReturnStr);
								tranIdPayment = genericUtility1.getColumnValue("TranID", headerDom);
								System.out.println("tranId :::::::::: " + tranIdPayment);

								if(refundReturnStr != null && refundReturnStr.indexOf("Success") > -1)
								{
									System.out.println("Inside If loop :::::::::: ");
									conn.commit();
									System.out.println("Commited Sucessfully :::::::::: ");
									refundReturnStr =  "success";


									AppConnectParm appConnect = new AppConnectParm();                   
									Properties p = appConnect.getProperty();
									InitialContext ctx = new InitialContext(p);
									RefundGateWayPaymentLocal locObj = (RefundGateWayPaymentLocal) ctx.lookup("ibase/RefundGateWayPayment/local");
									errString=locObj.segPay(tranIdPayment, xtraParams, forcedFlag, conn);

									//Changed by Samadhan on 8/02/2016 for other rcp_mode start
									if(errString.indexOf("VTINVRCPM") > -1)
									{
										errString = confString;
									}
									//Changed by Samadhan on 8/02/2016 for other rcp_mode end

									//	return errString; 


									/*System.out.println("Calling  WSR :::::::::: ");
								errString = wmsUtil.callNVOComponent(tranIdPayment, xtraParams, forcedFlag, "prcm_default_1", "nvo_business_object_misc_pay", conn);
							    System.out.println("return from WSR ::::::::::" + errString);

							    if(errString.indexOf("VTSUCC1") > -1)
							    {
							    	System.out.println("Success :::::::::: ");
							    }
							    else
							    {
							    	isError = true;
									return errString;  	
							    }*/

								}
								else
								{
									refundReturnStr = refundReturnStr;
								}	

							}
							else
							{
								refundReturnStr = refundReturnStr;
							}
						}
						//End by Sneha on 02/07/2015, for Auto Confirm Payment, Request ID: D15DKAT001
					}
					//Changed by Samadhan on 8/02/2016 for invoice id is blank start
					else
					{
						refundReturnStr = ReceivableToPayableTrf(sreturnDetail, conn);
						//return errString;
					}
					//Changed by Samadhan on 8/02/2016 for invoice id is blank end
					if( "success".equalsIgnoreCase(sorderRtrStr) || "success".equalsIgnoreCase(refundReturnStr))
					{	
						System.out.println("Final Error String:-"+errString);
						//Changed by Samadhan on 8/02/2016 for invoice id is blank
						if(invoiceId.length() != 0 && invoiceId != null)
						{
							System.out.println("Calling send mail method start");
							SendMailforSalesReturn(invoiceId,tranId,tranType,errString,xtraParams,conn) ; //Added By Manish for send mail to customer for Refund on 02/12/2015
							System.out.println("Calling send mail method End");
							//Changed by Samadhan on 8/02/2016 for invoice id is blank
						}
						return errString;
					}
					else
					{
						System.out.println("----------BOth receive && generateAuto--------------");			
						errString = itmdbAccess.getErrorString("", "VTSRTNC", "", "", conn);
						isError = true;
					}
				}
				else
				{
					isError = true;
					return errString;
				}

			}
			else
			{
				isError = true;
				errString = itmdbAccess.getErrorString("", "VTSRTNC", "", "", conn);
			}

		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("in finally--------->>"+isError);			
			try {
				if(isError)
				{
					conn.rollback();
				}
				else
				{
					conn.commit();
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(conn != null)
				{			
					conn.close();
					conn = null;	
				}
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		System.out.println("errString is +++:"+errString);
		return errString;

	}

	/*1. Function for transferring the negative receivables to payables.
	2. The receivable is adjusted and a new record is inserted in to payables.
	3. Record in inserted into receivables_adj */
	public String ReceivableToPayableTrf(Map<String,String>sReturnDetailsMap, Connection conn) throws RemoteException,ITMException
	{				
		ITMDBAccessEJB itmdbAccess = null;
		ValidatorEJB vdt=null;
		PreparedStatement pstmt=null;
		ResultSet rs = null;
		String tranId = "" ,invoiceId = "" , xtraParams = "",siteCode = "",tranIdCrn = "";
		String sql  ="",userId = "",confirmed = "",errCode = "",errorString = "",
		tranIdRecAdj = "",chgTerm = "",retString = "";		
		String tranIdRec = "",currCode = "",custCode = "",acctCode = "",cctrCode = "",finEntity = "",
		bankCode = "",tranSer = "",refserPay = "";
		double exchRate = 0,totAmt = 0,adjAmt = 0;
		Timestamp refDate = null,dueDate = null;
		int count = 0,miscCnt = 0,adjCnt = 0,rowCnt = 0;
		java.sql.Timestamp currDate = null;
		boolean isError = false;
		try
		{
			tranId = sReturnDetailsMap.get("TRAN_ID");
			invoiceId = sReturnDetailsMap.get("INVOICE_ID");
			siteCode = sReturnDetailsMap.get("SITE_CODE");
			tranIdCrn = sReturnDetailsMap.get("TRAN_ID__CRN");
			xtraParams = sReturnDetailsMap.get("XTRA_PARAM");			

			currDate = new Timestamp(System.currentTimeMillis());			
			vdt=new ValidatorEJB();
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String tranDate = simpleDateFormatObj.format(currentDate.getTime());			

			System.out.println("invoiceId------->>["+invoiceId+"]");
			//Changed by samadhan on 10/02/2016 for invoice id blank where sales return conf start
			if(invoiceId.length() != 0 && invoiceId != null)
			{
				//Changed by samadhan on 10/02/2016 for invoice id blank where sales return conf end
				sql = "SELECT COUNT(*) FROM MISC_PAYABLES WHERE REF_NO = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, invoiceId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);				
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count > 0)
				{
					errCode = "VTINVALPR"; //entered invoice not present in invoice master
					errorString = vdt.getErrorString("invoice_id",errCode,userId);
					return errorString;
				}
				if(invoiceId.length() == 0)
				{
					errCode = "VTINVNN"; //invoice can not be empty
					errorString = vdt.getErrorString("invoice_id",errCode,userId);
					return errorString;
				}
				else
				{
					sql = "SELECT COUNT(*) FROM INVOICE WHERE INVOICE_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, invoiceId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						count = rs.getInt(1);				
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					if(count == 0)
					{
						errCode = "VTINVNE"; //entered invoice not present in invoice master
						errorString = vdt.getErrorString("invoice_id",errCode,userId);
						return errorString;
					}
				}
				sql = "SELECT CASE WHEN CONFIRMED IS NULL THEN 'N' ELSE CONFIRMED END FROM INVOICE WHERE INVOICE_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, invoiceId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					confirmed = checkNull(rs.getString(1));				
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("confirmed------->>["+confirmed+"]");

				if("N".equalsIgnoreCase(confirmed))
				{
					errCode = "VTINVN"; //invoice not confirmed
					errorString = vdt.getErrorString("invoice_id",errCode,userId);
					return errorString;
				}
				//Changed by samadhan on 10/02/2016 for invoice id blank where sales return conf start
				//else
				//{
			}	
			//Changed by samadhan on 10/02/2016 for invoice id blank where sales return conf End
			// select all necessary details from receivables 

			sql ="SELECT TRAN_SER,TRAN_ID,REF_DATE,CURR_CODE,EXCH_RATE,CUST_CODE,ACCT_CODE,CCTR_CODE,DUE_DATE,FIN_ENTITY,"
				+ "TOT_AMT,ADJ_AMT,BANK_CODE FROM RECEIVABLES WHERE REF_NO  = ?";
			//+ "( SELECT TRAN_ID FROM DRCR_RCP WHERE INVOICE_ID = ?) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdCrn);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				rowCnt++;
				tranSer = checkNull(rs.getString("TRAN_SER"));
				tranIdRec = checkNull(rs.getString("TRAN_ID"));
				refDate = rs.getTimestamp("REF_DATE"); 
				currCode = checkNull(rs.getString("CURR_CODE"));
				exchRate = rs.getDouble("EXCH_RATE");
				custCode = checkNull(rs.getString("CUST_CODE"));
				acctCode = checkNull(rs.getString("ACCT_CODE"));
				//		cctrCode = checkNull(rs.getString("CCTR_CODE"));
				cctrCode = rs.getString("CCTR_CODE");
				dueDate = rs.getTimestamp("DUE_DATE");
				finEntity = checkNull(rs.getString("FIN_ENTITY"));					
				totAmt = rs.getDouble("TOT_AMT");
				adjAmt = rs.getDouble("ADJ_AMT");
				bankCode = checkNull(rs.getString("BANK_CODE"));				

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("receivables totAmt------->>["+totAmt+"]");
			System.out.println("receivables adjAmt------->>["+adjAmt+"]");
			System.out.println("receivables rowCnt------->>["+adjAmt+"]");
			if(rowCnt == 0)
			{
				errCode = "VTNOREC1"; //No records found for processing.
				errorString = vdt.getErrorString("invoice_id",errCode,userId);
				return errorString;
			}
			if((totAmt - adjAmt) >= 0)
			{
				errCode = "VTTOTAMT"; //don't process if receivables is not negetive.
				errorString = vdt.getErrorString("invoice_id",errCode,userId);
				return errorString;
			}

			sql = "UPDATE RECEIVABLES SET ADJ_AMT = TOT_AMT, STAT_DATE  = ?,STATUS = ? "
				+ "WHERE REF_NO = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setTimestamp(1, currDate);
			pstmt.setString(2,"A");
			//pstmt.setString(3,invoiceId);
			pstmt.setString(3,tranIdCrn);
			rowCnt = pstmt.executeUpdate();
			System.out.println("receivables rowCnt------->>["+rowCnt+"]");

			pstmt.close();
			pstmt = null;

			//Changed by samadhan on 10/02/2016 for invoice id blank where sales return conf Start
			/*sql = "SELECT SALE_ORDER FROM INVOICE WHERE INVOICE_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, invoiceId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					saleOrder = checkNull(rs.getString("SALE_ORDER"));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				System.out.println("saleOrder====>>["+saleOrder+"]");*/
			//Changed by samadhan on 10/02/2016 for invoice id blank where sales return conf End

			//retString= recPayGetData(siteCode,saleOrder,custCode,xtraParams,conn);				
			// Generate misc_payables tran_id

			if("R-ADV".equalsIgnoreCase(tranSer))
			{
				refserPay = "RCPADV";
			}
			else
			{
				refserPay = "RCVCNV";
			}
			tranId = generateTranTd("T_PAYABLES",tranDate,siteCode,conn);
			System.out.println("generateTranTd tranid------->>["+tranId+"]");

			// Insert into misc_payables

			sql = "INSERT INTO MISC_PAYABLES (TRAN_ID,TRAN_SER,TRAN_DATE,REF_NO,REF_DATE,CURR_CODE,EXCH_RATE," 
				+ "SUNDRY_CODE,SUNDRY_TYPE,ACCT_CODE,CCTR_CODE,DUE_DATE,FIN_ENTITY,SITE_CODE," 
				+ "TOT_AMT,ADJ_AMT,STATUS,STATUS_DATE,BANK_CODE) "
				+ "VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?,? )"; 
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			pstmt.setString(2,tranSer);//refserPay
			pstmt.setTimestamp(3,currDate);
			pstmt.setString(4,tranIdCrn);//invoiceId
			pstmt.setTimestamp(5,refDate);				
			pstmt.setString(6,currCode);
			pstmt.setDouble(7, exchRate);

			pstmt.setString(8,custCode);
			pstmt.setString(9,"C");
			pstmt.setString(10,acctCode);
			pstmt.setString(11,cctrCode);
			pstmt.setTimestamp(12,dueDate);	
			pstmt.setString(13,finEntity);
			pstmt.setString(14,siteCode);

			pstmt.setDouble(15, totAmt * -1);
			pstmt.setDouble(16, adjAmt * -1);

			pstmt.setString(17,"U");
			pstmt.setTimestamp(18,currDate);	
			pstmt.setString(19,bankCode);

			miscCnt = pstmt.executeUpdate();
			System.out.println("MISC_PAYABLES miscCnt------->>["+miscCnt+"]");

			pstmt.close();
			pstmt = null;

			//insert into receivables_adj
			tranIdRecAdj = generateTranTd("T_MISC_REC_ADJ",tranDate,siteCode,conn);				
			System.out.println("generateTranTd tranid------->>["+tranId+"]");

			sql = "INSERT INTO RECEIVABLES_ADJ(	TRAN_ID,REF_SER,REF_NO,TOT_AMT,ADJ_AMT,REF_SER_ADJ,REF_NO_ADJ,"
				+ "NET_AMT,TRAN_ID__RCV ) values (?,?,?,?,?,?,?,?,?)"; 

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdRecAdj);
			pstmt.setString(2,tranSer);
			pstmt.setString(3,tranIdCrn);//invoiceId

			pstmt.setDouble(4, totAmt);
			pstmt.setDouble(5, adjAmt);

			pstmt.setString(6,refserPay);
			pstmt.setString(7,tranId);				
			pstmt.setDouble(8,totAmt - adjAmt);
			pstmt.setString(9, tranIdRec);

			adjCnt = pstmt.executeUpdate();
			System.out.println("RECEIVABLES_ADJ adjCnt------->>["+adjCnt+"]");

			pstmt.close();
			pstmt = null;

			System.out.println("custCode------->>["+custCode+"]");		



			System.out.println(" miscCnt--->>["+miscCnt+"]adjCnt -->>["+adjCnt+"]");
			if(adjCnt > 0 && miscCnt > 0)
			{
				retString = "Success";					
			}
			else
			{
				retString = "Error";					
			}  
			//}
		}
		catch(Exception e)
		{
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("isError in finally-------->>"+isError);			
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;					
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;					
				}				

			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return retString;
	}
	private String generateAutoPayment(Map<String,String> sReturnDetailsMap,Connection conn) throws ITMException,Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "",refNon = "",billNo = "",currCode = "",sundryCode = "",acctCode = "",cctrCode = "",rcpMode = "",
		returnStr = "",siteCode = "",finEntity = "",sundryType = "",bankCode = "",payMode = "Q",saleOrder = "",
		tranIdMisc = "",tranSer = "",sundryName = "",refNoInvoice = "",chgUser = "",chgTerm ="",refNo = "",
		retString = "",despId = "",tokenInfo = "",vpsTxId = "";	
		String tranId = "",invoiceId = "",xtraParams = "",tranIdCrn = "";
		String acctCodeBal= "",cctrCodeBal= "",acctCodeBc= "",cctrCodeBc= "",acctCodeCf= "",acctCodeCfAp= "",modName = "",
		cctrCodeCf = "",cctrCodeCfAp = "",currCodeBc = "",wfStatus = "",bankName = "",xmlOutString = "",currCodeS="";
		double exchRate = 0,advAmt = 0,holdAmt = 0,adjAmt = 0,totAmt = 0,payAmt = 0,netPayable = 0,excRateBc = 0,mexrate = 0;
		java.sql.Timestamp refDate = null,tranDate = null,billDate = null,dueDate = null;
		StringBuffer xmlString = null;		
		java.sql.Timestamp currDate = null;
		FinCommon fin=new FinCommon();
		//Added by sarita on 26DEC2017 to add userId
		String userId = "";
		try		
		{
			//Added by sarita on 26DEC2017 to add userId
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			System.out.println("In generateAutoPayment@@ :"+sReturnDetailsMap); 
			tranId = sReturnDetailsMap.get("TRAN_ID");
			invoiceId = sReturnDetailsMap.get("INVOICE_ID");					
			xtraParams = sReturnDetailsMap.get("XTRA_PARAM");
			tranIdCrn = sReturnDetailsMap.get("TRAN_ID__CRN");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");  			
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);

			sql = "SELECT REF_NO,TRAN_DATE,REF_DATE,BILL_NO,BILL_DATE,CURR_CODE,EXCH_RATE,SUNDRY_CODE,"
				+ "ACCT_CODE,CCTR_CODE,DUE_DATE,SITE_CODE,FIN_ENTITY,TOT_AMT,SUNDRY_TYPE,BANK_CODE,PAY_MODE,"
				+ "ADV_AMT,TRAN_ID,TRAN_SER,ADJ_AMT,HOLD_AMT,"
				+ "TOT_AMT - (CASE WHEN ADJ_AMT IS NULL THEN 0 ELSE ADJ_AMT END) - (CASE WHEN HOLD_AMT IS NULL THEN 0 ELSE HOLD_AMT END) AS PAY_AMT,"
				+ "FN_SUNDRY_NAME(SUNDRY_TYPE,SUNDRY_CODE,'') AS SUNDRY_NAME,"
				+ "TOT_AMT - (CASE WHEN ADJ_AMT IS NULL THEN 0 ELSE ADJ_AMT END) - (CASE WHEN HOLD_AMT IS NULL THEN 0 ELSE HOLD_AMT END) AS NET_PAYABLE "
				+ "FROM MISC_PAYABLES WHERE REF_NO = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdCrn);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				refNoInvoice = checkNull(rs.getString("REF_NO"));
				tranDate = rs.getTimestamp("TRAN_DATE");
				refDate = rs.getTimestamp("REF_DATE");
				billNo = checkNull(rs.getString("BILL_NO"));
				billDate = rs.getTimestamp("BILL_DATE");
				currCode = checkNull(rs.getString("CURR_CODE"));
				exchRate = rs.getDouble("EXCH_RATE");
				sundryCode = checkNull(rs.getString("SUNDRY_CODE"));
				acctCode = checkNull(rs.getString("ACCT_CODE"));
				cctrCode = rs.getString("CCTR_CODE");
				dueDate = rs.getTimestamp("DUE_DATE");
				siteCode = checkNull(rs.getString("SITE_CODE"));
				finEntity = checkNull(rs.getString("FIN_ENTITY"));
				totAmt = rs.getDouble("TOT_AMT");
				sundryType = checkNull(rs.getString("SUNDRY_TYPE"));
				bankCode = checkNull(rs.getString("BANK_CODE"));
				payMode = checkNull(rs.getString("PAY_MODE"));
				advAmt = rs.getDouble("ADV_AMT");
				tranIdMisc = checkNull(rs.getString("TRAN_ID"));
				tranSer = checkNull(rs.getString("TRAN_SER"));
				adjAmt = rs.getDouble("ADJ_AMT");
				holdAmt = rs.getDouble("HOLD_AMT");
				payAmt = rs.getDouble("PAY_AMT");
				netPayable = rs.getDouble("NET_PAYABLE");
				sundryName = checkNull(rs.getString("SUNDRY_NAME"));	
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	
			sql = "SELECT SALE_ORDER,DESP_ID FROM INVOICE WHERE INVOICE_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				saleOrder = checkNull(rs.getString("SALE_ORDER"));
				despId = checkNull(rs.getString("DESP_ID"));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql = "SELECT TOKEN_INFO FROM DESPATCH WHERE DESP_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, despId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tokenInfo = checkNull(rs.getString("TOKEN_INFO"));				
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("saleOrder--->>["+saleOrder+"] tokenInfo---->>["+tokenInfo+"]");
			//Changed by Samadhan on 11/01/2015 for received paypal transaction id. Start 
			System.out.println("saleOrder====>>["+saleOrder+"]");
			sql = "SELECT RCP_MODE,CURR_CODE FROM SORDER WHERE SALE_ORDER = ?";				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,saleOrder);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				rcpMode= checkNull(rs.getString(1));				
				currCodeS= checkNull(rs.getString(2));

			}	
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("rcpMode----->>["+rcpMode+"]");
			//Changed by Samadhan on 11/01/2015 for received paypal transaction id. End

			if(tokenInfo != null && tokenInfo.length() > 0)
			{
				Document dom1 = genericUtility.parseString(tokenInfo);
				//Changed by Samadhan on 11/12/2015 for paypal transaction id start
				/*vpsTxId= genericUtility.getColumnValue("VPSTXID", dom1);
				vpsTxId = vpsTxId.replace('{', ' ');
				vpsTxId = vpsTxId.replace('}', ' ');*/
				//Changed by Samadhan on 11/12/2015 for paypal transaction id End
				if("P".equalsIgnoreCase(rcpMode))
				{
					vpsTxId= genericUtility.getColumnValue("TRANSACTIONID", dom1);
				}
				else if("S".equalsIgnoreCase(rcpMode))
				{
					vpsTxId= genericUtility.getColumnValue("VPSTXID", dom1);
					vpsTxId = vpsTxId.replace('{', ' ');
					vpsTxId = vpsTxId.replace('}', ' ');
				}
				else if("C".equalsIgnoreCase(rcpMode))
				{
					vpsTxId= "";//Need to confirm for bank transfer.
				}
				vpsTxId = vpsTxId == null ? "" : vpsTxId.trim();
			}			
			refNo = vpsTxId;
			System.out.println("currCode--->>["+currCode+"] acctCode---->>["+acctCode+"]");
			System.out.println("payAmt--->>["+payAmt+"] netPayable---->>["+netPayable+"]");
			System.out.println("bankCode--->>["+bankCode+"] siteCode---->>["+siteCode+"]");
			payMode = "R";
			String tranType = "A";
			System.out.println("tranSer--->>["+tranSer+"] payMode---->>["+payMode+"]");
			//Changed by Samadhan on 11/01/2015 for received paypal transaction id. Start 
			/*System.out.println("saleOrder====>>["+saleOrder+"]");
			sql = "SELECT RCP_MODE,CURR_CODE FROM SORDER WHERE SALE_ORDER = ?";				
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,saleOrder);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				rcpMode= checkNull(rs.getString(1));				
				currCodeS= checkNull(rs.getString(2));

			}	
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("rcpMode----->>["+rcpMode+"]");*/
			//Changed by Samadhan on 11/01/2015 for received paypal transaction id. End
			if("P".equalsIgnoreCase(rcpMode))
			{
				modName = "W_PAYPAL";
			}
			else if("S".equalsIgnoreCase(rcpMode))
			{
				modName = "W_SAGEPAY";
			}
			else if("C".equalsIgnoreCase(rcpMode))
			{
				modName = "W_CASHINHAND";
			}
			sql = "SELECT DESCR FROM GENCODES WHERE MOD_NAME = ? AND FLD_NAME = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, modName);
			pstmt.setString(2, currCodeS);
			rs = pstmt.executeQuery();
			if (rs.next())
			{					
				bankCode = checkNull(rs.getString("descr"));
			}
			System.out.println("Bank Code is="+bankCode);
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;


			if(bankCode == null || bankCode.length() == 0)
			{
				sql = "SELECT BANK_CODE FROM SITE WHERE SITE_CODE = ?";				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					bankCode= checkNull(rs.getString(1));				

				}	
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}

			if ( bankCode != null && bankCode.length() > 0)
			{
				sql = "SELECT BANK_NAME FROM BANK WHERE BANK_CODE = ?";				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,bankCode);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					bankName= checkNull(rs.getString(1));				

				}	
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;				
			}



			sql="select acct_code__bal, cctr_code__bal, acct_code__bc, cctr_code__bc," +
			" acct_code__cf, acct_code__cf_ap, cctr_code__cf, cctr_code__cf_ap " +
			"from bank where bank_code = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,bankCode);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				acctCodeBal=checkNull(rs.getString("acct_code__bal"));
				cctrCodeBal=rs.getString("cctr_code__bal");
				acctCodeBc=checkNull(rs.getString("acct_code__bc"));
				cctrCodeBc=rs.getString("cctr_code__bc");
				acctCodeCf=checkNull(rs.getString("acct_code__cf"));
				acctCodeCfAp=checkNull(rs.getString("acct_code__cf_ap"));
				cctrCodeCf=rs.getString("cctr_code__cf");
				cctrCodeCfAp=rs.getString("acct_code__cf_ap");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("Site Code>>>>>>>>>>"+siteCode);

			sql="select curr_code  from site, finent " +
			"where site.fin_entity = finent.fin_entity and site_code =?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			rs = pstmt.executeQuery();			
			if(rs.next())
			{
				currCodeBc=checkNull(rs.getString("curr_code"));

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("currCodeBc=========="+currCodeBc);

			sql="select std_exrt  from currency where curr_code =? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,currCodeBc);
			rs = pstmt.executeQuery();			
			if(rs.next())
			{
				excRateBc=rs.getDouble("std_exrt");

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("excRateBc=========="+excRateBc);
			System.out.println("refNoInvoice--->>["+refNoInvoice+"]");
			mexrate=fin.getDailyExchRateSellBuy(currCode, "", siteCode, currDateStr, "B", conn);
			System.out.println("ExcRate from getDailyExchRateSellBuy========="+mexrate);

			xmlString = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
			xmlString.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
			xmlString.append("<Header0>");
			xmlString.append("<description>Header0 members</description>");
			xmlString.append("<objName><![CDATA[").append("misc_pay").append("]]></objName>");
			xmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");

			xmlString.append("<Detail1 dbID='' domID=\"1\" objName=\"misc_pay\" objContext=\"1\">");
			xmlString.append("<attribute pkNames=\"tran_id:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");
			xmlString.append("<tran_id><![CDATA[]]></tran_id>");			
			xmlString.append("<tran_date><![CDATA[" + checkNull(currDateStr) + "]]></tran_date>");			
			xmlString.append("<tran_type><![CDATA[" + checkNull(tranType) + "]]></tran_type>");
			xmlString.append("<sundry_type><![CDATA[" + checkNull(sundryType) + "]]></sundry_type>");
			xmlString.append("<sundry_code><![CDATA[" + checkNull(sundryCode) + "]]></sundry_code>");
			xmlString.append("<pay_mode><![CDATA[" + payMode + "]]></pay_mode>");
			xmlString.append("<bank_code><![CDATA[" + checkNull(bankCode) + "]]></bank_code>");
			xmlString.append("<ref_no><![CDATA[" + checkNull(refNo) + "]]></ref_no>");
			xmlString.append("<ref_date>").append("<![CDATA[").append(currDateStr).append("]]></ref_date>\r\n");
			//xmlString.append("<ref_date><![CDATA[" + dueDate + "]]></ref_date>");
			xmlString.append("<remarks><![CDATA[" + "Generate Automatic payment" + "]]></remarks>");
			xmlString.append("<net_amt><![CDATA[" + 0 + "]]></net_amt>");
			xmlString.append("<curr_code><![CDATA[" + checkNull(currCode) + "]]></curr_code>");
			//	xmlString.append("<exch_rate><![CDATA[" + mexrate + "]]></exch_rate>");

			//  Changed by Manish on 03/05/16 as per Shailes Sir [satrt]
			xmlString.append("<exch_rate><![CDATA[" + exchRate + "]]></exch_rate>");
			//  Changed by Manish on 03/05/16 as per Shailes Sir [end]

			xmlString.append("<net_amt__bc><![CDATA[" + 0 + "]]></net_amt__bc>");			
			xmlString.append("<site_code><![CDATA[" + checkNull(siteCode) + "]]></site_code>");
			//xmlString.append("<site_descr><![CDATA[" + checkNull(siteDescr) + "]]></site_descr>");/
			xmlString.append("<fin_entity><![CDATA[" + finEntity + "]]></fin_entity>");
			//xmlString.append("<finent_descr><![CDATA[" + checkNull(finentDescr) + "]]></finent_descr>");
			xmlString.append("<acct_code__bal><![CDATA[" + checkNull(acctCodeBal) + "]]></acct_code__bal>");
			xmlString.append("<cctr_code__bal><![CDATA[" + cctrCodeBal + "]]></cctr_code__bal>");
			xmlString.append("<auto_paid><![CDATA[" + "Y" + "]]></auto_paid>");		
			xmlString.append("<bank_charges><![CDATA[" + 0 + "]]></bank_charges>");
			xmlString.append("<acct_code__bc><![CDATA[" + checkNull(acctCodeBc) + "]]></acct_code__bc>");
			xmlString.append("<cctr_code__bc><![CDATA[" + cctrCodeBc + "]]></cctr_code__bc>");
			xmlString.append("<curr_code__bc><![CDATA[" + checkNull(currCodeBc) + "]]></curr_code__bc>");
			xmlString.append("<exch_rate__bc><![CDATA[" + excRateBc + "]]></exch_rate__bc>");	
			xmlString.append("<acct_code__cf><![CDATA[" + checkNull(acctCodeCf)+ "]]></acct_code__cf>");	
			xmlString.append("<cctr_code__cf><![CDATA[" + cctrCodeCf + "]]></cctr_code__cf>");
			xmlString.append("<tax_amt><![CDATA[" + 0 + "]]></tax_amt>");
			xmlString.append("<tax_date><![CDATA[" + checkNull(currDateStr) + "]]></tax_date>");
			//xmlString.append("<WF_STATUS ><![CDATA[" + checkNull(wfStatus) + "]]></WF_STATUS >");
			xmlString.append("<bank_name><![CDATA[" + checkNull(bankName) + "]]></bank_name>");

			xmlString.append("<confirmed><![CDATA[N]]></confirmed>");
			xmlString.append("<emp_code__conf><![CDATA[]]></emp_code__conf>");
			xmlString.append("<conf_date><![CDATA[]]></conf_date>");
			xmlString.append("<chg_user><![CDATA[" + chgUser + "]]></chg_user>");
			xmlString.append("<chg_term><![CDATA[" + chgTerm + "]]></chg_term>");
			xmlString.append("<chg_date><![CDATA[" + currDateStr + "]]></chg_date>");

			xmlString.append("</Detail1>");	
			String lineNo = "  1";
			String stanCode=checkNull(getStanDraw(sundryType, sundryCode, conn));						
			System.out.println("Getting stanCode=============="+stanCode);
			String drawnAt=checkNull(getpayablesAt(sundryType, sundryCode, bankCode, conn));

			xmlString.append("<Detail2 dbID=':' domID='1' objName='misc_pay' objContext='2'>");
			xmlString.append("<attribute pkNames='tran_id:line_no:' status='N' updateFlag='A' selected='N' />");
			xmlString.append("<tran_id><![CDATA[]]></tran_id>");
			xmlString.append("<tran_ser><![CDATA["+checkNull(tranSer)+"]]></tran_ser>");
			xmlString.append("<line_no><![CDATA["+lineNo+"]]></line_no>");							
			xmlString.append("<vouch_no><![CDATA["+checkNull(tranIdCrn)+"]]></vouch_no>");
			xmlString.append("<vouch_date><![CDATA[" + checkNull(currDateStr) + "]]></vouch_date>");//Added by Jaimin 25/07/2007
			xmlString.append("<net_amt><![CDATA["+payAmt+"]]></net_amt>");
			xmlString.append("<pay_amt><![CDATA["+payAmt+"]]></pay_amt>");
			xmlString.append("<curr_code><![CDATA["+currCodeBc+"]]></curr_code>");
			xmlString.append("<exch_rate__vouch><![CDATA["+exchRate+"]]></exch_rate__vouch>");							
			xmlString.append("<diff_amt__exch><![CDATA[0]]></diff_amt__exch>");							
			xmlString.append("<acct_code__ap><![CDATA["+checkNull(acctCode)+"]]></acct_code__ap>");//
			xmlString.append("<cctr_code__ap><![CDATA["+cctrCode+"]]></cctr_code__ap>");//
			xmlString.append("<sundry_type><![CDATA["+checkNull(sundryType)+"]]></sundry_type>");//
			xmlString.append("<sundry_code><![CDATA["+checkNull(sundryCode)+"]]></sundry_code>");//					
			xmlString.append("<bank_charges><![CDATA["+0+"]]></bank_charges>");
			xmlString.append("<stan_code><![CDATA["+stanCode+"]]></stan_code>");
			xmlString.append("<drawn_at><![CDATA["+drawnAt+"]]></drawn_at>");						
			xmlString.append("<tax_amt><![CDATA["+0+"]]></tax_amt>");
			xmlString.append("<net_pay_amt><![CDATA["+payAmt+"]]></net_pay_amt>");
			//xmlString.append("<acct_code__disc><![CDATA["+checkNull(acctCodeDisc)+"]]></acct_code__disc>");//
			//xmlString.append("<cctr_code__disc><![CDATA["+checkNull(cctrCodeDisc)+"]]></cctr_code__disc>");//	
			//xmlString.append("<tax_env><![CDATA["+exchRate+"]]></tax_env>");//doubtremaining
			xmlString.append("<bill_no><![CDATA["+billNo+"]]></bill_no>");
			xmlString.append("<bill_date><![CDATA["+currDateStr+"]]></bill_date>");
			xmlString.append("<exch_rate><![CDATA["+exchRate+"]]></exch_rate>");

			//xmlString.append("<discount_amt><![CDATA["+disAmt+"]]></discount_amt>");
			//xmlString.append("<discount><![CDATA["+discount+"]]></discount>");	


			xmlString.append("<tot_amt><![CDATA["+totAmt+"]]></tot_amt>");							
			xmlString.append("</Detail2>");		
			xmlString.append("</Header0></group0></DocumentRoot>");			
			xmlOutString  = xmlString.toString();
			System.out.println("XmlString Detail======"+xmlString.toString());
			//replace and added by sarita on 26DEC2017 to add userId parameter
			//retString=saveData(siteCode, xmlOutString, conn);
			retString=saveData(siteCode, xmlOutString, conn,userId);
			System.out.println("Before retString------>>["+retString+"]");

			// Commented by Sneha on 02/07/2015, Request ID: D15DKAT001
			/*
			if(retString != null && retString.indexOf("Success") > -1)
			{	
				return "success";
			}
			else
			{
				return retString;
			}
			 */
			// End by Sneha on 02/07/2015, Request ID: D15DKAT001
			return retString;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
	}
	public String confirmSalesReturn(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			System.out.println("-------in confirmSales Return mothod@@----------------["+xtraParams+"]");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for sale order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;			
			compName = "nvo_business_object_dist_sreturn_conf";
			serviceCode = "prcm_default_1";


			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,serviceCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;

	}
	private String saveSaleOrderData (String tranId ,String siteCode,String xtraParams,Connection conn) throws ITMException,Exception
	{

		String sql ="",saleOrder = "",applDate = "",dbDate = "",saleOrderNew = "",chgUser = "",chgTerm = "",saleOrderOld = "";		
		ResultSet rs = null,rs1 = null;		
		PreparedStatement pstmt = null,pstmt1 = null;
		applDate = genericUtility.getApplDateFormat();
		dbDate = genericUtility.getDBDateFormat();
		String custCode = "",buyerName = "",notifyTo = "",itemSer = "",custPord = "",salesPers = "",taxEnv = "",priceList = "",
		crTerm = "",remarks = "",dlvAdd1 = "",dlvAdd2 = "",dlvAdd3 = "",dlvCity = "",stateCodeDlv = "",counCodeDlv = "",
		tranCode = "",dlvTerm = "",empCodeOrd = "",transMode = "",rcpMode = "",dlvTo = "",currCode = "",dlvPin = "",
		acctCodeSal = "",tel1Dlv = "",tel2Dlv = "",tel3Dlv = "",faxDlv = "",siteCodeShip = "",pordMode = "",udfStr1 = "",
		orderType = "",stanCode = "",deptCode = "";
		String lineNoSord = "",siteCodeD = "",itemFlag = "",taxEnvD = "",itemDescr = "",unitRate = "",packCode = "",
		unitStd = "",itemSerD = "",holdFlag = "",itemCodeOrd = "",unit = "",itemCode = "";
		double quantity = 0,rate = 0,discount = 0,taxAmtD = 0,netAmt = 0,convQtyStduom = 0,quantityFc = 0,quantityStduom = 0,
		convRtuomStduom = 0,rateStdUom = 0,rateStd = 0,rateClg = 0,netTotAmt,totOrdValue = 0;
		double exchRate = 0,ordAmt = 0,taxAmt = 0,totAmt = 0,frtAmt = 0;
		java.sql.Timestamp orderDate = null,pordDate = null,taxDate = null,currDate = null;


		chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));		
		chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));

		try
		{
			currDate = getCurrtDate();
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			currDate = getCurrtDate();
			tranId = tranId == null ? "" : tranId.trim();
			sql = "SELECT I.SALE_ORDER FROM SRETURN R, INVOICE I WHERE R.INVOICE_ID = I.INVOICE_ID AND TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				saleOrder = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			saleOrder = saleOrder == null ? "" : saleOrder.trim();		

			if(saleOrder.length() > 0)
			{
				saleOrderNew =  generateTranId( "w_sorder", siteCode,  conn );
				System.out.println("saleOrderNew ---------->>["+saleOrderNew+"]");
				sql = "select sale_order,order_date,cust_code,buyer_name,notify_to,item_ser,cust_pord,pord_date,sales_pers,tax_env,tax_date,"//11
					+ "price_list,cr_term,site_code,curr_code,exch_rate,due_date,remarks,dlv_add1,dlv_add2,dlv_add3,dlv_city,state_code__dlv,"//23
					+ "count_code__dlv,dlv_pin,stan_code,tran_code,ord_amt,tax_amt,tot_amt,dlv_term,frt_amt,emp_code__ord,trans_mode,"//34
					+ "rcp_mode,dlv_to,acct_code__sal,tel1__dlv,tel2__dlv,tel3__dlv,fax__dlv,site_code__ship,pord_mode,udf__str1," //44

					+ "order_type,cust_code__dlv,cust_code__bil,tax_opt,pl_date,confirmed,part_qty,status,status_date," //53
					+ "consume_fc,curr_code__frt,curr_code__comm,curr_code__ins,frt_term,order_mode,exch_rate__ins,exch_rate__frt," //61
					+ "cctr_code__sal,label_type,outside_inspection,exch_rate__comm,hazard_yn,price_list__clg,terr_code,order_status," //69
					+ "available_yn,single_lot,ship_status,chg_date,chg_user,chg_term,udf__str2,comm_perc,alloc_flag,inv_amt,"
					+ "adv_perc,comm_perc_1,comm_perc_2,udf__num1,udf__num2,ins_amt,max_order_value,chq_name,chq_amount," //88
					+ "notify_term,ord_billback_amt,ord_offinv_amt,line_billback_amt,line_offinv_amt,pending_order,user_remarks,"
					+ "net_tot_amt,tot_ord_value,dept_code " //98

					+ "from sorder where sale_order = ?";						

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);

				rs = pstmt.executeQuery();					
				if(rs.next())
				{					
					saleOrderOld = checkNull(rs.getString("sale_order"));
					//orderDate = rs.getTimestamp("order_date");//
					custCode = checkNull(rs.getString("cust_code"));
					buyerName = checkNull(rs.getString("buyer_name"));
					notifyTo = checkNull(rs.getString("notify_to"));
					itemSer = checkNull(rs.getString("item_ser"));

					custPord = checkNull(rs.getString("cust_pord"));
					//pordDate = rs.getTimestamp("pord_date"); //
					salesPers = checkNull(rs.getString("sales_pers"));
					taxEnv = checkNull(rs.getString("tax_env"));
					taxDate = rs.getTimestamp("tax_date");//


					priceList = checkNull(rs.getString("price_list"));
					crTerm = checkNull(rs.getString("cr_term"));
					siteCode = checkNull(rs.getString("site_code"));
					currCode = checkNull(rs.getString("curr_code"));
					exchRate = rs.getDouble("exch_rate");
					//dueDate = checkNull(rs.getString("due_date"));

					remarks = checkNull(rs.getString("remarks"));
					dlvAdd1 = checkNull(rs.getString("dlv_add1"));
					dlvAdd2 = checkNull(rs.getString("dlv_add2"));
					dlvAdd3 = checkNull(rs.getString("dlv_add3"));
					dlvCity = checkNull(rs.getString("dlv_city"));

					stateCodeDlv = checkNull(rs.getString("state_code__dlv"));
					counCodeDlv = checkNull(rs.getString("count_code__dlv"));
					dlvPin = checkNull(rs.getString("dlv_pin"));
					stanCode = checkNull(rs.getString("stan_code"));
					tranCode = checkNull(rs.getString("tran_code"));
					ordAmt = rs.getDouble("ord_amt");
					taxAmt = rs.getDouble("tax_amt");

					totAmt = rs.getDouble("tot_amt");
					dlvTerm = checkNull(rs.getString("dlv_term"));
					frtAmt = rs.getDouble("frt_amt");
					empCodeOrd = checkNull(rs.getString("emp_code__ord"));
					transMode = checkNull(rs.getString("trans_mode"));
					rcpMode = checkNull(rs.getString("rcp_mode"));

					dlvTo = checkNull(rs.getString("dlv_to"));
					acctCodeSal = checkNull(rs.getString("acct_code__sal"));
					tel1Dlv = checkNull(rs.getString("tel1__dlv"));
					tel2Dlv = checkNull(rs.getString("tel2__dlv"));
					tel3Dlv = checkNull(rs.getString("tel3__dlv"));
					faxDlv = checkNull(rs.getString("fax__dlv"));			
					siteCodeShip = checkNull(rs.getString("site_code__ship"));
					pordMode = checkNull(rs.getString("pord_mode"));
					udfStr1 = saleOrder;//checkNull(rs.getString("udf__str1"));
					//orderType = checkNull(rs.getString("order_type"));
					netTotAmt = rs.getDouble("net_tot_amt");
					totOrdValue = rs.getDouble("tot_ord_value");
					deptCode = checkNull(rs.getString("dept_code"));

					sql = "insert into sorder (sale_order,order_date,cust_code,buyer_name,notify_to,item_ser,cust_pord,pord_date,sales_pers,tax_env,tax_date,"//11
						+ "price_list,cr_term,site_code,curr_code,exch_rate,due_date,remarks,dlv_add1,dlv_add2,dlv_add3,dlv_city,state_code__dlv,"//23
						+ "count_code__dlv,dlv_pin,stan_code,tran_code,ord_amt,tax_amt,tot_amt,dlv_term,frt_amt,emp_code__ord,trans_mode,"//34
						+ "rcp_mode,dlv_to,acct_code__sal,tel1__dlv,tel2__dlv,tel3__dlv,fax__dlv,site_code__ship,pord_mode,udf__str1," //44

						+ "order_type,cust_code__dlv,cust_code__bil,tax_opt,pl_date,confirmed,part_qty,status,status_date," //53
						+ "consume_fc,curr_code__frt,curr_code__comm,curr_code__ins,frt_term,order_mode,exch_rate__ins,exch_rate__frt," //61
						+ "cctr_code__sal,label_type,outside_inspection,exch_rate__comm,hazard_yn,price_list__clg,terr_code,order_status," //69
						+ "available_yn,single_lot,ship_status,chg_date,chg_user,chg_term,udf__str2,comm_perc,alloc_flag,inv_amt,"
						+ "adv_perc,comm_perc_1,comm_perc_2,udf__num1,udf__num2,ins_amt,max_order_value,chq_name,chq_amount," //88
						+ "notify_term,ord_billback_amt,ord_offinv_amt,line_billback_amt,line_offinv_amt,pending_order,"
						+ "net_tot_amt,tot_ord_value,dept_code) " //97

						+ "values (?,?,?,?,?,?,?,?,?,?,"
						+ "?,?,?,?,?,?,?,?,?,?,"
						+ "?,?,?,?,?,?,?,?,?,?,"
						+ "?,?,?,?,?,?,?,?,?,?,"
						+ "?,?,?,?,?,?,?,?,?,?,"
						+ "?,?,?,?,?,?,?,?,?,?,"
						+ "?,?,?,?,?,?,?,?,?,?,"  	

						+"?,?,?,?,?,?,?,?,?,?,"
						+"?,?,?,?,?,?,?,?,?,?, "
						+ "?,?,?,?,?,?,?)";

					System.out.println("SQl123@----->>["+sql+"]");						

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,saleOrderNew);
					pstmt.setTimestamp(2, currDate);
					pstmt.setString(3,custCode);
					pstmt.setString(4,buyerName);
					pstmt.setString(5,notifyTo);

					pstmt.setString(6,itemSer);
					if(custPord != null && custPord.length() > 0)
					{
						pstmt.setString(7,"RP-"+custPord);
					}
					else
					{
						pstmt.setString(7,custPord);
					}					
					pstmt.setTimestamp(8, currDate);
					pstmt.setString(9,salesPers);
					pstmt.setString(10,taxEnv);					
					pstmt.setTimestamp(11, currDate);					

					pstmt.setString(12,priceList);	
					pstmt.setString(13,crTerm);	
					pstmt.setString(14,siteCode);	
					pstmt.setString(15,currCode);	
					pstmt.setDouble(16, exchRate);
					pstmt.setTimestamp(17, currDate);
					pstmt.setString(18,remarks);

					pstmt.setString(19,dlvAdd1);
					pstmt.setString(20,dlvAdd2);
					pstmt.setString(21,dlvAdd3);
					pstmt.setString(22,dlvCity);
					pstmt.setString(23,stateCodeDlv);
					pstmt.setString(24,counCodeDlv);
					pstmt.setString(25,dlvPin);


					pstmt.setString(26,stanCode);
					pstmt.setString(27,tranCode);
					pstmt.setDouble(28,ordAmt);
					pstmt.setDouble(29,taxAmt);
					pstmt.setDouble(30,totAmt);
					pstmt.setString(31,dlvTerm);

					pstmt.setDouble(32,frtAmt);
					pstmt.setString(33,empCodeOrd);
					pstmt.setString(34,transMode);
					pstmt.setString(35,null);
					pstmt.setString(36,dlvTo);

					pstmt.setString(37,acctCodeSal);
					pstmt.setString(38,tel1Dlv);
					pstmt.setString(39,tel2Dlv);
					pstmt.setString(40,tel3Dlv);					
					pstmt.setString(41,faxDlv);

					pstmt.setString(42,siteCodeShip);
					pstmt.setString(43,pordMode);
					pstmt.setString(44,udfStr1); //Old Sale order

					//other data

					pstmt.setString(45,"RP");//order_type																	
					pstmt.setString(46,custCode);//cust_code__dlv
					pstmt.setString(47,custCode);//cust_code__bil								
					pstmt.setString(48,"L");//tax_opt  			
					pstmt.setTimestamp(49,currDate);//pl_date
					pstmt.setString(50,"N");//confirmed
					pstmt.setString(51,"2");//part_qty
					pstmt.setString(52,"P");//status			
					pstmt.setTimestamp(53,currDate);//status_date
					pstmt.setString(54,"Y");//consume_fc									
					pstmt.setString(55,currCode);//curr_code__frt  
					pstmt.setString(56,currCode);//curr_code__comm
					pstmt.setString(57,currCode);//curr_code__ins
					pstmt.setString(58,"T");//frt_term										
					pstmt.setString(59,"D");//order_mode						
					pstmt.setString(60,"0");//exch_rate__ins				
					pstmt.setString(61,"0");//exch_rate__frt
					pstmt.setString(62," ");//cctr_code__sal
					pstmt.setString(63,"N");//label_type

					pstmt.setString(64,"Y");//outside_inspection
					pstmt.setString(65,"0");//exch_rate__comm			 
					pstmt.setString(66,"N");//hazard_yn  


					pstmt.setString(67,priceList);//price_list__clg


					pstmt.setString(68," ");//terr_code
					pstmt.setString(69,"O");//order_status 
					pstmt.setString(70,"Y");//available_yn			
					pstmt.setString(71,"N");//single_lot
					pstmt.setString(72,"O");//ship_status			
					pstmt.setTimestamp(73,currDate);//chg_date
					pstmt.setString(74,chgUser);//chg_user
					pstmt.setString(75,chgTerm);//chg_term

					pstmt.setString(76,"");//udf__str2		

					pstmt.setInt(77,0);//comm_perc
					pstmt.setString(78,"N");//alloc_flag
					pstmt.setInt(79,0);//inv_amt
					pstmt.setInt(80,0);//adv_perc
					pstmt.setInt(81,0);//comm_perc_1
					pstmt.setInt(82,0);//comm_perc_2									
					//pstmt.setString(81,"D");//order_mode

					pstmt.setInt(83,0);//udf__num1
					pstmt.setInt(84,0);//udf__num2
					pstmt.setInt(85,0);//ins_amt

					pstmt.setInt(86,0);//max_order_value
					pstmt.setString(87,"DUMMY");//chq_name

					pstmt.setInt(88,0);//chq_amount
					pstmt.setString(89,"NA");//notify_term
					pstmt.setInt(90,0);//ord_billback_amt									
					pstmt.setInt(91,0);//ord_offinv_amt
					pstmt.setInt(92,0);//line_billback_amt

					pstmt.setInt(93,0);//line_offinv_amt

					pstmt.setString(94,"N");//pending_order	
					pstmt.setDouble(95,totAmt);
					pstmt.setDouble(96,totOrdValue);
					pstmt.setString(97,deptCode);//dept_code	


				}

				int rowsHdr = pstmt.executeUpdate();
				System.out.println("sorder rowsHdr------->>"+rowsHdr);
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}

				if(rowsHdr > 0)
				{
					double netTotAmtD = 0,ordValue=0;

					sql = "select line_no,site_code,item_flg,quantity,dsp_date,rate,discount,tax_amt,tax_env,net_amt,item_descr,"
						+ "item_code__ord,item_ser,hold_flag,unit,item_code,chg_date,chg_user,chg_term,conv__qty_stduom,"
						+ "unit__rate,pack_code,quantity__fc,unit__std,quantity__stduom,"
						+ "conv__rtuom_stduom,status,status_date,no_art,rate__clg,rate__std,rate__stduom," //7

						+ "ord_value,min_shelf_life,max_shelf_life,comm_perc_1,comm_perc_on_1,comm_perc_on_2," //6
						+ "comm_perc_3,comm_perc_on_3 ,item_ser__prom,over_ship_perc,sales_pers_comm_1," //5
						+ "sales_pers_comm_2,sales_pers_comm_3,loc_type,nature,net_tot_amt," //7
						+ "billback_amt,offinv_amt  from sorddet where sale_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, saleOrder);
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						lineNoSord = rs.getString("line_no");
						lineNoSord = "   " + lineNoSord;
						lineNoSord = lineNoSord.substring(lineNoSord.length()-3);
						siteCodeD = checkNull(rs.getString("site_code"));
						itemFlag = checkNull(rs.getString("item_flg"));
						quantity = rs.getDouble("quantity");
						//dspSDate = rs/getTimestamp("dsp_date");

						rate = rs.getDouble("rate");
						rateClg = rs.getDouble("rate__clg");
						rateStd = rs.getDouble("rate__std");
						rateStdUom = rs.getDouble("rate__stduom");

						discount = rs.getDouble("discount");
						taxAmtD = rs.getDouble("tax_amt");
						taxEnvD = checkNull(rs.getString("tax_env"));
						netAmt = rs.getDouble("net_amt");
						itemDescr = checkNull(rs.getString("item_descr"));
						itemCodeOrd = checkNull(rs.getString("item_code__ord"));
						itemSerD = checkNull(rs.getString("item_ser"));
						holdFlag = checkNull(rs.getString("hold_flag"));
						unit = checkNull(rs.getString("unit"));
						itemCode = checkNull(rs.getString("item_code"));
						//dspSDate = rs/getTimestamp("chg_date");
						convQtyStduom = rs.getDouble("conv__qty_stduom");
						unitRate = checkNull(rs.getString("unit__rate"));
						packCode = checkNull(rs.getString("pack_code"));
						quantityFc = rs.getDouble("quantity__fc");
						unitStd = checkNull(rs.getString("unit__std"));

						quantityStduom = rs.getDouble("quantity__stduom");
						convRtuomStduom = rs.getDouble("conv__rtuom_stduom");

						netTotAmtD = rs.getDouble("net_tot_amt");
						ordValue = rs.getDouble("ord_value");




						sql="insert into sorddet (sale_order,line_no,site_code,item_flg,quantity,dsp_date,rate,discount,tax_amt,tax_env,net_amt," //11
							+ "item_descr,item_code__ord,item_ser,hold_flag,unit,item_code,chg_date,chg_user,chg_term, " //20

							+"conv__qty_stduom,unit__rate,pack_code,quantity__fc,unit__std,quantity__stduom," //26
							+ "conv__rtuom_stduom,status,status_date,no_art,rate__clg,rate__std,rate__stduom," //33

							+ "ord_value,min_shelf_life,max_shelf_life,comm_perc_1,comm_perc_on_1,comm_perc_on_2," //6
							+ "comm_perc_3,comm_perc_on_3 ,item_ser__prom,over_ship_perc,sales_pers_comm_1," //5
							+ "sales_pers_comm_2,sales_pers_comm_3,loc_type,nature," //7
							+ "billback_amt,offinv_amt,appl_seg,net_tot_amt ) " //2

							+ "values(?,?,?,?,?,?,?,?,?,?,"
							+ "?,?,?,?,?,?,?,?,?,?,"
							+"?,?,?,?,?,?,?,?,?,?,"
							+"?,?,?,?,?,?,?,?,?,?,"
							+"?,?,?,?,?,?,?,?,?,?,?,?)"; //52

						pstmt1 = conn.prepareStatement(sql);
						pstmt1.setString(1, saleOrderNew);
						pstmt1.setString(2, lineNoSord);
						pstmt1.setString(3, siteCodeD);
						pstmt1.setString(4, itemFlag);
						pstmt1.setDouble(5, quantity);

						pstmt1.setTimestamp(6, currDate); //dsp_date
						pstmt1.setDouble(7, rate);
						pstmt1.setDouble(8, discount);
						pstmt1.setDouble(9, taxAmtD);
						pstmt1.setString(10, taxEnvD);
						pstmt1.setDouble(11, netAmt);

						pstmt1.setString(12, itemDescr);
						pstmt1.setString(13, itemCodeOrd);
						pstmt1.setString(14, itemSer);
						pstmt1.setString(15, holdFlag);

						pstmt1.setString(16, unit);
						pstmt1.setString(17, itemCode);
						pstmt1.setTimestamp(18, currDate); //chgDate
						pstmt1.setString(19, chgUser);
						pstmt1.setString(20, chgTerm);

						pstmt1.setDouble(21, convQtyStduom);
						pstmt1.setString(22, unitRate);
						pstmt1.setString(23, packCode);
						pstmt1.setDouble(24, quantityFc);
						pstmt1.setString(25, unitStd);
						pstmt1.setDouble(26, quantityStduom);

						pstmt1.setDouble(27, convRtuomStduom);

						pstmt1.setString(28,"N");//status
						pstmt1.setTimestamp(29,currDate);//status_date
						pstmt1.setString(30,"1");//no_art
						pstmt1.setDouble(31,rateClg);//rate__clg
						pstmt1.setDouble(32,rateStd);//rate__std
						pstmt1.setDouble(33,rateStdUom);//rate__stduom

						/*double ordValue=quantity * rate;
						System.out.println("ordValue--->>"+ordValue +" ("+quantity +" * "+rate+")");*/											
						pstmt1.setDouble(34,ordValue);//ord_value
						pstmt1.setInt(35,0);//min_shelf_life
						pstmt1.setInt(36,0);//maxShelf
						pstmt1.setInt(37,0);//comm_perc_1
						pstmt1.setString(38,null);//comm_perc_on_1
						pstmt1.setString(39,null);//comm_perc_on_2

						pstmt1.setInt(40,0);//comm_perc_3
						pstmt1.setString(41,null);//comm_perc_on_3
						pstmt1.setString(42,null);//item_ser__prom
						pstmt1.setInt(43,0);//over_ship_perc
						pstmt1.setInt(44,0);//sales_pers_comm_1

						pstmt1.setInt(45,0);//sales_pers_comm_2
						pstmt1.setInt(46,0);//sales_pers_comm_3

						pstmt1.setString(47,"N");//loc_type
						pstmt1.setString(48,"C");//nature
						pstmt1.setInt(49,0);//billback_amt
						pstmt1.setInt(50,0);//offinv_amt	
						pstmt1.setString(51,"0");//appl_seg
						pstmt1.setDouble(52,netTotAmtD);


						int rows=pstmt1.executeUpdate();
						System.out.println("rows in detail ----["+rows+"]");
						if(pstmt1 != null)
						{
							pstmt1.close();
							pstmt1 = null;
						}
						if(rows > 0)
						{
							return "Success";
						}			


					}
				}


			} //end sale order condition

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}

		}
		return "Error";

	}
	private String saveSaleOrderDataNew (Map <String,String>sreturnDetailMap,Connection conn) throws ITMException,Exception
	{
		System.out.println("-----------in saveSaleOrderDataNew-----------------------");		

		String sql ="",saleOrder = "",applDate = "",dbDate = "",saleOrderNew = "",chgUser = "",chgTerm = "",saleOrderOld = "";		
		ResultSet rs = null,rs1 = null;		
		PreparedStatement pstmt = null,pstmt1 = null;
		applDate = genericUtility.getApplDateFormat();
		dbDate = genericUtility.getDBDateFormat();
		String tranId = "",siteCode = "",xtraParams = "", invoiceId = "";
		String custCode = "",buyerName = "",notifyTo = "",itemSer = "",custPord = "",salesPers = "",taxEnv = "",priceList = "",
		crTerm = "",remarks = "",dlvAdd1 = "",dlvAdd2 = "",dlvAdd3 = "",dlvCity = "",stateCodeDlv = "",counCodeDlv = "",
		tranCode = "",dlvTerm = "",empCodeOrd = "",transMode = "",rcpMode = "",dlvTo = "",currCode = "",dlvPin = "",
		acctCodeSal = "",tel1Dlv = "",tel2Dlv = "",tel3Dlv = "",faxDlv = "",siteCodeShip = "",pordMode = "",udfStr1 = "",
		orderType = "",stanCode = "",deptCode = "",custSpecNo = "",specRef = "";
		String lineNoSord = "",siteCodeD = "",itemFlag = "",taxEnvD = "",itemDescr = "",unitRate = "",packCode = "",
		unitStd = "",itemSerD = "",holdFlag = "",itemCodeOrd = "",unit = "",itemCode = "";
		String chqName = "",currCodeIns = "",currCodeFrt = "";
		double chqAmount = 0,exchRateIns = 0;
		double quantity = 0,rate = 0,discount = 0,taxAmtD = 0,netAmt = 0,convQtyStduom = 0,quantityFc = 0,quantityStduom = 0,
		convRtuomStduom = 0,rateStdUom = 0,rateStd = 0,rateClg = 0,netTotAmt = 0,totOrdValue = 0;
		double exchRate = 0,ordAmt = 0,taxAmt = 0,totAmt = 0,frtAmt = 0;
		java.sql.Timestamp orderDate = null,pordDate = null,taxDate = null,currDate = null;

		StringBuffer xmlBuffer = new StringBuffer();
		tranId = sreturnDetailMap.get("TRAN_ID");
		siteCode = sreturnDetailMap.get("SITE_CODE");
		invoiceId = sreturnDetailMap.get("INVOICE_ID");
		xtraParams = sreturnDetailMap.get("XTRA_PARAM");		

		chgUser = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode"));		
		chgTerm = checkNull(genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId"));
		//Added by sarita on 26DEC2017 to add userId
		String userId = "";
		try
		{
			//Added by sarita on 26DEC2017 to add userId
			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			currDate = getCurrtDate();
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);
			//currDate = getCurrtDate();
			tranId = tranId == null ? "" : tranId.trim();
			sql = "SELECT I.SALE_ORDER FROM SRETURN R, INVOICE I WHERE R.INVOICE_ID = I.INVOICE_ID AND TRAN_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				saleOrder = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			saleOrder = saleOrder == null ? "" : saleOrder.trim();		

			if(saleOrder.length() > 0)
			{
				saleOrderNew =  generateTranId( "w_sorder", siteCode,  conn );
				System.out.println("saleOrderNew ---------->>["+saleOrderNew+"]");
				sql = "select sale_order,order_date,cust_code,buyer_name,notify_to,item_ser,cust_pord,pord_date,sales_pers,tax_env,tax_date,"//11
					+ "price_list,cr_term,site_code,curr_code,exch_rate,due_date,remarks,dlv_add1,dlv_add2,dlv_add3,dlv_city,state_code__dlv,"//23
					+ "count_code__dlv,dlv_pin,stan_code,tran_code,ord_amt,tax_amt,tot_amt,dlv_term,frt_amt,emp_code__ord,trans_mode,"//34
					+ "rcp_mode,dlv_to,acct_code__sal,tel1__dlv,tel2__dlv,tel3__dlv,fax__dlv,site_code__ship,pord_mode,udf__str1," //44

					+ "order_type,cust_code__dlv,cust_code__bil,tax_opt,pl_date,confirmed,part_qty,status,status_date," //53
					+ "consume_fc,curr_code__frt,curr_code__comm,curr_code__ins,frt_term,order_mode,exch_rate__ins,exch_rate__frt," //61
					+ "cctr_code__sal,label_type,outside_inspection,exch_rate__comm,hazard_yn,price_list__clg,terr_code,order_status," //69
					+ "available_yn,single_lot,ship_status,chg_date,chg_user,chg_term,udf__str2,comm_perc,alloc_flag,inv_amt,"
					+ "adv_perc,comm_perc_1,comm_perc_2,udf__num1,udf__num2,ins_amt,max_order_value,chq_name,chq_amount," //88
					+ "notify_term,ord_billback_amt,ord_offinv_amt,line_billback_amt,line_offinv_amt,pending_order,user_remarks,"
					+ "net_tot_amt,tot_ord_value,dept_code " //98

					+ "from sorder where sale_order = ?";						

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);

				rs = pstmt.executeQuery();					
				if(rs.next())
				{					
					saleOrderOld = checkNull(rs.getString("sale_order"));
					//orderDate = rs.getTimestamp("order_date");//
					custCode = checkNull(rs.getString("cust_code"));
					buyerName = checkNull(rs.getString("buyer_name"));
					notifyTo = checkNull(rs.getString("notify_to"));
					itemSer = checkNull(rs.getString("item_ser"));

					custPord = checkNull(rs.getString("cust_pord"));
					//pordDate = rs.getTimestamp("pord_date"); //
					salesPers = checkNull(rs.getString("sales_pers"));
					taxEnv = checkNull(rs.getString("tax_env"));
					taxDate = rs.getTimestamp("tax_date");//

					priceList = checkNull(rs.getString("price_list"));
					crTerm = checkNull(rs.getString("cr_term"));
					siteCode = checkNull(rs.getString("site_code"));
					currCode = checkNull(rs.getString("curr_code"));
					exchRate = rs.getDouble("exch_rate");
					//dueDate = checkNull(rs.getString("due_date"));

					remarks = checkNull(rs.getString("remarks"));
					dlvAdd1 = checkNull(rs.getString("dlv_add1"));
					dlvAdd2 = checkNull(rs.getString("dlv_add2"));
					dlvAdd3 = checkNull(rs.getString("dlv_add3"));
					dlvCity = checkNull(rs.getString("dlv_city"));

					stateCodeDlv = checkNull(rs.getString("state_code__dlv"));
					counCodeDlv = checkNull(rs.getString("count_code__dlv"));
					dlvPin = checkNull(rs.getString("dlv_pin"));
					stanCode = checkNull(rs.getString("stan_code"));
					tranCode = checkNull(rs.getString("tran_code"));
					ordAmt = rs.getDouble("ord_amt");
					taxAmt = rs.getDouble("tax_amt");

					totAmt = rs.getDouble("tot_amt");
					dlvTerm = checkNull(rs.getString("dlv_term"));
					//frtAmt = rs.getDouble("frt_amt");
					empCodeOrd = checkNull(rs.getString("emp_code__ord"));
					transMode = checkNull(rs.getString("trans_mode"));
					rcpMode = checkNull(rs.getString("rcp_mode"));

					dlvTo = checkNull(rs.getString("dlv_to"));
					acctCodeSal = checkNull(rs.getString("acct_code__sal"));
					tel1Dlv = checkNull(rs.getString("tel1__dlv"));
					tel2Dlv = checkNull(rs.getString("tel2__dlv"));
					tel3Dlv = checkNull(rs.getString("tel3__dlv"));
					faxDlv = checkNull(rs.getString("fax__dlv"));			
					siteCodeShip = checkNull(rs.getString("site_code__ship"));
					pordMode = checkNull(rs.getString("pord_mode"));
					udfStr1 = saleOrder;//checkNull(rs.getString("udf__str1"));
					//orderType = checkNull(rs.getString("order_type"));
					//netTotAmt = rs.getDouble("net_tot_amt");
					totOrdValue = rs.getDouble("tot_ord_value");
					deptCode = checkNull(rs.getString("dept_code"));
					chqName = checkNull(rs.getString("chq_name"));
					exchRateIns = rs.getDouble("exch_rate__ins");
					currCodeIns = checkNull(rs.getString("curr_code__ins"));
					currCodeFrt = checkNull(rs.getString("curr_code__frt"));

					xmlBuffer.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
					xmlBuffer.append("<DocumentRoot>");
					xmlBuffer.append("<description>").append("Datawindow Root").append("</description>");
					xmlBuffer.append("<group0>");
					xmlBuffer.append("<description>").append("Group0 description").append("</description>");
					xmlBuffer.append("<Header0>");
					xmlBuffer.append("<objName><![CDATA[").append("upload_sorder").append("]]></objName>");
					xmlBuffer.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
					xmlBuffer.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
					xmlBuffer.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
					xmlBuffer.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
					xmlBuffer.append("<action><![CDATA[").append("SAVE").append("]]></action>");
					xmlBuffer.append("<elementName><![CDATA[").append("").append("]]></elementName>");
					xmlBuffer.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
					xmlBuffer.append("<taxKeyValue><![CDATA[").append("	").append("]]></taxKeyValue>");
					xmlBuffer.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
					xmlBuffer.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
					xmlBuffer.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
					xmlBuffer.append("<description>").append("Header0 members").append("</description>");

					xmlBuffer.append("<Detail1 objContext =\"1\"").append(" objName=\"upload_sorder\" domID=\"1\" dbID=\"\">");
					xmlBuffer.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");

					xmlBuffer.append("<sale_order><![CDATA[").append(saleOrderNew).append("]]></sale_order>");
					xmlBuffer.append("<order_date>").append("<![CDATA[").append(currDateStr).append("]]></order_date>\r\n");

					xmlBuffer.append("<order_type>").append("<![CDATA[").append("RP").append("]]></order_type>\r\n");
					xmlBuffer.append("<cust_code>").append("<![CDATA[").append(custCode).append("]]></cust_code>\r\n");
					xmlBuffer.append("<cust_code__dlv>").append("<![CDATA[").append(custCode).append("]]></cust_code__dlv>\r\n");
					xmlBuffer.append("<cust_code__bil>").append("<![CDATA[").append(custCode).append("]]></cust_code__bil>\r\n");
					xmlBuffer.append("<cust_name__bil>").append("<![CDATA[").append(custCode).append("]]></cust_name__bil>\r\n");

					xmlBuffer.append("<tax_opt>").append("<![CDATA[").append("L").append("]]></tax_opt>\r\n");
					xmlBuffer.append("<item_ser>").append("<![CDATA[").append(itemSer).append("]]></item_ser>\r\n");
					xmlBuffer.append("<cust_pord>").append("<![CDATA[").append("").append("]]></cust_pord>\r\n");
					xmlBuffer.append("<tax_env>").append("<![CDATA[").append(taxEnv).append("]]></tax_env>\r\n");
					xmlBuffer.append("<tax_date>").append("<![CDATA[").append(currDateStr).append("]]></tax_date>\r\n");
					xmlBuffer.append("<pl_date>").append("<![CDATA[").append(currDateStr).append("]]></pl_date>\r\n");

					xmlBuffer.append("<cr_term>").append("<![CDATA[").append(crTerm).append("]]></cr_term>\r\n");
					xmlBuffer.append("<site_code>").append("<![CDATA[").append(siteCode).append("]]></site_code>\r\n");
					xmlBuffer.append("<confirmed>").append("<![CDATA[").append("N").append("]]></confirmed>\r\n");
					xmlBuffer.append("<curr_code>").append("<![CDATA[").append(currCode).append("]]></curr_code>\r\n");
					xmlBuffer.append("<due_date>").append("<![CDATA[").append(currDateStr).append("]]></due_date>\r\n");

					xmlBuffer.append("<dlv_add1>").append("<![CDATA[").append(dlvAdd1).append("]]></dlv_add1>\r\n");
					xmlBuffer.append("<dlv_add2>").append("<![CDATA[").append(dlvAdd2).append("]]></dlv_add2>\r\n");
					xmlBuffer.append("<dlv_add3>").append("<![CDATA[").append(dlvAdd3).append("]]></dlv_add3>\r\n");
					xmlBuffer.append("<dlv_city>").append("<![CDATA[").append(dlvCity).append("]]></dlv_city>\r\n");
					xmlBuffer.append("<state_code__dlv>").append("<![CDATA[").append(stateCodeDlv).append("]]></state_code__dlv>\r\n");

					xmlBuffer.append("<count_code__dlv>").append("<![CDATA[").append(counCodeDlv).append("]]></count_code__dlv>\r\n");
					xmlBuffer.append("<dlv_pin>").append("<![CDATA[").append(dlvPin).append("]]></dlv_pin>\r\n");
					xmlBuffer.append("<stan_code>").append("<![CDATA[").append(stanCode).append("]]></stan_code>\r\n");
					xmlBuffer.append("<part_qty>").append("<![CDATA[").append("2").append("]]></part_qty>\r\n");
					xmlBuffer.append("<status>").append("<![CDATA[").append("P").append("]]></status>\r\n");

					xmlBuffer.append("<status_date>").append("<![CDATA[").append(currDateStr).append("]]></status_date>\r\n");
					xmlBuffer.append("<consume_fc>").append("<![CDATA[").append("Y").append("]]></consume_fc>\r\n");
					xmlBuffer.append("<tran_code>").append("<![CDATA[").append(tranCode).append("]]></tran_code>\r\n");
					//xmlBuffer.append("<chg_date>").append("<![CDATA[").append(currDate).append("]]></chg_date>\r\n");
					//xmlBuffer.append("<chg_user>").append("<![CDATA[").append(currDate).append("]]></chg_user>\r\n");
					//xmlBuffer.append("<chg_term>").append("<![CDATA[").append(currDate).append("]]></chg_term>\r\n");


					xmlBuffer.append("<udf__str1>").append("<![CDATA[").append(saleOrderOld).append("]]></udf__str1>\r\n");
					//xmlBuffer.append("<udf__str2>").append("<![CDATA[").append(currDate).append("]]></udf__str2>\r\n");
					xmlBuffer.append("<dlv_term>").append("<![CDATA[").append("NA").append("]]></dlv_term>\r\n");
					xmlBuffer.append("<curr_code__frt>").append("<![CDATA[").append(currCodeFrt).append("]]></curr_code__frt>\r\n");

					xmlBuffer.append("<tot_amt>").append("<![CDATA[").append(totAmt).append("]]></tot_amt>\r\n");
					xmlBuffer.append("<frt_term>").append("<![CDATA[").append("T").append("]]></frt_term>\r\n");
					xmlBuffer.append("<alloc_flag>").append("<![CDATA[").append("Y").append("]]></alloc_flag>\r\n");
					xmlBuffer.append("<emp_code__ord>").append("<![CDATA[").append(empCodeOrd).append("]]></emp_code__ord>\r\n");
					xmlBuffer.append("<pord_date>").append("<![CDATA[").append(currDateStr).append("]]></pord_date>\r\n");


					xmlBuffer.append("<exch_rate>").append("<![CDATA[").append(exchRate).append("]]></exch_rate>\r\n");
					xmlBuffer.append("<ord_amt>").append("<![CDATA[").append(ordAmt).append("]]></ord_amt>\r\n");
					xmlBuffer.append("<tax_amt>").append("<![CDATA[").append(taxAmt).append("]]></tax_amt>\r\n");
					//xmlBuffer.append("<udf__num1>").append("<![CDATA[").append(currDate).append("]]></udf__num1>\r\n");
					//xmlBuffer.append("<udf__num2>").append("<![CDATA[").append(currDate).append("]]></udf__num2>\r\n");

					xmlBuffer.append("<frt_amt>").append("<![CDATA[").append(frtAmt).append("]]></frt_amt>\r\n");
					xmlBuffer.append("<trans_mode>").append("<![CDATA[").append(transMode).append("]]></trans_mode>\r\n");
					xmlBuffer.append("<rcp_mode>").append("<![CDATA[").append("").append("]]></rcp_mode>\r\n");
					xmlBuffer.append("<order_mode>").append("<![CDATA[").append("D").append("]]></order_mode>\r\n");
					xmlBuffer.append("<curr_code__ins>").append("<![CDATA[").append(currCodeIns).append("]]></curr_code__ins>\r\n");

					xmlBuffer.append("<exch_rate__ins>").append("<![CDATA[").append(exchRateIns).append("]]></exch_rate__ins>\r\n");
					xmlBuffer.append("<dlv_to>").append("<![CDATA[").append(dlvTo).append("]]></dlv_to>\r\n");
					xmlBuffer.append("<tel1__dlv>").append("<![CDATA[").append(tel1Dlv).append("]]></tel1__dlv>\r\n");
					xmlBuffer.append("<tel2__dlv>").append("<![CDATA[").append(tel2Dlv).append("]]></tel2__dlv>\r\n");
					xmlBuffer.append("<fax__dlv>").append("<![CDATA[").append(faxDlv).append("]]></fax__dlv>\r\n");


					//xmlBuffer.append("<email_addr>").append("<![CDATA[").append(email).append("]]></email_addr>\r\n");
					xmlBuffer.append("<tot_ord_value>").append("<![CDATA[").append(totOrdValue).append("]]></tot_ord_value>\r\n");
					xmlBuffer.append("<site_code__ship>").append("<![CDATA[").append(siteCodeShip).append("]]></site_code__ship>\r\n");
					//xmlBuffer.append("<cheque_no>").append("<![CDATA[").append(currDate).append("]]></cheque_no>\r\n");
					//xmlBuffer.append("<cheque_date>").append("<![CDATA[").append(currDate).append("]]></cheque_date>\r\n");

					xmlBuffer.append("<pord_mode>").append("<![CDATA[").append(pordMode).append("]]></pord_mode>\r\n");
					xmlBuffer.append("<chq_amount>").append("<![CDATA[").append(chqAmount).append("]]></chq_amount>\r\n");
					xmlBuffer.append("<chq_name>").append("<![CDATA[").append(chqName).append("]]></chq_name>\r\n");
					//xmlBuffer.append("<licence_no_1>").append("<![CDATA[").append(currDate).append("]]></licence_no_1>\r\n");
					xmlBuffer.append("<order_status>").append("<![CDATA[").append("O").append("]]></order_status>\r\n");

					xmlBuffer.append("<notify_to>").append("<![CDATA[").append(notifyTo).append("]]></notify_to>\r\n");
					xmlBuffer.append("<buyer_name>").append("<![CDATA[").append(buyerName).append("]]></buyer_name>\r\n");
					xmlBuffer.append("<single_lot>").append("<![CDATA[").append("N").append("]]></single_lot>\r\n");
					//xmlBuffer.append("<pending_order>").append("<![CDATA[").append(pendingOrder).append("]]></pending_order>\r\n");
					xmlBuffer.append("<net_tot_amt>").append("<![CDATA[").append(totAmt).append("]]></net_tot_amt>\r\n");

					xmlBuffer.append("<ship_status>").append("<![CDATA[").append("P").append("]]></ship_status>\r\n");
					xmlBuffer.append("<user_remarks>").append("<![CDATA[").append("").append("]]></user_remarks>\r\n");

					xmlBuffer.append("</Detail1>\r\n");	

				}			

				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


				double netTotAmtD = 0,ordValue=0;
				int domId = 0;
				/*sql = "select line_no,site_code,item_flg,quantity,dsp_date,rate,discount,tax_amt,tax_env,net_amt,item_descr,"
						+ "item_code__ord,item_ser,hold_flag,unit,item_code,chg_date,chg_user,chg_term,conv__qty_stduom,"
						+ "unit__rate,pack_code,quantity__fc,unit__std,quantity__stduom,"
						+ "conv__rtuom_stduom,status,status_date,no_art,rate__clg,rate__std,rate__stduom," //7

						+ "ord_value,min_shelf_life,max_shelf_life,comm_perc_1,comm_perc_on_1,comm_perc_on_2," //6
						+ "comm_perc_3,comm_perc_on_3 ,item_ser__prom,over_ship_perc,sales_pers_comm_1," //5
						+ "sales_pers_comm_2,sales_pers_comm_3,loc_type,nature,net_tot_amt," //7
						+ "billback_amt,offinv_amt,cust_spec__no,spec_ref  from sorddet where sale_order = ?";*/

				sql = "SELECT S.LINE_NO,S.SITE_CODE,S.ITEM_FLG,S.QUANTITY,S.DSP_DATE,S.RATE,S.DISCOUNT,S.TAX_AMT,S.TAX_ENV,S.NET_AMT,S.ITEM_DESCR, "
					+ "S.ITEM_CODE__ORD,S.ITEM_SER,S.HOLD_FLAG,S.UNIT,S.ITEM_CODE,S.CHG_DATE,S.CHG_USER,S.CHG_TERM,S.CONV__QTY_STDUOM, "
					+ "S.UNIT__RATE,S.PACK_CODE,S.QUANTITY__FC,S.UNIT__STD,S.QUANTITY__STDUOM, "
					+ "S.CONV__RTUOM_STDUOM,S.STATUS,S.STATUS_DATE,S.NO_ART,S.RATE__CLG,S.RATE__STD,S.RATE__STDUOM, " 
					+ "S.ORD_VALUE,S.MIN_SHELF_LIFE,S.MAX_SHELF_LIFE,S.COMM_PERC_1,S.COMM_PERC_ON_1,S.COMM_PERC_ON_2, "  
					+ "S.COMM_PERC_3,S.COMM_PERC_ON_3 ,S.ITEM_SER__PROM,S.OVER_SHIP_PERC,S.SALES_PERS_COMM_1, "
					+ "S.SALES_PERS_COMM_2,S.SALES_PERS_COMM_3,S.LOC_TYPE,S.NATURE,S.NET_TOT_AMT, "
					+ "S.BILLBACK_AMT,S.OFFINV_AMT,S.CUST_SPEC__NO,S.SPEC_REF  " 
					+ "FROM SORDDET S, INVOICE_TRACE I, SRETURNDET SR  "
					+ "WHERE S.LINE_NO = I.SORD_LINE_NO AND SR.LINE_NO__INV = I.LINE_NO AND "
					+ "S.SALE_ORDER = ? AND SR.TRAN_ID = ? AND I.INVOICE_ID = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, saleOrder);
				pstmt.setString(2, tranId);
				pstmt.setString(3, invoiceId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					domId++;
					lineNoSord = rs.getString("line_no");
					lineNoSord = "   " + lineNoSord;
					lineNoSord = lineNoSord.substring(lineNoSord.length()-3);
					siteCodeD = checkNull(rs.getString("site_code"));
					itemFlag = checkNull(rs.getString("item_flg"));
					quantity = rs.getDouble("quantity");
					//dspSDate = rs/getTimestamp("dsp_date");

					rate = rs.getDouble("rate");
					rateClg = rs.getDouble("rate__clg");
					rateStd = rs.getDouble("rate__std");
					rateStdUom = rs.getDouble("rate__stduom");

					discount = rs.getDouble("discount");
					taxAmtD = rs.getDouble("tax_amt");
					taxEnvD = checkNull(rs.getString("tax_env"));
					netAmt = rs.getDouble("net_amt");
					itemDescr = checkNull(rs.getString("item_descr"));
					itemCodeOrd = checkNull(rs.getString("item_code__ord"));
					itemSerD = checkNull(rs.getString("item_ser"));
					holdFlag = checkNull(rs.getString("hold_flag"));
					unit = checkNull(rs.getString("unit"));
					itemCode = checkNull(rs.getString("item_code"));
					//dspSDate = rs/getTimestamp("chg_date");
					convQtyStduom = rs.getDouble("conv__qty_stduom");
					unitRate = checkNull(rs.getString("unit__rate"));
					packCode = checkNull(rs.getString("pack_code"));
					quantityFc = rs.getDouble("quantity__fc");
					unitStd = checkNull(rs.getString("unit__std"));
					itemSer = checkNull(rs.getString("item_ser"));
					custSpecNo = checkNull(rs.getString("cust_spec__no"));
					specRef = checkNull(rs.getString("spec_ref"));

					quantityStduom = rs.getDouble("quantity__stduom");
					convRtuomStduom = rs.getDouble("conv__rtuom_stduom");

					netTotAmtD = rs.getDouble("net_tot_amt");
					ordValue = rs.getDouble("ord_value");


					xmlBuffer.append("<Detail2 objContext =\"2\"").append(" objName=\"upload_sorder\" domID= \"1\" dbID=\"\">");
					xmlBuffer.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
					xmlBuffer.append("<sale_order><![CDATA[").append(saleOrderNew).append("]]></sale_order>");
					xmlBuffer.append("<line_no><![CDATA[").append(lineNoSord).append("]]></line_no>");
					xmlBuffer.append("<site_code><![CDATA[").append(siteCodeD).append("]]></site_code>");
					xmlBuffer.append("<item_flg><![CDATA[").append("I").append("]]></item_flg>");

					xmlBuffer.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
					xmlBuffer.append("<dsp_date><![CDATA[").append(currDateStr).append("]]></dsp_date>");
					xmlBuffer.append("<rate><![CDATA[").append(rate).append("]]></rate>");
					xmlBuffer.append("<discount><![CDATA[").append(discount).append("]]></discount>");
					//xmlBuffer.append("<tax_amt><![CDATA[").append(saleOrderNew).append("]]></tax_amt>");

					xmlBuffer.append("<tax_env><![CDATA[").append(taxEnvD).append("]]></tax_env>");
					xmlBuffer.append("<net_amt><![CDATA[").append(netAmt).append("]]></net_amt>");
					xmlBuffer.append("<item_code__ord><![CDATA[").append(itemCodeOrd).append("]]></item_code__ord>");
					xmlBuffer.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>");
					//

					xmlBuffer.append("<conv__qty_stduom><![CDATA[").append(convQtyStduom).append("]]></conv__qty_stduom>");
					xmlBuffer.append("<conv__rtuom_stduom><![CDATA[").append(convRtuomStduom).append("]]></conv__rtuom_stduom>");
					xmlBuffer.append("<unit__rate><![CDATA[").append(unitRate).append("]]></unit__rate>");
					xmlBuffer.append("<unit__std><![CDATA[").append(unitStd).append("]]></unit__std>");
					xmlBuffer.append("<quantity__stduom><![CDATA[").append(quantityStduom).append("]]></quantity__stduom>");

					xmlBuffer.append("<rate__clg><![CDATA[").append(rateClg).append("]]></rate__clg>");
					xmlBuffer.append("<rate__std><![CDATA[").append(rateStd).append("]]></rate__std>");
					xmlBuffer.append("<rate__stduom><![CDATA[").append(rateStdUom).append("]]></rate__stduom>");
					xmlBuffer.append("<item_descr><![CDATA[").append(itemDescr).append("]]></item_descr>");

					//xmlBuffer.append("<item_descr><![CDATA[").append(saleOrderNew).append("]]></item_descr>");
					xmlBuffer.append("<item_ser><![CDATA[").append(itemSerD).append("]]></item_ser>");

					xmlBuffer.append("<hold_flag><![CDATA[").append("N").append("]]></hold_flag>");


					xmlBuffer.append("<appl_seg><![CDATA[").append("0").append("]]></appl_seg>");
					//xmlBuffer.append("<cust_spec__no><![CDATA[").append(custSpecNo).append("]]></cust_spec__no>");
					//xmlBuffer.append("<price_list_disc><![CDATA[").append(saleOrderNew).append("]]></price_list_disc>");

					xmlBuffer.append("<loc_type><![CDATA[").append("N").append("]]></loc_type>");
					xmlBuffer.append("<nature><![CDATA[").append("C").append("]]></nature>");
					xmlBuffer.append("<no_art><![CDATA[").append("1").append("]]></no_art>");
					xmlBuffer.append("<unit><![CDATA[").append(unit).append("]]></unit>");
					xmlBuffer.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>");					
					xmlBuffer.append("<spec_ref><![CDATA[").append(specRef).append("]]></spec_ref>");


					xmlBuffer.append("</Detail2>");

				}	
				xmlBuffer.append("</Header0>");
				xmlBuffer.append("</group0>");
				xmlBuffer.append("</DocumentRoot>");
				if(xmlBuffer!=null && xmlBuffer.length() > 0)
				{
					System.out.println("Before save Data------->>["+xmlBuffer.toString()+"]");
					//replace and added by sarita on 26DEC2017 to add userId parameter
					//String ret = saveData(siteCode, xmlBuffer.toString(), conn);
					String ret = saveData(siteCode, xmlBuffer.toString(), conn,userId);
					System.out.println("After RP saleOrder save------->>["+ret+"]");
					if(ret != null && ret.indexOf("Success") > -1)
					{
						return "Success";
					}
				}
				else
				{
					System.out.println("XmlString is null or blank please check server log............. ");	
				}



			} //end sale order condition

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmt1 != null)
			{
				pstmt1.close();
				pstmt1 = null;
			}

		}
		return "Error";


	}
	private String generateTranId(String windowName,String siteCode, Connection  conn )throws ITMException,Exception
	{

		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";	
		java.sql.Timestamp currDate = null;		
		try
		{
			currDate =getCurrtDate();
			SimpleDateFormat sdfAppl = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String currDateStr = sdfAppl.format(currDate);			
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			//System.out.println("selSql :"+selSql);
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString( 1, windowName );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();rs = null;
			pstmt.close();pstmt = null;
			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer :"+tranSer);

			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +		"<tran_id></tran_id>";
			xmlValues = xmlValues +		"<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues +		"<order_date>" + currDateStr + "</order_date>"; 
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :"+tranId);

		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +selSql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{

			if (rs != null)
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}

		}
		return tranId;

	}
	private String checkNull(String input)
	{
		if(input == null)
		{
			input = "";
		}
		return input.trim();
	}
	public String getStanDraw(String sundryType ,String sundryCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql="",stanCode="",empCode="";
		try
		{
			System.out.println(">>>>>>>>>Enter in getStanDraw method");			
			System.out.println(">>>>>>>>sundryType==="+sundryType);
			System.out.println(">>>>>>>>sundryCode==="+sundryCode);

			if((sundryType!=null && sundryType.trim().length()>0) && "E".equalsIgnoreCase(sundryType))
			{
				sql="select stan_code from employee where emp_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type=E>>>>>>"+stanCode);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "S".equalsIgnoreCase(sundryType))
			{
				sql="select stan_code from supplier where supp_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type= S>>>>>>"+stanCode);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "C".equalsIgnoreCase(sundryType))
			{
				sql="select stan_code from customer where cust_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type=C>>>>>>"+stanCode);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "P".equalsIgnoreCase(sundryType))
			{
				sql="select emp_code  from sales_pers where sales_pers = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					empCode = checkNull(rs.getString("emp_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;

				System.out.println("empCode from Sundry type=P>>>>>>"+empCode);

				if(empCode!=null && empCode.trim().length()>0)
				{
					sql="select stan_code from employee where emp_code = ?";
					pstmt= conn.prepareStatement(sql);
					pstmt.setString(1,empCode);				
					rs = pstmt.executeQuery(); 
					if(rs.next())
					{
						stanCode = checkNull(rs.getString("stan_code"));
					}
					rs.close();
					pstmt.close();
					pstmt = null;
					rs = null;
					System.out.println("StanCode from Sundry type=P>>>>>>"+stanCode);
				}

			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "T".equalsIgnoreCase(sundryType))
			{
				sql="select stan_code  from transporter where tran_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type= T>>>>>>"+stanCode);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "X".equalsIgnoreCase(sundryType))
			{
				sql="select stan_code from tax_authority where tauth_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("StanCode from Sundry type= X>>>>>>"+stanCode);
			}

		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e);
			throw new ITMException(e);
		}		
		return stanCode;

	}
	public String getpayablesAt(String sundryType ,String sundryCode,String bankCode,Connection conn) throws ITMException
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql="",payables="",empCode="",stanCode="",bankRef="";
		try
		{
			System.out.println(">>>>>>>>>Enter in getStanDraw method");			
			System.out.println(">>>>>>>>sundryType==="+sundryType);
			System.out.println(">>>>>>>>sundryCode==="+sundryCode);
			System.out.println(">>>>>>>>bankCode==="+bankCode);

			if((sundryType!=null && sundryType.trim().length()>0) && "E".equalsIgnoreCase(sundryType))
			{
				sql="select dd_payable_bank,stan_code from employee where emp_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					payables = checkNull(rs.getString("dd_payable_bank"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type=E>>>>>>"+payables);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "S".equalsIgnoreCase(sundryType))
			{
				sql="select bank_ref,stan_code from supplier where supp_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					payables = checkNull(rs.getString("bank_ref"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= S>>>>>>"+payables);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "C".equalsIgnoreCase(sundryType))
			{
				sql="select bank_name ,stan_code from customer where cust_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					payables = checkNull(rs.getString("bank_name"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type=C>>>>>>"+payables);
			}

			else if((sundryType!=null && sundryType.trim().length()>0) && "T".equalsIgnoreCase(sundryType))
			{
				sql="select payable_ref,stan_code from transporter where tran_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					payables = checkNull(rs.getString("payable_ref"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= T>>>>>>"+payables);
			}
			else if((sundryType!=null && sundryType.trim().length()>0) && "X".equalsIgnoreCase(sundryType))
			{
				sql="select bank_ref,stan_code from tax_authority where tauth_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);				
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					payables = checkNull(rs.getString("bank_ref"));
					stanCode = checkNull(rs.getString("stan_code"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= X>>>>>>"+payables);
			}
			if(payables!=null && payables.trim().length()>0)
			{
				sql="select drawn_at, bank_ref  from bank_stan_serv where bank_code = ? and stan_code = ?";
				pstmt= conn.prepareStatement(sql);
				pstmt.setString(1,bankCode);
				pstmt.setString(2,stanCode);
				rs = pstmt.executeQuery(); 
				if(rs.next())
				{
					payables = checkNull(rs.getString("drawn_at"));
					bankRef = checkNull(rs.getString("bank_ref"));
				}
				rs.close();
				pstmt.close();
				pstmt = null;
				rs = null;
				System.out.println("payables from Sundry type= X>>>>>>"+payables);
				System.out.println("bankRef from Sundry type= X>>>>>>"+bankRef);
				if(bankRef!=null && bankRef.trim().length()>0)
				{					
					payables=payables.trim() +","+bankRef.trim();
					System.out.println("Payables final====="+payables);
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e);
			throw new ITMException(e);
		}		
		return payables;

	}
	//Added and replace by sarita on 26DEC2017
    //private String saveData(String siteCode, String xmlString, Connection conn) throws ITMException, Exception
	private String saveData(String siteCode, String xmlString, Connection conn,String userId) throws ITMException, Exception
	{

		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

			String [] authencate = new String[2];
			//replace and added by sarita on 26DEC2017 to keep first object of user array as userID 
			//authencate[0] = "";
			authencate[0] = userId;
			authencate[1] = "";
			System.out.println("xmlString in masterStateful :::: " + xmlString);
			retString = masterStateful.processRequest(authencate, siteCode, true, xmlString, true, conn);
			masterStateful = null;			

		}
		catch(ITMException e)
		{			
			System.out.println("ITMException ::saveData :==>");
			throw new ITMException(e);
		}
		catch(Exception e)
		{			
			System.out.println("Exception ::saveData :==>");
			throw new Exception(e);
		}
		return retString;

	}
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn )throws ITMException
	{		
		System.out.println("inside generateTranTd@@.........");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String newKeystring = "",tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
		{		 	
			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);				
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
				// Changed by Sneha on 01-09-2016, for Closing the Open Cursor [Start]
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				// Changed by Sneha on 01-09-2016, for Closing the Open Cursor [End]
			}
			/*rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;*/
			if(rs != null)
			{
				rs.close();
				rs=null;				
			}
			if(pstmt != null)
			{
				pstmt.close();				
				pstmt=null;
			}

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{			
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		}
		catch (Exception e)
		{		
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}

		return tranId;
	}
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}

	//Change By Manish for send mail to customer on 15/12/2015 [Start]
	public void SendMailforSalesReturn(String invoiceId,String tranId,String tranType,String errorString,String xtraParams,Connection conn) throws Exception,SQLException   
	{
		System.out.println("----------in sendingMail--------------------");				
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		String sql="",sql1="",sql2="",formatCode = "",formatCodeCSR = "",mailFlag = "",attachFlag="",attachPath = "", sendTo="", sendToCSR="",
		copyTo="", copyToCSR="",bccTo="", bccToCSR="",subject="", subjectCSR="",bodyText="", bodyTextCSR="",emailAdd="",custName="",refundAmount="",
		saleOrder="",currCode="",itemDescr="",loginSite="",headImagePath = "",footImagePath = "",siteCodeforSorder = "" ;

		EMail email = new EMail();
		CommonWmsUtil commonWmsUtil = CommonWmsUtil.getInstance();
		Document dom = null;
		String emailType=null;
		CommonWmsUtil commonutility = new CommonWmsUtil();
		try
		{	
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSite");
			DistCommon discommon = new DistCommon();
			mailFlag = checkNull(discommon.getDisparams("999999","DDWMS_MAIL_FLAG",conn));
			attachFlag= checkNull(discommon.getDisparams("999999","DDWMS_ATTACHMENT_FLAG",conn));
			System.out.println("mailFlag-------"+mailFlag);

			/*formatCode = loginSite+'_'+tranType;                     // Sending mail for customer.
			formatCodeCSR = loginSite+'_'+tranType+'_'+"CSR";*/        // Sending mail for CSR team.
			sql = "SELECT S.SITE_CODE FROM SORDER S, INVOICE I WHERE S.SALE_ORDER = I.SALE_ORDER AND I.INVOICE_ID = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, invoiceId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCodeforSorder = checkNull(rs.getString(1));
			}
			rs.close();
			pstmt.close();
			rs=null;
			pstmt=null;
			System.out.println("Site Code for Sale Order["+siteCodeforSorder+"]");

			formatCode = siteCodeforSorder+'_'+tranType;                     
			formatCodeCSR = siteCodeforSorder+'_'+tranType+'_'+"CSR";

			System.out.println("formatCode=======["+formatCode+"]");	
			System.out.println("formatCode=======["+formatCodeCSR+"]");	
			if("Y".equalsIgnoreCase(mailFlag) && formatCode!= null && formatCodeCSR!= null && formatCode.length() > 0 && formatCodeCSR.length() > 0 )
			{
				sql="select send_to,copy_to,blind_copy,subject,body_text from mail_format where format_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, formatCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sendTo = checkNull(rs.getString(1));
					copyTo = checkNull(rs.getString(2));
					bccTo = checkNull(rs.getString(3));
					subject = checkNull(rs.getString(4));
					bodyText = checkNull(rs.getString(5));
				}
				rs.close();
				pstmt.close();
				rs=null;
				pstmt=null;
				System.out.println("bodyText-------"+bodyText);
				System.out.println("formatCode-------"+formatCode);

				sql1 = "SELECT C.EMAIL_ADDR, C.CUST_NAME, S.NET_AMT, I.SALE_ORDER,  S.CURR_CODE FROM CUSTOMER C, INVOICE I, SRETURN S " +
				" WHERE C.CUST_CODE = I.CUST_CODE AND S.INVOICE_ID = I.INVOICE_ID  AND I.INVOICE_ID = ? ";
				pstmt = conn.prepareStatement(sql1);
				pstmt.setString(1, invoiceId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					emailAdd = checkNull(rs.getString(1));
					custName = checkNull(rs.getString(2));
					refundAmount = checkNull(rs.getString(3));
					saleOrder = checkNull(rs.getString(4));	
					currCode = checkNull(rs.getString(5));			
				}
				rs.close();
				pstmt.close();
				rs=null;
				pstmt=null;

				sql2 = "SELECT DISTINCT(SD.ITEM_DESCR) FROM SRETURNDET SR, SORDDET SD WHERE  SD.ITEM_CODE = SR.ITEM_CODE AND SR.INVOICE_ID = ? AND SR.TRAN_ID = ? ";
				pstmt = conn.prepareStatement(sql2);
				pstmt.setString(1, invoiceId);
				pstmt.setString(2, tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					itemDescr = checkNull(rs.getString(1));
				}
				// Changed by Sneha on 01-09-2016, for Closing the Open Cursor [Start]
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				// Changed by Sneha on 01-09-2016, for Closing the Open Cursor [End]
				
				System.out.println("custName----------["+custName+"]");
				System.out.println("refundAmount----------["+refundAmount+"]");
				System.out.println("saleOrder----------["+saleOrder+"]");
				System.out.println("item description----------["+itemDescr+"]");

				bodyText = bodyText.replaceAll("CUSTOMER_NAME", custName);
				bodyText = bodyText.replaceAll("REFUND_AMOUNT", refundAmount);
				bodyText = bodyText.replaceAll("CURR_CODE", currCode);
				bodyText = bodyText.replaceAll("ORDER_NUMBER", saleOrder);
				bodyText = bodyText.replaceAll("REPLACEMENT_ITEM", itemDescr);

				sendTo = sendTo.replaceAll("EMAIL", emailAdd);

				headImagePath = commonutility.getDDSalesConfig("DDWMS_HEADER_IMAGE");
				footImagePath = commonutility.getDDSalesConfig("DDWMS_FOOTER_IMAGE");

				System.out.println("sendTo-------"+sendTo);
				System.out.println("bodyText-------"+bodyText);
				System.out.println("headImagePath-------"+headImagePath);
				System.out.println("footImagePath-------"+footImagePath);
				SendMail(sendTo,copyTo,bccTo,subject,bodyText,headImagePath,footImagePath);

				System.out.println(" ********Email send succesfully for Customer ***********");

				System.out.println("----------customer relationship-----------");
				sql="select send_to,copy_to,blind_copy,subject,body_text from mail_format where format_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, formatCodeCSR);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sendToCSR = checkNull(rs.getString(1));
					copyToCSR = checkNull(rs.getString(2));
					bccToCSR = checkNull(rs.getString(3));
					subjectCSR = checkNull(rs.getString(4));
					bodyTextCSR = checkNull(rs.getString(5));
				}
				/*rs.close();
				pstmt.close();
				rs=null;
				pstmt=null;*/
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				System.out.println("bodyText-------"+bodyText);
				System.out.println("formatCode-------"+formatCodeCSR);

				bodyTextCSR = bodyTextCSR.replaceAll("CUSTOMER_NAME", custName);
				bodyTextCSR = bodyTextCSR.replaceAll("REFUND_AMOUNT", refundAmount);
				bodyTextCSR = bodyTextCSR.replaceAll("CURR_CODE", currCode);
				bodyTextCSR = bodyTextCSR.replaceAll("ORDER_NUMBER", saleOrder);
				bodyTextCSR = bodyTextCSR.replaceAll("REPLACEMENT_ITEM", itemDescr);

				System.out.println("bodyText-------"+bodyTextCSR);
				System.out.println("sendTo-------"+sendToCSR);
				SendMail(sendToCSR,copyToCSR,bccToCSR,subjectCSR,bodyTextCSR,headImagePath,footImagePath);
				System.out.println(" ********Email send succesfully for CSR***********");
			}

		} 
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :SorderInsertSchedule :sendMail : " + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs=null;				
			}
			if(pstmt != null)
			{
				pstmt.close();				
				pstmt=null;
			}
		}
		email = null;

	}
	//Change By Manish for send mail to customer on 15/12/2015 [End]
	private class SMTPAuthenticator extends javax.mail.Authenticator
	{
		public PasswordAuthentication getPasswordAuthentication()
		{
			try
			{
				String username = CommonConstants.USERNAME;
				String password = CommonConstants.PASSWORD;
				return new PasswordAuthentication(username, password);
			}
			catch(Exception e)
			{
				e.printStackTrace();
				return null;
			}
		}
	}

	public void SendMail(String sendTo,String copyTo,String bccTo,String subject,String bodyText,String headImagePath,String footImagePath ) throws Exception,SQLException  
	{

		boolean debug = false;
		//Changed by Samadhan on 11/02/2016 for SMTP_PORT
		String port = CommonConstants.SMTPPORT;
		String fromAddress = CommonConstants.MAILFROM;
		System.out.println("fromAddress-------["+fromAddress+"]");
		String host = CommonConstants.SMTPHOST; 
		System.out.println("host---------["+host+"]");
		Properties props = new Properties();
		Authenticator auth = null;
		if(CommonConstants.USERNAME != null && CommonConstants.PASSWORD != null)
		{
			props.put("mail.smtp.starttls.enable", "true");
			props.put("mail.smtp.host", host);
			//Changed by Samadhan on 11/02/2016 for SMTP_PORT
			//props.put("mail.smtp.port", "2587");
			System.out.println("SMTPPORT:"+port);
			props.put("mail.smtp.port", port);
			props.put("mail.smtp.auth","true");
			auth = new SMTPAuthenticator();
		}
		Session session= Session.getDefaultInstance(props,auth);
		session.setDebug(debug);   
		System.out.println("host---------["+host+"]");
		try {
			Message message = new MimeMessage(session);
			message.setFrom(new InternetAddress(fromAddress));
			message.setRecipients(Message.RecipientType.TO,
					InternetAddress.parse(sendTo));
			message.setSubject(subject);
			MimeMultipart multipart = new MimeMultipart("related");

			BodyPart messageBodyPart = new MimeBodyPart();
			BodyPart messageBodyPart1 = new MimeBodyPart();

			String htmlText = bodyText;
			messageBodyPart.setContent(htmlText, "text/html");
			multipart.addBodyPart(messageBodyPart);
			messageBodyPart = new MimeBodyPart();
			messageBodyPart1 = new MimeBodyPart();
			DataSource fds = new FileDataSource(headImagePath);
			messageBodyPart1.setDataHandler(new DataHandler(fds));
			messageBodyPart1.setHeader("Content-ID", "<image>");
			DataSource fds1 = new FileDataSource(footImagePath);
			messageBodyPart.setDataHandler(new DataHandler(fds1));
			messageBodyPart.setHeader("Content-ID", "<image1>");
			multipart.addBodyPart(messageBodyPart);
			multipart.addBodyPart(messageBodyPart1);
			message.setContent(multipart);
			Transport.send(message);

			System.out.println("Sent message successfully....");

		} catch (MessagingException e) {
			throw new RuntimeException(e);
		}
	}
}
