/*
 * Author:Santosh Teurwadkar
 * Date:07-Dec-2015
 * Request ID:D15IKAT001 (Demo Task)
 */

package ibase.webitm.ejb.wms;


import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.ejb.Stateless;
import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Stateless

public class GenTaskDemoIC extends ValidatorEJB implements GenTaskDemoICRemote, GenTaskDemoICLocal 
{

	E12GenericUtility genericUtility = new E12GenericUtility();

	@Override
	public String wfValData(String xmlString, String xmlString1,String xmlString2, String objContext, String editFlag,String xtraParams) throws RemoteException, ITMException {

		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;

		try{
			System.out.println("xmlString:::" + xmlString);

			if (xmlString != null && xmlString.trim().length() != 0){
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0){
				dom1 = genericUtility.parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() != 0){
				dom2 = genericUtility.parseString(xmlString2);
			}

			errString = wfValData(dom, dom1, dom2, objContext, editFlag,xtraParams);

		}
		catch(Exception e){

			System.out.println("Exception : GenDemoTask : wfValData(String xmlString) : ==>\n"+ e.getMessage());
		}

		return (errString);
	}

	@SuppressWarnings("null")
	public String wfValData(Document dom, Document dom1, Document dom2,String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException {

		String errString = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>");

		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null;
		PreparedStatement pstmt = null;

		String userId = "";
		int currentFormNo = 0;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		int childNodeListLength;
		int ctr = 0;
		long cnt = 0;
		String childNodeName = null;

		String errCode = "";
		String errorType = "";

		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();

		try{
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			userId = getValueFromXTRA_PARAMS(xtraParams, "loginCode");

			if (objContext != null && objContext.trim().length() > 0){
				currentFormNo = Integer.parseInt(objContext);
			}

			switch(currentFormNo){

			case 1:
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);

				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();

				for (ctr = 0; ctr < childNodeListLength;){

					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();

					if (childNodeName.equalsIgnoreCase("site_code")){
						String site_code = genericUtility.getColumnValue("site_code", dom);

						if (site_code == null || site_code.length() < 0){

							errCode = "VTPORD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}

					else if (childNodeName.equalsIgnoreCase("customer")){
						String customer = genericUtility.getColumnValue("customer", dom);

						if (customer == null && customer.length() < 0){

							errCode = "VTPORD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}

					else if (childNodeName.equalsIgnoreCase("supplier")) {
						String supplier = genericUtility.getColumnValue("supplier", dom);

						if (supplier == null || supplier.length() < 0) {

							errCode = "VTPORD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}

					else if(childNodeName.equalsIgnoreCase("item_code")){

						String item_code = genericUtility.getColumnValue("item_code", dom);

						if (item_code == null || item_code.length() < 0){

							errCode = "VTPORD1";
							errList.add(errCode);
							errFields.add(childNodeName.toLowerCase());
						}
					}

					break;
				}

			}

			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if (errList != null && errListSize > 0) {
				for (cnt = 0; cnt < errListSize; cnt++) {

					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType = errorType(conn, errCode);

					if (errString.length() > 0) {
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if (errorType.equalsIgnoreCase("E")) {
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			else{
				errStringXml = new StringBuffer("");
			}

		}// end of try

		catch (Exception e) {
			e.printStackTrace();
		} finally{

			try{
				//Commented by Santosh on 14-06-2016
				//connDriver = null;
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;

				}
				if (conn != null && !conn.isClosed()) {
					conn.close();
					conn = null;
				}

			}
			catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}

		errString = errStringXml.toString();
		return errString;
	}

	public String itemChanged(String xmlString, String xmlString1,String xmlString2, String objContext, String currentColumn,String editFlag, String xtraParams) throws RemoteException,ITMException {

		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";

		try {

			System.out.println("xmlString[" + xmlString + "]");
			System.out.println("xmlString1[" + xmlString1 + "]");
			System.out.println("xmlString2[" + xmlString2 + "]");

			if (xmlString != null && xmlString.trim().length() != 0) {

				System.out.println("xmlString[" + xmlString + "]");
				dom = genericUtility.parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() != 0) {

				dom1 = genericUtility.parseString(xmlString1);

			}
			if (xmlString2 != null && xmlString2.trim().length() != 0) {

				dom2 = genericUtility.parseString(xmlString2);
			}

			valueXmlString = itemChanged(dom, dom1, dom2, objContext,currentColumn, editFlag, xtraParams);
		} 
		catch (Exception e) {

			System.out.println("Exception :GenTaskDemoEJB:itemChanged(String,String,String,String,String,String):"+ e.getMessage() + ":");
			valueXmlString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}

		return valueXmlString;
	}

	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2,String objContext, String currentColumn, String editFlag,String xtraParams) throws RemoteException, ITMException {

		int currentFormNo = 0;

		StringBuffer valueXmlString = new StringBuffer();

		Timestamp currDate = null;

		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;

		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();

		try {
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]

			System.out.println("Obj Context = "+objContext);

			if (objContext != null && objContext.trim().length() > 0) {
				currentFormNo = Integer.parseInt(objContext);
			}

			valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>\r\n<Root>\r\n<header>\r\n<editFlag>");
			valueXmlString.append(editFlag).append("</editFlag>\r\n</header>\r\n");

			System.out.println("currentColumn[" + currentColumn + "]");
			System.out.println("objContext[" + objContext + "]");

			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String today = sdf.format(currDate);
			System.out.println("Todays Date=" + today);

			switch (currentFormNo) {

			case 1: 
			{

				System.out.println("INSIDE CASE1");

				valueXmlString.append("<Detail1 dbID='1' selected = 'N'>\r\n");

				if (currentColumn.trim().equalsIgnoreCase("itm_default")) {

					valueXmlString.append("<site_code>").append("<![CDATA[]]>").append("</site_code>\r\n");
					valueXmlString.append("<customer>").append("<![CDATA[]]>").append("</customer>\r\n");
					valueXmlString.append("<supplier>").append("<![CDATA[]]>").append("</supplier>\r\n");
					valueXmlString.append("<item_code>").append("<![CDATA[]]>").append("</item_code>\r\n");
					valueXmlString.append("<quantity>").append("<![CDATA[]]>").append("</quantity>\r\n");
				}

				valueXmlString.append("</Detail1>\r\n");

				break;
			}

			case 2: 
			{			
				System.out.println("INSIDE CASE2");	

				String siteCode = genericUtility.getColumnValue("site_code", dom1,"1").trim();
				String customer = genericUtility.getColumnValue("customer", dom1,"1").trim();
				String supplier = genericUtility.getColumnValue("supplier", dom1,"1").trim();
				String itemCode = genericUtility.getColumnValue("item_code", dom1,"1").trim();
				String quantity = genericUtility.getColumnValue("quantity", dom1,"1").trim();

				System.out.println("SITECODE :"+siteCode);
				System.out.println("CUSTOMER :"+customer);
				System.out.println("SUPPLIER :"+supplier);
				System.out.println("ITEMCODE :"+itemCode);
				System.out.println("QUANTITY :"+quantity);

				Map<String,String> resultHashMap=new HashMap<String,String>();
				Map<String,String> formData=new HashMap<String,String>();	

				formData.put("siteCode", siteCode);					
				formData.put("customer", customer);
				formData.put("supplier", supplier);
				formData.put("itemCode", itemCode);
				formData.put("quantity", quantity);				

				try {

					resultHashMap=generatePurcOrder(xtraParams, conn, formData);
					resultHashMap=generateSaleOrder(xtraParams, conn, formData, resultHashMap);


				} catch (Exception e) {

					e.printStackTrace();
				}	

				System.out.println("RESULT HASH MAP : "+resultHashMap);

				if(resultHashMap.get("unconfirmedPO")==null){
					resultHashMap.put("unconfirmedPO","Failed to Generate Purchase Order!");	
				}
				else if(resultHashMap.get("confirmedPO")==null){
					resultHashMap.put("confirmedPO","Failed to Generate Purchase Order!");
				}
				else if(resultHashMap.get("tranId")==null){
					resultHashMap.put("tranId","Receipt not generated!");
				}
				else if(resultHashMap.get("unconfirmedSO")==null){
					resultHashMap.put("unconfirmedSO","Failed to Generate Sale Order!");
				}
				else if(resultHashMap.get("confirmedSO")==null){
					resultHashMap.put("confirmedSO","Failed to Generate Sale Order!");
				}
				else if(resultHashMap.get("waveId")==null){
					resultHashMap.put("waveId","Wave not generated!");
				}


				String unconfirmedPO =(String)resultHashMap.get("unconfirmedPO");
				String confirmedPO=(String)resultHashMap.get("confirmedPO");
				String tranId=(String)resultHashMap.get("tranId");
				String unconfirmedSO=(String)resultHashMap.get("unconfirmedSO");
				String confirmedSO=(String)resultHashMap.get("confirmedSO");
				String waveId=(String)resultHashMap.get("waveId");

				valueXmlString.append("<Detail2 dbID='1' selected = 'N'>\r\n");
				valueXmlString.append("<unconfirmedPO>").append("<![CDATA["+unconfirmedPO+"]]>").append("</unconfirmedPO>\r\n");
				valueXmlString.append("<confirmedPO>").append("<![CDATA["+confirmedPO+"]]>").append("</confirmedPO>\r\n");
				valueXmlString.append("<tranId>").append("<![CDATA["+tranId+"]]>").append("</tranId>\r\n");
				valueXmlString.append("<unconfirmedSO>").append("<![CDATA["+unconfirmedSO+"]]>").append("</unconfirmedSO>\r\n");
				valueXmlString.append("<confirmedSO>").append("<![CDATA["+confirmedSO+"]]>").append("</confirmedSO>\r\n");
				valueXmlString.append("<waveId>").append("<![CDATA["+waveId+"]]>").append("</waveId>\r\n");
				valueXmlString.append("</Detail2>\r\n");

				break;
			}

			}

		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
				if (conn != null && !conn.isClosed()) {
					conn.close();
					conn = null;
				}

			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		valueXmlString.append("</Root>\r\n");
		System.out.println("\n****ValueXmlString :" + valueXmlString.toString()+ ":********");

		return valueXmlString.toString();
	}

	public HashMap<String,String> generatePurcOrder(String xtraParams, Connection conn, Map<String, String> formData) throws RemoteException,ITMException {

		String retString = "", sysDateStr="",siteCodeBill="",address1="",address2="",city="",siteDescr="",
		priceList="",pricelistClg="", itemSer="", crTerm="", currCode="";

		Map<String,String> resultMap=new HashMap<String, String>();

		int counter=0;	

		System.out.println("Inside generate Purchase Order");

		@SuppressWarnings("unused")
		String siteCode = "", customer="", supplier="", itemCode = "", quantity = "";

		siteCode=(String)formData.get("siteCode");
		customer=(String)formData.get("customer");
		supplier=(String)formData.get("supplier");
		itemCode=(String)formData.get("itemCode");
		quantity=(String)formData.get("quantity");

		while(counter<2){			

			String retStr = "", errString = "";
			boolean isError = false;

			String sql="";
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			MasterStatefulLocal masterStatefulLocal = null;

			try{

				E12GenericUtility genericUtility = new E12GenericUtility();
				AppConnectParm appConnect = new AppConnectParm();
				Properties p = appConnect.getProperty();
				InitialContext ctx = new InitialContext(p);

				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				Date sysDate = new Date();
				sysDateStr = sdf.format(sysDate);

				System.out.println("XTRA PARAMS ["+xtraParams+"]");



				sql = "SELECT SITE_CODE__ACCT, ADD1, ADD2, CITY, DESCR FROM SITE WHERE SITE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);
				rs = pstmt.executeQuery();

				if(rs.next()){

					siteCodeBill=checkNull(rs.getString("SITE_CODE__ACCT"));
					address1=checkNull(rs.getString("ADD1"));
					address2=checkNull(rs.getString("ADD2"));
					city=checkNull(rs.getString("CITY"));
					siteDescr=checkNull(rs.getString("DESCR"));
				}	
				if(pstmt != null){
					pstmt.close();pstmt = null;
				}
				if (rs != null){
					rs.close();rs = null;
				}

				sql="SELECT ITEM_SER FROM ITEM WHERE ITEM_CODE=?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs=pstmt.executeQuery();

				if(rs.next()){
					itemSer=rs.getString("ITEM_SER");
				}
				if(pstmt != null){
					pstmt.close();pstmt = null;
				}
				if (rs != null){					
					rs.close();rs = null;
				}

				sql = "SELECT CR_TERM, CURR_CODE, DLV_TERM, PRICE_LIST,PRICE_LIST__CLG FROM SUPPLIER WHERE SUPP_CODE = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, supplier);
				rs = pstmt.executeQuery();

				if(rs.next()){

					currCode=checkNull(rs.getString("CURR_CODE"));
					crTerm=checkNull(rs.getString("CR_TERM"));
					priceList = checkNull(rs.getString("PRICE_LIST" ));
					pricelistClg= checkNull(rs.getString("PRICE_LIST__CLG"));
				}

				if( pstmt != null ) {
					pstmt.close();pstmt = null;
				}
				if ( rs != null ) {
					rs.close();rs = null;
				}

				StringBuffer xmlString= new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
				xmlString.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 escription</description>");
				xmlString.append("<Header0>");
				xmlString.append("<description>Header0 members</description>");
				xmlString.append("<objName><![CDATA[").append("porder").append("]]></objName>");
				xmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
				xmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
				xmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
				xmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
				xmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
				xmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
				xmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
				xmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
				xmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
				xmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
				xmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");

				xmlString.append("<Detail1 dbID='' domID=\"1\" objName=\"porder\" objContext=\"1\">");
				xmlString.append("<attribute pkNames=\"purc_order:\" status=\"N\" updateFlag=\"A\" selected=\"N\" />");
				xmlString.append("<purc_order><![CDATA[").append("").append("]]></purc_order>");
				xmlString.append("<ord_date><![CDATA[").append(sysDateStr).append("]]></ord_date>");
				xmlString.append("<pord_type><![CDATA[").append("T").append("]]></pord_type>");
				xmlString.append("<supp_code><![CDATA[").append(supplier).append("]]></supp_code>");
				xmlString.append("<site_code__dlv><![CDATA[").append(siteCode).append("]]></site_code__dlv>");
				xmlString.append("<site_code__ord><![CDATA[").append(siteCode).append("]]></site_code__ord>");
				xmlString.append("<site_code__bill><![CDATA[").append(siteCodeBill).append("]]></site_code__bill>");
				xmlString.append("<status><![CDATA[").append("O").append("]]></status>");
				xmlString.append("<status_date><![CDATA[").append(sysDateStr).append("]]></status_date>");
				xmlString.append("<accept_criteria><![CDATA[").append("P").append("]]></accept_criteria>");
				xmlString.append("<site_add1><![CDATA[").append(address1).append("]]></site_add1>");
				xmlString.append("<site_add2><![CDATA[").append(address2).append("]]></site_add2>");
				xmlString.append("<city__site><![CDATA[").append(city).append("]]></city__site>");
				xmlString.append("<site_descr><![CDATA[").append(siteDescr).append("]]></site_descr>");
				xmlString.append("<tax_date><![CDATA[").append(sysDateStr).append("]]></tax_date>");
				xmlString.append("<item_ser><![CDATA[").append(itemSer).append("]]></item_ser>");
				xmlString.append("<dept_code><![CDATA[").append("9999").append("]]></dept_code>");
				xmlString.append("<emp_code><![CDATA[").append("99999").append("]]></emp_code>");
				xmlString.append("<cr_term><![CDATA[").append(crTerm).append("]]></cr_term>");
				xmlString.append("<curr_code><![CDATA[").append(currCode).append("]]></curr_code>");
				xmlString.append("<curr_code__frt><![CDATA[").append(currCode).append("]]></curr_code__frt>");
				xmlString.append("<curr_code__ins><![CDATA[").append(currCode).append("]]></curr_code__ins>");
				xmlString.append("<dlv_term><![CDATA[").append("NA").append("]]></dlv_term>");
				xmlString.append("<price_list><![CDATA[").append(priceList).append("]]></price_list>");
				xmlString.append("<price_list__clg><![CDATA[").append(pricelistClg).append("]]></price_list__clg>");
				xmlString.append("<exch_rate><![CDATA[").append("1").append("]]></exch_rate>");
				xmlString.append("<curr_code__comm><![CDATA[").append(currCode).append("]]></curr_code__comm>");
				xmlString.append("<term_table><![CDATA[").append("NA").append("]]></term_table>"); 
				xmlString.append("<frt_rate><![CDATA[").append("0").append("]]></frt_rate>");

				xmlString.append("</Detail1>");

				System.out.println("11111. XMLSTRING after adding detail1 " +xmlString.toString());

				xmlString.append("<Detail2 dbID=':' domID=\"1\" objName='porder' objContext='2'>");
				xmlString.append("<attribute pkNames='purc_order:line_no:' status='N' updateFlag='A' selected='N'/>");
				xmlString.append("<purc_order><![CDATA[").append("").append("]]></purc_order>");				
				xmlString.append("<line_no><![CDATA[").append("  1").append("]]></line_no>");
				xmlString.append("<status><![CDATA[").append("O").append("]]></status>");
				xmlString.append("<status_date><![CDATA[").append(sysDateStr).append("]]></status_date>");
				xmlString.append("<site_code><![CDATA[").append(siteCode).append("]]></site_code>");
				xmlString.append("<item_code><![CDATA[").append(itemCode).append("]]></item_code>");
				xmlString.append("<quantity><![CDATA[").append(quantity).append("]]></quantity>");
				xmlString.append("<unit><![CDATA[").append("NO").append("]]></unit>");
				xmlString.append("<quantity__stduom><![CDATA[").append(quantity).append("]]></quantity__stduom>");
				xmlString.append("<unit__std><![CDATA[").append("NO").append("]]></unit__std>");
				xmlString.append("<unit__rate><![CDATA[").append("NO").append("]]></unit__rate>");
				xmlString.append("<rate><![CDATA[").append("10").append("]]></rate>");
				xmlString.append("<loc_code><![CDATA[").append("GLDD").append("]]></loc_code>");
				xmlString.append("<acct_code__dr><![CDATA[").append("401003").append("]]></acct_code__dr>");
				xmlString.append("<cctr_code__dr><![CDATA[").append("DV01").append("]]></cctr_code__dr>");
				xmlString.append("<acct_code__cr><![CDATA[").append("112002").append("]]></acct_code__cr>");
				xmlString.append("<cctr_code__cr><![CDATA[").append("DV01").append("]]></cctr_code__cr>");
				xmlString.append("<dlv_qty><![CDATA["+quantity+"]]></dlv_qty>");
				xmlString.append("<dlv_date><![CDATA["+sysDateStr+"]]></dlv_date>");
				xmlString.append("<rate__stduom><![CDATA[").append("10").append("]]></rate__stduom>");
				xmlString.append("<no_art><![CDATA[").append("1").append("]]></no_art>");
				xmlString.append("<rate__clg><![CDATA[").append("10").append("]]></rate__clg>");
				xmlString.append("<conv__qty_stduom><![CDATA[").append("1").append("]]></conv__qty_stduom>");			
				xmlString.append("</Detail2>");

				xmlString.append("</Header0></group0></DocumentRoot>");

				System.out.println("XMLSTRING For the generation of Purchase Order:: "+xmlString.toString());

				if(xtraParams==null){
					xtraParams = getXtraParams("99999",siteCode,"99999",conn);
				}
				String userInfo = getUserInfo(xtraParams);

				masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

				if(counter==0){

					System.out.println("Generating unconfirmed purchase order.");          

					retString = masterStatefulLocal.processRequest(userInfo, xmlString.toString(), true, conn); 

					System.out.println("retString....in Unconfirmed purchase order:: "+retString);

					if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 ){

						String tranIdPurcOrder = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
						System.out.println("Unconfirmed purchase order is :"+tranIdPurcOrder);
						conn.commit();

						resultMap.put("unconfirmedPO", tranIdPurcOrder);

					}
					else {

						System.out.println("Unconfirmed purchase order not generated.");
					}

				}
				else{

					System.out.println("Genrating confirmed purchase order.");

					retString = masterStatefulLocal.processRequest(userInfo, xmlString.toString(), true, conn); 

					System.out.println("retString....in confirmed purchase order:: "+retString);


					if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 ){

						String tranIdPurcOrder = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
						System.out.println("Confirmed Purchase order is :"+tranIdPurcOrder);
						conn.commit();

						resultMap.put("confirmedPO", tranIdPurcOrder);

						System.out.println("Calling NVO to autoconfirm purchase order.");

						retString=confirmOrder("porder", tranIdPurcOrder, xtraParams, "", conn);

						if(retString !=null && retString.indexOf("VTSUCC1") > -1){

							System.out.println("NVO call successful!");

							String tranId=generatePurchaseReceipt(tranIdPurcOrder,xtraParams,conn, formData);

							System.out.println("Return String from Purchase receipt : "+tranId);

							resultMap.put("tranId", tranId);

						}
						else {

							System.out.println("Purchase order not confirmed.");

						}		            	
					}
					else{

						System.out.println("asn confirm error checking");
					}				            
				}

			}						
			catch(Exception e){

				isError = true;
				errString = "ERROR";
				try{

					conn.rollback();
					retString = retStr;
				}
				catch(Exception e1){

					e1.printStackTrace();
				}

				e.printStackTrace();
				throw new ITMException(e);
			}
			finally{

				System.out.println("is Error in finally="+isError);
				try{

					if(isError){

						System.out.println("Closing error");
						conn.rollback();
						retString = retStr;
					}
				}
				catch( Exception e){

					e.printStackTrace();
					throw new ITMException(e);
				}
			}

			System.out.println("errString from generatePorder =["+errString+"]");

			counter++; 

		}

		System.out.println("Final return from generate Porder="+retString);

		return (HashMap<String, String>) resultMap;	
	}	

	public String generatePurchaseReceipt(String tranId, String xtraParams, Connection conn, Map<String,String> formData) throws RemoteException,ITMException {


		String tranIdPurcRecp="", porcpString="", retString="",  sysDateStr="", purcOrder="", itemSer="",currCode="";

		MasterStatefulLocal masterStatefulLocal=null;

		StringBuffer detail1XMLString=null;

		String sql="";
		PreparedStatement pstmt=null;
		ResultSet rs=null;

		@SuppressWarnings("unused")
		String siteCode = "", customer="", supplier="", itemCode = "", quantity = "";

		siteCode=(String)formData.get("siteCode");
		customer=(String)formData.get("customer");
		supplier=(String)formData.get("supplier");
		itemCode=(String)formData.get("itemCode");
		quantity=(String)formData.get("quantity");

		try {

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);

			masterStatefulLocal=(MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			if(xtraParams==null){
				xtraParams = getXtraParams("99999",siteCode,"99999",conn);
			}
			String userInfo=getUserInfo(xtraParams);

			SimpleDateFormat sdf=new SimpleDateFormat(genericUtility.getApplDateFormat());
			Date sysDate=new Date();
			sysDateStr=sdf.format(sysDate);

			purcOrder=tranId;

			System.out.println("PURCHASE ORDER : "+purcOrder);

			sql="SELECT ITEM_SER FROM ITEM WHERE ITEM_CODE=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs=pstmt.executeQuery();

			if(rs.next()){
				itemSer=rs.getString("ITEM_SER");
			}
			if(pstmt != null){
				pstmt.close();pstmt = null;
			}
			if (rs != null){					
				rs.close();rs = null;
			}
			sql = "SELECT CURR_CODE FROM SUPPLIER WHERE SUPP_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, supplier);
			rs = pstmt.executeQuery();

			if(rs.next()){

				currCode=checkNull(rs.getString("CURR_CODE"));
			}

			if( pstmt != null ) {
				pstmt.close();pstmt = null;
			}
			if ( rs != null ) {
				rs.close();rs = null;
			}


			detail1XMLString = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
			detail1XMLString.append("<DocumentRoot>\r\n");
			detail1XMLString.append("<description>Datawindow Root</description>\r\n");
			detail1XMLString.append("<group0>\r\n");
			detail1XMLString.append("<description>Group0 description</description>\r\n");
			detail1XMLString.append("<Header0>\r\n");
			detail1XMLString.append("<description>Header0 members</description>\r\n");
			detail1XMLString.append("<DocumentRoot>\r\n");
			detail1XMLString.append("<description>Datawindow Root</description>\r\n");
			detail1XMLString.append("<group0>\r\n");
			detail1XMLString.append("<description>Group0 description</description>\r\n");
			detail1XMLString.append("<Header0>\r\n");
			detail1XMLString.append("<description>Header0 members</description>\r\n");

			detail1XMLString.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\" />\r\n");
			detail1XMLString.append("<objName><![CDATA[").append("porcp").append("]]></objName>");
			detail1XMLString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			detail1XMLString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			detail1XMLString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			detail1XMLString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			detail1XMLString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			detail1XMLString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			detail1XMLString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			detail1XMLString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			detail1XMLString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			detail1XMLString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");

			detail1XMLString.append("<Detail1 dbID=\"\" domID=\"1\" objContext=\"1\" objName=\"porcp\">\r\n");	
			detail1XMLString.append("<tran_id></tran_id>\r\n");
			detail1XMLString.append("<tran_date><![CDATA["+sysDateStr+"]]></tran_date>\r\n");
			detail1XMLString.append("<eff_date><![CDATA["+sysDateStr+"]]></eff_date>\r\n");
			detail1XMLString.append("<tran_type><![CDATA[T]]></tran_type>\r\n");
			detail1XMLString.append("<site_code><![CDATA["+siteCode+"]]></site_code>\r\n");
			detail1XMLString.append("<purc_order><![CDATA["+purcOrder+"]]></purc_order>\r\n");
			detail1XMLString.append("<supp_code><![CDATA["+supplier+"]]></supp_code>\r\n");
			detail1XMLString.append("<dc_date><![CDATA["+sysDateStr+"]]></dc_date>\r\n");
			detail1XMLString.append("<tran_code><![CDATA[19]]></tran_code>\r\n");
			detail1XMLString.append("<curr_code><![CDATA["+currCode+"]]></curr_code>\r\n");
			detail1XMLString.append("<exch_rate>1</exch_rate>\r\n");
			detail1XMLString.append("<tran_ser><![CDATA[P-RCP]]></tran_ser>\r\n");
			detail1XMLString.append("<tax_date><![CDATA["+sysDateStr+"]]></tax_date>\r\n");
			detail1XMLString.append("<rec_date><![CDATA["+sysDateStr+"]]></rec_date>\r\n");
			detail1XMLString.append("<confirmed>N</confirmed>\r\n");
			detail1XMLString.append("<conf_date>"+sysDateStr+"</conf_date>\r\n");
			detail1XMLString.append("<item_ser><![CDATA["+itemSer+"]]></item_ser>\r\n");
			detail1XMLString.append("<vouch_created>N</vouch_created>\r\n");
			detail1XMLString.append("<emp_code><![CDATA[99999]]></emp_code>\r\n");
			detail1XMLString.append("<freight_status><![CDATA[B]]></freight_status>\r\n");
			detail1XMLString.append("</Detail1>\r\n");

			detail1XMLString.append("<Detail2 dbID=\"\" domID=\"1\" objContext=\"2\" objName=\"porcp\">\r\n");
			detail1XMLString.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\" />\r\n");
			detail1XMLString.append("<tran_id></tran_id>\r\n");
			detail1XMLString.append("<line_no><![CDATA[  1]]></line_no>\r\n");
			detail1XMLString.append("<item_code><![CDATA["+itemCode+"]]></item_code>\r\n");
			detail1XMLString.append("<purc_order><![CDATA["+purcOrder+"]]></purc_order>\r\n");
			detail1XMLString.append("<quantity>"+quantity+"</quantity>\r\n");
			detail1XMLString.append("<unit><![CDATA[NO]]></unit>\r\n");
			detail1XMLString.append("<rate>10</rate>\r\n");
			detail1XMLString.append("<loc_code><![CDATA[GRL]]></loc_code>\r\n");
			detail1XMLString.append("<lot_sl>1S</lot_sl>\r\n");
			detail1XMLString.append("<line_no__ord><![CDATA[  1]]></line_no__ord>\r\n");
			detail1XMLString.append("<acct_code__dr><![CDATA[401003]]></acct_code__dr>\r\n");
			detail1XMLString.append("<cctr_code__dr><![CDATA[DV01]]></cctr_code__dr>\r\n");
			detail1XMLString.append("<acct_code__cr><![CDATA[112002 ]]></acct_code__cr>\r\n");
			detail1XMLString.append("<cctr_code__cr><![CDATA[DV01]]></cctr_code__cr>\r\n");
			detail1XMLString.append("<unit__rate><![CDATA[NO]]></unit__rate>\r\n");
			detail1XMLString.append("<conv__qty_stduom>1</conv__qty_stduom>\r\n");
			detail1XMLString.append("<conv__rtuom_stduom>1</conv__rtuom_stduom>\r\n");
			detail1XMLString.append("<unit__std><![CDATA[NO]]></unit__std>\r\n");
			detail1XMLString.append("<quantity__stduom>"+quantity+"</quantity__stduom>\r\n");
			detail1XMLString.append("<rate__stduom>10</rate__stduom>\r\n");
			detail1XMLString.append("<no_art>1</no_art>\r\n");
			detail1XMLString.append("<status>P</status>\r\n");
			detail1XMLString.append("<rate__clg><![CDATA[10]]></rate__clg>\r\n");
			detail1XMLString.append("<std_rate><![CDATA[10]]></std_rate>\r\n");
			detail1XMLString.append("</Detail2>\r\n");
			detail1XMLString.append("</Header0></group0></DocumentRoot></Header0></group0></DocumentRoot>\r\n");

			System.out.println("DETAIL1XMLSTRING "+detail1XMLString.toString());

			System.out.println("Genrating purchase receipt.");

			retString = masterStatefulLocal.processRequest(userInfo, detail1XMLString.toString(), true, conn);           

			System.out.println("11111.retString....Purchase Receipt:: "+retString);

			if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 ){

				tranIdPurcRecp = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
				System.out.println("Purchase Receipt tranId is :"+tranIdPurcRecp);
				conn.commit();

			}
			else {

				System.out.println("Purchase Receipt not generated");
				return retString;
			}

		} catch (Exception e) {
			e.printStackTrace();
		}

		System.out.println("Final return string in PORCP : "+porcpString);

		return tranIdPurcRecp;
	}

	public HashMap<String, String> generateSaleOrder(String xtraParams, Connection conn, Map<String, String> formData, Map<String, String> resultHashMap){

		String retString="", sysDateStr="", sql="", itemSer="", custName="";

		PreparedStatement pstmt=null;

		ResultSet rs=null;

		int count=0;

		MasterStatefulLocal masterStatefulLocal=null;

		@SuppressWarnings("unused")
		String siteCode = "", customer="", supplier="", itemCode = "", quantity = "";

		siteCode=(String)formData.get("siteCode");
		customer=(String)formData.get("customer");
		supplier=(String)formData.get("supplier");
		itemCode=(String)formData.get("itemCode");
		quantity=(String)formData.get("quantity");

		try {

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Date sysDate = new Date();
			sysDateStr = sdf.format(sysDate);

			while(count<2){

				sql="SELECT ITEM_SER FROM ITEM WHERE ITEM_CODE=?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, itemCode);
				rs=pstmt.executeQuery();

				if(rs.next()){
					itemSer=rs.getString("ITEM_SER");
				}

				if( pstmt != null ){
					pstmt.close();pstmt = null;
				}
				if ( rs != null ) {
					rs.close();rs = null;
				}

				sql="SELECT CUST_NAME FROM CUSTOMER WHERE CUST_CODE=?";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, customer);
				rs=pstmt.executeQuery();

				if(rs.next()){
					custName=rs.getString("CUST_NAME");
				}

				if( pstmt != null ){
					pstmt.close();pstmt = null;
				}
				if ( rs != null ) {
					rs.close();rs = null;
				}

				StringBuffer salesOrderXMLString=new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");       

				salesOrderXMLString.append("<DocumentRoot>");
				salesOrderXMLString.append("<description>DatawindowRoot</description>");
				salesOrderXMLString.append("<group0>");
				salesOrderXMLString.append("<description>Group0description</description>");
				salesOrderXMLString.append("<Header0>");
				salesOrderXMLString.append("<objName><![CDATA[sorder]]></objName>");
				salesOrderXMLString.append("<pageContext><![CDATA[1]]></pageContext>");
				salesOrderXMLString.append("<objContext><![CDATA[1]]></objContext>");
				salesOrderXMLString.append("<editFlag><![CDATA[A]]></editFlag>");
				salesOrderXMLString.append("<focusedColumn><![CDATA[]]></focusedColumn>");
				salesOrderXMLString.append("<action><![CDATA[SAVE]]></action>");
				salesOrderXMLString.append("<elementName><![CDATA[]]></elementName>");
				salesOrderXMLString.append("<keyValue><![CDATA[1]]></keyValue>");
				salesOrderXMLString.append("<taxKeyValue><![CDATA[]]></taxKeyValue>");
				salesOrderXMLString.append("<saveLevel><![CDATA[1]]></saveLevel>");
				salesOrderXMLString.append("<forcedSave><![CDATA[true]]></forcedSave>");
				salesOrderXMLString.append("<taxInFocus><![CDATA[false]]></taxInFocus>");
				salesOrderXMLString.append("<description>Header0members</description>");

				salesOrderXMLString.append("<Detail1 objContext=\"1\" objName=\"sorder\" domID=\"1\" dbID=\"\" >");
				salesOrderXMLString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				salesOrderXMLString.append("<sale_order><![CDATA[]]></sale_order>");
				salesOrderXMLString.append("<order_date><![CDATA["+sysDateStr+"]]></order_date>");
				salesOrderXMLString.append("<cust_code><![CDATA["+customer+"]]></cust_code>");
				salesOrderXMLString.append("<item_ser><![CDATA["+itemSer+"]]></item_ser>");
				salesOrderXMLString.append("<site_code><![CDATA["+siteCode+"]]></site_code>");
				salesOrderXMLString.append("<emp_code__ord><![CDATA[99999]]></emp_code__ord>");
				salesOrderXMLString.append("<cust_code__dlv><![CDATA["+customer+"]]></cust_code__dlv>");
				salesOrderXMLString.append("<cust_code__bil><![CDATA["+customer+"]]></cust_code__bil>");
				salesOrderXMLString.append("<cust_name__bil><![CDATA["+custName+"]]></cust_name__bil>");
				salesOrderXMLString.append("<due_date><![CDATA["+sysDateStr+"]]></due_date>");
				salesOrderXMLString.append("<chg_user><![CDATA[BASE]]></chg_user>");
				salesOrderXMLString.append("<chg_term><![CDATA[127.0.0.1]]></chg_term>");
				salesOrderXMLString.append("</Detail1>");

				salesOrderXMLString.append("<Detail2 objContext=\"2\" objName=\"sorder\" domID=\"1\" dbID=\"\" >");
				salesOrderXMLString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
				salesOrderXMLString.append("<sale_order><![CDATA[]]></sale_order>");
				salesOrderXMLString.append("<line_no><![CDATA[  1]]></line_no>");
				salesOrderXMLString.append("<site_code><![CDATA["+siteCode+"]]></site_code>");
				salesOrderXMLString.append("<quantity><![CDATA["+quantity+"]]></quantity>");
				salesOrderXMLString.append("<dsp_date><![CDATA["+sysDateStr+"]]></dsp_date>");
				salesOrderXMLString.append("<rate><![CDATA[10]]></rate>");
				salesOrderXMLString.append("<unit><![CDATA[NO]]></unit>");
				salesOrderXMLString.append("<item_code__ord><![CDATA["+itemCode+"]]></item_code__ord>");
				salesOrderXMLString.append("<rate__stduom>10</rate__stduom>");
				salesOrderXMLString.append("<rate__clg>10</rate__clg>");

				salesOrderXMLString.append("</Detail2>");

				salesOrderXMLString.append("</Header0>");
				salesOrderXMLString.append("</group0>");
				salesOrderXMLString.append("</DocumentRoot>");


				System.out.println("XMLSTRING for SALESORDER : "+salesOrderXMLString);

				AppConnectParm appConnect = new AppConnectParm();
				Properties p = appConnect.getProperty();
				InitialContext ctx = new InitialContext(p);

				if(xtraParams==null){
					xtraParams = getXtraParams("99999",siteCode,"99999",conn);
				}		
				String userInfo = getUserInfo(xtraParams);

				masterStatefulLocal = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");

				System.out.println("COUNT VALUE : "+count);


				if(count==0){

					System.out.println("Inside unconfirmed generateSalesOrder()");

					retString = masterStatefulLocal.processRequest(userInfo, salesOrderXMLString.toString(), false, conn); 

					System.out.println("SalesOrder retString....qqq::"+retString);


					if ( retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 ){

						String tranIdSaleOrder = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
						System.out.println("SaleOrder tranId is :"+tranIdSaleOrder);
						conn.commit();

						resultHashMap.put("unconfirmedSO", tranIdSaleOrder);
					}
					else {

						System.out.println("salesOrder generation failed!");
					}		
				}
				else{

					System.out.println("Inside confirmed generateSalesOrder()");

					System.out.println("SALEORDER STRING IN NVO PART : "+salesOrderXMLString.toString());

					retString = masterStatefulLocal.processRequest(userInfo, salesOrderXMLString.toString(), false, conn);

					System.out.println("RETURN STRING IN CONFIRMED SALE ORDER : "+retString);

					if (retString.indexOf("Success") > -1 && retString.indexOf("<TranID>") > 0 ){

						String tranIdSaleOrder = retString.substring( retString.indexOf("<TranID>")+8, retString.indexOf("</TranID>"));
						System.out.println("SaleOrder tranId is :"+tranIdSaleOrder);
						conn.commit();

						resultHashMap.put("confirmedSO", tranIdSaleOrder);

						System.out.println("Calling NVO to autoconfirm sale order.");

						retString=confirmOrder("sorder", tranIdSaleOrder, xtraParams, "", conn);

						if(retString !=null && retString.indexOf("PRCSTATUS") > -1){

							System.out.println("NVO call successful for Sale Order!");

							String retWaveGen=generateWave(tranIdSaleOrder, xtraParams, formData);

							sql="SELECT WAVE_ID FROM WAVE_TASK WHERE SALE_ORDER__FROM=?";
							pstmt=conn.prepareStatement(sql);
							pstmt.setString(1, tranIdSaleOrder);
							rs=pstmt.executeQuery();

							String waveId="";

							while (rs.next()) {
								waveId=rs.getString("WAVE_ID");
							}

							resultHashMap.put("waveId",waveId);

							System.out.println("RETURN STRING FROM WAVE GEN : "+retWaveGen);

						}
						else {

							System.out.println("saleOrder generation failed!");
						}		

					}
				}
				count++;	
			}

		}
		catch (Exception e) {
			e.printStackTrace();
		}

		System.out.println("Final return string in : "+retString);
		return (HashMap<String, String>) resultHashMap;	
	}

	public String generateWave(String saleOrder, String xtraParams, Map<String, String> formData){

		String retString="", sysDateStr="";

		String siteCode="", customer="";

		siteCode=(String)formData.get("siteCode");
		customer=(String)formData.get("customer");

		StringBuffer xmlString=null;

		try {

			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			Date sysDate = new Date();
			sysDateStr = sdf.format(sysDate);

			xmlString = new StringBuffer();
			xmlString.append("<DocumentRoot>");
			xmlString.append("<description>").append("Datawindow Root").append( "</description>\r\n" );
			xmlString.append("<group0>\r\n");
			xmlString.append("<description>").append("Group0 description").append( "</description>\r\n" );
			xmlString.append("<Header0>\r\n");
			xmlString.append("<description>\r\n").append("Header0 members").append( "</description>\r\n" );
			xmlString.append("<Detail1 dbID=\"\" domID=\"1\" objContext=\"1\" objName=\"wavegen\">\r\n" );
			xmlString.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\"/>\r\n" );
			xmlString.append("<site_code><![CDATA[" ).append(siteCode).append( "]]></site_code>\r\n" );
			xmlString.append("<default_qty_flag><![CDATA[" ).append("Y").append( "]]></default_qty_flag>\r\n" );
			xmlString.append("<item_ser__from><![CDATA[" ).append("00").append( "]]></item_ser__from>\r\n" );
			xmlString.append("<item_ser__to><![CDATA[").append("ZZ").append("]]></item_ser__to>\r\n");
			xmlString.append("<item_code__from><![CDATA[").append("00").append("]]></item_code__from>\r\n");
			xmlString.append("<item_code__to ><![CDATA[" ).append("ZZ").append( "]]></item_code__to>\r\n" );
			xmlString.append("<cust_code__dlv__from  ><![CDATA[" ).append("00").append( "]]></cust_code__dlv__from>\r\n" );
			xmlString.append("<cust_code__dlv__to><![CDATA[" ).append("ZZ").append( "]]></cust_code__dlv__to>\r\n" );
			xmlString.append("<cust_code__from ><![CDATA[" ).append(customer).append( "]]></cust_code__from>\r\n" );
			xmlString.append("<cust_code__to ><![CDATA[").append(customer).append("]]></cust_code__to>\r\n");
			xmlString.append("<sale_order__from><![CDATA[").append(saleOrder).append("]]></sale_order__from>\r\n");
			xmlString.append("<sale_order__to><![CDATA[").append(saleOrder).append("]]></sale_order__to>\r\n");
			xmlString.append("<due_date__from><![CDATA[").append(sysDateStr).append("]]></due_date__from>\r\n");
			xmlString.append("<due_date__to><![CDATA[").append(sysDateStr).append("]]></due_date__to>\r\n");
			xmlString.append("<wave_mode><![CDATA[").append("P").append("]]></wave_mode>\r\n");
			xmlString.append("<single_lot><![CDATA[").append("N").append("]]></single_lot>\r\n");
			xmlString.append("<master_pack_allow><![CDATA[").append("N").append("]]></master_pack_allow>\r\n");
			xmlString.append("<active_pick_allow><![CDATA[").append("Y").append("]]></active_pick_allow>\r\n");
			xmlString.append("<stock_to_dock_allow><![CDATA[").append("N").append("]]></stock_to_dock_allow>\r\n");
			xmlString.append("<printer_name><![CDATA[").append("N").append("]]></printer_name>\r\n");
			xmlString.append("<print_label><![CDATA[").append("N").append("]]></print_label>\r\n");
			xmlString.append("<parcelpack_allow><![CDATA[").append("Y").append("]]></parcelpack_allow>\r\n");
			xmlString.append("<ship_type><![CDATA[").append("A").append("]]></ship_type>\r\n");
			xmlString.append("<direct_pick_loc><![CDATA[").append("").append("]]></direct_pick_loc>\r\n");
			xmlString.append("<pallet_no><![CDATA[").append("").append("]]></pallet_no>\r\n");
			xmlString.append("<order_type><![CDATA[").append("").append("]]></order_type>\r\n");
			xmlString.append("<remarks><![CDATA[").append("").append("]]></remarks>\r\n");
			xmlString.append("<tran_code><![CDATA[").append("").append("]]></tran_code>\r\n");
			xmlString.append("<tran_name><![CDATA[").append("").append("]]></tran_name>\r\n");
			xmlString.append("<loc_type_parent><![CDATA[").append("").append("]]></loc_type_parent>\r\n");
			xmlString.append("<trans_mode><![CDATA[").append("").append("]]></trans_mode>\r\n");
			xmlString.append("</Detail1>\r\n");
			xmlString.append("</Header0>\r\n");
			xmlString.append("</group0>\r\n");
			xmlString.append("</DocumentRoot>\r\n");

			AppConnectParm appConnect = new AppConnectParm();
			Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);

			System.out.println("Before waveGeneration xmlString------>>["+xmlString.toString()+"]");
			WaveGenerationPrcLocal prcNew = null;
			prcNew=(WaveGenerationPrcLocal)ctx.lookup("ibase/WaveGenerationPrc/local");

			String getData = prcNew.getData(xmlString.toString(), xmlString.toString(), "W_WAVEGEN", xtraParams);
			System.out.println("Return String from WaveGenerationPrc getData---->>["+getData+"]");
			String processData = prcNew.process(xmlString.toString(), getData, "w_wavegen", xtraParams);
			System.out.println("Return String from WaveGenerationPrc process------["+processData+"]");

			retString=getData+"\r\n"+processData;

		} catch (Exception e) {
			System.out.println("GenTaskDemoPos.generateWave()"+e);
		}

		System.out.println("Final return string in Wave Generation : "+retString);

		return retString;
	}

	public String confirmOrder(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException{

		String methodName = "", compName = "", retString = "", serviceCode = "", serviceURI = "", actionURI = "";

		String sql = "";
		PreparedStatement psmt = null;
		ResultSet rs = null;

		@SuppressWarnings("unused")
		boolean isError=false;

		try{

			System.out.println("-------in confirmOrder method----------------");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id to confrim order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,businessObj);
			rs = psmt.executeQuery();

			if (rs.next()){

				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (psmt != null)
			{
				psmt.close();
				psmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,serviceCode);
			rs = psmt.executeQuery();

			if (rs.next()){

				serviceURI = rs.getString("SERVICE_URI");
			}
			// Changed by Manish on 01/04/16 for max cursor issue [start]
			if (psmt != null)
			{
				psmt.close();
				psmt=null;
			}
			if (rs !=null)
			{
				rs.close();
				rs=null;
			}
			// Changed by Manish on 01/04/16 for max cursor issue [end]
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName));
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);

			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e){

			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}

		finally{	

			try{
				if (psmt != null){

					psmt.close();
					psmt = null;
				}	
				if (rs !=null)
				{
					rs.close();
					rs=null;
				}
			}
			catch(Exception e){

				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();

				try{

					conn.rollback();

				}
				catch (Exception s){

					System.out.println("Unable to rollback");
					s.printStackTrace();
				}

				throw new ITMException(e);
			}
		}
		return retString;
	}

	public String getUserInfo(String xtraParams)throws ITMException{

		StringBuffer userInfoStr = new StringBuffer();

		String userId = "", loginEmpCode = "", loginSiteCode = "", entityCode = "", profileId = "",
		userType = "", chgTerm = "";
		//Added by sarita on 26DEC2017
		String transDB = "";
		try{

			E12GenericUtility genericUtility = new E12GenericUtility();

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginSiteCode");
			entityCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"entityCode");
			profileId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"profileId");
			userType = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userType");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"chgTerm");
			//added  by sarita on 26DEC2017 to insert transDB parameter
			transDB = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"transDB");
			System.out.println("xtraParams  is @@@@@ " + xtraParams);

			userInfoStr.append("<UserInfo>");
			userInfoStr.append("<loginCode>").append("<![CDATA["+userId+"]]>").append("</loginCode>\r\n");
			userInfoStr.append("<empCode>").append("<![CDATA["+loginEmpCode+"]]>").append("</empCode>\r\n");
			userInfoStr.append("<siteCode>").append("<![CDATA["+loginSiteCode+"]]>").append("</siteCode>\r\n");
			userInfoStr.append("<entityCode>").append("<![CDATA["+entityCode+"]]>").append("</entityCode>\r\n");
			userInfoStr.append("<profileId>").append("<![CDATA["+profileId+"]]>").append("</profileId>\r\n");
			userInfoStr.append("<userType>").append("<![CDATA["+userType+"]]>").append("</userType>\r\n");
			userInfoStr.append("<remoteHost>").append("<![CDATA["+chgTerm+"]]>").append("</remoteHost>\r\n");
			//added  by sarita on 26DEC2017 to insert transDB parameter
			userInfoStr.append("<transDB>").append("<![CDATA["+transDB+"]]>").append("</transDB>\r\n");
			userInfoStr.append("</UserInfo>");
		}
		catch (Exception e){

			throw new ITMException(e);
		}
		return userInfoStr.toString();
	}

	public String getXtraParams(String loginCode, String siteCode, String empCode, Connection conn)throws Exception{

		String remotehost = "", entityCode = "", profileId = "", userType = "", userCountry = "", userLang="";

		StringBuffer xtraParamsBuff = new StringBuffer();
		
		String sql = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		//Added by sarita on 26DEC2017
		String transDB = "";

		try{
			//added & replace by sarita on 26DEC2017 to insert transDB parameter
			//sql = "SELECT USER_TYPE,ENTITY_CODE,PROFILE_ID,USER_LANG,USER_COUNTRY FROM USERS WHERE CODE = ? ";
			sql = "SELECT USER_TYPE,ENTITY_CODE,PROFILE_ID,USER_LANG,USER_COUNTRY,TRANS_DB FROM USERS WHERE CODE = ? ";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,loginCode);			
			rs = pstmt.executeQuery();
			while(rs.next()){

				entityCode = rs.getString("ENTITY_CODE");
				profileId  = rs.getString("PROFILE_ID");
				userType   = rs.getString("USER_TYPE");
				userLang   = rs.getString("USER_LANG");
				userCountry= rs.getString("USER_COUNTRY");
				//added  by sarita on 26DEC2017 to insert transDB parameter
				transDB= rs.getString("TRANS_DB");
			}			

			remotehost =  InetAddress.getLocalHost().getHostAddress();
			String XTRA_PARAMS_SEPARATOR = "~~";

			xtraParamsBuff.append("loginCode=" + loginCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + empCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + siteCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + entityCode);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + profileId);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userType);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userLang);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userCountry);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + CommonConstants.ENCODING);
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId="+remotehost);
			//added  by sarita on 26DEC2017 to insert transDB parameter
			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("transDB="+transDB);
			String chgTerm = remotehost;

			if(chgTerm!=null && chgTerm.length()>15){

				chgTerm = chgTerm.substring(0, 15);
			}

			else if(chgTerm==null || chgTerm.length()==0){

				chgTerm = remotehost;
			}

			xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm );
			System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");

		}
		catch(Exception e){

			e.printStackTrace();
		}
		finally{

			try{

				if(rs != null){

					rs.close();
					rs = null;
				}
				if(pstmt != null){

					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e){

				e.printStackTrace();
			}
		}
		return xtraParamsBuff.toString();
	}

	public String checkNullAndTrim(String inputVal) {

		if ( inputVal == null ) {

			inputVal = "";
		}
		else {

			inputVal = inputVal.trim();
		}

		return inputVal;
	}

	public String checkNull(String input){
		if (input == null || "null".equalsIgnoreCase(input)){

			input= "";
		}

		return input.trim();
	}

	private String errorType(Connection conn, String errorCode) {
		String msgType = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try {
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, errorCode);
			rs = pstmt.executeQuery();
			while (rs.next()) {
				msgType = rs.getString("MSG_TYPE");
			}
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			try {
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		return msgType;
	}

}
