/*
 * Author: Wasim Ansari
 * Date: 26-SEP-2016
 * Request: S16EBAS006 (Sale Order Wizard)
 */

package ibase.webitm.bean.wms;

import java.io.File;
import java.rmi.RemoteException;

import ibase.system.config.AppConnectParm;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.wms.SorderWizardEJBRemote;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;

import javax.naming.InitialContext;
import javax.servlet.http.HttpSession;

public class SorderWizBean 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";

	public SorderWizBean(String objName, HttpSession sessionCtx) throws ITMException 
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
	}

	public SorderWizBean() {
		// TODO Auto-generated constructor stub
	}

	//public String getList( String param, String field, String[] values) throws ITMException
	public String getList( String param, String field, String[] values,String details) throws ITMException
	{
		String List = "";

		SorderWizardEJBRemote sorderWizRemote = null;

		String xslFileName = "";

		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (ibase.webitm.ejb.wms.SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			//List = sorderWizRemote.getList(param,field,values);
			List = sorderWizRemote.getList(param,field,values,details);

			if("cust_code".equalsIgnoreCase(field) || "cust_code__bil".equalsIgnoreCase(field) || "cust_code__dlv".equalsIgnoreCase(field))
			{
				xslFileName = getXSLFileName( "sorderWizCust_List_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			}
			else
			{
				xslFileName = getXSLFileName( "sorderWiz_List_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			}

			List = (genericUtility).transformToString( xslFileName, List, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return List;
	}


	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			//File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD" + File.separator + "Galaxy");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " 1xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

	/**
	 * go to prevoius form
	 * @param formNo
	 * @param xmlData
	 * @return
	 * @throws ITMException
	 */
	public String previousForm( String formNo, String xmlData ) throws ITMException 
	{
		String retHtmlData = null;

		try
		{
			System.out.println("In Method : [previousForm]"+xmlData);

			String xslFileName = getXSLFileName( this.objName + formNo + "_wiz_" + this.user_lang + "_" + this.user_country + "_" + "A" + ".xsl" );

			retHtmlData = (genericUtility).transformToString( xslFileName, xmlData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{

		}
		return retHtmlData;
	}

	/**
	 * get Summary Page Detail
	 * @param objName and random
	 * @return
	 * @throws ITMException
	 */
	public String getSorderSummaryDetails( String objName, String random ) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.getSorderSummaryDetails(objName,random);

			String xslFileName = getXSLFileName( "sorderWiz_ViewReport_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			details = (genericUtility).transformToString( xslFileName, details, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	/*public String SaveSorderHeader(String str) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.SaveSorderHeader(str);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}*/

	public String SaveSorderDetail(String str,String xmlStringFile) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.SaveSorderDetail(str,xmlStringFile);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	public String getSorderHeader(String saleOrder,String flag) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.getSorderHeader(saleOrder,flag);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	public String getSorderDetail(String saleOrder,String flag) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.getSorderDetail(saleOrder,flag);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	public String ResetHeader(String data) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.ResetHeader(data);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	public String getSorderDetail2(String siteCode,String empCode,String saleOrder,String status) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.getSorderDetail2(siteCode,empCode,saleOrder,status);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	public String getSKUDetail(String itemParent,String itemDLVDate,String paraData,String otherDetails) throws ITMException 
	{
		String details = null;
		SorderWizardEJBRemote sorderWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			details = sorderWizRemote.getSKUDetail(itemParent,itemDLVDate,paraData,otherDetails);
		}	
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return details;
	}

	//Added by Kaustubh on 4 Dec 2017 start

	public String getTaxData( String xmlData, String formNo, String domID, UserInfoBean userInfo,String objName) throws ITMException
	{
		String taxData = "";

		SorderWizardEJBRemote sorderWizRemote = null;


		try
		{
			System.out.println("In Method : [getTaxData]"+xmlData);
			System.out.println("FormNo::"+formNo+"dbid::"+domID);
			System.out.println("userInfo::"+userInfo);
			System.out.println("ObjName ::"+objName);

			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (ibase.webitm.ejb.wms.SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			//List = sorderWizRemote.getList(param,field,values);
			taxData = sorderWizRemote.getTaxData(xmlData,formNo,domID,userInfo,objName);

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return taxData;
	}

	//Added by Kaustubh on 4 Dec 2017 end


	//Added by Kaustubh on 22 Dec 2017 start

	public String getSchemeDetail( String xmlData, String formNo, UserInfoBean userInfo,String objName) throws ITMException
	{
		String taxData = "";

		SorderWizardEJBRemote sorderWizRemote = null;

		try
		{
			System.out.println("In Method : [getTaxData]"+xmlData);
			System.out.println("userInfo::"+userInfo);
			System.out.println("ObjName ::"+objName);

			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (ibase.webitm.ejb.wms.SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			//List = sorderWizRemote.getList(param,field,values);
			taxData = sorderWizRemote.getSchemeDetail(xmlData,formNo,userInfo,objName);

			String xslFileName = getXSLFileName( "sorderWiz_Scheme_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			taxData = (genericUtility).transformToString( xslFileName, taxData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			System.out.println("SchemeDetails ::"+taxData);

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return taxData;
	}

	//Added by Kaustubh on 22 Dec 2017 end	
	
	//Added by Kaustubh on 6 Jan 2018 start
	
	public String getTaxXml(String empCode, String siteCode, String itemCode,String lineNo)throws ITMException
	{
		String taxData = "";

		SorderWizardEJBRemote sorderWizRemote = null;


		try
		{
			System.out.println("In Method : [getTaxData]"+empCode);
			System.out.println("FormNo::"+siteCode+"dbid::"+itemCode);
			System.out.println("userInfo::"+userInfo);
			System.out.println("ObjName ::"+objName);

			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			sorderWizRemote = (ibase.webitm.ejb.wms.SorderWizardEJBRemote) ctx.lookup("ibase/SorderWizardEJB/remote");
			//List = sorderWizRemote.getList(param,field,values);
			taxData = sorderWizRemote.getTaxXml(empCode,siteCode,itemCode,lineNo);

		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( sorderWizRemote != null )
			{
				sorderWizRemote = null;
			}
		}
		return taxData;
	}
	
	//Added by Kaustubh on 6 Jan 2018 start
}
