package ibase.webitm.ejb.gstclient;


import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.bean.gstclient.GstDetailData;
import ibase.webitm.bean.gstclient.GstHeaderData;
import ibase.webitm.bean.gstclient.GstHrdDetData;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;

import org.jboss.ejb3.annotation.TransactionTimeout;
import org.json.JSONObject;
import org.w3c.dom.Document;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.log.SysoCounter;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.RequestBodyEntity;

@Stateless
//@TransactionTimeout(60000)  
//@StatelessDeployment(transactionTimeout=6000)
public class GetGstTableData extends ActionHandlerEJB implements GetGstTableDataRemote, GetGstTableDataLocal
{
	
@Override
	public String actionHandler(String tran_id , String xtraParams ,String sitecode ,String period, String type, String forced_flag) throws RemoteException,ITMException
	{
	    System.out.println("Json for gst table data transfer called");
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String  resString = null;
		try
		{
			/*ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
			if(tran_id != null && tran_id.trim().length()!=0)
			{
				System.out.println("TRAN_ID String :"+tran_id);
				dom = genericUtility.parseString(tran_id);
			}
			*/
		     	System.out.println("TRAN id:"+tran_id+":");
			  resString = getGstTableData(tran_id,xtraParams,sitecode, period, type,forced_flag);
			
		}catch(Exception e)
		{
			System.out.println("Exception :jSON :actionHandler(String xmlString):" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("returning from actionMETHOD :actionHandler"+resString);
	    return resString;
	}

 	//Changed by wasim on to overload getGstTableData with connection parameter [START]
 	public String getGstTableData(String tran_id, String xtraParams ,String sitecode, String period, String type, String forced_flag) throws Exception
	{
 		String retString = "";
 		Connection conn = null;
 		try
 		{
 			retString = getGstTableData(tran_id, xtraParams,forced_flag,sitecode,period,type, conn);
 		}
 		catch(Exception e)
 		{
 			System.out.println("Exception inside getGstTableData==>"+e.getMessage());
 			throw new Exception();
 		}
 		
 		System.out.println("Returning from getGstTableData ["+retString+"]");
 		return retString;
	}
	//Changed by wasim on to overload getGstTableData with connection parameter [END]
	
 	//public String getGstTableData(String tran_id, String xtraParams , String forced_flag) throws RemoteException,ITMException
	public String getGstTableData(String tran_id, String xtraParams , String forced_flag,String sitecode, String period, String type, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("Inside GetGstTableData");
		System.out.println("Newsitecode::"+sitecode);
		System.out.println("New period::"+period);
		System.out.println("New type::"+type);
		
		String s=period;  
		String s1= s.substring(0,4);
		String s2= s.substring(4,6);
		String newPeriod=s2.concat(s1);
		System.out.println(s1);
		System.out.println(s2);
		System.out.println("after conversion::"+newPeriod);
		
		//Connection conn = null;
		String sql,sql1,sql2;
		
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		//final String APPLICATION_JSON = "application/json";
		final String APPLICATION_JSON = "APPLICATION_FORM_URLENCODED";
		
		ArrayList<GstHeaderData> headerDatalist = null;
		ArrayList<String> tranIDList = null;

		ArrayList<GstDetailData> detailDatalist = null;
		GstHrdDetData 	gstHrdDetData = new GstHrdDetData();
		GstHeaderData gstHeaderData = null;
		GstDetailData gstDetailData = null;
		String retString="",newType="";
		boolean isError = false;
		DistCommon distCommon = new DistCommon();
		//String GST_TABLE_URL="http://192.168.0.225:9090/ibase/rest/service/insertdata";
		String GST_TABLE_URL="";
		int connectionTimeout=0,socketTimeout=0,totalNoRecords=0,
			multipleOfRecords=0,noOfIteration=0,reminder = 0, noOfSlots = 10;
		
		PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null;
		ResultSet rs = null, rs1 = null;
		
		boolean isLocConn = false;
		boolean isSuccess = false;
		ConnDriver connDriver = null;
		
		try	
		{
			
			if(conn == null)
			{
				//conn = getConnection();
				connDriver = new ConnDriver();
				conn = connDriver.getConnectDB("DriverGST"); 
				conn.setAutoCommit(false);
				connDriver = null;
				
				isLocConn = true;
			}
			else
			{
				System.out.println("Connection is not null");
			}
			

			sql = " SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "GST_SYNC_SERVER_URI");
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				GST_TABLE_URL = rs.getString("SERVICE_URI");
			}
			if(pstmt != null)
			{
	    		pstmt.close();pstmt = null;
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			
			System.out.println("GST_SYNC_SERVER_URI ["+GST_TABLE_URL+"]");
			
			if(GST_TABLE_URL == null || GST_TABLE_URL.trim().length() == 0)
			{
				 retString = itmDBAccessLocal.getErrorString("","URLNOTFOUND","","",conn);
				 return retString;
			}
			
			
			 sql = " SELECT count(*) FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P'  and site_code = ?  and PRD_CODE= ? and REC_TYPE= ? ";
			    pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sitecode);
				pstmt.setString(2, newPeriod);
				if ("S".equalsIgnoreCase(type))
				{
					pstmt.setString(3, "1");
				}
				else
				{
					pstmt.setString(3, "2");
				}
				System.out.println("query::"+pstmt);
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					totalNoRecords = rs.getInt(1);
					
				}
				
				 if(pstmt != null)
				{
		    		pstmt.close();
		    		pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				if(totalNoRecords==0)
				{
					System.out.println("inside error condition::"+totalNoRecords);
					return retString = itmDBAccessLocal.getErrorString("","VNINVDATA","","",conn);
					
					//retString="No Data Found For Sync Operation";
				}
				System.out.println("totalNoRecords::"+totalNoRecords);
				
				String slotCount = distCommon.getDisparams("999999", "NO_OF_SLOT", conn);
				if("NULLFOUND".equalsIgnoreCase(slotCount))
				{
					noOfSlots = 100;
				}
				else
				{
					noOfSlots = Integer.parseInt(slotCount);
				}
				
				
				if(totalNoRecords >= totalNoRecords)
				{
					noOfIteration = totalNoRecords / noOfSlots;
					reminder = totalNoRecords % noOfSlots;
					System.out.println("noOfIteration::"+noOfIteration);
					System.out.println("reminder::"+reminder);
				}
				else
				{
					noOfIteration = 1;
				}
					
				if(reminder > 0)
				{
					noOfIteration = noOfIteration + 1;
				}
				
		
				//	totalNoRecords=
			
			//lOOP Total no of Records SELECT count(*) FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P'  and site_code = ?  and PRD_CODE= ?, for 1g 1050;
			//Parmater for Multiple of records in one slot, for e.g 100
			//Total no of iteration  = no of Records / records in one slot 10
			//Reminder = no of Records % records in one slot 50
			//if Reminder > 0 then iteration + 1 eg. 11
			//SELECT * FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P'  and site_code = ?  and PRD_CODE= ? and row_num = ?
			//if remider == no of Records - Parmater ro num =reminder else paramter
			
			//sql = "SELECT * FROM GST_DATA_HDR WHERE TRAN_ID IN ('0000000974','0000000989','0000001039')";
			//sql = " SELECT * FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P' ";
				
		    if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
		    {
		    	sql = " SELECT * FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P'  and site_code = ?  and PRD_CODE= ? AND REC_TYPE = ? and FETCH FIRST ? ROWS ONLY ";
		    }
		    else 
		    {
		    	sql = " SELECT * FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P'  and site_code = ?  and PRD_CODE= ? AND REC_TYPE = ? and rownum <= ?";
		    }
		/*	pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, sitecode);
			pstmt.setString(2, newPeriod);*/
			if ("S".equalsIgnoreCase(type))
			{
				 newType= "1";
			}
			else
			{
				 newType= "2";
			}
			//pstmt.setInt(4, noOfSlots);
			
			
			for(int lCtr = 0 ;lCtr <= noOfIteration; lCtr++)
			{
					System.out.println("query::"+pstmt);
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sitecode);
					pstmt.setString(2, newPeriod);
					pstmt.setString(3, newType);
					pstmt.setInt(4, noOfSlots);
					rs = pstmt.executeQuery();
					
					headerDatalist = new ArrayList<GstHeaderData>();
					tranIDList = new ArrayList<String>();
		
					while(rs.next())
					{
						detailDatalist = new ArrayList<GstDetailData>();
						gstHeaderData = new GstHeaderData();
						gstHeaderData.tranID = checkNullAndTrim(rs.getString("TRAN_ID"));
						tranIDList.add((rs.getString("TRAN_ID")));
						//System.out.println("tranIDList"+tranIDList);
						gstHeaderData.tranDate=checkNullAndTrim(rs.getString("TRAN_DATE"));
						gstHeaderData.tranIdRef=checkNullAndTrim(rs.getString("TRAN_ID__REF"));
						gstHeaderData.siteCode=checkNullAndTrim(rs.getString("SITE_CODE"));
						gstHeaderData.prdCode=checkNullAndTrim(rs.getString("PRD_CODE"));
						gstHeaderData.recType=checkNullAndTrim(rs.getString("REC_TYPE"));
						gstHeaderData.tranType=checkNullAndTrim(rs.getString("TRAN_TYPE"));
						gstHeaderData.custCode=checkNullAndTrim(rs.getString("CUST_CODE"));
						gstHeaderData.custName=checkNullAndTrim(rs.getString("CUST_NAME"));
						gstHeaderData.subType=checkNullAndTrim(rs.getString("SUBMISSION_TYPE"));
						gstHeaderData.docCheckSum=checkNullAndTrim(rs.getString("DOC_CHECKSUM"));
						gstHeaderData.docType=checkNullAndTrim(rs.getString("DOC_TYPE"));
						gstHeaderData.docNum=checkNullAndTrim(rs.getString("DOC_NO"));
						gstHeaderData.docDate=checkNullAndTrim(rs.getString("DOC_DATE"));
						gstHeaderData.amt=rs.getDouble("AMOUNT");
						gstHeaderData.revCharge=checkNullAndTrim(rs.getString("REVERSE_CHRG"));
						gstHeaderData.lrNo=checkNullAndTrim(rs.getString("LR_NO"));
						gstHeaderData.lrDate=checkNullAndTrim(rs.getString("LR_DATE"));
						gstHeaderData.reasCode=checkNullAndTrim(rs.getString("REAS_CODE"));
						gstHeaderData.refIdInv=checkNullAndTrim(rs.getString("REF_ID__INV"));
						gstHeaderData.refDateInv=checkNullAndTrim(rs.getString("REF_DATE__INV"));
						gstHeaderData.provAssmnt=checkNullAndTrim(rs.getString("PROV_ASSMNT"));
						gstHeaderData.ordNo=checkNullAndTrim(rs.getString("ORDER_NO"));
						gstHeaderData.ordDate=checkNullAndTrim(rs.getString("ORDER_DATE"));
						gstHeaderData.remarks=checkNullAndTrim(rs.getString("REMARKS"));
						gstHeaderData.subStatus=checkNullAndTrim(rs.getString("SUBMIT_STATUS"));
						gstHeaderData.subDate=checkNullAndTrim(rs.getString("SUBMIT_DATE"));
						gstHeaderData.addUser=checkNullAndTrim(rs.getString("ADD_USER"));
						gstHeaderData.addDate=checkNullAndTrim(rs.getString("ADD_DATE"));
						gstHeaderData.addTerm=checkNullAndTrim(rs.getString("ADD_TERM"));
						gstHeaderData.chgUser=checkNullAndTrim(rs.getString("CHG_USER"));
						gstHeaderData.chgDate=checkNullAndTrim(rs.getString("CHG_DATE"));
						gstHeaderData.chgTerm=checkNullAndTrim(rs.getString("CHG_TERM"));
						gstHeaderData.taxRegNo=checkNullAndTrim(rs.getString("TAX_REG_NO"));
						gstHeaderData.recoStatus=checkNullAndTrim(rs.getString("RECO_STATUS"));
						gstHeaderData.ecomRegNo=checkNullAndTrim(rs.getString("ECOM_REG_NO"));
						gstHeaderData.refSer=checkNullAndTrim(rs.getString("REF_SER"));
						gstHeaderData.gstCode=checkNullAndTrim(rs.getString("GST_CODE"));
						gstHeaderData.gstType=checkNullAndTrim(rs.getString("GST_TYPE"));
						gstHeaderData.refId=checkNullAndTrim(rs.getString("REF_ID"));
					
						String TranForDetID=rs.getString("TRAN_ID");
					
						
						sql1 = "select * from GST_DATA_DET WHERE tran_id=?";
						
					    pstmt1 = conn.prepareStatement(sql1);
						pstmt1.setString(1, TranForDetID);
					    rs1 = pstmt1.executeQuery();
					    
					    while(rs1.next())
						{
					    	gstDetailData=new GstDetailData();
					    	gstDetailData.tranID=checkNullAndTrim(rs1.getString("TRAN_ID"));
					    	gstDetailData.lineNo=rs1.getInt("LINE_NO");
					    	gstDetailData.status=checkNullAndTrim(rs1.getString("STATUS"));
					    	gstDetailData.srNoOld=rs1.getInt("SR_NO__OLD");
					    	gstDetailData.lineType=checkNullAndTrim(rs1.getString("LINE_TYPE"));
					    	gstDetailData.gsCode=checkNullAndTrim(rs1.getString("GS_CODE"));
					    	gstDetailData.taxableAmt=rs1.getDouble("TAXABLE_AMT");
					    	gstDetailData.igstPerc=rs1.getDouble("IGST_PERC");
					    	gstDetailData.igstAmt=rs1.getDouble("IGST_AMT");
					    	gstDetailData.cgstPerc=rs1.getDouble("CGST_PERC");
					    	gstDetailData.cgstAmt=rs1.getDouble("CGST_AMT");
					    	gstDetailData.sgstPerc=rs1.getDouble("SGST_PERC");
					    	gstDetailData.sgstAmt=rs1.getDouble("SGST_AMT");
					    	gstDetailData.gsDescr=checkNullAndTrim(rs1.getString("GS_DESCR"));
					    	gstDetailData.unit=checkNullAndTrim(rs1.getString("UNIT"));
					    	gstDetailData.quantity=rs1.getDouble("QUANTITY");
					    	gstDetailData.suppType=checkNullAndTrim(rs1.getString("SUPPLY_TYPE"));
					    	gstDetailData.cessPerc=rs1.getDouble("CESS_PERC");
					    	gstDetailData.cessAmt=rs1.getDouble("CESS_AMT");
					    	gstDetailData.remarks=checkNullAndTrim(rs1.getString("REMARKS"));
					    	gstDetailData.itcType=checkNullAndTrim(rs1.getString("ITC_TYPE"));
					    	gstDetailData.itcIgst=rs1.getDouble("ITC_IGST");
					    	gstDetailData.itcCgst=rs1.getDouble("ITC_CGST");
					    	gstDetailData.itcSgst=rs1.getDouble("ITC_SGST");
					    	gstDetailData.itcCess=rs1.getDouble("ITC_CESS");
					    	gstDetailData.gstRate=rs1.getDouble("GST_RATE");
					    	
					    	//System.out.println("ITC_CESS"+rs1.getInt("ITC_CESS"));
					    	
					    	detailDatalist.add(gstDetailData);
				    	
						}
					    if(pstmt1 != null)
						{
				    		pstmt1.close();
				    		pstmt1 = null;
						}
						if(rs1 != null)
						{
							rs1.close();
							rs1 = null;
						}	
				    	gstHeaderData.detaildata = detailDatalist;
				    
				    	headerDatalist.add(gstHeaderData);
				    
					}//while(rs.next())
				
					if(pstmt != null)
					{
			    		pstmt.close();
			    		pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				
				if(tranIDList != null)
				{
					System.out.println("headerDatalist Size ===>["+tranIDList.size()+"]["+tranIDList.toString()+"]");
				}
					
				System.out.println("headerDatalist Size ===>["+headerDatalist.size()+"]");
				
				if(headerDatalist.size()>0)
				{
					gstHrdDetData.headerData=headerDatalist;
		            ObjectMapper objectMapper = new ObjectMapper();
					String json = objectMapper.writeValueAsString(gstHrdDetData); 				
					JSONObject gstr1HeaderObj = new JSONObject();
					gstr1HeaderObj.put("data", json);
					
					
					RequestBodyEntity request = Unirest.post(String.format("%s", GST_TABLE_URL))
							                  // .setTimeouts(connectionTimeout,socketTimeout)
							                    .header("Content-Type", MediaType.APPLICATION_FORM_URLENCODED) 
							                    .body(new JsonNode(gstr1HeaderObj.toString()));                  
					System.out.println("request body ["+request.getBody()+"]");
					
					HttpResponse<String> gstr1Resp = request.getHttpRequest().asString();
					System.out.println("status["+gstr1Resp.getStatus()+"]body["+gstr1Resp.getBody()+"]");
					String status =gstr1Resp.getBody();
				
				    if("successfull".equalsIgnoreCase(status))
				    {
				      sql2="update gst_data_hdr set submit_status='Y' where tran_id=?";
					  pstmt2 = conn.prepareStatement(sql2);
			          
					  for (int i = 0; i < tranIDList.size(); i++) 
			          {  
			        	pstmt2.setString(1,tranIDList.get(i));
			        	pstmt2.addBatch();
			        	pstmt2.clearParameters();
			          }
					  pstmt2.executeBatch();		

					  if(pstmt2 != null)
					  {
						pstmt2.close(); 
						pstmt2 = null;
					  }
					  isSuccess = true;
				   }
				}
				
				
				
			}//for(int lCtr = 0 ;lCtr <= noOfIteration; lCtr++)
			
		
			if(pstmt != null)
			{
	    		pstmt.close();
	    		pstmt = null;
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			
			//System.out.println("headerDatalist Size ===>["+headerDatalist.size()+"]");
			
			if(isSuccess)
			{
				retString = itmDBAccessLocal.getErrorString("","PRCSUCCESS","","",conn);
			}
			
			/*if(headerDatalist.size()>0)
			{
				gstHrdDetData.headerData=headerDatalist;
				
				
				
	            ObjectMapper objectMapper = new ObjectMapper();
				
				String json = objectMapper.writeValueAsString(gstHrdDetData); 
				
				
				//System.out.println("json to SAVE GST Data[:"+json+":]");
				
				JSONObject gstr1HeaderObj = new JSONObject();
				gstr1HeaderObj.put("data", json);
				
				
				//Form f = new Form();
			//	f.param("data", json);
				
				RequestBodyEntity request = Unirest.post(String.format("%s", GST_TABLE_URL))
									    .header("Content-Type", APPLICATION_JSON)
									    .header("data", json)
									    .body(new JsonNode(gstr1HeaderObj.toString()));
				
				//RequestBodyEntity request = Unirest.post(String.format("%s", GST_TABLE_URL))
			//	Unirest.setTimeouts(0,0);
				RequestBodyEntity request = Unirest.post(String.format("%s", GST_TABLE_URL))
						                  // .setTimeouts(connectionTimeout,socketTimeout)
						                    .header("Content-Type", MediaType.APPLICATION_FORM_URLENCODED) 
						                    .body(new JsonNode(gstr1HeaderObj.toString()));                  
				System.out.println("request body ["+request.getBody()+"]");
				
			HttpResponse<String> gstr1Resp = request.getHttpRequest().asString();
				
			System.out.println("status["+gstr1Resp.getStatus()+"]body["+gstr1Resp.getBody()+"]");
			
			String status =gstr1Resp.getBody();
			
			    if("successfull".equalsIgnoreCase(status))
			    {
			      sql2="update gst_data_hdr set submit_status='Y' where tran_id=?";
				  pstmt2 = conn.prepareStatement(sql2);
		          
				  for (int i = 0; i < tranIDList.size(); i++) 
		          {  
		        	pstmt2.setString(1,tranIDList.get(i));
		        	pstmt2.addBatch();
		        	pstmt2.clearParameters();
		          }
				  pstmt2.executeBatch();		

				  if(pstmt2 != null)
				  {
					pstmt2.close(); 
					pstmt2 = null;
				  }
				  retString = itmDBAccessLocal.getErrorString("","PRCSUCCESS","","",conn);
			   }
			    //retString = itmDBAccessLocal.getErrorString("","PRCSUCCESS","","",conn);
			}*/
			/*else
			{
				 retString = itmDBAccessLocal.getErrorString("","PRCSUCCESS","","",conn);
			}*/
			
		}
		catch(Exception e)
		{
			//System.out.println("Exception GSTRegNoPosEJB ==>"+e.getMessage());
			System.out.println("Exception GetGstTableDataEJB ==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println(" Inside finally getGstTableData isLocConn ["+isLocConn+"] isError ["+isError+"] ");
				
				if (rs != null )
				{
					rs.close();rs = null;
				}
				if (rs1 != null )
				{
					rs1.close();rs1 = null;
				}
				if( pstmt != null )
				{
					pstmt.close();pstmt = null;
				}
				if( pstmt1 != null )
				{
					pstmt1.close();pstmt1 = null;
				}
				if( pstmt2 != null )
				{
					pstmt2.close();pstmt2 = null;
				}
				
				if(isLocConn)
				{
					if(isError)
					{
						System.out.println("Inside rollbacking....");
						conn.rollback();
					}
					else
					{
						System.out.println("Inside committing....");
						conn.commit();
					}
					if (conn != null )
					{
						conn.close();conn = null;
					}
				}
					
			}
			catch( Exception e)
			{
				e.printStackTrace();
			}
		}
			
		return retString;
	}
	
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
}
