<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <xsl:template match="*" mode="serialize"> <xsl:text>&lt;</xsl:text>  <xsl:value-of select="name()"/>  <xsl:apply-templates select="@*" mode="serialize" /> <xsl:choose>  <xsl:when test="node()"> <xsl:text>&gt;</xsl:text>  <xsl:apply-templates mode="serialize" />  <xsl:text>&lt;/</xsl:text>  <xsl:value-of select="name()"/>  <xsl:text>&gt;</xsl:text> </xsl:when> <xsl:otherwise>   <xsl:text> /&gt;</xsl:text> </xsl:otherwise> </xsl:choose> </xsl:template> <xsl:template match="@*" mode="serialize">  <xsl:text> </xsl:text> <xsl:value-of select="name()"/>  <xsl:text>="</xsl:text>   <xsl:value-of select="."/>   <xsl:text>"</xsl:text> </xsl:template><xsl:template match="/">
<html>
<head>

<link type="text/css" rel="stylesheet" href="/ibase/webitm/css/TaxSumView.css"/>
</head>
<body id='groupDiv'  bgcolor='#E7E7ED' ><FORM id="brow" METHOD="POST" ACTION="fwd.jsp">
<INPUT type='hidden' name='OBJ_NAME' value='taxsumview'/>
<INPUT type='hidden' name='PAGE_CONTEXT' value='1'/>
<INPUT type='hidden' name='OBJ_CONTEXT' value='1'/>
<INPUT type='hidden' name='EDIT_FLAG' value='V'/>
<INPUT type='hidden' name='EDIT_TMPLT' value='0'/>
<INPUT type='hidden' name='DOM_ID' value=''/>
<INPUT type='hidden' name='DB_ID' value=''/>
<INPUT type='hidden' name='CONFIRM_ID' value='null~null'/>
<INPUT type='hidden' name='COL_NAME' value=''/>
<INPUT type='hidden' name='ORDER' value='ascending'/>
<INPUT type='hidden' name='DATATYPE' value='text'/>
<INPUT type='hidden' name='REFRESH_MODE' value='false'/>
<div  class="itemtbl" id="itemtbl" >

<xsl:for-each select="/DocumentRoot/group0">
<xsl:variable name="col_name" select="../col_name"/>
<xsl:variable name="datatype" select="../datatype"/>
<xsl:variable name="sort_order" select="../order"/>
<script>
var sortOrder='<xsl:value-of select="$sort_order"/>';
var isAnyRecordSelected = false;
</script>
<xsl:for-each select="./Header0">
<div class="eachRow">
	<div class="eachSection">
        <div class="imgDiv"><img src="/ibase/webitm/images/view_tax.png"/></div>
    </div>
     <div class="eachSection">
		<div class="eachContent title">Tax Summary View</div>
	</div>
     <div class="eachSection alighrt" >
       <div class="eachContent textRtAlign title" style="margin-top:12px;"><xsl:text> </xsl:text><xsl:value-of select="./Detail1[attribute/@updateFlag!='D']/eff_date"/></div>
    </div>
</div>
<xsl:for-each select="./Detail1[attribute/@updateFlag!='D']">
<div class="eachRow">
	<div class="eachSection">
            <xsl:variable name ='taxDescr'><xsl:value-of select='tax_descr'/></xsl:variable>
		<div class="dynamic imgDiv "><xsl:value-of select = "substring($taxDescr,1,1)"/></div>
	</div>
	<div class="eachSection">
		<div class="eachContent"><xsl:value-of select='tax_descr'/> (<xsl:value-of select='tax_code'/>)</div>
        <div class="eachContent"><xsl:value-of select='tran_code'/></div>
	</div>
	<div class="eachSection alighrt" >
		 <div class="eachContent textRtAlign">
	     	<div class="eachContent textRtAlign">
              <xsl:value-of select='tax_amount'/>
             <xsl:text> </xsl:text><xsl:value-of select='curr_code__tax'/>
            </div>
            <div class="eachContent textRtAlign">
              <xsl:value-of select='taxable_amount'/> @ <xsl:value-of select='tax_perc'/>%
            </div>
	    </div>
    </div>
</div>
</xsl:for-each>
</xsl:for-each>
</xsl:for-each>
<div class="eachRow">
	<div class="eachSection alighrt">
		<div class="eachSection alighlt">Total Tax : 
              <xsl:value-of select= "sum(/DocumentRoot/group0/Header0/Detail1[attribute/@updateFlag!='D']/tax_amount)"/>
              <xsl:text> </xsl:text> 
             <xsl:value-of select="/DocumentRoot/group0/Header0/Detail1[attribute/@updateFlag!='D']/curr_code__tax"/>
        </div>
	</div>
</div>
</div>
</FORM>
</body></html>
</xsl:template>
</xsl:stylesheet>
