<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>
<xsl:template match="/">

<html>

<body>
	<div class="mainContainer">
		<!-- <xsl:if test="not(//header_data)">
			<p style="font-size:16px;">Sales order confirmation is pending or order is cancelled.</p>
		</xsl:if>  changes by sarita on 30NOV2017-->
	<!-- <xsl:for-each select="//Detail1">   changes by sarita on 30NOV2017-->
		<xsl:variable name="orderStatus"><xsl:value-of select="//Detail1/header_data/status"/></xsl:variable>
		<xsl:variable name="custPo"><xsl:value-of select="//Detail1/header_data/cust_pord"/></xsl:variable>
		<xsl:variable name="custPoDate"><xsl:value-of select="//Detail1/header_data/pord_date"/></xsl:variable>
		<div class="statusHeader">
			<div class="statusLine">
				<div class="leftAlignDiv">
					<p><strong>Order#</strong>&#160;<xsl:value-of select="//Detail1/header_data/sale_order" /> </p>
				</div>
				<div class="rightAlignDiv">
					<div class="orderStatsDiv">
						<input type="hidden" value="{$orderStatus}" id="orderStatus"/>
						<xsl:if test="$orderStatus='H'">
						<span>Sales order is on hold</span><img class="orderStatsImg" src="/ibase/images/galaxy/orderHold.png" />
						</xsl:if>
						<xsl:if test="$orderStatus='P'">
						<span>Sales order is pending</span><img class="orderStatsImg" src="/ibase/images/galaxy/orderPending.png" />
						</xsl:if>
						<xsl:if test="$orderStatus='C'">
						<span>Sales order is closed</span><img class="orderStatsImg" src="/ibase/images/galaxy/orderClosed.png" />
						</xsl:if>
						<xsl:if test="$orderStatus='X'">
						<span>Sales order is cancelled</span><img class="orderStatsImg" src="/ibase/images/galaxy/orderCancel.png" />
						</xsl:if>
					</div>
				</div>
			</div>
			<div class="statusLine">
				<div class="leftAlignDiv">
					<div class="custPoDate">
						<strong>Cust PO#</strong>&#160;
							<xsl:if test="$custPo = '' or $custPo = 'null'">
								N/A
							</xsl:if>
							<xsl:if test="$custPo = not('') or $custPo = not('null')">
								<xsl:value-of select="cust_pord"/>
							</xsl:if>
							&#160;<strong>PO Dt.</strong>&#160;
							<xsl:if test="$custPoDate = '' or $custPoDate = 'null'">
								N/A
							</xsl:if>
							<xsl:if test="$custPoDate = not('') or $custPoDate = not('null')">
								<xsl:value-of select="pord_date"/>
							</xsl:if>
						
					</div>
				</div>
				<div class="rightAlignDiv">
					<strong>Date</strong>&#160;<xsl:value-of select="//Detail1/header_data/order_date"/>
				</div>
			</div>
			<div class="statusLine">
				<div class="leftAlignDiv" id="dueDateLine">
					Due date between <xsl:value-of select="//Detail1/header_data/min_due_date"/> to <xsl:value-of select="//Detail1/header_data/max_due_date"/>
				</div>
			</div>
		</div>
	  
	    <!-- <div class="eachLineData">  changes by sarita on 30NOV2017-->
	     <div class="dataContainer">
	    	<xsl:for-each select="//Detail1/policy"> 
	    	<div class='eachLineData'>
	   			<div class="statusLine">
	   				<div class="leftAlignDiv">
						<p><strong>Cr.Policy:</strong>&#160;<xsl:value-of select="lsCrPolicy" /> </p>
					</div>
					
					<!-- <div class="rightAlignDiv">
						<p><strong>Despatch ID:</strong>&#160;<xsl:value-of select="despid" /> </p>
					</div>-->	
	   			</div>   
	   			
	   			<div class="statusLine">
					<div class="leftAlignDiv">
						<p><xsl:value-of select="lsStr" /> </p>
					</div>
					
					<div class="rightAlignDiv">
						<p> <b><xsl:value-of select="lsStatus" /></b></p>
					</div>				
				</div>	
			</div>														
			</xsl:for-each> 
		</div>
		
		<!-- <xsl:for-each select="//Detail1">  changes by sarita on 30NOV2017-->
		<div class="dataContainer">
			<xsl:for-each select="//Detail1/Item">
				<xsl:variable name="lineStatus"><xsl:value-of select="status"/></xsl:variable>
				<xsl:variable name="stkQty"><xsl:value-of select="stk_qty"/></xsl:variable>
				<xsl:variable name="despQty"><xsl:value-of select="desp_qty"/></xsl:variable>
				<xsl:variable name="reasDtl"><xsl:value-of select="reas_detail"/></xsl:variable>
				
				<div class='eachLineData'>
				 	<div class='itemDescrDiv'>
						<xsl:value-of select="item_descr"/> (<xsl:value-of select="item_code"/>)
					</div>
					<div class='lineSumryDiv'>
						<xsl:choose>
							<xsl:when test="$lineStatus='P'">
								<div class='pendDueDtLblDiv'>
									<div class='pendQtyDiv'>
										<xsl:value-of select="pend_qty"/>&#160;<xsl:value-of select="unit"/>
									   	Pending
									</div>
									<div class='dueDateLbl'>
										Due on
									</div>
								</div>
								
								<div class='shipQtyDueDtDiv'>
									<div class='shipQtyDiv'>
										<xsl:if test="$despQty='' or $despQty='0'">
										 	Not shipped
										 </xsl:if>
										<xsl:if test="$despQty=not('') and $despQty=not('0')">
											<xsl:value-of select="desp_qty"/>&#160;<xsl:value-of select="unit"/>
											Shipped
										</xsl:if>
										<xsl:if test="$reasDtl=not('') and $reasDtl=not('0')">
											<xsl:value-of select="reas_detail"/>&#160;<xsl:value-of select="unit"/>
										</xsl:if>
									</div>
									<div class='dueDate'>
										<xsl:value-of select="dsp_date"/>
									</div>
								</div>
								
								<div class='stkQtyDiv'>
									<xsl:if test="$stkQty='' or $stkQty='0'">
									 	No stock available
									 </xsl:if>
									<xsl:if test="$stkQty=not('')">
										<xsl:value-of select="stk_qty"/>&#160;<xsl:value-of select="unit"/>
										in stock
									</xsl:if>
								</div>								
							</xsl:when>
							
							<xsl:otherwise>
								<div class='closeOrderQtyDiv'>
									<xsl:value-of select="quantity"/>&#160;<xsl:value-of select="unit"/><br></br>
									 Orderd
								</div>
								<!-- <div class='closeOrderSumryDiv'>
									Line shipped completely
								</div> changes by sarita on 11DEC2017-->
								<div class='closeOrderSumryDiv'>
								<xsl:if test="$lineStatus='H'">
									<span>Sales order is on hold</span>
								</xsl:if>
								<xsl:if test="$lineStatus='P'">
									<span>Sales order is pending</span>
								</xsl:if>
								<xsl:if test="$lineStatus='D'">
									<span>Line shipped completely</span>
								</xsl:if>
								<xsl:if test="$lineStatus='X'">
									<span>Sales order is cancelled</span>
								</xsl:if>
								</div>
							</xsl:otherwise>					
						</xsl:choose>
					</div>
				</div>
			</xsl:for-each>
		</div>
		
	 	<!-- <xsl:for-each select="//Detail1">  changes by sarita on 30NOV2017-->
	 	<TABLE id="invoiceDetails" border="0" width="100%" cellpadding="0" cellspacing="0" style="margin-top:20px;margin-bottom:10px;">
				<xsl:for-each select="//Detail1/Invoice">
					<xsl:variable name="invoiceId"><xsl:value-of select="invoice_id"/></xsl:variable>
					<xsl:variable name="transMode"><xsl:value-of select="trans_mode"/></xsl:variable>
					<!-- Added by Santosh on 21/03/2017 to hide inovice row if invoice is not generated  -->
					<xsl:if test="$invoiceId = not('')">
						<TR>				
							<TD nowrap="false" align="left" valign="middle" width="5%"> 
							    
							    <xsl:if test="$invoiceId = '' or $invoiceId = 'null'">
							    	
							    </xsl:if>
							    <xsl:if test="$invoiceId = not('')">
							    	<strong>Invoice#</strong><br></br>
							    	<xsl:value-of select="invoice_id"/>
							    </xsl:if>
							</TD>
							<TD nowrap="true" align="right" valign="middle" width="5%" style="padding-top:17px;" > 
							   <xsl:value-of select="tran_date"/>
							</TD>
							<TD nowrap="true" align="right" valign="middle" width="5%" style="padding-top:17px;" > 
							   <xsl:value-of select="tran_name"/>
							</TD>
							<TD nowrap="true" align="right" valign="middle" width="5%" style="padding-top:17px;" > 
								<xsl:if test="$transMode='A'">
									By Air
								</xsl:if>
								<xsl:if test="$transMode='C'">
									By Courier
								</xsl:if>
								<xsl:if test="$transMode='D'">
									Direct
								</xsl:if>
								<xsl:if test="$transMode='F'">
									By Surface
								</xsl:if>
								<xsl:if test="$transMode='L'">
									By Railway
								</xsl:if>
								<xsl:if test="$transMode='R'">
									By Road
								</xsl:if>
								<xsl:if test="$transMode='S'">
									By Ship
								</xsl:if>
							</TD>
						</TR>
					<!-- Added by Santosh on 21/03/2017 to hide inovice row if invoice is not generated  -->
					</xsl:if>
				</xsl:for-each>
			</TABLE>		
	</div> 
</body>
</html>
</xsl:template>
</xsl:stylesheet>
