package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.PlanVsActualRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class PlanVsActualServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		PlanVsActualRemote planvsactualRemote = null;
		InitialContext context                = null;
		AppConnectParm appConnectParm         = new AppConnectParm();
		String dataSourceName                 = "";
		String loginId = "",fromDate = "",salePersons = "", toDate = "";
		HttpSession session                   = null;
		JSONObject jsonObjData                = null;
		OutputStream outputStream             = null;
		UserInfoBean userInfo                 = null;
		try
		{
			response.setContentType("application/xml");
			session = request.getSession(true);
			userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			fromDate = request.getParameter("fromDate");
			toDate = request.getParameter("toDate");
			salePersons = request.getParameter("salePersons");
			System.out.println("loginId = "+loginId+"fromDate = "+fromDate+"toDate = "+toDate+"sales person = "+salePersons);
			dataSourceName = request.getParameter("dataSourceName");
			if(salePersons.length()== 0)
			{
				salePersons = loginId;
			}
			context = new InitialContext(appConnectParm.getProperty());
			planvsactualRemote = (PlanVsActualRemote) context.lookup("ibase/PlanVsActual/remote");
			jsonObjData = (JSONObject) planvsactualRemote.getPlanVsActualTreeStructure(dataSourceName,loginId,fromDate,toDate,salePersons);
			System.out.println(" Final data set for PlanVsActualServlet build the Graph is===" + jsonObjData);
			outputStream   = response.getOutputStream();			
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			
		}
		catch (Exception e)
		{
			System.out.println("Exception : PlanVsActualServlet :doPost(HttpServletRequest request, HttpServletResponse response) :"+ e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
