package ibase.dashboard.sfa.ejb;

import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.rmi.RemoteException;
import org.json.simple.JSONObject;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Calendar;
import java.util.Date;

import javax.ejb.Stateless;

@Stateless
public class PlanVsActual extends ValidatorEJB implements PlanVsActualLocal,PlanVsActualRemote 
{
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getPlanVsActualTreeStructure(String dataSourceName,String loginId,String fromDate,String toDate,String salePersons) throws RemoteException, ITMException 
	{
		JSONObject rawDataPlanDtlJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "";
		DashboardUtility dashboardUtility = null;
		SimpleDateFormat formatter = null;
		E12GenericUtility e12GenericUtility = null;
		try 
		{
			fromDate = fromDate == null ? "": fromDate.trim();
			toDate = toDate == null ? "": toDate.trim();
			salePersons = salePersons == null ? "": salePersons.trim();
			dashboardUtility = new DashboardUtility();
			salePersons = dashboardUtility.getCommaSeparated(salePersons);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			formatter = new SimpleDateFormat("dd-MMM-yy");
			HashMap<String, ArrayList<String>> planHashMap = new HashMap<String, ArrayList<String>>();
			
			ArrayList<String> docList = new ArrayList<String>();
			
			//HashMap<String, HashMap<String, ArrayList<String>>> finalMap = new HashMap<String, HashMap<String,ArrayList<String>>>();
			TreeMap<String, HashMap<String, ArrayList<String>>> finalMap = new TreeMap<String, HashMap<String,ArrayList<String>>>();
			
			/*----------Planned doctors visited-----Planned--------*/
			if("".equalsIgnoreCase(fromDate) && "".equalsIgnoreCase(toDate)){
				fromDate = getDateString("firstDayOfWeek",formatter);
				toDate = getDateString("lastDayOfWeek",formatter);
				
				appendSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginId+"') connect by prior emp_code = report_to))";
			}
			else {
				appendSQL = " AND sp.sales_pers in("+salePersons+")) ";
				e12GenericUtility = new E12GenericUtility();
				fromDate = e12GenericUtility.getValidDateString(fromDate, "dd/MM/yyyy", "dd-MMM-yy");
				toDate = e12GenericUtility.getValidDateString(toDate, "dd/MM/yyyy", "dd-MMM-yy");
			}
			
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE " +
					"WHERE SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'" +
					""+appendSQL+" INTERSECT  (SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS , SP.SP_NAME ,SPC.SC_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME , L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			String docName = "",locality = "", speciality = "";
			String eventDate = "",docNamewithImage = "";
			
			
			while(rs.next())
			{
				eventDate    = rs.getString("eventdate");
				docName      = rs.getString("DoctorName");
				docNamewithImage = getImageStrfromName(docName);
				locality      = rs.getString("LOCALITY");
				speciality   = rs.getString("SPECIALITY");
				planHashMap = new  HashMap<String, ArrayList<String>>();
				if(finalMap!=null && finalMap.containsKey(eventDate))
				{
					planHashMap = finalMap.get(eventDate);
					docList = planHashMap.get("plan");
					//docList.add(docName+"@"+speciality+"@"+locality);
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", docList);
					planHashMap.put("missed", new ArrayList<String>());
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
				}
				else
				{
					docList = new ArrayList<String>();
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", docList);
					planHashMap.put("missed", new ArrayList<String>());
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
					
				}
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println(" Planned doctors visited finalMap :"+finalMap);
			
			docList = new ArrayList<String>();
			/*----------Planned doctors not visited-----Missed-------*/
			//sql="(select to_char(SPH.PLAN_DATE,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,spc.SC_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join sprs_plan_hdr sph on sp.sales_pers=sph.sprs_code__plan inner join sprs_plan_cust spc on sph.plan_id=spc.plan_id inner join STRG_CUSTOMER SC ON SC.SC_CODE=spc.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE between '06-AUG-16' and '16-AUG-16' AND SPRS_CODE__PLAN='M00005') MINUS (select to_char(sm.event_date,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,SM.STRG_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join strg_meet sm on sp.sales_pers=sm.sales_pers INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE where sm.event_date between '06-AUG-16' and '16-AUG-16' AND SM.SALES_PERS='M00005' and sp.sales_pers in (select emp_code from employee start with emp_code = (select emp_code from users where code='M00001') connect by prior emp_code = report_to) and sp.sales_pers in ('M00005') )";
			sql = "(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS ,SP.SP_NAME ,SPC.SC_CODE , INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+" MINUS (SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS , SP.SP_NAME ,SM.STRG_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				eventDate = rs.getString("eventdate");
				docName = rs.getString("DoctorName");
				docNamewithImage = getImageStrfromName(docName);
				locality = rs.getString("LOCALITY");
				speciality = rs.getString("SPECIALITY");
				
				planHashMap = new  HashMap<String, ArrayList<String>>();
				if(finalMap!=null && finalMap.containsKey(eventDate))
				{
					planHashMap = finalMap.get(eventDate);
					docList = planHashMap.get("missed");
					//docList.add(docName+"@"+speciality+"@"+locality);
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", docList);
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
				}
				else
				{
					docList = new ArrayList<String>();
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", docList);
					planHashMap.put("unplan", new ArrayList<String>());
					finalMap.put(eventDate, planHashMap);
					
				}
			}
			System.out.println(" Planned doctors not visited :"+finalMap);
			
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			docList = new ArrayList<String>();
			
			/*----------Unplanned doctors visited----Unplanned--------*/
			//sql="(select to_char(sm.event_date,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,SM.STRG_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join strg_meet sm on sp.sales_pers=sm.sales_pers INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE where sm.event_date between '06-AUG-16' and '16-AUG-16' AND SM.SALES_PERS='M00005') minus (select to_char(SPH.PLAN_DATE,'dd-mm-yy')  as eventdate ,sp.sales_pers ,sp.sp_name ,spc.SC_CODE ,INITCAP(SC.first_name||' '||SC.middle_name||' '||SC.last_name )AS DoctorName ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY from sales_pers sp inner join sprs_plan_hdr sph on sp.sales_pers=sph.sprs_code__plan inner join sprs_plan_cust spc on sph.plan_id=spc.plan_id inner join STRG_CUSTOMER SC ON SC.SC_CODE=spc.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE between '06-AUG-16' and '16-AUG-16' AND SPRS_CODE__PLAN='M00005' and sp.sales_pers in (select emp_code from employee start with emp_code = (select emp_code from users where code='M00001') connect by prior emp_code = report_to) and sp.sales_pers in ('M00005'))";
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE , INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY , SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+" MINUS (SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY')  AS EVENTDATE ,SP.SALES_PERS ,SP.SP_NAME ,SPC.SC_CODE , INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				eventDate = rs.getString("eventdate");
				docName = rs.getString("DoctorName");
				docNamewithImage = getImageStrfromName(docName);
				locality = rs.getString("LOCALITY");
				speciality = rs.getString("SPECIALITY");
				planHashMap = new  HashMap<String, ArrayList<String>>();
				if(finalMap!=null && finalMap.containsKey(eventDate))
				{
					planHashMap = finalMap.get(eventDate);
					docList = planHashMap.get("unplan");
					//docList.add(docName+"@"+speciality+"@"+locality);
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", planHashMap.get("missed"));
					planHashMap.put("unplan", docList);
					finalMap.put(eventDate, planHashMap);
				}
				else
				{
					docList = new ArrayList<String>();
					docList.add(docNamewithImage+"@"+speciality+"@"+locality);
					planHashMap.put("plan", planHashMap.get("plan"));
					planHashMap.put("missed", planHashMap.get("missed"));
					planHashMap.put("unplan", docList);
					finalMap.put(eventDate, planHashMap);
					
				}
			}
			System.out.println(" Unplanned doctors visited hashMap :"+finalMap);
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			int count = 0;
			
			for (Map.Entry<String, HashMap<String, ArrayList<String>>> entry : finalMap.entrySet())
			{
				rawJson = new JSONObject();
				if((getDateString("", formatter)).equalsIgnoreCase(entry.getKey())){
					rawJson.put("eventdate", "Today");
				}
				else if((getDateString("yesterday", formatter)).equalsIgnoreCase(entry.getKey())){
					rawJson.put("eventdate", "Yesterday");
				}
				else{
					rawJson.put("eventdate", entry.getKey());
				}
				rawJson.put("category", entry.getValue());
				rawDataPlanDtlJson.put(count, rawJson);
				count++;
			}
			System.out.println("rawDataPlanDtlJson :"+rawDataPlanDtlJson);
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getPlanVsActualTreeStructure()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPlanDtlJson;
	}
	
	private String getImageStrfromName(String doctorName) {
		String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator; 
		File file = new File(userImagePath+doctorName+".png");
		String retString = "";
		if(file.exists())
		{
			retString = "<img class='defaultIconImage' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+doctorName+".png'/>";
		}else
		{
			doctorName = doctorName.trim();
			String[] splited = doctorName.split(" ");
			System.out.println("splited getImageStrfromName :"+splited[0].charAt(0));
			String defaultUserImg = ""+splited[0].charAt(0);
			
			if(splited.length>1)
			{
				String lastWord = doctorName.substring(doctorName.lastIndexOf(" ")+1);
				System.out.println("lastWord  getImageStrfromName :"+lastWord);
				defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
			}
			System.out.println("defaultUserImg :"+defaultUserImg);
			
			retString = "<div class='defaultIconImage'> "+defaultUserImg+" </div>";
		}
		System.out.println("doctorName = "+doctorName+"retString ="+retString);
		retString = doctorName+"~"+retString;
		return retString;
	}

	/*----------Method for getting Todays Agenda--------*/
	@SuppressWarnings("unchecked")
	public JSONObject getTodayAgenda(String dataSourceName,String loginId,String salePersons) throws ITMException{
		JSONObject rawDataPlanDtlJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "", scCode = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "";
		DashboardUtility dashboardUtility = null;
		SimpleDateFormat formatter = null;
		String fromDate ="",toDate = "",locality = "",prvlocality = "",doctorName = "";
		ArrayList<String> strgCodeList = null;
		try 
		{
			salePersons = salePersons == null ? "": salePersons.trim();
			dashboardUtility = new DashboardUtility();
			salePersons = dashboardUtility.getCommaSeparated(salePersons);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			formatter = new SimpleDateFormat("dd-MMM-yy");
			fromDate = getDateString("",formatter);
			toDate  = getDateString("",formatter);
			
			if("".equalsIgnoreCase(salePersons) && loginId != null){
				
				appendSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginId+"') connect by prior emp_code = report_to))";
			}
			else {
				appendSQL = " AND sp.sales_pers in("+salePersons+")) ";
			}
			
			sql = "(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS , SP.SP_NAME , SPC.SC_CODE AS SC_CODE, INITCAP(SC.FIRST_NAME ||' ' ||SC.MIDDLE_NAME ||' ' ||SC.LAST_NAME )AS DOCTORNAME, L.DESCR         AS LOCALITY , SPL.DESCR       AS SPECIALITY FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE    =SC.SC_CODE AND SS.SALES_PERS=SP.SALES_PERS INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE BETWEEN '"+fromDate+"' AND '"+toDate+"'"+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();			
			int count = 0;
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			strgCodeList = getStrgCodeList(dataSourceName, loginId, salePersons);
			
			while(rs.next())
			{
			    rawJson = new JSONObject();	
			    locality    = rs.getString("LOCALITY");
			    doctorName  = rs.getString("DOCTORNAME").trim();
			    scCode     = rs.getString("SC_CODE").trim();
			    		
			    if(!locality.equalsIgnoreCase(prvlocality))
				{
			    	rawJson.put("locality", locality);
			    	rawJson.put("defaultIconTitle", "defaultIconTitle");
					System.out.println("locality :"+locality);
					prvlocality  = locality;
				}else
				{
					rawJson.put("locality", "");
				}
				
				File file = new File(userImagePath+doctorName+".png");
				if(file.exists())
				{
					rawJson.put("doctor_image", "<img class='defaultIconImage' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+doctorName+".png'/>");
				}else
				{
					doctorName = doctorName.trim();
					String[] splited = doctorName.split(" ");
					System.out.println("splited getTodayAgenda :"+splited[0].charAt(0));
					String defaultUserImg = ""+splited[0].charAt(0);
					
					if(splited.length>1)
					{
						String lastWord = doctorName.substring(doctorName.lastIndexOf(" ")+1);
						System.out.println("lastWord  getTodayAgenda :"+lastWord);
						defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
					}
					System.out.println("defaultUserImg :"+defaultUserImg);
					
					rawJson.put("doctor_image", "<div class='defaultIconImage'> "+defaultUserImg+" </div>");
				}
				//doctorName = "<div class='defaultIconTitle'> "+doctorName+" </div>";
				//String speciality = "<div class='defaultIconSubTitle'> "+rs.getString("SPECIALITY")+" </div>";
				
				rawJson.put("doctorName", doctorName);
				rawJson.put("time", "10:00 am");
				
				//rawJson.put("speciality", rs.getString("SPECIALITY"));
				//rawJson.put("speciality", speciality);
				
				if(strgCodeList.contains(scCode)){
					rawJson.put("meet_status", "<img class='defaultIconImage' src='/ibase/dwh/FusionChart/images/Tick-mark.png'/>");
				}
				else{
					rawJson.put("meet_status", "");
				}
				rawDataPlanDtlJson.put(count, rawJson);
				count++;
			}
			/*while(rs.next())
			{
				if(count == 0){
					
					rawJson.put("heading", "<table border='1' width='100%'> <tr> <td>Planning of "+rs.getString("SP_NAME")+"</td>  </tr> </table>");
					rawJson.put("tableHeader", "<table><tr><td style='text-align: left;'>Doctor Name</td><td style='text-align: left;'>Speciality</td><td style='text-align: left;'>Location</td></tr>");
					rawJson.put("doctorName", rs.getString("DoctorName"));
					rawJson.put("locality",   rs.getString("LOCALITY"));
					rawJson.put("speciality", rs.getString("SPECIALITY"));	
				}
				else{
					rawJson.put("heading", "");
					rawJson.put("tableHeader", "");
					rawJson.put("doctorName", rs.getString("DoctorName"));
					rawJson.put("locality",   rs.getString("LOCALITY"));
					rawJson.put("speciality", rs.getString("SPECIALITY"));
				}
				rawDataPlanDtlJson.put(count, rawJson);
				count++;
				
			}*/
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getTodayAgenda()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPlanDtlJson;
	}

	public String getDateString(String dateCondition,SimpleDateFormat formatter ) {
        Calendar cal = Calendar.getInstance(); 
        
        if("firstDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+1);
        }
        if("yesterday".equalsIgnoreCase(dateCondition)){
        	cal.add(Calendar.DATE, -1);
        }
        if("lastDayOfWeek".equalsIgnoreCase(dateCondition)){
        	int currentDOW = cal.get(Calendar.DAY_OF_WEEK);
            cal.add(Calendar.DAY_OF_YEAR, (currentDOW * -1)+7);
        }
        System.out.println("formatter.format(cal.getTime(): "+formatter.format(cal.getTime()));
		return formatter.format(cal.getTime());
	}
	
	public ArrayList<String> getStrgCodeList(String dataSourceName,String loginId,String salePersons) throws ITMException
	{
		String todayDate = getDateString("",new SimpleDateFormat("dd-MMM-yy"));
		String appendSQL  = "",sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		ArrayList<String> strgCodeList = new ArrayList<String>();
		
		try {
			
			if(!salePersons.contains(","))
			{
				appendSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginId+"') connect by prior emp_code = report_to))";
			}
			else {
				appendSQL = " AND sp.sales_pers in("+salePersons+")) ";
			}
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE AS STRG_CODE,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SM.EVENT_DATE = '"+todayDate+"' "+appendSQL+" INTERSECT  (SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , SP.SALES_PERS , SP.SP_NAME ,SPC.SC_CODE ,INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )AS DOCTORNAME , L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE WHERE SPH.PLAN_DATE = '"+todayDate+"' "+appendSQL+"";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			String strg_code = "";
			
			while(rs.next())
			{
				strg_code = rs.getString("STRG_CODE");
				strg_code = strg_code == null ? "" : strg_code.trim();
				strgCodeList.add(strg_code);
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
		} catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getStrgCodeList()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		
		return strgCodeList;
	}
	 
	/*@SuppressWarnings("unchecked")
	@Override
	public JSONObject getTodaysCalls(String dataSourceName,String loginId,String salePersons) throws RemoteException, ITMException 
	{
		JSONObject rawDataPlanDtlJson = new JSONObject();
		JSONObject rawJson = null;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		String appendSQL = "";
		DashboardUtility dashboardUtility = null;
		SimpleDateFormat formatter = null;
		E12GenericUtility e12GenericUtility = null;
		int count = 0;
		double plannedRowCount=0, unplannedRowCount=0, missedRowCount=0, listedRowCount=0, unlistedRowCount=0;
		try 
		{
			salePersons = salePersons == null ? "": salePersons.trim();
			dashboardUtility = new DashboardUtility();
			salePersons = dashboardUtility.getCommaSeparated(salePersons);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			formatter = new SimpleDateFormat("dd-MMM-yy");
			
			----------Planned doctors visited-----Planned--------
			
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY') AS EVENTDATE , " +
				"SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE ," +
				"INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )" +
				"AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY  " +
				"FROM SALES_PERS SP INNER JOIN STRG_MEET SM " +
				"ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC " +
				"ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L " +
				"ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS " +
				"ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL " +
				"ON SPL.SPL_CODE=SS.SPL_CODE " +
				"WHERE SM.EVENT_DATE <= sysdate)  INTERSECT  " +
				"(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY') AS EVENTDATE , " +
				"SP.SALES_PERS , SP.SP_NAME ,SPC.SC_CODE ," +
				"INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )" +
				"AS DOCTORNAME , L.DESCR AS LOCALITY ,SPL.DESCR AS " +
				"SPECIALITY  FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH " +
				"ON SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN " +
				"SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN " +
				"STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN " +
				"LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN " +
				"STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN " +
				"SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE " +
				"WHERE SPH.PLAN_DATE <= sysdate) ";
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs = pstmt.executeQuery();
            plannedRowCount = 0;
            rs.last();
            plannedRowCount = rs.getRow();
            rs.beforeFirst();
			
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println(" Planned doctors visited :"+plannedRowCount);
			
			----------Planned doctors not visited-----Missed-------
			sql = "(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY')  AS EVENTDATE ," +
				"SP.SALES_PERS ,SP.SP_NAME ,SPC.SC_CODE , " +
				"INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )" +
				"AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY " +
				"FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON " +
				"SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN " +
				"SPRS_PLAN_CUST SPC ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN " +
				"STRG_CUSTOMER SC ON SC.SC_CODE=SPC.SC_CODE INNER JOIN " +
				"LOCALITY L ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN " +
				"STRG_SERIES SS ON SS.SC_CODE=SC.SC_CODE INNER JOIN " +
				"SPECIALITY SPL ON SPL.SPL_CODE=SS.SPL_CODE " +
				"WHERE SPH.PLAN_DATE = sysdate) MINUS (SELECT " +
				"TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY')  AS EVENTDATE ," +
				"SP.SALES_PERS , SP.SP_NAME ,SM.STRG_CODE ," +
				"INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )" +
				"AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS " +
				"SPECIALITY FROM SALES_PERS SP INNER JOIN STRG_MEET SM " +
				"ON SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC " +
				"ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L " +
				"ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS " +
				"ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL " +
				"ON SPL.SPL_CODE=SS.SPL_CODE WHERE " +
				"SM.EVENT_DATE = sysdate)";
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs = pstmt.executeQuery();
            missedRowCount = 0;
            rs.last();
            missedRowCount = rs.getRow();
            rs.beforeFirst();
			
			
			System.out.println(" Planned doctors not visited :"+missedRowCount);
			
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			----------Unplanned doctors visited----Unplanned--------
			sql = "(SELECT TO_CHAR(SM.EVENT_DATE,'DD-MON-YYYY')  AS EVENTDATE ," +
				"SP.SALES_PERS ,SP.SP_NAME ,SM.STRG_CODE , " +
				"INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )" +
				"AS DOCTORNAME ,L.DESCR AS LOCALITY , SPL.DESCR AS SPECIALITY " +
				"FROM SALES_PERS SP INNER JOIN STRG_MEET SM ON " +
				"SP.SALES_PERS=SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC " +
				"ON SC.SC_CODE=SM.STRG_CODE INNER JOIN LOCALITY L " +
				"ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS " +
				"ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL " +
				"ON SPL.SPL_CODE=SS.SPL_CODE WHERE " +
				"SM.EVENT_DATE <= sysdate) MINUS " +
				"(SELECT TO_CHAR(SPH.PLAN_DATE,'DD-MON-YYYY')  AS EVENTDATE ," +
				"SP.SALES_PERS ,SP.SP_NAME ,SPC.SC_CODE , " +
				"INITCAP(SC.FIRST_NAME||' '||SC.MIDDLE_NAME||' '||SC.LAST_NAME )" +
				"AS DOCTORNAME ,L.DESCR AS LOCALITY ,SPL.DESCR AS SPECIALITY " +
				"FROM SALES_PERS SP INNER JOIN SPRS_PLAN_HDR SPH ON " +
				"SP.SALES_PERS=SPH.SPRS_CODE__PLAN INNER JOIN SPRS_PLAN_CUST SPC " +
				"ON SPH.PLAN_ID=SPC.PLAN_ID INNER JOIN STRG_CUSTOMER SC " +
				"ON SC.SC_CODE=SPC.SC_CODE INNER JOIN LOCALITY L " +
				"ON L.LOCALITY_CODE=SC.LOCALITY_CODE INNER JOIN STRG_SERIES SS " +
				"ON SS.SC_CODE=SC.SC_CODE INNER JOIN SPECIALITY SPL " +
				"ON SPL.SPL_CODE=SS.SPL_CODE WHERE " +
				"SPH.PLAN_DATE <= sysdate)";
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs = pstmt.executeQuery();
            unplannedRowCount = 0;
            rs.last();
            unplannedRowCount = rs.getRow();
            rs.beforeFirst();
			
			
			System.out.println(" Unplanned doctors visited  :"+unplannedRowCount);
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			---------Listed ------------------------- 
			sql="SELECT * FROM STRG_MEET SM INNER JOIN STRG_SERIES SS ON SS.SALES_PERS = SM.SALES_PERS WHERE SM.EVENT_DATE=sysdate";
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs = pstmt.executeQuery();
            listedRowCount = 0;
            rs.last();
            listedRowCount = rs.getRow();
            rs.beforeFirst();
			
			
			System.out.println("Listed------>  :"+listedRowCount);
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			-----------Unlisted---------------------- 
			sql="SELECT * FROM STRG_MEET SM INNER JOIN STRG_SERIES SS ON SS.SC_CODE != SM.STRG_CODE WHERE SM.EVENT_DATE=sysdate";
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs = pstmt.executeQuery();
            unlistedRowCount = 0;
            rs.last();
            unlistedRowCount = rs.getRow();
            rs.beforeFirst();
			
			
			System.out.println("Unlisted------>  :"+unlistedRowCount);
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			
			rawJson = new JSONObject();
			rawJson.put("plannedRowCount", plannedRowCount);
			rawJson.put("unplannedRowCount", unplannedRowCount);
			//rawJson.put("missedRowCount", missedRowCount);
			rawJson.put("listedRowCount", listedRowCount);
			rawJson.put("unlistedRowCount", unlistedRowCount);
			
			System.out.println("plannedRowCount======= : "+plannedRowCount);
			
			double totalCount = plannedRowCount+unplannedRowCount;
			System.out.println("TotalCount======= : "+totalCount);
			
			double planDashArray = (plannedRowCount/totalCount)*302;
			System.out.println("planDashArray ====== : "+planDashArray);
			
			
			double listedDashArray = (240/listedRowCount);
			System.out.println("listedDashArray == : "+listedDashArray);
			
			double unlistedDashArray = (240/unlistedRowCount)/listedRowCount;
			System.out.println("unlistedDashArray == : "+unlistedDashArray);
			
			
			rawJson.put("planDashArray", (unplannedRowCount/(plannedRowCount+unplannedRowCount))*302);
			//rawJson.put("missedDashArray", 240);
			rawJson.put("listedDashArray", (unlistedDashArray/(listedDashArray+unlistedDashArray))*240);
			rawJson.put("total", (int)(plannedRowCount+unplannedRowCount+missedRowCount));
			
			
			
			rawDataPlanDtlJson.put(count, rawJson);
			
			System.out.println("rawDataPlanDtlJson :"+rawDataPlanDtlJson);
			
	    } 
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual:getPlanVsActualTreeStructure()" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPlanDtlJson;
	}*/
	
	// This is new requirement for circular bar chart added on dated :18-12-17	
	@SuppressWarnings("unchecked")
	public JSONObject getTodaysCalls(String dataSourceName,String loginCode,String salePersons) throws RemoteException, ITMException
	{	
		System.out.println("inside getTodaysCalls");
		JSONObject rawDataPlanDtlJson = new JSONObject();
		JSONObject rawJson = new JSONObject();
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yy");
		Date date = new Date();
		String sysDate = sdf.format(date);
		
		int count = 0;
		
		String salesPersonCode = "", salesPersonName = "", salesPerson_image = "" ;
		String customerCode = "", customerName = "" , customer_Image = "";
		StringBuffer rowBuffer = new StringBuffer();
		StringBuffer listedBuffer = new StringBuffer();
		int planned=0, unplanned=0,listed=0, unListed=0;
		int totalCalls=0;
		String localSQL="";
		
		try 
		{
			rowBuffer.append("<div>");
			listedBuffer.append("<div>");
			salePersons     = salePersons == null ? "": salePersons.trim();
			dashboardUtility = new DashboardUtility();
			salePersons      = dashboardUtility.getCommaSeparated(salePersons);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver   = null;
			System.out.println(" >>>>>>>> SQL FOR PLANNED DOCTORS >>>>>>> ");
			
			if("".equalsIgnoreCase(salePersons) && loginCode != null)
			{
				
				localSQL = " AND SP.SALES_PERS IN (SELECT EMP_CODE FROM EMPLOYEE START WITH EMP_CODE = (SELECT EMP_CODE FROM USERS WHERE CODE='"+loginCode+"') connect by prior emp_code = report_to)";
			}
			else {
				localSQL = " AND sp.sales_pers in ("+salePersons+") ";
			}
			
			
			/*----------Planned doctors visited-----Planned--------*/
									
			// new sql query provided by sagar
			sql ="SELECT SM.EVENT_DATE, SM.SALES_PERS, SP.SP_NAME, SM.STRG_CODE, (SC.FIRST_NAME ||' '||SC.LAST_NAME)AS NAME "
			   + " FROM STRG_MEET SM INNER JOIN SALES_PERS SP ON SP.SALES_PERS = SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE "
			   + " INNER JOIN SPRS_PLAN_HDR SPH ON SPH.SPRS_CODE__PLAN = SM.SALES_PERS AND SPH.PLAN_DATE=SM.EVENT_DATE "
			   + " WHERE SM.EVENT_DATE = '"+sysDate+"' AND SM.SALES_PERS= SP.SALES_PERS "
			   + " AND NOT EXISTS (SELECT SPC.SC_CODE FROM SPRS_PLAN_CUST SPC "
			   + " WHERE SPC.SC_CODE=SM.STRG_CODE AND SPC.PLAN_ID = SPH.PLAN_ID) ";

						
			pstmt = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs = pstmt.executeQuery();
            rs.last();
            planned = rs.getRow();
            String plannedDocImagePath    = "";
            System.out.println("get planned visited count" + planned);
            rs.beforeFirst();			
			
            
            
            if(planned > 0)
			{
				rowBuffer.append("<table cellspacing='0' cellpadding='0' width='100%' ><tr rowspan='2'><td class='defaultTitle'>Planned</td></tr>");
				while(rs.next())
				{
					salesPersonCode    = checkNull(rs.getString("SC_CODE"));
				    salesPersonName    = checkNull(rs.getString("NAME"));
				    String object      = "images"+ File.separator + "users";
				    plannedDocImagePath     = "/ibase/CustomMenuImageServlet?fldValue="+salesPersonCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+salesPersonName;
			     	salesPerson_image = "<img class='cardProdImg2' src='"+plannedDocImagePath+"'/>";
			    	rowBuffer.append("<tr><td><table cellspacing='0' cellpadding='0' " +
				     		"style='border-bottom:1px solid #E8E8E8;' width='100%'><tr>" +
				     		"<td width='2%'>"+salesPerson_image+"</td>" +
				     		"<td style = 'width:80%;' id='"+salesPersonCode+"' onclick='getRowWisePkValue(this.id)' >"+salesPersonName.toUpperCase()+"</td>" +
				     		"<td class = 'dashboardEditImg'></td>" +
				       			"</tr></table></td></tr>");				}
				rowBuffer.append("</table>");
			}
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
            
						
			// sql for unplanned by sagar
			sql = " SELECT SM.EVENT_DATE, SM.SALES_PERS, SP.SP_NAME, SM.STRG_CODE, (SC.FIRST_NAME ||' '||SC.LAST_NAME)AS NAME "
				+ " FROM STRG_MEET SM INNER JOIN SALES_PERS SP ON SP.SALES_PERS = SM.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE INNER JOIN SPRS_PLAN_HDR SPH ON SPH.SPRS_CODE__PLAN = SM.SALES_PERS AND SPH.PLAN_DATE=SM.EVENT_DATE "
				+ " WHERE SM.EVENT_DATE = '"+sysDate+"' AND SM.SALES_PERS = SP.SALES_PERS  AND NOT EXISTS (SELECT SPC.SC_CODE FROM SPRS_PLAN_CUST SPC WHERE SPC.SC_CODE=SM.STRG_CODE AND SPC.PLAN_ID = SPH.PLAN_ID) ";
				  		
			
			pstmt     = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs        = pstmt.executeQuery();
            rs.last();
            unplanned   = rs.getRow();
            System.out.println("get unplanned doctor visited count" + unplanned);
            rs.beforeFirst();			
			String unplannedDocImagePath    = "";// Please define proper variable name
			if(unplanned > 0)
			{
				rowBuffer.append("<table cellspacing='0' cellpadding='0' width='100%' ><tr rowspan='2'><td class='defaultTitle'>Unplanned</td></tr>");
				while(rs.next())
				{
					salesPersonCode    = checkNull(rs.getString("STRG_CODE"));
				    salesPersonName    = checkNull(rs.getString("NAME"));
				    String object      = "images"+ File.separator + "users";
				    unplannedDocImagePath     = "/ibase/CustomMenuImageServlet?fldValue="+salesPersonCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+salesPersonName;
			     	salesPerson_image = "<img class='cardProdImg2' src='"+unplannedDocImagePath+"'/>";
			    	rowBuffer.append("<tr><td><table cellspacing='0' cellpadding='0' " +
				     		"style='border-bottom:1px solid #E8E8E8;' width='100%'><tr>" +
				     		"<td width='2%'>"+salesPerson_image+"</td>" +
				     		"<td style = 'width:80%;' id='"+salesPersonCode+"' onclick='getRowWisePkValue(this.id)' >"+salesPersonName.toUpperCase()+"</td>" +
				     		"<td class = 'dashboardEditImg'></td>" +
			       			"</tr></table></td></tr>");
				}
				rowBuffer.append("</table>");
			}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			
			
			/*----------Listed doctors visited.--*/
			
			/*sql = "SELECT sm.tran_id,  TO_CHAR(sm.event_date, 'dd-mon-yyyy') AS Event_Date,  "
					+ "sm.strg_code,  sm.sales_pers,  sp.sc_code, SS.SP_NAME "
					+ "FROM SALES_PERS SS INNER JOIN STRG_MEET SM ON SS.SALES_PERS=SM.SALES_PERS "
					+ "INNER JOIN strg_series SP ON sp.sales_pers   = sm.sales_pers "
					+ "WHERE sm.strg_code =sp.sc_code AND sm.event_date <= sysdate "+localSQL+" and ROWNUM <10 ";*/
			
				
			//Listed Query by SAGAR	
			sql = "SELECT SM.EVENT_DATE, SM.SALES_PERS, SP.SP_NAME ,SM.STRG_CODE ,(SC.FIRST_NAME ||' '||SC.LAST_NAME)AS NAME "
				+ " FROM STRG_SERIES SS INNER JOIN STRG_MEET SM ON SM.STRG_CODE=SS.SC_CODE AND SM.SALES_PERS=SS.SALES_PERS INNER JOIN SALES_PERS SP ON SP.SALES_PERS=SS.SALES_PERS INNER JOIN STRG_CUSTOMER SC ON SC.SC_CODE=SM.STRG_CODE "
				+ " WHERE SM.SALES_PERS = SP.SALES_PERS AND SM.EVENT_DATE  = '"+sysDate+"' AND SS.STATUS='Y' ";	
				
			pstmt    = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs       = pstmt.executeQuery();
            rs.last();
            listed   = rs.getRow();
            String listedDocImagePath    = "";
            System.out.println("get listed doctor visited count" + listed);
            rs.beforeFirst();
			if(listed > 0)
			{
				 listedBuffer.append("<table cellspacing='0' cellpadding='0' width='100%' ><tr rowspan='2'><td class='defaultTitle'>Listed</td></tr>");
				while(rs.next())
				{
				    //salesPersonCode    = checkNull(rs.getString("SALES_PERS")) ;
				    //salesPersonName    = checkNull(rs.getString("SP_NAME")) ;
					customerCode = checkNull(rs.getString("STRG_CODE"));
					customerName = checkNull(rs.getString("NAME"));
				    String object      = "images"+ File.separator + "users";
				    listedDocImagePath = "/ibase/CustomMenuImageServlet?fldValue="+customerCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+customerName;
				    customer_Image = "<img class='cardProdImg2' src='"+listedDocImagePath+"'/>";
				    listedBuffer.append("<tr><td><table cellspacing='0' cellpadding='0' " +
				     		"style='border-bottom:1px solid #E8E8E8;' width='100%'><tr>" +
				     		"<td width='2%'>"+customer_Image+"</td>" +
				     		"<td style = 'width:80%;' id='"+customerCode+"' onclick='getRowWisePkValue(this.id) >"+customerName.toUpperCase()+"</td>" +
				     		"<td class = 'dashboardEditImg'></td>" +
			       			"</tr></table></td></tr>");
				}
				listedBuffer.append("</table>");
			}
			 	rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			
			
			/*----------Unlisted doctors visited.--*/
			
			/*sql = "SELECT sm.tran_id,  TO_CHAR(sm.event_date, 'dd-mon-yyyy') AS Event_Date,  "
					+ "sm.strg_code,  sm.sales_pers, sp.sc_code, SS.SP_NAME "
					+ "FROM SALES_PERS SS INNER JOIN STRG_MEET SM ON SS.SALES_PERS=SM.SALES_PERS "
					+ "INNER JOIN strg_series SP ON sp.sales_pers   = sm.sales_pers "
					+ "WHERE sm.strg_code !=sp.sc_code AND sm.event_date <= sysdate "+localSQL+" and ROWNUM <10 ";*/
			
			// Unlisted query by Sagar	
			sql = "SELECT SM.EVENT_DATE  ,SP.SALES_PERS ,SP.SP_NAME,SM.STRG_CODE,SM.STRG_NAME "
				+ " FROM STRG_MEET SM INNER JOIN SALES_PERS SP ON SP.SALES_PERS=SM.SALES_PERS "
				+ " WHERE SM.SALES_PERS= SP.SALES_PERS AND SM.EVENT_DATE = '"+sysDate+"'  AND NOT EXISTS (SELECT SC_CODE FROM STRG_CUSTOMER SC WHERE SC.SC_CODE = SM.STRG_CODE) ";	
						
			pstmt    = conn.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
            rs       = pstmt.executeQuery();
            rs.last();
            unListed   = rs.getRow();
            String unlistedDocImagePath    = "";
            System.out.println("get listed doctor visited count" + unListed);
            rs.beforeFirst();
			if(unListed > 0)
			{
				listedBuffer.append("<table cellspacing='0' cellpadding='0' width='100%' ><tr rowspan='2'><td class='defaultTitle'>Unlisted</td></tr>");
				while(rs.next())
				{
					salesPersonCode    = checkNull(rs.getString("STRG_CODE")) ;
				    salesPersonName    = checkNull(rs.getString("NAME")) ;
				    String object      = "images"+ File.separator + "users";
				    unlistedDocImagePath     = "/ibase/CustomMenuImageServlet?fldValue="+salesPersonCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+salesPersonName;
			     	salesPerson_image = "<img class='cardProdImg2' src='"+unlistedDocImagePath+"'/>";
			     	listedBuffer.append("<tr><td><table cellspacing='0' cellpadding='0' " +
				     		"style='border-bottom:1px solid #E8E8E8;' width='100%'><tr>" +
				     		"<td width='2%'>"+salesPerson_image+"</td>" +
				     		"<td style = 'width:80%;' id='"+salesPersonCode+"' onclick='getRowWisePkValue(this.id) >"+salesPersonName.toUpperCase()+"</td>" +
				     		"<td class = 'dashboardEditImg'></td>" +
			       			"</tr></table></td></tr>");
				}
				listedBuffer.append("</table>");
			}
			 	rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			
			rowBuffer.append("</div>");
			listedBuffer.append("</div>");
			System.out.println("rowbuffer ======> "+rowBuffer);
			System.out.println("listed buffer =========> " + listedBuffer);
			if(planned > 0)
			{
				rawJson.put("plannedtodaystatus", rowBuffer.toString());
				rawJson.put("listedtodaystatus", "");
			}
			else
			{
				rawJson.put("listedtodaystatus", listedBuffer.toString());
				rawJson.put("plannedtodaystatus", "");
			}
			
			
			double totalCountPlanning   = planned+unplanned;
			System.out.println("TotalCount======= : "+totalCountPlanning);
			
			
			double planDashArray = (planned/totalCountPlanning)*342;
			System.out.println("planDashArray ====== : "+planDashArray);			
			double totalCountListing  = listed+unListed;			
			double listedDashArray = (listed/totalCountListing)*280;
			System.out.println("listedDashArray ====== : "+listedDashArray);
						
			String planning = "<td style='width: 29%;'> <div style='display: inline-flex; padding: 6px;float: left;'> <label style='padding:5px 0px 5px 12px;float:right;display:block font-size: 12px;text-align: right;'>Planned</label> <div class='color-box' style='position: absolute;margin-top:8px;background-color: #3BC806;width: 8px;height: 8px;margin-right: 5px;vertical-align: middle;border-radius: 8px;display:block;text-align: right;float: right;'></div> </div> <div style='display: inline-flex;padding: 6px;float: left;'> <label style='padding:5px 0px 5px 12px; float:right; display:block font-size: 12px;'>Unplanned</label> <div class='color-box' style='position: absolute; margin-top:8px;   background-color: #FFA200; width: 8px;height: 8px; margin-right: 5px; vertical-align: middle;border-radius: 8px; display:block;'></div> </div>  <div>  </div> <div> </div> </td>";
			String listing  = "<td style='width: 29%;'> <div style='display: inline-flex; padding: 6px;float: left;'> <label style='padding:5px 0px 5px 12px;float:right;display:block font-size: 12px;text-align: right;'>Listed</label> <div class='color-box' style='position: absolute;margin-top:8px;background-color: #2F9EFC;width: 8px;height: 8px;margin-right: 5px;vertical-align: middle;border-radius: 8px;display:block;text-align: right;float: right;'></div> </div> <div style='display: inline-flex;padding: 6px;float: left;'> <label style='padding:5px 0px 5px 12px; float:right; display:block font-size: 12px;'>Unlisted</label> <div class='color-box' style='position: absolute; margin-top:8px;   background-color: #FF6715; width: 8px;height: 8px; margin-right: 5px; vertical-align: middle;border-radius: 8px; display:block;'></div> </div>  <div>  </div> <div> </div> </td>";
			
			
			//  display data according to planning and listing if planning data is available then only planned & unplanned data will be displayed or else listed & unlisted data will be displayed
			if(totalCountPlanning > 0 )
			{
				rawJson.put("planDashArray", planDashArray);
				rawJson.put("strokeWidthPlan", 10);
				rawJson.put("strokeWidthList", 0);
				rawJson.put("Planning", planning);
				rawJson.put("Listing", "");		
				
			}
			else 
			{
				rawJson.put("listedDashArray", listedDashArray);
				rawJson.put("strokeWidthPlan", 0);
				rawJson.put("strokeWidthList", 10);
				rawJson.put("Listing", listing);
				rawJson.put("Planning", "");		
			}
			
			rawJson.put("total", planned+unplanned+listed+unListed);
			rawDataPlanDtlJson.put(count, rawJson);
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
			System.out.println("Exception in PlanVsActual.getTodaysStatus() " + e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in PlanVsActual.getTodaysStatus() " + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPlanDtlJson;
	
		
	}
	
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}

}











/*<td style="width: 20%;">
<div style="display: inline-flex; padding: 6px;float: left;"> <label style="padding:5px 0px 5px 12px;float:right;display:block font-size: 12px;text-align: right;">Planned</label> <div class="color-box" style="position: absolute;margin-top:8px;background-color: #3BC806;width: 8px;height: 8px;margin-right: 5px;vertical-align: middle;border-radius: 8px;display:block;text-align: right;float: right;"></div> </div>

 <div style="display: inline-flex;padding: 6px;float: left;"> <label style="padding:5px 0px 5px 12px; float:right; display:block font-size: 12px;">Unplanned</label> <div class="color-box" style="position: absolute; margin-top:8px;   background-color: #FFA200; width: 8px;height: 8px; margin-right: 5px; vertical-align: middle;border-radius: 8px; display:block;"></div> </div>

 <div>  </div>
 <div> </div>
</td>*/


