
package ibase.dashboard.scm.ejb;

import ibase.system.config.ConnDriver;

import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.*;

import javax.ejb.Stateless;
import org.json.simple.JSONObject;

@Stateless
public class ShortageInventory extends ValidatorEJB implements ShortageInventoryLocal, ShortageInventoryRemote  
{
	
	@SuppressWarnings({ "unchecked", "static-access", "unused"})
	public JSONObject getShortageInventory(String dataSourceName , String loginSiteCode , String finYear) throws RemoteException, ITMException 
	{
		JSONObject shortageInvJSON = new JSONObject();
		JSONObject rowData = null;
		String sql = "", sql1 = "", fromDate = "", toDate = "";
		String tran_image = "" , itemCode = "";
		String itemDescr = "", pkFieldValue = "";
		int pendingQty = 0, pendingValue = 0, pendingValueGlobal = 0, availableQty = 0, avgSalesPerDay = 0, availQtyForNearBy = 0;
		int daysInventoryAvail = 0, shortageInventory  =0, orderCount = 0, quantity = 0, balanceDays = 0;
		Connection con = null;
		ConnDriver connDriver = new ConnDriver();
		ResultSet rs = null, rs1 = null;
		PreparedStatement pstmt = null, pstmt1 = null;
		int count=0;
		Calendar cal = null;
		SimpleDateFormat sdf = null;
		StringBuffer rowBuffer = new StringBuffer();
		HashMap<Integer, ArrayList<String>> sortDaysWise = new HashMap<Integer, ArrayList<String>>();
		ArrayList<String> valueAgainstDays = new ArrayList<String>();
		try 
		{
			System.out.println("Try block of InventoryShortage.getShortageInventory() dataSourceName: "+dataSourceName);
			con = connDriver.getConnectDB(dataSourceName);
			connDriver=null;
			
			System.out.println("LOGIN SITE CODE ======= " + loginSiteCode);
			cal = Calendar.getInstance();
			sdf = new SimpleDateFormat("dd-MMM-yy");
			int currentDayMonth = cal.DAY_OF_MONTH;
			int lastDayMonth = cal.getActualMaximum(Calendar.DATE);
			cal = Calendar.getInstance();
			//cal.add(cal.MONTH,-1);
			//cal.set(Calendar.DATE, cal.getActualMinimum(Calendar.DATE));

			System.out.println("get currentDayMonth==="+currentDayMonth+" LastDayMonth========"+lastDayMonth);
			
			System.out.println("Date of today: "+fromDate+" Last day of month: "+toDate);
			
			sql = "select item_code,ROUND(nvl(SUM(quantity) / SUM(DAY),0),0) as avg_sales " +
					"from ( select i.item_code as item_code,1 as day," +
					//" to_date(h.conf_date) as conf_date,  " +
					"round(sum(i.quantity__stduom),0) as quantity  " +
					"from invoice_trace i, invoice h where i.invoice_id = h.invoice_id " +
					"AND TO_DATE(H.CONF_DATE) BETWEEN TO_DATE(SYSDATE) - 90 " +
					"AND TO_DATE(SYSDATE) AND H.SITE_CODE ='"+loginSiteCode+"' " +
					"GROUP BY I.ITEM_CODE) " +
					"GROUP BY ITEM_CODE ORDER BY ITEM_CODE";
			pstmt = con.prepareStatement(sql,ResultSet.TYPE_SCROLL_SENSITIVE,ResultSet.CONCUR_READ_ONLY);
			rs = pstmt.executeQuery();
			int rowCount = 0;
			rs.last();
			rowCount = rs.getRow();
			System.out.println("rowCount ==== " + rowCount);
			rs.beforeFirst();
			rowData = new JSONObject();	
			while(rs.next())
			{
				itemCode     	   = checkNull(rs.getString("item_code"));
				pkFieldValue       = itemCode;
				avgSalesPerDay     = Math.round(checInteger(rs.getString("avg_sales")));
				//For calculating available inventory
		     	sql1 = "SELECT FN_GET_ITMSTK ('"+itemCode+"', '"+loginSiteCode+"') as available_qty from dual";
		     	pstmt1 = con.prepareStatement(sql1);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					availableQty = Math.round(rs1.getInt("available_qty"));
				}
				System.out.println("availableQty get==== " + availableQty);
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				
				//For calculating available inventoryNumber of Pending orders,Total Pending order quantity,total Pending order value
				sql1 = "SELECT SORDITEM.ITEM_CODE,  ITEM.DESCR AS ITEM_DESCR," +
						"COUNT(DISTINCT SORDITEM.SALE_ORDER) ORDER_COUNT, " +
						"sum(sorditem.quantity) quantity, sum(sorditem.quantity - sorditem.qty_desp)" +
						" as pending_qty, sum ((sorditem.quantity - sorditem.qty_desp) * " +
						"sorditem.rate ) as pending_value FROM sorder, sorditem, item, sorddet " +
						"WHERE ( sorder.sale_order = sorditem.sale_order ) " +
						"and  ( sorditem.sale_order = sorddet.sale_order ) " +
						"and ( sorditem.line_no = sorddet.line_no ) " +
						"and ( sorditem.item_code = item.item_code ) and  ( sorder.confirmed = 'Y' ) " +
						"and  ( sorditem.status = 'P' ) AND ( sorditem.site_code='"+loginSiteCode+"') " +
						"and ( sorditem.item_code='"+itemCode+" ') " +
						"group by sorditem.item_code,item.descr";
		     	pstmt1 = con.prepareStatement(sql1);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					itemDescr = checkNull(rs1.getString("ITEM_DESCR"));
					orderCount = Math.round(rs1.getInt("ORDER_COUNT"));
					quantity = Math.round(rs1.getInt("quantity"));
					pendingQty = Math.round(rs1.getInt("pending_qty"));
					pendingValue = Math.round(rs1.getInt("pending_value"));
					String object = "images"+ File.separator + "users";
			     	String userImagePath = "/ibase/CustomMenuImageServlet?fldValue="+itemCode+"&object="+object+"&objName="+object+"&ALT_FLD_VALUE="+itemDescr;
			     	tran_image = "<img class='cardProdImg2' src='"+userImagePath+"' style='margin-top:-15px'/>";
				}
				System.out.println("orderCount get==== " + orderCount+" quantity : "+quantity+" pendingValue: "+pendingValue);
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				
				//For calculating Number of days inventory available
				daysInventoryAvail = Math.round(availableQty/avgSalesPerDay);
				System.out.println("daysInventoryAvail get=========="+daysInventoryAvail);
				//For calculating Near by site stock
				String siteCodeFrom = "";
				sql1 = "SELECT SITE_CODE__FROM, DISTANCE FROM DIST_INTERSITE_OPTIONS  " +
						"WHERE SITE_CODE='"+loginSiteCode+"' ORDER BY SITE_CODE ASC,DISTANCE ASC";
		     	pstmt1 = con.prepareStatement(sql1);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					siteCodeFrom = checkNull(rs1.getString("SITE_CODE__FROM"));
				}
				System.out.println("siteCodeFrom get=========="+siteCodeFrom);
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				
				sql1 = "SELECT FN_GET_ITMSTK ('"+itemCode+"', '"+siteCodeFrom+"') as available_qty_nearby from dual";
		     	pstmt1 = con.prepareStatement(sql1);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					availQtyForNearBy = Math.round(rs1.getInt("available_qty_nearby"));
				}
				System.out.println("availQtyForNearBy get=========="+availQtyForNearBy);
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				
				//For calculating Shortage of inventory
				sql1="select case when si.MIN_STK_DAY  is null then i.MIN_STK_DAY else " +
						"si.MIN_STK_DAY end as balance_days from siteitem si,item i " +
						"where  si.item_code  = i.item_code and  si.item_code  ='"+itemCode+" ' " +
						"and    si.site_code  ='"+loginSiteCode+"'  order by si.MIN_STK_DAY";
				pstmt1 = con.prepareStatement(sql1);
				rs1 = pstmt1.executeQuery();
				if(rs1.next())
				{
					balanceDays = checInteger(rs1.getString("balance_days"));
				}
				System.out.println("balanceDays get=========="+balanceDays);
				rs1.close();
				rs1 = null;
				pstmt1.close();
				pstmt1 = null;
				
				shortageInventory      = Math.round((balanceDays*avgSalesPerDay) - availableQty);
				System.out.println("shortageInventory get: "+shortageInventory);
				
		     	
				String availableQtyStr = "";
				if(shortageInventory > 0)
				{
					availableQtyStr = availableQty+"(+"+shortageInventory+")pc";
				}
				else
				{
					availableQtyStr = availableQty+"(No shortage)";
				}
				
				pendingValueGlobal = pendingValueGlobal + pendingValue;
				
				
				if(sortDaysWise.containsKey(daysInventoryAvail))
				{
					valueAgainstDays.add("<div class='tdMousehover'>" +
					"<table border='0' cellpadding='0' cellspacing='1' width='100%' style= 'border-bottom: 1px solid #ececec; padding: 2px;margin:auto;'>" +
					"<tr class = 'row' id='"+pkFieldValue+"' onclick='getRowWisePkValue(this.id)>" +
					"<td width='2%'>"+tran_image+"</td>" +
					"<td><table cellpadding='0' cellspacing='0' width='70%' style='padding-left:5px;'>" +
						"<tr><td><table cellpadding='0' cellspacing='1'>" +
								"<tr><td> "+itemDescr+" ("+itemCode+") "+" </td></tr>" +
								"</table></td></tr>" +
						"<tr><td><table cellpadding='0' cellspacing='1'>" +
								"<tr><td><font style='font-size:13px;'> "+avgSalesPerDay+"pc/day </font></td>" +
								"<td style='padding-left:20px;'><font style='font-size:13px;'> available "+availableQtyStr+" </font></td>" +
								"<td style='padding-left:20px;'><font style='font-size:13px;'> near by "+availQtyForNearBy+"pc </font></td></tr>" +
								"</table></td></tr>" +
						"<tr><td ><table cellpadding='0' cellspacing='1'>" +
								"<tr><td class='defaultIconSubTitle'><font style='font-size:11px;'> Order ("+orderCount+") </font></td>" +
								"<td class='defaultIconSubTitle' style='padding-left:20px;'><font style='font-size:11px;'> "+pendingQty+"pc </font></td>" +
								"<td class='defaultIconSubTitle' style='padding-left:20px;'><font style='font-size:11px;'> "+pendingValue+"INR </font></td></tr>" +
								"</table></td></tr>" +
						"</table></td>" +
					"<td align='right' style='padding-right:10px;'><div style='margin-top:-15px;'> "+daysInventoryAvail+" days </div></td></tr></table></div>");
				}
				else
				{
					valueAgainstDays = new ArrayList<String>();
					valueAgainstDays.add("<div class='tdMousehover'>" +
							"<table border='0' cellpadding='0' cellspacing='1' width='100%' style= 'border-bottom: 1px solid #ececec; padding: 2px;margin:auto;'>" +
							"<tr class = 'row' id='"+pkFieldValue+"' onclick='getRowWisePkValue(this.id)'>" +
							"<td width='2%'>"+tran_image+"</td>" +
							"<td><table cellpadding='0' cellspacing='0' width='70%' style='padding-left:5px;'>" +
								"<tr><td><table cellpadding='0' cellspacing='1'>" +
										"<tr><td> "+itemDescr+" ("+itemCode+") "+" </td></tr>" +
										"</table></td></tr>" +
								"<tr><td><table cellpadding='0' cellspacing='1'>" +
										"<tr><td><font style='font-size:13px;'> "+avgSalesPerDay+"pc/day </font></td>" +
										"<td style='padding-left:20px;'><font style='font-size:13px;'> available "+availableQtyStr+" </font></td>" +
										"<td style='padding-left:20px;'><font style='font-size:13px;'> near by "+availQtyForNearBy+"pc </font></td></tr>" +
										"</table></td></tr>" +
								"<tr><td ><table cellpadding='0' cellspacing='1'>" +
										"<tr><td class='defaultIconSubTitle'><font style='font-size:11px;'> Order ("+orderCount+") </font></td>" +
										"<td class='defaultIconSubTitle' style='padding-left:20px;'><font style='font-size:11px;'> "+pendingQty+"pc </font></td>" +
										"<td class='defaultIconSubTitle' style='padding-left:20px;'><font style='font-size:11px;'> "+pendingValue+"INR </font></td></tr>" +
										"</table></td></tr>" +
								"</table></td>" +
							"<td align='right' style='padding-right:10px;'><div style='margin-top:-15px;'> "+daysInventoryAvail+" days </div></td></tr></table></div>");
				}
				sortDaysWise.put(daysInventoryAvail, valueAgainstDays);
			}
			System.out.println("Before Sorting sortDaysWise: "+sortDaysWise.toString()+"\n pendingValueGlobal: "+pendingValueGlobal);
			Map<Integer, ArrayList<String>> sortedMap = new TreeMap<Integer, ArrayList<String>>(sortDaysWise); 
			System.out.println("After Sorting sortedMap: "+sortedMap.toString());
		    for (Map.Entry<Integer, ArrayList<String>> entry : sortedMap.entrySet())
            {
                System.out.print(entry.getKey() + ": ");
                System.out.println(entry.getValue());
                ArrayList<String> mapValue = entry.getValue();
                for(int i = 0; i < mapValue.size(); i++)
                {
                	rowBuffer.append(mapValue.get(i));
                }
                
            }
			rowData.put("shortageInventoryTable", rowBuffer.toString());
			rowData.put("exportToExcel", "<td><img src='"+CommonConstants.TOMCAT_HOME+"/ibase/E12BROWSER/FusionChart/images/excel.png' width='20px' height='20px' alt='Export to Excel' id='excel' name='excel' onclick='exportExcel(this.parentNode.id)' align='right' style='padding : 16px;'></td>");
			rowData.put("Items", pendingValueGlobal);
			shortageInvJSON.put(count, rowData);
			count++;
		} 
		catch (Exception e) 
		{
			System.out.println("Catch Block of InventoryShortage.getShortageInventory()"+e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (con != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					con.close();
					con = null;
				}
				con = null;
			} catch (Exception e)
			{
				e.printStackTrace();
				System.out.println("Exception in :InventoryShortage:" + e.getMessage());
				throw new ITMException(e);
			}
	    }
		return shortageInvJSON;
	}
	
	private String checkNull(String input)
	{
		if (input == null)
		{
			input = "";
		} else
		{
			input = input.trim();
		}
		return input;
	}
	private int checInteger(String input)
	{
		if (input == null || input.length()==0)
		{
			return 0;
		} else
		{
			return Integer.parseInt(input);
		}
		
	}
	
}
