package ibase.webitm.webService.ejb;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

import javax.ejb.Stateless;

@Stateless
public class GmailPluginEJB implements GmailPluginEJBRemote,GmailPluginEJBLocal 
{


	@Override
	public String SaveGoogleRefreshToken(String RefreshToken, String EmailId) throws ITMException 
	{
		String returnString = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		try 
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			System.out.println("In createExtServiceLog - \nRefreshToken - ["+ RefreshToken +"], \nEmailId - ["+ EmailId +"]");
			ConnDriver connDriver = new ConnDriver();
			String transDB = "";
			
            if( transDB.length() > 0 )
            {
                conn = connDriver.getConnectDB( transDB );
            }
            else
            {
                conn = connDriver.getConnectDB( "DriverITM" );
            }
            conn.setAutoCommit(false);
			connDriver = null;
            
			
			pstmt = null;

			String sql = "";
			int insertCnt = 0;
		        System.out.println("refresh token"+RefreshToken);
				sql = "UPDATE USERS SET GOOGLE_REFRESH_TOKEN = ?  WHERE EMAIL_ID = ?";
				
			
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, RefreshToken);
				pstmt.setString(2, EmailId);
				insertCnt = pstmt.executeUpdate();
				
				pstmt.close();
				if(insertCnt > 0)
				{
					returnString = "Success";
				}
				conn.commit();
				
				System.out.println("after commit");
			
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				System.out.println( "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
		
		return returnString;
		
	
	}

	public String getGoogleRefreshToken( String emailId) throws ITMException 
	{
		System.out.println("in getGoogleRefreshToken");
	//	String returnString = "";
		Connection conn = null;
		String googleRefreshToken = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try 
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
			System.out.println("In createExtServiceLog - \nEmailId - ["+ emailId +"]");
			ConnDriver connDriver = new ConnDriver();
			String transDB = "";
			
            if( transDB.length() > 0 )
            {
                conn = connDriver.getConnectDB( transDB );
            }
            else
            {
                conn = connDriver.getConnectDB( "DriverITM" );
            }
            conn.setAutoCommit(false);
			connDriver = null;
            			
			
			pstmt = null;

			String sql = "";
		//	int insertCnt = 0;
			
				sql = "SELECT GOOGLE_REFRESH_TOKEN FROM USERS WHERE EMAIL_ID = ?";
				
			
				pstmt = conn.prepareStatement(sql);
				System.out.println(sql);  
				pstmt.setString(1, emailId);
				rs = pstmt.executeQuery();
				
				if(rs.next())
				{
					googleRefreshToken = rs.getString("GOOGLE_REFRESH_TOKEN");
				}
				
		            rs.close();
		            rs = null;
		            pstmt.close();
		            pstmt = null;
			
		}
		catch (SQLException e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null )
				{
					conn.close();
					conn = null;
				}
			}
			catch( Exception e )
			{
				System.out.println( "Exception :" + e.getMessage() );
				e.printStackTrace();
			}
		}
//		System.out.println("returnString - ["+ returnString +"]");
		
		System.out.println("GOOGLE_REFRESH_TOKEN - ["+ googleRefreshToken +"]");
		return googleRefreshToken;
	
		
	}

}