/**
 * 
 */
package ibase.webitm.webService;

import ibase.bean.EventLogInfoBean;
import ibase.ejb.CommonDBAccessRemote;
import ibase.ejb.UserEventLogEJBLocal;
import ibase.servlet.Messages;
import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.BaseException;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.DBAccessRemote;
import ibase.webitm.ejb.DocumentHandlerRemote;
import ibase.webitm.ejb.EventManagerRemote;
import ibase.webitm.ejb.ExtServiceEventManagerLocal;
import ibase.webitm.ejb.MasterDataRemote;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.PopUpRemote;
import ibase.webitm.utility.ITMException;
import ibase.webitm.webService.ejb.ExtServiceRemote;
import ibase.wrkflw.E12FollowUpActionLocal;
import ibase.wrkflw.SignManagerRemote;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.spec.KeySpec;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.UUID;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.xml.bind.DatatypeConverter;

import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
//Added By Umakanta Das on 12-JUN-2017[ To get logic of prop days ]
import ibase.webitm.utility.hrp.Attd_eSalarySlip;

/**
 * @author Prasad Raut
 *
 */
@Path("/E12ExtService")
public class E12ExtService 
{
	private UserInfoBean userInfo = null;
	private E12GenericUtility genericUtility = new E12GenericUtility();
	
	/**
	 * Get External Service Data
	 * 
	 * @param dataFor
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param serviceParam1
	 * @param serviceParam2
	 * @param serviceParam3
	 * @param serviceParam4
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getExtServiceData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getExtServiceData( @QueryParam("dataFor") String dataFor, @QueryParam("userCode") String userCode, 
			@QueryParam("password") String password, @QueryParam("isPwdEncrypt") String isPwdEncrypt,
			@QueryParam("serviceParam1") String serviceParam1, @QueryParam("serviceParam2") String serviceParam2,
			@QueryParam("serviceParam3") String serviceParam3, @QueryParam("serviceParam4") String serviceParam4, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		//Changed by Prasad on 18/02/16 [for validating user] START
		JSONObject resultJson = new JSONObject();
		try 
		{
			String result = "";
			dataFor = E12GenericUtility.checkNull( dataFor );
			userCode = E12GenericUtility.checkNull( userCode );
			password = E12GenericUtility.checkNull( password );
			isPwdEncrypt = E12GenericUtility.checkNull( isPwdEncrypt ).length() > 0 ? E12GenericUtility.checkNull( isPwdEncrypt ) : "false";
			String authStatus = "";
			if ( userCode.length() > 0 )
			{
				authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
				//if ( isValidLogin )
				if ( "VALID".equalsIgnoreCase( authStatus ) )
				{
					//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] START
					/*String clientIP = E12GenericUtility.checkNull( request.getRemoteAddr() );
					InetAddress inetAddress = null;
					inetAddress = InetAddress.getLocalHost();
					String hostName = inetAddress.getHostName();
					String hostIP = inetAddress.getHostAddress();
					if ( getUserInfo() != null )
					{
						getUserInfo().setRemoteHost( ( clientIP.length() > 0 ) ? clientIP : "SYSTEM" );
						getUserInfo().setSessionId( request.getSession().getId() );
						getUserInfo().setHostName( hostName );
						getUserInfo().setHostIP( hostIP );
					}*/
					//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] END
					String xtraParams = getXtraParams();
					result = executeSystemEvent( dataFor, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams );
					resultJson.put( "status", "success" );
				}
				else
				{
					result = authStatus;
					resultJson.put( "status", "error" );
				}
			}
			else
			{
				result = "You are not authorized to access.";
				resultJson.put( "status", "error" );
			}
			resultJson.put( "results", result );
			//Changed by Prasad on 18/02/16 [for validating user] END
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getExtServiceData : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		return Response.status(200).entity( resultJson.toString() ).build();
	}
	
	/**
	 * 
	 * @param dataFor
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param serviceParam1
	 * @param serviceParam2
	 * @param serviceParam3
	 * @param serviceParam4
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getExtServiceClient")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getExtnServiceData( @FormParam("dataFor") String dataFor, @FormParam("userCode") String userCode, 
			@FormParam("password") String password, @FormParam("isPwdEncrypt") String isPwdEncrypt,
			@FormParam("serviceParam1") String serviceParam1, @FormParam("serviceParam2") String serviceParam2,
			@FormParam("serviceParam3") String serviceParam3, @FormParam("serviceParam4") String serviceParam4, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		JSONObject resultJson = new JSONObject();
		try 
		{
			String result = "";
			dataFor = E12GenericUtility.checkNull( dataFor );
			userCode = E12GenericUtility.checkNull( userCode );
			password = E12GenericUtility.checkNull( password );
			isPwdEncrypt = E12GenericUtility.checkNull( isPwdEncrypt ).length() > 0 ? E12GenericUtility.checkNull( isPwdEncrypt ) : "false";
			String authStatus = "";
			if ( userCode.length() > 0 )
			{
				authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
				//if ( isValidLogin )
				if ( "VALID".equalsIgnoreCase( authStatus ) )
				{
					//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] START
					/*String clientIP = E12GenericUtility.checkNull( request.getRemoteAddr() );
					InetAddress inetAddress = null;
					inetAddress = InetAddress.getLocalHost();
					String hostName = inetAddress.getHostName();
					String hostIP = inetAddress.getHostAddress();
					if ( getUserInfo() != null )
					{
						getUserInfo().setRemoteHost( ( clientIP.length() > 0 ) ? clientIP : "SYSTEM" );
						getUserInfo().setSessionId( request.getSession().getId() );
						getUserInfo().setHostName( hostName );
						getUserInfo().setHostIP( hostIP );
					}*/
					//Changed by Prasad on 07/03/16 [shifted code to getAuthStatus method] END
					String xtraParams = getXtraParams();
					result = executeSystemEvent( dataFor, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams );
					resultJson.put( "status", "success" );
				}
				else
				{
					resultJson.put( "status", "error" );
					result = authStatus;
				}
			}
			else
			{
				resultJson.put( "status", "error" );
				result = "You are not authorized to access.";
			}
			resultJson.put( "results", result );
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getExtServiceData : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		return Response.status(200).entity( resultJson.toString() ).build();
	}
	
	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] START
	/**
	 * Used for authenticate user
	 * 
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/login")
	@Produces(MediaType.APPLICATION_JSON)
	public Response authenticateUser(@QueryParam("USER_CODE") String userCode, @QueryParam("PASSWORD") String password,
			@QueryParam("IS_PWD_ENCRYPT") String isPwdEncrypt, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		//Added by Prasad on 13/04/17 [to insert tokenId while login]
		String tokenId = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&PASSWORD="+ password);
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				userCode = checkNull( userCode );
				password = checkNull( password );
				isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
				String isValidLogin = "false";
				if ( userCode.length() > 0 )
				{
					isValidLogin = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
					if ( "VALID".equalsIgnoreCase( isValidLogin ) )
					{
						//Changed by Prasad on 13/04/17 [to insert tokenId while login] START
						/*String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
						if ( tokenId.length() > 30 )
						{
							tokenId = tokenId.substring( 0, 30 );
						}*/
						tokenId = generateNewTokenId( userCode );
						//Changed by Prasad on 13/04/17 [to insert tokenId while login] END
						System.out.println("tokenId - "+ tokenId.length());
						
						request.getSession().setAttribute( "TOKEN_ID", tokenId );
						request.getSession().setAttribute( "USER_INFO", getUserInfo() );
						
						JSONObject resultDtlJson = new JSONObject();
						resultDtlJson.put( "TOKEN_ID", tokenId );
						resultDtlJson.put( "EMP_ID", getUserInfo().getEmpCode() );
						//result = resultDtlJson.toString();
						result = getEmployeeDtl(resultDtlJson);
						if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.jsonToXMLString( result );
						}
						status = "success";
					}
					else
					{
						result = isValidLogin;
						status = "error";
					}
				}
				else
				{
					result = "Please enter username.";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : authenticateUser : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "login", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Used for authenticate user
	 * 
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param inputString
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/login")
	@Produces(MediaType.APPLICATION_JSON)
	public Response authenticateUserClient(@FormParam("USER_CODE") String userCode, @FormParam("PASSWORD") String password,
			@FormParam("IS_PWD_ENCRYPT") String isPwdEncrypt, @FormParam("INPUT_STR") String inputString, 
			@FormParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		//Added by Prasad on 13/04/17 [to insert tokenId while login]
		String tokenId = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&PASSWORD="+ password);
				paramString.append("&IS_PWD_ENCRYPT="+ isPwdEncrypt);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				userCode = checkNull( userCode );
				password = checkNull( password );
				isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
				String isValidLogin = "false";
				if ( userCode.length() > 0 )
				{
					isValidLogin = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
					if ( "VALID".equalsIgnoreCase( isValidLogin ) )
					{
						//Changed by Prasad on 13/04/17 [to insert tokenId while login] START
						/*String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
						if ( tokenId.length() > 30 )
						{
							tokenId = tokenId.substring( 0, 30 );
						}*/
						tokenId = generateNewTokenId( userCode );
						//Changed by Prasad on 13/04/17 [to insert tokenId while login] END
						System.out.println("tokenId - "+ tokenId.length());
						
						request.getSession().setAttribute( "TOKEN_ID", tokenId );
						request.getSession().setAttribute( "USER_INFO", getUserInfo() );
						
						JSONObject resultDtlJson = new JSONObject();
						resultDtlJson.put( "TOKEN_ID", tokenId );
						resultDtlJson.put( "EMP_ID", getUserInfo().getEmpCode() );
						//result = resultDtlJson.toString();
						result = getEmployeeDtl(resultDtlJson);
						if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
						{
							result = genericUtility.jsonToXMLString( result );
						}
						status = "success";
					}
					else
					{
						result = isValidLogin;
						status = "error";
					}
				}
				else
				{
					result = "Please enter username.";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : authenticateUser : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "login", params, tokenId, dataFormat, status, result);
		}
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Forgot Password
	 * 
	 * @param userCode
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/forgot_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response forgotPassword(@QueryParam("USER_CODE") String userCode, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String empStatus = getCommonDBAccess().checkEmpStatus( userCode );
				Date empDeactDate = getCommonDBAccess().checkEmpDeactDate( userCode );
				Date currentDate = new Date();
				if( "".equals( empStatus ) || "A".equalsIgnoreCase( empStatus ) )
				{
					if ( empDeactDate != null && empDeactDate.before( currentDate ) )
					{
						result = Messages.getString( "AuthenticateServlet_notAnActiveUser", getUserLangAndCountry( userCode ) );
						status = "error";
					}
					else
					{
						DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
						String condition =  " CODE = '" + userCode + "' ";
						String emailId = dbAccess.getDBColumnValue( "USERS", "EMAIL_ID", condition );
						System.out.println("emailId - ["+ emailId +"]");
						String clientIP = checkNull( request.getRemoteAddr() );
						clientIP = ( clientIP.length() > 0 ) ? clientIP : "SYSTEM";
						if ( checkNull( emailId ).length() > 0 )
						{
							String varCode = getCommonDBAccess().sendVarificationCode( userCode );
							result = "Verification Code : "+varCode;
							getCommonDBAccess().secureAccount( userCode, "0" );
							getCommonDBAccess().updatePasswordChgLog( userCode, clientIP, "Browser" );
							result = Messages.getString( "AuthenticateServlet_newPasswordIsSentToYourEmaiID", getUserLangAndCountry( userCode ) ) + " [" + emailId +"]" ;
							status = "success";
						}
						else
						{
							result = "Email Id Not Found !";
							status = "error";
						}
					}
				}
				else
				{
					result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUser", getUserLangAndCountry( userCode ) );
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : forgotPassword : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Forgot Password
	 * 
	 * @param userCode
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/forgot_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response forgotPasswordClient(@FormParam("USER_CODE") String userCode, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String empStatus = getCommonDBAccess().checkEmpStatus( userCode );
				Date empDeactDate = getCommonDBAccess().checkEmpDeactDate( userCode );
				Date currentDate = new Date();
				if( "".equals( empStatus ) || "A".equalsIgnoreCase( empStatus ) )
				{
					if ( empDeactDate != null && empDeactDate.before( currentDate ) )
					{
						result = Messages.getString( "AuthenticateServlet_notAnActiveUser", getUserLangAndCountry( userCode ) );
						status = "error";
					}
					else
					{
						DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
						String condition =  " CODE = '" + userCode + "' ";
						String emailId = dbAccess.getDBColumnValue( "USERS", "EMAIL_ID", condition );
						System.out.println("emailId - ["+ emailId +"]");
						String clientIP = checkNull( request.getRemoteAddr() );
						clientIP = ( clientIP.length() > 0 ) ? clientIP : "SYSTEM";
						if ( checkNull( emailId ).length() > 0 )
						{
							String varCode = getCommonDBAccess().sendVarificationCode( userCode );
							result = "Verification Code : "+varCode;
							getCommonDBAccess().secureAccount( userCode, "0" );
							getCommonDBAccess().updatePasswordChgLog( userCode, clientIP, "Browser" );
							result = Messages.getString( "AuthenticateServlet_newPasswordIsSentToYourEmaiID", getUserLangAndCountry( userCode ) ) + " [" + emailId +"]" ;
							status = "success";
						}
						else
						{
							result = "Email Id Not Found !";
							status = "error";
						}
					}
				}
				else
				{
					result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUser", getUserLangAndCountry( userCode ) );
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : forgotPassword : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "forgot_password", params, "", dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Change Password
	 * 
	 * @param userCode
	 * @param oldPassword
	 * @param newPassword
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/change_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response changePassword(@QueryParam("USER_CODE") String userCode, @QueryParam("OLD_PASS") String oldPassword, 
			@QueryParam("NEW_PASS") String newPassword, @QueryParam("TOKEN_ID") String tokenId, 
			@QueryParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&OLD_PASS="+ oldPassword);
				paramString.append("&NEW_PASS="+ newPassword);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				if( getCommonDBAccess().checkOldPassword( userCode, oldPassword ) )
				{
					if( ! getCommonDBAccess().checkPassHistory( userCode, newPassword ) )
					{
						getCommonDBAccess().updatePassword( userCode, newPassword );
						result = "Password updated successfully";
						status = "success";
					}
					else
					{
						result = "Password already use. Please enter new password.";
						status = "error";
					}
				}
				else
				{
					result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword", getUserLangAndCountry( userCode ) );
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : chgPassword : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Change Password
	 * 
	 * @param userCode
	 * @param oldPassword
	 * @param newPassword
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/change_password")
	@Produces(MediaType.APPLICATION_JSON)
	public Response changePasswordClient(@FormParam("USER_CODE") String userCode, @FormParam("OLD_PASS") String oldPassword, 
			@FormParam("NEW_PASS") String newPassword, @FormParam("TOKEN_ID") String tokenId, 
			@FormParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&OLD_PASS="+ oldPassword);
				paramString.append("&NEW_PASS="+ newPassword);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				if( getCommonDBAccess().checkOldPassword( userCode, oldPassword ) )
				{
					if( ! getCommonDBAccess().checkPassHistory( userCode, newPassword ) )
					{
						getCommonDBAccess().updatePassword( userCode, newPassword );
						result = "Password updated successfully";
						status = "success";
					}
					else
					{
						result = "Password exists.";
						status = "error";
					}
				}
				else
				{
					result = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword", getUserLangAndCountry( userCode ) );
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : chgPassword : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "change_password", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Logout user session
	 * 
	 * @param userCode
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/logout")
	@Produces(MediaType.APPLICATION_JSON)
	public Response logout(@QueryParam("USER_CODE") String userCode, @QueryParam("TOKEN_ID") String tokenId, 
			@QueryParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				if ( checkNull( userCode ).length() > 0 )
				{
					String sessionUserCode = userInfo.getLoginCode();
					if ( userCode.equals( sessionUserCode ) )
					{
						if ( validateUserSession( request, tokenId ) )
						{
							logout( userCode, request );
							result = "Logout successfully";
							status = "success";
						}
					}
					else
					{
						result = "Invalid user.";
						status = "error";
					}
				}
				else
				{
					result = "Please enter username.";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : chgPassword : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Logout user session
	 * 
	 * @param userCode
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/logout")
	@Produces(MediaType.APPLICATION_JSON)
	public Response logoutClient(@FormParam("USER_CODE") String userCode, @FormParam("TOKEN_ID") String tokenId, 
			@FormParam("DATA_FORMAT") String dataFormat, @Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USER_CODE="+ userCode);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				if ( checkNull( userCode ).length() > 0 )
				{
					String sessionUserCode = userInfo.getLoginCode();
					if ( userCode.equals( sessionUserCode ) )
					{
						if ( validateUserSession( request, tokenId ) )
						{
							logout( userCode, request );
							result = "Logout successfully";
							status = "success";
						}
					}
					else
					{
						result = "Invalid user.";
						status = "error";
					}
				}
				else
				{
					result = "Please enter username.";
					status = "error";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : chgPassword : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "logout", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Used for calling system actions for provided object
	 * 
	 * @param objName - object Name
	 * @param action - actions to perform ('Add', 'Edit',...)
	 * @param xmlString - input Data
	 * @param tokenId - 
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/callSystemAction")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemAction(@QueryParam("ACTION") String action, @QueryParam("OBJ_NAME") String objName, 
			@QueryParam("INPUT_STR") String inputString, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request, @Context ServletContext context) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION="+ action);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				inputString = checkNull( inputString );
				if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
				{
					inputString = genericUtility.jsonToXMLString( inputString );
				}
				result = checkNull( processRequest( inputString, context ) );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : callSystemAction : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Used for calling system actions for provided object
	 * 
	 * @param objName - object Name
	 * @param action - actions to perform ('Add', 'Edit',...)
	 * @param xmlString - input Data
	 * @param tokenId - 
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/callSystemAction")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemActionClient(@FormParam("ACTION") String action, @FormParam("OBJ_NAME") String objName, 
			@FormParam("INPUT_STR") String inputString, @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request, @Context ServletContext context) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION="+ action);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				inputString = checkNull( inputString );
				if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
				{
					inputString = genericUtility.jsonToXMLString( inputString );
				}
				result = checkNull( processRequest( inputString, context ) );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : callSystemAction : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemAction", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Used for calling user defined events for provided object
	 * 
	 * @param objName - object Name
	 * @param eventCode - events to perform ('Confirm a transaction', ...)
	 * @param xmlString - input data
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/callSystemEvent")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemEvent(@QueryParam("OBJ_NAME") String objName, @QueryParam("EVENT_CODE") String eventCode, 
			@QueryParam("INPUT_STR") String inputString, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("EVENT_CODE="+ eventCode);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				System.out.println("getUserInfo() - "+ getUserInfo().toString());
				EventManagerRemote eventManager = (EventManagerRemote) getInitialContext().lookup("ibase/EventManagerEJB/remote");
				if ( eventManager.isEventExist( objName, eventCode ) )
				{
					String transDB = userInfo.getTransDB();
					String xmlString = inputString;
					if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
					{
						xmlString = genericUtility.jsonToXMLString( inputString );
					}
					if( checkNull( transDB ).length() > 0 )
					{
						result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams(), userInfo );
					}
					else
					{
						result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams() );
					}
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
				else
				{
					status = "error";
					result = "Event Code not found.";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : callSystemEvent : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Used for calling user defined events for provided object
	 * 
	 * @param objName - object Name
	 * @param eventCode - events to perform ('Confirm a transaction', ...)
	 * @param xmlString - input data
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective response in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/callSystemEvent")
	@Produces(MediaType.APPLICATION_JSON)
	public Response callSystemEventClient(@FormParam("OBJ_NAME") String objName, @FormParam("EVENT_CODE") String eventCode, 
			@FormParam("INPUT_STR") String inputString, @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("EVENT_CODE="+ eventCode);
				paramString.append("&OBJ_NAME="+ objName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				System.out.println("getUserInfo() - "+ getUserInfo().toString());
				EventManagerRemote eventManager = (EventManagerRemote) getInitialContext().lookup("ibase/EventManagerEJB/remote");
				if ( eventManager.isEventExist( objName, eventCode ) )
				{
					String transDB = userInfo.getTransDB();
					String xmlString = inputString;
					if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
					{
						xmlString = genericUtility.jsonToXMLString( inputString );
					}
					if( checkNull( transDB ).length() > 0 )
					{
						result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams(), userInfo );
					}
					else
					{
						result = executeSystemEvent( objName, eventCode, xmlString , xmlString, "1", getXtraParams() );
					}
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
				else
				{
					status = "error";
					result = "Event Code not found.";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : callSystemEvent : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "callSystemEvent", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * to get required data for provided object
	 * 
	 * @param objName - Object Name
	 * @param refId - transaction Id
	 * @param tokenId - provided at login time
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective data in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getData( @QueryParam("OBJ_NAME") String objName, @QueryParam("REF_ID") String refId, 
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				result = getDetailXMLDomString( objName, "1", "V", refId, null );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getData : "+ e.getMessage() );
			result = getStackTrace(e);
			status = "exception";
		}
		finally
		{
			result = generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * to get required data for provided object
	 * 
	 * @param objName - Object Name
	 * @param refId - transaction Id
	 * @param tokenId - provided at login time
	 * @param dataFormat
	 * @param request
	 * @return responseStr - respective data in provided data_format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getDataClient( @FormParam("OBJ_NAME") String objName, @FormParam("REF_ID") String refId, 
			@FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				result = getDetailXMLDomString( objName, "1", "V", refId, null );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getData : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse(request, "getData", params, tokenId, dataFormat, status, result);
		}
		
		return Response.status(200).entity( result ).build();
	}
	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] START
	/**
	 * Get Pophelp data
	 * 
	 * @param objName
	 * @param fieldName
	 * @param inputString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/fieldPophelp")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPopHelpData( @QueryParam("OBJ_NAME") String objName, @QueryParam("FIELDNAME") String fieldName, 
			@QueryParam("INPUT_STR") String inputString, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&FIELDNAME="+ fieldName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				fieldName = checkNull( fieldName );
				inputString = checkNull( inputString );
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else if ( fieldName.length() == 0 )
				{
					result = "Please enter valid Field Name.";
					status = "error";
				}
				else
				{
					String xmlString = inputString;
					if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
					{
						xmlString = genericUtility.jsonToXMLString( inputString );
					}
					result = getpopUpKeyStr(objName, fieldName, xmlString, getUserInfo());
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getPopHelpData : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "fieldPophelp", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Pophelp data
	 * 
	 * @param objName
	 * @param fieldName
	 * @param inputString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/fieldPophelp")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPopHelpDataClient( @FormParam("OBJ_NAME") String objName, @FormParam("FIELDNAME") String fieldName, 
			@FormParam("INPUT_STR") String inputString, @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&FIELDNAME="+ fieldName);
				paramString.append("&INPUT_STR="+ inputString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				fieldName = checkNull( fieldName );
				inputString = checkNull( inputString );
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else if ( fieldName.length() == 0 )
				{
					result = "Please enter valid Field Name.";
					status = "error";
				}
				else
				{
					String xmlString = inputString;
					if ( "JSON".equalsIgnoreCase( dataFormat ) && inputString.length() > 0 )
					{
						xmlString = genericUtility.jsonToXMLString( inputString );
					}
					result = getpopUpKeyStr(objName, fieldName, xmlString, getUserInfo());
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getPopHelpData : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "fieldPophelp", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Brow data
	 * 
	 * @param objName
	 * @param argNames
	 * @param argValues
	 * @param argTypes
	 * @param advQuery
	 * @param searchParam
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/objectBrowse")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getBrowData( @QueryParam("OBJ_NAME") String objName, @QueryParam("ARG_NAMES") String argNames, 
			@QueryParam("ARG_VALUES") String argValues, @QueryParam("ARG_TYPES") String argTypes, 
			@QueryParam("ADV_QRY") String advQuery, @QueryParam("SEARCH_PARAM") String searchParam, 
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&ARG_NAMES="+ argNames);
				paramString.append("&ARG_VALUES="+ argValues);
				paramString.append("&ARG_TYPES="+ argTypes);
				paramString.append("&ADV_QRY="+ advQuery);
				paramString.append("&SEARCH_PARAM="+ searchParam);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				argNames = checkNull(argNames);
				argValues = checkNull(argValues);
				argTypes = checkNull(argTypes);
				advQuery = checkNull(advQuery);
				searchParam = checkNull(searchParam);
				String editorId = new SimpleDateFormat("ddMMyyHHmmssSSS").format(new Date());
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else
				{
					result = getXMLDataForHeader( objName, argValues, argTypes, advQuery, request, searchParam, editorId );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getBrowData : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "objectBrowse", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * get brow data
	 * 
	 * @param objName
	 * @param argNames
	 * @param argValues
	 * @param argTypes
	 * @param advQuery
	 * @param searchParam
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/objectBrowse")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getBrowDataClient( @FormParam("OBJ_NAME") String objName, @FormParam("ARG_NAMES") String argNames, 
			@FormParam("ARG_VALUES") String argValues, @FormParam("ARG_TYPES") String argTypes, 
			@FormParam("ADV_QRY") String advQuery, @FormParam("SEARCH_PARAM") String searchParam, 
			@FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&ARG_NAMES="+ argNames);
				paramString.append("&ARG_VALUES="+ argValues);
				paramString.append("&ARG_TYPES="+ argTypes);
				paramString.append("&ADV_QRY="+ advQuery);
				paramString.append("&SEARCH_PARAM="+ searchParam);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				argNames = checkNull( argNames );
				argValues = checkNull(argValues );
				argTypes = checkNull( argTypes );
				advQuery = checkNull( advQuery );
				searchParam = checkNull( searchParam );
				String editorId = new SimpleDateFormat("ddMMyyHHmmssSSS").format(new Date());
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else
				{
					result = getXMLDataForHeader( objName, argValues, argTypes, advQuery, request, searchParam, editorId );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getBrowData : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "objectBrowse", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get itemchange data
	 * 
	 * @param objName
	 * @param transDomStr
	 * @param detailDomStr
	 * @param domId
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/performItemChange")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getItemChange( @QueryParam("OBJ_NAME") String objName, @QueryParam("TRANS_DOM") String transDomStr, 
			@QueryParam("DETAIL_DOM") String detailDomStr, @QueryParam("DOM_ID") String domId, 
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&TRANS_DOM="+ transDomStr);
				paramString.append("&DETAIL_DOM="+ detailDomStr);
				paramString.append("&DOM_ID="+ domId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				transDomStr = checkNull(transDomStr);
				detailDomStr = checkNull(detailDomStr);
				domId = checkNull(domId);
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else if ( domId.length() == 0 )
				{
					result = "Please enter valid Dom Id.";
					status = "error";
				}
				else if ( transDomStr.length() == 0 )
				{
					result = "Please enter Transaction Dom data.";
					status = "error";
				}
				else if ( detailDomStr.length() == 0 )
				{
					result = "Please enter Detail Dom data.";
					status = "error";
				}
				else
				{
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						if ( transDomStr.length() > 0 )
						{
							transDomStr = genericUtility.jsonToXMLString( transDomStr );
						}
						if ( detailDomStr.length() > 0 )
						{
							detailDomStr = genericUtility.jsonToXMLString( detailDomStr );
						}
					}
					result = getItemChangeData( objName, domId, transDomStr, detailDomStr );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getItemChange : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "performItemChange", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * get Itemchange data
	 * 
	 * @param objName
	 * @param transDomStr
	 * @param detailDomStr
	 * @param domId
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/performItemChange")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getItemChangeClient( @FormParam("OBJ_NAME") String objName, @FormParam("TRANS_DOM") String transDomStr, 
			@FormParam("DETAIL_DOM") String detailDomStr, @FormParam("DOM_ID") String domId, 
			@FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&TRANS_DOM="+ transDomStr);
				paramString.append("&DETAIL_DOM="+ detailDomStr);
				paramString.append("&DOM_ID="+ domId);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				transDomStr = checkNull(transDomStr);
				detailDomStr = checkNull(detailDomStr);
				domId = checkNull(domId);
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else if ( domId.length() == 0 )
				{
					result = "Please enter valid Dom Id.";
					status = "error";
				}
				else if ( transDomStr.length() == 0 )
				{
					result = "Please enter Transaction Dom data.";
					status = "error";
				}
				else if ( detailDomStr.length() == 0 )
				{
					result = "Please enter Detail Dom data.";
					status = "error";
				}
				else
				{
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						if ( transDomStr.length() > 0 )
						{
							transDomStr = genericUtility.jsonToXMLString( transDomStr );
						}
						if ( detailDomStr.length() > 0 )
						{
							detailDomStr = genericUtility.jsonToXMLString( detailDomStr );
						}
					}
					result = getItemChangeData( objName, domId, transDomStr, detailDomStr );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getItemChange : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "performItemChange", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] START
	/**
	 * Get Inbox data of Workflow
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getInbox")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwInbox( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String signStatus = "U";
				String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
				result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getWrkFlwInbox : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getInbox", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Inbox data of workflow
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getInbox")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwInboxClient( @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String signStatus = "U";
				String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
				result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getWrkFlwInbox : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getInbox", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Approved data of workflow
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getApproved")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwApproved( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String signStatus = "S";
				String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
				result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getWrkFlwApproved : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getApproved", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Approved data of workflow
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getApproved")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwApprovedClient( @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String signStatus = "S";
				String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
				result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getWrkFlwApproved : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getApproved", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Rejected data of workflow
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getRejected")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwRejected( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String signStatus = "R";
				String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
				result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getWrkFlwRejected : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getRejected", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Rejected data of workflow
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getRejected")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getWrkFlwRejectedClient( @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				String signStatus = "R";
				String roles = "", context1 = "", context2 = "", context3 = "", applName = "";
				result = getWrkFlwBrowData( signStatus, roles, context1, context2, context3, applName, getUserInfo() );
				if ( "JSON".equalsIgnoreCase( dataFormat ) )
				{
					result = genericUtility.xmlToJSONString( result );
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getWrkFlwRejected : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getRejected", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Sign transaction details
	 * 
	 * @param refSer
	 * @param refId
	 * @param lineNo
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getSignTransDet")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getSignTransDet( @QueryParam("REF_SER") String refSer, @QueryParam("REF_ID") String refId, 
			@QueryParam("LINE_NO") String lineNo, @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&LINE_NO="+ lineNo);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				refSer = checkNull( refSer );
				refId = checkNull( refId );
				lineNo = checkNull( lineNo );
				
				if ( refSer.length() == 0 )
				{
					result = "Please enter valid Ref Series.";
					status = "error";
				}
				else if ( refId.length() == 0 )
				{
					result = "Please enter valid Ref Id.";
					status = "error";
				}
				else if ( lineNo.length() == 0 )
				{
					result = "Please enter valid line No.";
					status = "error";
				}
				else
				{
					int lineNum = Integer.parseInt( lineNo );
					result = getSignTransDetData( refSer, refId, lineNum, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getSignTransDet : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getSignTransDet", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Sign transaction details
	 * 
	 * @param refSer
	 * @param refId
	 * @param lineNo
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getSignTransDet")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getSignTransDetClient( @FormParam("REF_SER") String refSer, @FormParam("REF_ID") String refId, 
			@FormParam("LINE_NO") String lineNo, @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&LINE_NO="+ lineNo);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				refSer = checkNull( refSer );
				refId = checkNull( refId );
				lineNo = checkNull( lineNo );
				
				if ( refSer.length() == 0 )
				{
					result = "Please enter valid Ref Series.";
					status = "error";
				}
				else if ( refId.length() == 0 )
				{
					result = "Please enter valid Ref Id.";
					status = "error";
				}
				else if ( lineNo.length() == 0 )
				{
					result = "Please enter valid line No.";
					status = "error";
				}
				else
				{
					int lineNum = Integer.parseInt( lineNo );
					result = getSignTransDetData( refSer, refId, lineNum, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getSignTransDet : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getSignTransDet", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Update Sign status (Approve/Reject)
	 * 
	 * @param actionCode
	 * @param xmlString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/updateSignStatus")
	@Produces(MediaType.APPLICATION_JSON)
	public Response updateSignStatus( @QueryParam("ACTION_CODE") String actionCode, @QueryParam("XML_STRING") String xmlString,  
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat,  @QueryParam("UUID") String uuid,
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION_CODE="+ actionCode);
				paramString.append("&XML_STRING="+ xmlString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&UUID="+ uuid);	
				params = paramString.toString();
			}
			System.out.println("params - " + params);	
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] Start
			if ( checkNull( uuid ).length() > 0 )
			{
				String condition = "UUID = '" + uuid +"' ";
				DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
				String userId = dbAccess.getDBColumnValue("NOTIFICATION_LOG", "USER_ID__TO", condition);				
				if ( checkNull( userId ).length() > 0 )
				{
					result = "valid";
					setUserInfo(getCommonDBAccess().createUserInfo(userId));					
				}
				else
				{
					result = "invalid";
				}
				System.out.println("validateUUId - ["+ result +"]/n UserId:::["+userId+"]");
			}
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] End
			else
			{
				result = validateRequest( request, dataFormat, tokenId );
				System.out.println("validateRequest - ["+ result +"]");
			}
			if ( "valid".equalsIgnoreCase( result ) )
			{
				actionCode = checkNull( actionCode );
				xmlString = checkNull( xmlString );
				
				if ( actionCode.length() == 0 )
				{
					result = "Please enter valid Action Code.";
					status = "error";
				}
				else if ( xmlString.length() == 0 )
				{
					result = "Please enter XML Data.";
					status = "error";
				}
				else
				{
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						if ( xmlString.length() > 0 )
						{
							xmlString = genericUtility.jsonToXMLString( xmlString );
						}
					}
					result = updateSignStatus( xmlString, actionCode, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : updateSignStatus : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "updateSignStatus", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}

	/**
	 * Update Sign status (Approve/Reject)
	 * 
	 * @param actionCode
	 * @param xmlString
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/updateSignStatus")
	@Produces(MediaType.APPLICATION_JSON)
	public Response updateSignStatusClient( @FormParam("ACTION_CODE") String actionCode, @FormParam("XML_STRING") String xmlString, 
			@FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, @FormParam("UUID") String uuid,
			@Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("ACTION_CODE="+ actionCode);
				paramString.append("&XML_STRING="+ xmlString);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				paramString.append("&UUID="+ uuid);				
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] Start
			if ( checkNull( uuid ).length() > 0 )
			{
				String condition = "UUID = '" + uuid +"' ";
				DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
				String userId = dbAccess.getDBColumnValue("NOTIFICATION_LOG", "USER_ID__TO", condition);				
				if ( checkNull( userId ).length() > 0 )
				{
					result = "valid";
					setUserInfo(getCommonDBAccess().createUserInfo(userId));					
				}
				else
				{
					result = "invalid";
				}
				System.out.println("validateUUId - ["+ result +"]/n UserId:::["+userId+"]");
			}
			//changed by Pankaj on 20-sep-2016 [S16FBAS008][Bypass the authentication using UUID of PushNotification] End
			else
			{
				result = validateRequest( request, dataFormat, tokenId );
				System.out.println("validateRequest - ["+ result +"]");
			}
			
			if ( "valid".equalsIgnoreCase( result ) )
			{
				actionCode = checkNull( actionCode );
				xmlString = checkNull( xmlString );
				
				if ( actionCode.length() == 0 )
				{
					result = "Please enter valid Action Code.";
					status = "error";
				}
				else if ( xmlString.length() == 0 )
				{
					result = "Please enter XML Data.";
					status = "error";
				}
				else
				{
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						if ( xmlString.length() > 0 )
						{
							xmlString = genericUtility.jsonToXMLString( xmlString );
						}
					}
					result = updateSignStatus( xmlString, actionCode, getUserInfo() );
					if ( "JSON".equalsIgnoreCase( dataFormat ) )
					{
						result = genericUtility.xmlToJSONString( result );
					}
					status = "success";
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : updateSignStatus : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "updateSignStatus", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] START
	/**
	 * Get User Image
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getUserImage")
	public Response getUserImage( @QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				result = getUserImage( response );
				if ( "success".equalsIgnoreCase( result ) )
		        {
		        	status = "success";
		        }
		        else
		        {
		        	status = "error";
		        }
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getUserImage : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getUserImage", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get User Image
	 * 
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getUserImage")
	public Response getUserImageClient( @FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				result = getUserImage( response );
				if ( "success".equalsIgnoreCase( result ) )
		        {
		        	status = "success";
		        }
		        else
		        {
		        	status = "error";
		        }
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getUserImageClient : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getUserImage", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Attachment of provided object name and refId
	 * 
	 * @param objName
	 * @param refSer
	 * @param refId
	 * @param docType
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/getAttachDocument")
	public Response getAttachDocument( @QueryParam("OBJ_NAME") String objName, @QueryParam("REF_SER") String refSer,
			@QueryParam("REF_ID") String refId, @QueryParam("DOC_TYPE") String docType, 
			@QueryParam("TOKEN_ID") String tokenId, @QueryParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&DOC_TYPE="+ docType);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				refSer = checkNull( refSer );
				if ( refSer.length() == 0 )
				{
					DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
					refSer = dbAccess.getRefSer( null, objName, getUserInfo() );
				}
				
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else if ( refId.length() == 0 )
				{
					result = "Please enter valid Ref Id.";
					status = "error";
				}
				else
				{
					result = getAttachDocument( refId, refSer, docType, response );
			        if ( "success".equalsIgnoreCase( result ) )
			        {
			        	status = "success";
			        }
			        else
			        {
			        	status = "error";
			        }
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getAttachDocument : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getAttachDocument", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Get Attachment of provided object name and refId
	 * 
	 * @param objName
	 * @param refSer
	 * @param refId
	 * @param docType
	 * @param tokenId
	 * @param dataFormat
	 * @param request
	 * @param response
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getAttachDocument")
	public Response getAttachDocumentClient( @FormParam("OBJ_NAME") String objName, @FormParam("REF_SER") String refSer,
			@FormParam("REF_ID") String refId, @FormParam("DOC_TYPE") String docType, 
			@FormParam("TOKEN_ID") String tokenId, @FormParam("DATA_FORMAT") String dataFormat, 
			@Context HttpServletRequest request, @Context HttpServletResponse response ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("OBJ_NAME="+ objName);
				paramString.append("&REF_SER="+ refSer);
				paramString.append("&REF_ID="+ refId);
				paramString.append("&DOC_TYPE="+ docType);
				paramString.append("&TOKEN_ID="+ tokenId);
				paramString.append("&DATA_FORMAT="+ dataFormat);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, dataFormat, tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				objName = checkNull( objName );
				refSer = checkNull( refSer );
				if ( refSer.length() == 0 )
				{
					DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
					refSer = dbAccess.getRefSer( null, objName, getUserInfo() );
				}
				if ( objName.length() == 0 )
				{
					result = "Please enter valid Object Name.";
					status = "error";
				}
				else if ( refId.length() == 0 )
				{
					result = "Please enter valid Ref Id.";
					status = "error";
				}
				else
				{
			        result = getAttachDocument( refId, refSer, docType, response );
			        if ( "success".equalsIgnoreCase( result ) )
			        {
			        	status = "success";
			        }
			        else
			        {
			        	status = "error";
			        }
				}
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : getAttachDocumentClient : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "getAttachDocument", params, tokenId, dataFormat, status, result );
		}
		
		return Response.status(200).entity( result ).build();
	}
	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] END
	
	//Added by Prasad on 26/05/16 [For keep alive session] START
	/**
	 * Keep session alive
	 * 
	 * @param tokenId
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/keepAlive")
	public Response keepSessionAlive( @QueryParam("TOKEN_ID") String tokenId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("&TOKEN_ID="+ tokenId);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, "JSON", tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				if ( getUserInfo() != null )
				{
					result = getUserInfo().getDesignation()+":"+getUserInfo().getDivision()+":"+getUserInfo().getSiteCode()+":"+getUserInfo().getDateJoin()+":"+getUserInfo().getEmpName()+":"+getUserInfo().getEmpCode();
				}
				else
				{
					result = "";
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : keepAlive : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "keepAlive", params, tokenId, "JSON", status, result );
		}
		return Response.status(200).entity( result ).build();
	}
	
	/**
	 * Keep session alive
	 * 
	 * @param tokenId
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/keepAlive")
	public Response keepSessionAliveClient( @FormParam("TOKEN_ID") String tokenId, @Context HttpServletRequest request ) throws BaseException, Exception
	{
		String result = "";
		String params = "";
		String status = "error";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("&TOKEN_ID="+ tokenId);
				params = paramString.toString();
			}
			System.out.println("params - " + params);
			result = validateRequest( request, "JSON", tokenId );
			System.out.println("validateRequest - ["+ result +"]");
			if ( "valid".equalsIgnoreCase( result ) )
			{
				if ( getUserInfo() != null )
				{
					result = getUserInfo().getDesignation()+":"+getUserInfo().getDivision()+":"+getUserInfo().getSiteCode()+":"+getUserInfo().getDateJoin()+":"+getUserInfo().getEmpName()+":"+getUserInfo().getEmpCode();
				}
				else
				{
					result = "";
				}
				status = "success";
			}
			else
			{
				status = "error";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : keepAlive : "+ e.getMessage() );
			status = "exception";
			result = getStackTrace(e);
		}
		finally
		{
			result = generateResponse( request, "keepAlive", params, tokenId, "JSON", status, result );
		}
		return Response.status(200).entity( result ).build();
	}
	//Added by Prasad on 26/05/16 [For keep alive session] END
	
	/**
	 * It creates a object of InitialContext & returns the same.
	 * 
	 * @return
	 * @throws ITMException
	 */
	private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "Exception : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	
	/**
	 * Get User Valid or not
	 * 
	 * @param request
	 * @param userCode
	 * @param password
	 * @param siteCode
	 * @param authMode
	 * @param isSHA256Appld
	 * @return
	 * @throws Exception
	 * @throws BaseException
	 */
	private String getAuthStatus(HttpServletRequest request, String userCode, String password, String siteCode, String authMode, String isSHA256Appld) throws Exception, BaseException 
	{
	    String authStatus = "false";
		try 
		{
			String xmlInfo = "";
			if ( getCommonDBAccess() != null )
			{
				//CommonDBAccessRemote commDBAccess = (CommonDBAccessRemote) getInitialContext().lookup("ibase/CommonDBAccessEJB/remote");
				//authStatus = commDBAccess.authenticate(userCode, password, siteCode, authMode, isSHA256Appld);
				xmlInfo = getCommonDBAccess().authenticate(userCode, password, siteCode, authMode, isSHA256Appld);
				System.out.println( "xmlInfo - ["+ xmlInfo +"]" );
				authStatus = generateResponse(request, userCode, authMode, xmlInfo);
				//isValidLogin = getAuthenticationStatus( authStatus );
				//if ( isValidLogin )
				if ( "VALID".equalsIgnoreCase( authStatus ) )
				{
					Document document = genericUtility.parseString( xmlInfo );
					setUserInfo( createUserInfo( userCode, password, document ) );
					
					//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] START
					InetAddress inetAddress = InetAddress.getLocalHost();
					String hostName = inetAddress.getHostName();
					String hostIP = inetAddress.getHostAddress();
					String clientIP = checkNull( request.getRemoteAddr() );
					if ( getUserInfo() != null )
					{
						getUserInfo().setRemoteHost( ( clientIP.length() > 0 ) ? clientIP : "SYSTEM" );
						getUserInfo().setSessionId( request.getSession().getId() );
						getUserInfo().setHostName( hostName );
						getUserInfo().setHostIP( hostIP );
						getUserInfo().setRemoteHostName( hostName );
					}
					//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] END
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception: getAuthStatus: "+ e.getMessage());
			throw new BaseException(e);
		}
		System.out.println("isValidLogin - ["+ authStatus +"]");
	    return authStatus;
	}
	
	/**
	 * Get Authentication Status value
	 * 
	 * @param xmlInfo
	 * @return
	 * @throws BaseException
	 */
	private boolean getAuthenticationStatus( String xmlInfo ) throws BaseException 
	{
		boolean flag = false;
		try 
		{
			Document document = genericUtility.parseString( xmlInfo );
			if ( document.getElementsByTagName("STATUS").item(0) != null 
					&& document.getElementsByTagName("STATUS").item(0).getFirstChild() != null ) 
			{
				flag = Boolean.valueOf(	document.getElementsByTagName("STATUS").item(0).getFirstChild().getNodeValue() ).booleanValue();
			}
		} 
		catch (BaseException be) 
		{
			System.out.println("BaseException: getAuthenticationStatus: "+ be.getMessage());
			throw be;
		}
		catch (Exception e) 
		{
			System.out.println("Exception: getAuthenticationStatus: "+ e.getMessage());
			throw new BaseException(e);
		}
		System.out.println("Authentication Status :["+ flag +"]");
		return flag;
	}
	
	/**
	 * Executing System events for provided object Name and Event
	 * 
	 * @param objName
	 * @param eventCode
	 * @param serviceParam1
	 * @param serviceParam2
	 * @param serviceParam3
	 * @param serviceParam4
	 * @param xtraParams
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String serviceParam1, String serviceParam2, String serviceParam3, String serviceParam4, String xtraParams ) throws ITMException
	{
		String returnValue = "";
		try
		{
			String userInfo = "";
			if ( getUserInfo() != null )
			{
				userInfo = getUserInfo().toString();
			}
			ExtServiceEventManagerLocal eventManager = (ExtServiceEventManagerLocal) getInitialContext().lookup( "ibase/ExtServiceEventManagerEJB/local" );
			returnValue = eventManager.executeSystemEvent( objName, "getExtServiceData", serviceParam1, serviceParam2, serviceParam3, serviceParam4, xtraParams, userInfo );
		}
		catch (Exception e)
		{
			System.out.println("Exception: executeSystemEvent: "+ e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("executeSystemEvent :["+ returnValue +"]");
		return returnValue;
	}
	
	/**
	 * Creating userInfo
	 * 
	 * @param userCode
	 * @param passwd
	 * @param document
	 * @return
	 * @throws BaseException
	 */
	private UserInfoBean createUserInfo( String userCode, String passwd, Document document ) throws BaseException
	{
		UserInfoBean userInfo = null;
		try
		{
			userInfo = new ibase.utility.UserInfoBean();			
			userInfo.setLoginCode( userCode );
			userInfo.setLoginPwd( passwd );
			if ( document.getElementsByTagName( "PROFILE_ID" ).item(0) != null 
					&& document.getElementsByTagName( "PROFILE_ID" ).item(0).getFirstChild() != null )
			{
				userInfo.setProfileId( document.getElementsByTagName( "PROFILE_ID" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_CODE" ).item(0) != null 
					&& document.getElementsByTagName( "EMP_CODE" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpCode( document.getElementsByTagName("EMP_CODE").item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_FNAME" ).item(0) != null 
					&& document.getElementsByTagName( "EMP_FNAME" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpFName( document.getElementsByTagName( "EMP_FNAME" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_MNAME" ).item(0) != null 
					&& document.getElementsByTagName( "EMP_MNAME" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpMName( document.getElementsByTagName( "EMP_MNAME" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "EMP_LNAME" ).item(0) != null 
					&& document.getElementsByTagName( "EMP_LNAME" ).item(0).getFirstChild() != null )
			{
				userInfo.setEmpLName( document.getElementsByTagName( "EMP_LNAME" ).item(0).getFirstChild().getNodeValue() );
			}
			if (document.getElementsByTagName( "SITE_CODE" ).item(0) != null 
					&& document.getElementsByTagName( "SITE_CODE" ).item(0).getFirstChild() != null)
			{
				userInfo.setSiteCode( document.getElementsByTagName( "SITE_CODE" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "IS_BI_USER" ).item(0) != null 
					&& document.getElementsByTagName( "IS_BI_USER" ).item(0).getFirstChild() != null )
			{
				userInfo.setIsBIUser( document.getElementsByTagName("IS_BI_USER").item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "PROFILE_ID__RES" ).item(0) != null 
					&& document.getElementsByTagName( "PROFILE_ID__RES" ).item(0).getFirstChild() != null )
			{
				userInfo.setProfileIdRes( document.getElementsByTagName( "PROFILE_ID__RES" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "LOGGER_TYPE" ).item(0) != null 
					&& document.getElementsByTagName( "LOGGER_TYPE" ).item(0).getFirstChild() != null )
			{
				userInfo.setLoggerType( document.getElementsByTagName( "LOGGER_TYPE" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "STAN_CD__HQ_DESCR" ).item(0) != null 
					&& document.getElementsByTagName( "STAN_CD__HQ_DESCR" ).item(0).getFirstChild() != null )
			{
				userInfo.setStanCode( document.getElementsByTagName( "STAN_CD__HQ_DESCR" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "DESIGNATION" ).item(0) != null 
					&& document.getElementsByTagName( "DESIGNATION" ).item(0).getFirstChild() != null )
			{
				userInfo.setDesignation( document.getElementsByTagName( "DESIGNATION" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "DATE_JOIN" ).item(0) != null 
					&& document.getElementsByTagName( "DATE_JOIN" ).item(0).getFirstChild() != null )
			{
				userInfo.setDateJoin( document.getElementsByTagName( "DATE_JOIN" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "TRANS_DB" ).item(0) != null 
					&& document.getElementsByTagName( "TRANS_DB" ).item(0).getFirstChild() != null )
			{
				userInfo.setTransDB( document.getElementsByTagName( "TRANS_DB" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "USER_THEME" ).item(0) != null 
					&& document.getElementsByTagName( "USER_THEME" ).item(0).getFirstChild() != null )
			{
				userInfo.setUserTheme( document.getElementsByTagName( "USER_THEME" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( document.getElementsByTagName( "USER_GEO_FENCE_ENABLED" ).item(0) != null 
					&& document.getElementsByTagName( "USER_GEO_FENCE_ENABLED" ).item(0).getFirstChild() != null )
			{
				userInfo.setUserGeoFence( document.getElementsByTagName( "USER_GEO_FENCE_ENABLED" ).item(0).getFirstChild().getNodeValue() );
			}
			if ( getCommonDBAccess() != null )
			{
				userInfo.setEmpInfo( getCommonDBAccess().getEmpInfo( userInfo.getLoginCode(), userInfo.getSiteCode() ) );
			}
		}
		catch( Exception e )
		{
			System.out.println("Exception: createUserInfo:==>\n"+e);
			throw new BaseException( e );
		}
		System.out.println( "UserInfoBean Created....." );
		return userInfo;
	}
	
	/**
	 * Creating xtraParams String
	 * 
	 * @return
	 * @throws Exception
	 */
	private String getXtraParams() throws Exception 
	{
		StringBuffer xtraParamsBuff = new StringBuffer();
		try 
		{
			if ( getUserInfo() != null )
			{
				UserInfoBean userInfo = getUserInfo();
				String XTRA_PARAMS_SEPARATOR = "~~";
				xtraParamsBuff.append("loginCode=" + userInfo.getLoginCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginEmpCode=" + userInfo.getEmpCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("loginSiteCode=" + userInfo.getSiteCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("entityCode=" + userInfo.getEntityCode());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("profileId=" + userInfo.getProfileId());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("userType=" + userInfo.getUserType());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("runMode=I");
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("charEnc=" + userInfo.getCharEnc());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("termId=" + userInfo.getRemoteHost());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_lang=" + userInfo.getUserLanguage());
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("user_country=" + userInfo.getUserCountry());
				
				String chgTerm = userInfo.getRemoteHostName();
				if (chgTerm != null && chgTerm.length() > 15) 
				{
					chgTerm = chgTerm.substring(0, 15);
				}
				else if (chgTerm == null || chgTerm.length() == 0) 
				{
					chgTerm = userInfo.getRemoteHost();
				}
				xtraParamsBuff.append(XTRA_PARAMS_SEPARATOR).append("chgTerm=" + chgTerm);
			}
			System.out.println("xtraParamsBuff ["+xtraParamsBuff+"]");
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}

		return xtraParamsBuff.toString();
	}
	
	//Changed by Prasad on 18/02/16 [for validating user] START
	/**
	 * Generating server response after login
	 * 
	 * @param request
	 * @param userCode
	 * @param loginMode
	 * @param xmlInfo
	 * @return
	 * @throws BaseException
	 */
	private String generateResponse( HttpServletRequest request, String userCode, String loginMode, String xmlInfo )throws BaseException
	{
		System.out.println( "Generating Response...." );
		String responseString = "";
		try
		{
			HttpSession session = request.getSession();
			if ( checkNull( xmlInfo ).length() > 0 )
			{
				Document document = genericUtility.parseString( xmlInfo );
				if ( document.getElementsByTagName( "STATUS_CODE" ).item(0) != null && document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild() != null )
				{
					String statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
					responseString = statusCode;
					if ( statusCode.equalsIgnoreCase("RESIGNED") )
					{
						responseString = Messages.getString( "AuthenticateServlet_employeeHasResigned", getUserLangAndCountry(userCode) );
					}
					else if ( statusCode.equalsIgnoreCase("LOCKED") )
					{
						responseString = Messages.getString( "AuthenticateServlet_accountIsLockedContactAdmin", getUserLangAndCountry(userCode) );
					}
					else if ( statusCode.indexOf("INVALID") != -1 )
					{
						if ( statusCode.equalsIgnoreCase("INVALID_USR") )
						{
							responseString = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword",getUserLangAndCountry(userCode) );
						}
						else if ( statusCode.equalsIgnoreCase("INVALID_PWD") )
						{
							responseString = Messages.getString( "AuthenticateServlet_pleaseEnterValidUserNameAndPassword",getUserLangAndCountry(userCode) );
						}
						if ( session.getAttribute( "INVALID_COUNT" ) == null )
						{
							session.setAttribute( "INVALID_COUNT", new Integer( 1 ) );
						}
						else
						{
							int maxCount = 5;
							int invaildCount = ( ( Integer )session.getAttribute( "INVALID_COUNT" ) ).intValue();
							if (invaildCount == maxCount-1)
							{
								if (document.getElementsByTagName( "RES_TYPE" ) != null && document.getElementsByTagName( "RES_TYPE" ).item( 0 ) != null)
								{
									String resType = document.getElementsByTagName("RES_TYPE").item(0).getFirstChild().getNodeValue();
									getCommonDBAccess().secureAccount( userCode, resType );
									if ( Integer.parseInt( resType ) == 0 )
									{
										String emailIdOff = null;
										if (document.getElementsByTagName("EMAIL_ID") != null && document.getElementsByTagName("EMAIL_ID").item(0) != null)
										{
											emailIdOff = document.getElementsByTagName("EMAIL_ID").item(0).getFirstChild().getNodeValue();
										}
										responseString = Messages.getString( "AuthenticateServlet_passwordBlockedSinceWronglyEntered", getUserLangAndCountry(userCode)) 
												+ maxCount + Messages.getString( "AuthenticateServlet_newPasswordSentToEmailID", getUserLangAndCountry(userCode) ) + emailIdOff;
									}
									else if ( Integer.parseInt( resType ) == 1)
									{
										responseString = Messages.getString( "AuthenticateServlet_accountIsLockedContactAdmin",getUserLangAndCountry(userCode) );
									}
									else
									{
										System.out.println("Invaild Response Type(resType) Found :"+resType);
									}
								}
								session.setAttribute( "INVALID_COUNT", new Integer( 0 ) );
							}
							else
							{
								session.setAttribute( "INVALID_COUNT", new Integer( invaildCount+1 ) );
							}
						}	
					}
					else if( statusCode.indexOf("PASS_EXP") != -1 )
					{
						if ( statusCode.equalsIgnoreCase("PASS_EXP_NOGRACE") )
						{
							responseString = Messages.getString( "AuthenticateServlet_passwordExpiredChangeIt",getUserLangAndCountry(userCode) );
						}
					}
					else if( statusCode.equalsIgnoreCase("VALID") )
					{
						if(document.getElementsByTagName( "SITE_CODE" ).item(0) != null)
						{
							String siteCodeValue = document.getElementsByTagName("SITE_CODE").item(0).getFirstChild().getNodeValue(); 
							if ( siteCodeValue.equalsIgnoreCase("INVALID_SITE") )
							{
								responseString = Messages.getString( "AuthenticateServlet_NotValidSite",getUserLangAndCountry(userCode) );
								session.setAttribute( "USER_INFO", null );
							}
							else if ( siteCodeValue.equalsIgnoreCase("INACCESSIBLE_SITE")  )
							{
								responseString = Messages.getString( "AuthenticateServlet_InAccessibleSite",getUserLangAndCountry(userCode) );
								session.setAttribute( "USER_INFO", null ); 
							}
						}
					}
					else if ( statusCode.equalsIgnoreCase("FIRST_LOGIN") )
					{
						responseString = Messages.getString( "AuthenticateServlet_compulsoryChangePasswordPleaseDoSo",getUserLangAndCountry(userCode) );
					}
					else if(statusCode.equalsIgnoreCase("ATTENDANCE_MISSING"))
					{
						responseString = Messages.getString( "AuthenticateServlet_entryInDailyAttendanceNotFound",getUserLangAndCountry(userCode) );
					}
				}
			}
		}
		catch( BaseException be )
		{
			System.out.println("Exception: generateResponse:==>\n"+be);
			throw be;
		}
		catch( Exception e )
		{
			System.out.println("Exception: generateResponse:==>\n"+e);
			throw new BaseException( e );
		}
		System.out.println( "responseString - ["+ responseString +"]" );
		return responseString;
	}
	
	/**
	 * This method will get the user language and user country 
	 * from User table depend upon user code
	 * 
	 * @param userCode the user id from login page
	 * @return the list of user lang and user country
	 */
	private ArrayList<String> getUserLangAndCountry( String userCode )
	{
		ArrayList<String> langAndCountryList = new ArrayList<String>(); 
		try 
		{
			String userLanguage = getCommonDBAccess().getDBColumnValue( "USERS", "USER_LANG","WHERE CODE = "+"'" +userCode+"'" );
			String userCountry = getCommonDBAccess().getDBColumnValue( "USERS", "USER_COUNTRY", "WHERE CODE = "+"'" +userCode+"'" );
			if( userLanguage != null && userCountry != null )
			{
				langAndCountryList.add( userLanguage );
				langAndCountryList.add( userCountry );
			}
			System.out.println( "User Language["+userLanguage+"], User Country["+userCountry+"], List["+langAndCountryList.toString()+"]" );
		}
		catch (Exception e)
		{
			System.out.println("Exception :: while accessing user country and user language from database. ");
			e.printStackTrace();
		}
		
		return langAndCountryList;
	}
	
	/**
	 * To get CommonDBAccessRemote object
	 * 
	 * @return
	 * @throws BaseException
	 */
	private CommonDBAccessRemote getCommonDBAccess() throws BaseException
	{
		CommonDBAccessRemote ejbObj = null;
		try
		{
			ejbObj = (CommonDBAccessRemote) getInitialContext().lookup("ibase/CommonDBAccessEJB/remote");
		}
		catch( BaseException be )
		{
			System.out.println("Exception: getCommonDBAccess:==>\n"+be);
			throw be;
		}
		catch( Exception e )
		{
			System.out.println("Exception: getCommonDBAccess:==>\n"+e);
			throw new BaseException( e );
		}
		return ejbObj;
	}
	//Changed by Prasad on 18/02/16 [for validating user] END
	/**
	 * @return the userInfo
	 */
	public UserInfoBean getUserInfo() 
	{
		return userInfo;
	}

	/**
	 * @param userInfo the userInfo to set
	 */
	public void setUserInfo(UserInfoBean userInfo) 
	{
		this.userInfo = userInfo;
	}
	
	//Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] START
	/**
	 * User Logout
	 * 
	 * @param userCode
	 * @param sessionId
	 * @throws BaseException
	 */
	private void logout( String userCode, HttpServletRequest request ) throws BaseException
	{
		String sessionId = request.getSession().getId();
		try 
		{
			EventLogInfoBean eventInfoBean = new EventLogInfoBean( userCode );
			eventInfoBean.removeSessionActivity( sessionId );
			getCommonDBAccess().updateSessionTrace( userCode, sessionId );
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		finally
		{
			HttpSession session = request.getSession(false);
			if(session != null)
			{
				session.invalidate();
			}
		}
	}
	
	/**
	 * Validate a User using Token Id (which is provided after successful login)
	 * 
	 * @param request
	 * @param tokenId
	 * @return isValidUser - true if the user is valid, otherwise false
	 */
	private boolean validateUserSession( HttpServletRequest request, String tokenId )
	{
		boolean isValidUser = false;
		try 
		{
			String sessionTokenId = request.getSession().getAttribute( "TOKEN_ID" ) != null ? ""+request.getSession().getAttribute( "TOKEN_ID" ) : "";
			tokenId = checkNull( tokenId );
			System.out.println( "sessionTokenId - ["+ sessionTokenId +"], tokenId - ["+ tokenId +"]");
			if ( tokenId.length() > 0 && sessionTokenId.equals( tokenId ) )
			{
				isValidUser = true;
				if ( request.getSession().getAttribute( "USER_INFO" ) != null )
				{
					UserInfoBean userInfo = (UserInfoBean) request.getSession().getAttribute( "USER_INFO" );
					setUserInfo( userInfo );
				}
			}
		}
		catch (Exception e) 
		{
			isValidUser = false;
			e.printStackTrace();
		}
		return isValidUser;
	}
	
	/**
	 * Executing system events
	 * 
	 * @param objName
	 * @param eventCode
	 * @param transDomString
	 * @param detailDomString
	 * @param domId
	 * @param xtraParams
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams ) throws ITMException
	{
		String retStr = "";
		try
		{
			InitialContext ctx = getInitialContext();
			
			EventManagerRemote eventManager = (EventManagerRemote)ctx.lookup("ibase/EventManagerEJB/remote");
			retStr = eventManager.executeSystemEvent( objName, eventCode, null, transDomString, detailDomString, xtraParams, domId );
			eventManager.remove();
			eventManager = null;
		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :: executeSystemEvent :==>"+ itme.getMessage());
			throw itme;
		}
		catch (Exception e)
		{
			System.out.println("Exception :: executeSystemEvent :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		return retStr;
	}
	
	/**
	 * Executing system events
	 * 
	 * @param objName
	 * @param eventCode
	 * @param transDomString
	 * @param detailDomString
	 * @param domId
	 * @param xtraParams
	 * @param userInfoBean
	 * @return
	 * @throws ITMException
	 */
	private String executeSystemEvent( String objName, String eventCode, String transDomString, String detailDomString, String domId, String xtraParams,UserInfoBean userInfoBean ) throws ITMException
	{
		String retStr = "";
		try
		{
			InitialContext ctx = getInitialContext();
			
			EventManagerRemote eventManager = (EventManagerRemote)ctx.lookup("ibase/EventManagerEJB/remote");
			retStr = eventManager.executeSystemEvent( objName, eventCode, null, transDomString, detailDomString, xtraParams, domId, userInfoBean );
			eventManager.remove();
			eventManager = null;
		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :: executeSystemEvent :==>"+ itme.getMessage());
			throw itme;
		}
		catch (Exception e)
		{
			System.out.println("Exception :: executeSystemEvent :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		return retStr;
	}
	
	/**
     * log created to keep record of web service calls 
     * 
     * @param tokenId
     * @param action
     * @param params
     * @param responseType
     * @param response
     * @param userInfo
     * @return
     * @throws ITMException
     */
    private String generateExtServiceLog( HttpServletRequest request, String tokenId, String action, String params, String responseType, String response, UserInfoBean userInfo) throws ITMException
    {
    	String result = "";
    	String requestedTerm = "", requestedUser = "";
    	try 
    	{
    		//Added by Prasad on 11/05/17 [to set hostName and hostAddress in log table] START
    		String hostName = "", hostIP = "";
			InetAddress inetAddress = InetAddress.getLocalHost();
			hostName = inetAddress.getHostName();
			hostIP = inetAddress.getHostAddress();
    		if ( userInfo != null )
    		{
    			requestedTerm = checkNull( userInfo.getRemoteHost() );
    			if( requestedTerm.length() > 15 )
    			{
    				requestedTerm = requestedTerm.substring(0, 15);
    			}
    			requestedUser = checkNull( userInfo.getLoginCode() );
    		}
    		else
    		{
    			requestedTerm = checkNull( request.getRemoteAddr() );
    			if( requestedTerm.length() > 15 )
    			{
    				requestedTerm = requestedTerm.substring(0, 15);
    			}
    			/*InetAddress inetAddress = InetAddress.getLocalHost();
    			requestedUser = inetAddress.getHostName();
				if ( requestedUser.length() > 10 )
				{
					requestedUser = requestedUser.substring(0, 10);
				}*/
				if ( hostName.length() > 10 )
				{
					requestedUser = hostName.substring(0, 10);
				}
    		}
			//DBAccessRemote dbAccess = (DBAccessRemote) getInitialContext().lookup("ibase/DBAccessEJB/remote");
    		//result = dbAccess.createExtServiceLog(tokenId, action, params, responseType, response, requestedTerm, requestedUser, userInfo);
    		ExtServiceRemote extServices = (ExtServiceRemote) getInitialContext().lookup("ibase/ExtServiceEJB/remote");
			result = extServices.createExtServiceLog(tokenId, action, params, responseType, response, requestedTerm, requestedUser, hostName, hostIP, userInfo);
			//Added by Prasad on 11/05/17 [to set hostName and hostAddress in log table] END
		}
    	catch (NamingException e) 
    	{
			e.printStackTrace();
			throw new ITMException(e);
		}
    	catch (UnknownHostException e) 
    	{
			e.printStackTrace();
			throw new ITMException(e);
		}
    	if ( "error".equals( responseType ) )
		{
			String fileName = requestedUser + "_log_" + System.currentTimeMillis() + ".log";
			generateErrorLog( response, fileName );
		}
		return result;
    }
    
    /**
     * check valid Data Format or not (XML/JSON)
     * 
     * @param dataFormat
     * @return
     */
    private boolean isValidDataFormat( String dataFormat )
    {
    	boolean isValidDataFormat = false;
    	dataFormat = checkNull( dataFormat );
    	if ( "JSON".equalsIgnoreCase(dataFormat) || "XML".equalsIgnoreCase(dataFormat) )
    	{
    		isValidDataFormat = true;
    	}
    	return isValidDataFormat;
    }
	
	/**
	 * to check null and undefined value
	 * 
	 * @param input
	 * @return
	 */
	private String checkNull(String input)
	{
		if ( input == null || "null".equalsIgnoreCase(input) || "undefined".equalsIgnoreCase(input) )
		{
			input= "";
		}
		return input.trim();
	}
	
	/**
	 * Generate a log file for upload document
	 * 
	 * @param log
	 * @param fileName
	 */
    private void generateErrorLog( String log, String fileName ) 
	{
		try 
		{
			String logDir = CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + "webService_Log" + File.separator + fileName;
			File outFile = new File( CommonConstants.JBOSSHOME + File.separator + "log" + File.separator + "webService_Log" );
			if ( ! outFile.exists() ) 
			{
				outFile.mkdir();
			}
			PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(logDir, true)));
			out.println( log );
			out.close();
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
	}
	
	/**
     * get a print stack trace
     * 
     * @param e
     * @return
     */
    private String getStackTrace( Exception e )
    {
    	/*StringWriter exception = new StringWriter();
		try 
		{
			e.printStackTrace( new PrintWriter( exception ) );
		}
		catch (Exception e1) 
		{
			e1.printStackTrace();
		}*/
    	String exception = "";
    	if ( genericUtility == null )
    	{
    		genericUtility = new E12GenericUtility();
    	}
    	exception = genericUtility.createErrorString(e);
		return exception;
    }
    //Added by Prasad on 07/03/16 [E-travel related services - T15JSUN001] END
    
    //Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] START
    /**
	 * Validate User Request
	 * 
	 * @param request
	 * @param dataFormat
	 * @param tokenId
	 * @return
	 */
	private String validateRequest( HttpServletRequest request, String dataFormat )
	{
		String validStr = "valid";
		try 
		{
			if ( ! request.isSecure() )
			{
				validStr = "This option is only available with 'Https'.";
			}
			else if ( ! isValidDataFormat( dataFormat ) )
			{
				validStr = "Please enter valid Data Format.";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : validateRequest : "+ e.getMessage() );
			validStr = getStackTrace(e);
		}
		return validStr;
	}
	
	/**
	 * Validate User Request
	 * 
	 * @param request
	 * @param dataFormat
	 * @param tokenId
	 * @return
	 */
	private String validateRequest( HttpServletRequest request, String dataFormat, String tokenId )
	{
		String validStr = "valid";
		try 
		{
			if ( ! request.isSecure() )
			{
				validStr = "This option is only available with 'Https'.";
			}
			else if ( ! isValidDataFormat( dataFormat ) )
			{
				validStr = "Please enter valid Data Format.";
			}
			else if ( ! validateUserSession( request, tokenId ) )
			{
				validStr = "You are not authorized to access.";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : validateRequest : "+ e.getMessage() );
			validStr = getStackTrace(e);
		}
		return validStr;
	}
	
	/**
	 * Generate Service Response
	 * 
	 * @param request
	 * @param serviceName
	 * @param params
	 * @param tokenId
	 * @param dataFormat
	 * @param status
	 * @param result
	 * @return
	 */
	private String generateResponse( HttpServletRequest request, String serviceName, String params, String tokenId, String dataFormat, String status, String result )
	{
		String response = "";
		try 
		{
			JSONObject responseJson = new JSONObject();
			JSONObject resultJson = new JSONObject();
			
			result = checkNull( result );
			//Added by Prasad 29/11/16 [to check warning status also] START
			if ( result.indexOf( "Warning" ) != -1 )
			{
				status = "warning";
			}
			//Added by Prasad 29/11/16 [to check warning status also] END
			else if ( result.indexOf( "Errors" ) != -1 )
			{
				status = "error";
			}
			else if ( result.indexOf( "Exception" ) != -1 )
			{
				status = "exception";
			}
			resultJson.put( "status", status );
			try 
			{
				String logResult = generateExtServiceLog( request, tokenId, serviceName, params, status, result, getUserInfo() );
				System.out.println("logResult - ["+ logResult +"]");
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
			resultJson.put( "results", result );
			responseJson.put( "Response", resultJson );
			response = responseJson.toString();
			if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
			{
				response = genericUtility.jsonToXMLString( response );
				response = genericUtility.remAllXmlDec( response );
			}
		}
		catch (ITMException e) 
		{
			System.out.println( "ITMException : generateResponse : "+ e.getMessage() );
			response = getStackTrace(e);
		}
		catch (JSONException e) 
		{
			System.out.println( "JSONException : generateResponse : "+ e.getMessage() );
			response = getStackTrace(e);
		}
		return response;
	}
	
    /**
     * get brow data
     * 
     * @param objName
     * @param argFieldValues
     * @param argFieldTypes
     * @param advQuery
     * @param request
     * @param searchParam
     * @param editorId
     * @return
     * @throws ITMException
     */
    private String getXMLDataForHeader( String objName, String argFieldValues, String argFieldTypes, String advQuery, HttpServletRequest request, String searchParam, String editorId) throws ITMException
	{
		String retXMLStr = null;
		try
		{
			UserInfoBean userInfo = ( UserInfoBean )request.getSession().getAttribute( "USER_INFO" );
			if(userInfo != null)
			{
				MasterDataRemote mDataRem = ( MasterDataRemote ) this.getInitialContext().lookup( "ibase/MasterDataEJB/remote" );
				mDataRem.setEditorId(editorId);
				retXMLStr = mDataRem.getXMLFromDBForBrow( objName, "1", "1", argFieldValues, argFieldTypes, advQuery, userInfo, true, searchParam );
			}
			else
			{
				retXMLStr = "You have not logged on or your session has expired.";
			}
		}
		catch ( ITMException itme )
		{
			System.out.println( "ITMException :: getXMLDataForHeader :"+ itme.getMessage() );
			throw itme;
		}
		catch ( Exception e )
		{
			System.out.println( "Exception :: getXMLDataForHeader :"+ e.getMessage() );
			throw new ITMException( e );
		}
		return retXMLStr;
	}
    
    /**
     * Get pophelp data
     * 
     * @param objName
     * @param fieldName
     * @param paramXmlStr
     * @param userInfo
     * @return
     * @throws ITMException 
     */
    private String getpopUpKeyStr(String objName, String fieldName, String paramXmlStr,UserInfoBean userInfo) throws ITMException 
	{
    	String xmlString = "";
		try
		{
			PopUpRemote popUp = ( PopUpRemote )getInitialContext().lookup( "ibase/PopUpEJB/remote" );
			xmlString = popUp.getpopUpKeyStr(objName, fieldName, paramXmlStr, userInfo, "", "", null );
		}
		catch(Exception e)
		{
			System.out.println("Exception :: getPopUpKeyStr ["+e.getMessage()+"]");
			throw new ITMException( e );
		}
		return xmlString;
	}
    
    /**
     * Get value from document
     * 
     * @param parentDom
     * @param currFieldName
     * @return
     * @throws ITMException
     */
    private String getValueOfField( Document parentDom, String currFieldName ) throws ITMException
	{
		System.out.println("Getting value for field : ["+currFieldName+"]");
		String fieldValue = null;
		try
		{			
			NodeList detailNodeList = parentDom.getElementsByTagName("Detail1");
			if (detailNodeList.getLength() > 0)
			{
				if (detailNodeList.item(0).getAttributes().getNamedItem(currFieldName) != null)
				{
					fieldValue = detailNodeList.item(0).getAttributes().getNamedItem(currFieldName).getNodeValue();
				}
				else
				{
					fieldValue = null;
				}
			}
			if (fieldValue == null)
			{
				System.out.println("Seraching dom value as an element from dom.........");
				NodeList currFieldList = parentDom.getElementsByTagName(currFieldName);
				if (currFieldList.getLength() > 0)
				{
					if (currFieldList.item(0).getFirstChild() != null)
					{
						fieldValue = currFieldList.item(0).getFirstChild().getNodeValue();
					}
					else
					{
						fieldValue = null;
					}
				}
			}
		}
		catch (Exception e)
		{
			System.out.println("Exception :: getValueOfField() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("getValueOfField() - fieldName : ["+currFieldName+"], value : ["+fieldValue+"]");
		return fieldValue;
	}
    
    /**
     * get detail xmlstring from MasterStatefulEJB for provided object
     * 
     * @param objName
     * @param objContext
     * @param editFlag
     * @param pkValues
     * @param argFieldValues
     * @return
     * @throws RemoteException
     * @throws ITMException
     */
    private String getDetailXMLDomString( String objName, String objContext, String editFlag, String pkValues, String argFieldValues )throws RemoteException,ITMException
	{
		String resultString = "";
		//Added By Nilesh Start ::12-05-2017
		MasterStatefulLocal masterStateful=null;
		//Added By Nilesh End ::12-05-2017
		try 
		{
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfo );
			resultString = masterStateful.getDetailXMLDomString( objName, objContext, editFlag, pkValues, argFieldValues );
		}
		catch (NamingException e) 
		{
			System.out.println("NamingException :: getDetailXMLDomString() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		//Added By Nilesh Start ::12-05-2017
				finally
				{
					if(masterStateful!=null)
					{
						masterStateful.remove();
						masterStateful=null;
					}
				}
				//Added By Nilesh End ::12-05-2017
		return resultString;
	}
    
    /**
	 * Process request of MasterStatefulEJB
	 * 
	 * @param xmlString
	 * @return
	 * @throws ITMException
	 */
	private String processRequest( String xmlString, ServletContext context ) throws ITMException
	{
		String resultString = "";
		Connection conn = null;
		boolean isError = false;
		//Added By Nilesh Start::12-05-2017
		MasterStatefulLocal masterStateful=null;
		//Added By Nilesh End::12-05-2017
		try 
		{
			String userInfoStr = getUserInfo().toString();
			System.out.println( "getUserInfo() - "+ userInfoStr );
			String transDB = getUserInfo().getTransDB();
			ConnDriver connDriver = new ConnDriver();
			if( checkNull( transDB ).length() > 0 )
			{
				conn = connDriver.getConnectDB( transDB );
			}
			else
			{
				conn = connDriver.getConnectDB( "DriverITM" );
			}
			connDriver = null;
			conn.setAutoCommit( false );
			masterStateful = (MasterStatefulLocal) getInitialContext().lookup( "ibase/MasterStatefulEJB/local" );
			int randInt = new Random().nextInt();
			masterStateful.setEditorId( ""+randInt );
			masterStateful.setUserInfo( userInfoStr, xmlString );
			resultString = checkNull( masterStateful.processRequest( getUserInfo(), xmlString, true, conn ) );
			
			//Added by Prasad on 29/11/16 [for adding follow up actions] START
			if ( checkNull( xmlString ).length() > 0 )
			{
				String saveLevel = "";
				Node saveLevelNode = genericUtility.parseString( xmlString ).getElementsByTagName( "saveLevel" ).item(0);
				if ( saveLevelNode != null && saveLevelNode.getFirstChild() != null )
				{
					saveLevel = saveLevelNode.getFirstChild().getNodeValue();
				}
				if ( ( saveLevel != null && resultString != null ) && ( saveLevel.equals( "1" ) && resultString.indexOf( "Success" ) != -1 ) )
				{
					try 
				    {
						String tranID = "";
					    Node tranIdNode = genericUtility.parseString( resultString ).getElementsByTagName( "TranID" ).item(0);
						if ( tranIdNode != null && tranIdNode.getFirstChild() != null)
						{
							tranID = tranIdNode.getFirstChild().getNodeValue();
						}
						String objName = "";
						Node objNameNode = genericUtility.parseString( xmlString ).getElementsByTagName( "objName" ).item(0);
						if ( objNameNode != null && objNameNode.getFirstChild() != null )
						{
							objName = objNameNode.getFirstChild().getNodeValue();
						}
						System.out.println( "objName - ["+ objName +"], tranID - ["+ tranID +"]" );
						String userId = getUserInfo().getLoginCode();
						String randomNo = ""+ new Random().nextInt();
						addFollowUpAction( userId, randomNo, tranID, objName, context );
					}
				    catch (Exception e) 
				    {
						e.printStackTrace();
					}
				}
			}
			//Added by Prasad on 29/11/16 [for adding follow up actions] END
		}
		catch (ITMException e) 
		{
			System.out.println("ITMException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (RemoteException e) 
		{
			System.out.println("RemoteException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (SQLException e) 
		{
			System.out.println("SQLException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (NamingException e) 
		{
			System.out.println("NamingException :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			System.out.println("Exception :: processRequest() :==>\n"+e.getMessage());
			isError = true;
			throw new ITMException(e);
		}
		finally
		{
			if ( resultString.indexOf( "<Errors>" ) != -1 || resultString.indexOf( "Exception" ) != -1 )
			{
				isError = true;
			}
			if( conn !=null )
			{
				try 
				{
					if ( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}
					conn.close();
					conn = null;
				}
				catch (SQLException e) 
				{
					e.printStackTrace();
				}
			}
			//Added By Nilesh Start::12-05-2017
			if(masterStateful!=null)
			{
				masterStateful.remove();
				masterStateful=null;
			}
			//Added By Nilesh End::12-05-2017
		}
		return resultString;
	}
	
	/**
	 * Get Item Change Data
	 * 
	 * @param objName
	 * @param domId
	 * @param transDomStr
	 * @param detailDomStr
	 * @return
	 * @throws ITMException
	 */
	private String getItemChangeData( String objName, String domId, String transDomStr, String detailDomStr ) throws ITMException 
	{
		String resultString = "";
		try {
			String transDB = checkNull( getUserInfo().getTransDB() );
			if( transDB.length() > 0 )
			{
				resultString = executeSystemEvent( objName, "post_item_change", transDomStr, detailDomStr, domId, getXtraParams(), getUserInfo() );
			}
			else
			{
				resultString = executeSystemEvent( objName, "post_item_change", transDomStr, detailDomStr, domId, getXtraParams() );
			}
			if(resultString != null && resultString.indexOf("Errors") == -1)
			{
				Document transDom = genericUtility.parseString( transDomStr );
				String objContext = getValueOfField( transDom, "objContext" );
				if(resultString != null && resultString.indexOf("Detail"+objContext) == -1)
				{
					resultString = resultString.replaceAll("Detail", "Detail"+objContext);
				}
				System.out.println("responseStr[After updating the objContext] ::"+resultString);
				
				Document responseDom = genericUtility.parseString(resultString);
				Element element = (Element)responseDom.getElementsByTagName("Detail"+objContext).item(0);
				if(element != null)
				{
					element.setAttribute("domID", domId);
				}
				resultString = genericUtility.serializeDom(responseDom);
				System.out.println("responseStr[After updating the domID] ::"+resultString);
			}
		}
		catch (ITMException e) 
		{
			System.out.println("ITMException :: getItemChangeData() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		catch (DOMException e) 
		{
			System.out.println("DOMException :: getItemChangeData() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		catch (Exception e) 
		{
			System.out.println("Exception :: getItemChangeData() :==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		return resultString;
	}
	//Added by Prasad on 26/05/16 [Adding PopHelp, ItemChange, BrowData options- T15JSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] START
	/**
	 * Get sign details (Inbox/Approved/Rejected)
	 * 
	 * @param signStatus
	 * @param roles
	 * @param context1
	 * @param context2
	 * @param context3
	 * @param applName
	 * @param userInfo
	 * @return
	 * @throws RemoteException
	 * @throws Exception
	 */
	private String getWrkFlwBrowData( String signStatus, String roles, String context1, String context2, String context3, String applName, UserInfoBean userInfo ) throws ITMException, Exception
	{
		String signXMLData = "";
		try 
		{
			SignManagerRemote signManager =(SignManagerRemote) getInitialContext().lookup("ibase/SignManagerEJB/remote");
			String entityCode = "";
			if( userInfo != null )
			{
				entityCode = userInfo.getEntityCode();
			}
			signXMLData = signManager.getBrowData( "", signStatus, roles, context1, context2, context3, entityCode, userInfo.toString(), applName );
		}
		catch (Exception e) 
		{
			System.out.println("Exception: getWrkFlwBrowData: "+ e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("signXMLData - ["+ signXMLData +"]");
		return signXMLData;
	}
	
	/**
	 * get Sign transaction details
	 * 
	 * @param refSer
	 * @param refId
	 * @param lineNo
	 * @param userInfo
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String getSignTransDetData( String refSer, String refId, int lineNo, UserInfoBean userInfo ) throws RemoteException, ITMException
	{
		String signTransXMLData = "";
		try 
		{
			SignManagerRemote signManager =(SignManagerRemote) getInitialContext().lookup("ibase/SignManagerEJB/remote");
			String userCode = "";
			String siteCode = "";
			if( userInfo != null )
			{
				userCode = userInfo.getLoginCode();
				siteCode = userInfo.getSiteCode();
			}
			String transDetailXML = signManager.getTransXMLString( userCode, siteCode, refSer, refId, lineNo, userInfo.toString(), null );
			
			HashMap<String, String> transDetailMap = new HashMap<String, String>();
			if( checkNull( transDetailXML ).length() > 0 )
			{
				Document doc = genericUtility.parseString( transDetailXML );
				NodeList detailNodeList = doc.getElementsByTagName( "Detail" );
				Node detailNode = detailNodeList.item(0);
				NodeList detailChildList = detailNode.getChildNodes();
				int detailChildListLength = detailChildList.getLength();
				for(int dCtr = 0; dCtr < detailChildListLength; dCtr++)
				{
					Node currChild = detailChildList.item( dCtr );
					if( ! currChild.getNodeName().equalsIgnoreCase("attribute"))
					{
						if (currChild.getFirstChild() != null)
						{
							if (currChild.getFirstChild().getNodeType() == Node.ELEMENT_NODE)
							{
								transDetailMap.put( currChild.getNodeName(), genericUtility.serializeDom(currChild) );	
							}
							else
							{
								transDetailMap.put( currChild.getNodeName(), currChild.getFirstChild().getNodeValue() );
							}
						}
						else
						{
							transDetailMap.put( currChild.getNodeName(), "" );
						}
					}
				}
			}
			signTransXMLData = transDetailMap.get( "TRANS_INFO" );
		}
		catch (Exception e) 
		{
			System.out.println("Exception: getWrkFlwTransXMLData: "+ e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("signTransXMLData - ["+ signTransXMLData +"]");
		return signTransXMLData;
	}
	
	/**
	 * Update Sign status
	 * 
	 * @param xmlString
	 * @param actionCode
	 * @param userInfo
	 * @return
	 * @throws ITMException
	 * @throws Exception
	 */
	private String updateSignStatus( String xmlString, String actionCode, UserInfoBean userInfo ) throws ITMException, Exception
	{
		String responseStr = "";
		try 
		{
			String SIGN_ACTION = "1";
			String REJECT_ACTION = "2";
			String SAVE_ACTION = "3";
			String SIGN_CLOSE_ACTION = "4";
			String REVERT_ACTION = "5";
			
			String eventCode = "Workflow";
			if ( SIGN_ACTION.equals( actionCode ) ) 
			{
				eventCode = "SIGN_ACTION";
			} 
			else if ( SIGN_CLOSE_ACTION.equals( actionCode ) )  
			{
				eventCode = "SIGN_CLOSE_ACTION";
			}
			else if ( REVERT_ACTION.equals( actionCode ) )  
			{
				eventCode = "REVERT_ACTION";
			}
			else if ( REJECT_ACTION.equals( actionCode ) )  
			{
				eventCode = "REJECT_ACTION";
			}
			else if ( SAVE_ACTION.equals( actionCode ) )  
			{
				eventCode = "SAVE_ACTION";
			}
			SignManagerRemote signManager = (SignManagerRemote) getInitialContext().lookup("ibase/SignManagerEJB/remote");
			UserEventLogEJBLocal userEventLogEJB = (UserEventLogEJBLocal) getInitialContext().lookup("ibase/UserEventLogEJB/local");
			
			ArrayList<String> signDetailList = getSignDetailList( xmlString );		
			String objName = checkNull( signDetailList.get( 0 ) );
			String refSer = checkNull( signDetailList.get(1) );
			String refId = checkNull( signDetailList.get( 2 ) );
			String lineNo = checkNull( signDetailList.get( 3 ) );
			String userId = checkNull( signDetailList.get( 4 ) );
			String signRemarks = checkNull( signDetailList.get( 5 ) );
			String signStatus = checkNull( signDetailList.get( 6 ) );
			String siteCode = checkNull( signDetailList.get( 7 ) );
			String signReason = "";
			if(signDetailList.size() > 8)
			{
				signReason = checkNull( signDetailList.get( 8 ) );
			}
			Date startTime = new Date();
			String chgString = "";
			String signBy = "";
			if(userId.length() == 0)
			{
				userId = userInfo.getLoginCode();
			}
			if(siteCode.length() == 0)
			{
				siteCode = userInfo.getSiteCode();
			}
			if ( SIGN_ACTION.equals( actionCode ) || SIGN_CLOSE_ACTION.equals( actionCode ) || REVERT_ACTION.equals( actionCode ) || REJECT_ACTION.equals( actionCode ) )
			{
				StringTokenizer refIdST = new StringTokenizer( refId, "," );
				StringTokenizer lineNoST = new StringTokenizer( lineNo, ",");
				TreeMap<String, String> signStatusMap = new TreeMap<String, String>();
				while ( refIdST.hasMoreTokens() )
				{
					String refID = refIdST.nextToken();
					int lineNum = Integer.parseInt(lineNoST.nextToken().trim());
					responseStr = signManager.sign( lineNum, refID, refSer, objName, signStatus, userId, siteCode, signRemarks, chgString, userInfo.toString(), actionCode, signBy, signReason );
					System.out.println("response String1:"+responseStr);
					String eventResult = "Success";
				    if( responseStr.indexOf("<Errors>") != -1 )
					{
				      	eventResult = "Failure";
					}
				    
				    if( userEventLogEJB != null && userInfo != null )
				    {
				      	userEventLogEJB.setEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), "", eventCode, eventCode, startTime, new Date(), "" , refID, eventResult, "WF" );
				    }
					signStatusMap.put( refSer+"-"+refID, responseStr);
				}
				responseStr = multipleSignStatus( signStatusMap );
				System.out.println("response String2:"+responseStr);
			}
			else if( SAVE_ACTION.equals( actionCode ) )
			{
				responseStr = signManager.saveTrans( objName, refSer, refId, lineNo, chgString, userInfo.toString(), signRemarks, null );
				String eventResult = "Success";
			    if( responseStr.indexOf("<Errors>") != -1 )
				{
			      	eventResult = "Failure";
				}
			    if( userEventLogEJB != null && userInfo != null )
			    {
			      	userEventLogEJB.setEventLog( userInfo.getLoginCode(), objName, userInfo.getSesstionId(), "", eventCode, eventCode, startTime, new Date(), "" , refId, eventResult, "WF" );
			    }
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception: updateWrkFlwStatus :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("response String3:"+responseStr);
		return responseStr;
	}
	
	/**
	 * Get Sign details
	 * 
	 * @param signXMLStr
	 * @return
	 * @throws ITMException
	 */
	private ArrayList<String> getSignDetailList( String signXMLStr )throws ITMException
	{
		ArrayList<String> signDetailList = new ArrayList<String>();
		try
		{
			String signXML = genericUtility.getNormalizeString( signXMLStr );
			Document signDataDom = genericUtility.parseString( signXML );
			NodeList detailNodeList = signDataDom.getElementsByTagName("Detail");
			Node detailNode = detailNodeList.item(0);
			
			NodeList detailChildList = detailNode.getChildNodes();
			for(int dCtr = 0; dCtr < detailChildList.getLength(); dCtr++)
			{
				Node currChild = detailChildList.item(dCtr);
				if(!currChild.getNodeName().equalsIgnoreCase("attribute"))
				{
					if (currChild.getFirstChild() != null)
					{
						signDetailList.add( currChild.getFirstChild().getNodeValue() );
					}
					else
					{
						signDetailList.add( "" );
					}
				}
			}
		}
		catch (ITMException itme)
		{
			System.out.println("ITMException :getSignDetailList :==>"+ itme.getMessage());
			throw itme;
		}
		catch (Exception e)
		{
			System.out.println("Exception :getSignDetailList :==>"+ e.getMessage());
			throw new ITMException(e);
		}
		System.out.println( "signDetailList : "+ signDetailList );
		return signDetailList;
	}
	
	/**
	 * Return Treemap into string || Only One Transaction should get signed @ a time.
	 * input TreeMap : Due to display in accending order
	 * 
	 * @param signStatusMap
	 * @return
	 * @throws RemoteException
	 * @throws ITMException
	 */
	private String multipleSignStatus( TreeMap<String, String> signStatusMap)throws RemoteException, ITMException
	{	
		StringBuffer responseString = new StringBuffer();
		try
		{
			String str = "";
			System.out.println( "multipleSignStatus: signStatusMap - ["+ signStatusMap +"]" );
			responseString.append( "<?xml version='1.0'?><Root>" );
			Iterator<String> iterator = signStatusMap.keySet().iterator();
			while (iterator.hasNext())
			{	
				String refSerRefID = iterator.next();
				responseString.append( "<Detail id=\""+refSerRefID+"\">" );
				str = signStatusMap.get( refSerRefID ).toString();
				str = str.substring( str.indexOf(">") + 1, str.length() );
				responseString.append( str );
				responseString.append( "</Detail>" );
			}
			responseString.append( "</Root>" );
		}
		catch( Exception e)
		{
			System.out.println("Exception: multipleSignStatus:==>"+ e.getMessage());
			throw new ITMException(e);
		}
		System.out.println("multipleSignStatus - ["+ responseString.toString() +"]");
		return responseString.toString();
	}
	//Added by Prasad on 26/05/16 [Adding Workflow related options- T16CSUN001] END
	
	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] START
	/**
	 * Get attachment and write into ServletOutputStream
	 * 
	 * @param refId
	 * @param refSer
	 * @param docType
	 * @param response
	 * @return
	 */
	private String getAttachDocument( String refId, String refSer, String docType, HttpServletResponse response )
	{
		String result = "";
		try 
		{
			String resultXML = "";
			DocumentHandlerRemote docHandler = (DocumentHandlerRemote) getInitialContext().lookup("ibase/DocumentHandlerEJB/remote");
			if ( refId != null && refId.indexOf(",") != -1 )
			{
				resultXML = docHandler.getMultiDocumentInfoList( refSer, refId, "" );
			}
			else
			{
				resultXML = docHandler.getDocumentInfoList( refSer, refId, "" );
			}
			HashMap<String, String> docIdMap = getDocumentIds( resultXML, docType );
			
			if ( docIdMap.size() > 0 )
			{
				byte[] byteArray = null;
				int count = 0;
				for ( Map.Entry<String, String> docIdEntry : docIdMap.entrySet() )
				{
					String docId = checkNull( docIdEntry.getKey() );
					String fileName = checkNull( docIdEntry.getValue() );
					String fileType = "";
					if ( fileName.length() > 0 )
					{
						fileType = fileName.substring( fileName.lastIndexOf(".") + 1 );
					}
					System.out.println("docId - ["+ docId +"], fileName - ["+ fileName +"], fileType - ["+ fileType +"]");
					if ( count == 0 )
					{
						byteArray = docHandler.getDocument( docId );
						setContentType( fileName, fileType, response );
						ServletOutputStream outputStream = response.getOutputStream();
						outputStream.write( byteArray );
						outputStream.flush();
						outputStream.close();
						break;
					}
					count++;
				}
				response.setBufferSize( byteArray.length );
				result = "success";
			}
			else
			{
				result = "No Document attached.";
			}
		}
		catch (ITMException e) 
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		catch (RemoteException e) 
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		catch (NamingException e) 
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		catch (IOException e) 
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		
		return result;
	}
	
	/**
	 * Get document id from xmlstring 
	 * 
	 * @param xmlStr
	 * @param docType
	 * @return
	 * @throws ITMException
	 */
	private HashMap<String, String> getDocumentIds( String xmlStr, String docType ) throws ITMException 
	{
		HashMap<String, String> docIdMap = new LinkedHashMap<String, String>();
		try 
		{
			Node childNode = null;
			Node node = null;
			NodeList childList = null;
			docType = checkNull( docType );
			if( checkNull( xmlStr ).length() > 0 )
			{
				Document dom = genericUtility.parseString( xmlStr );
				NodeList nodeList = dom.getElementsByTagName( "ID" );
				for( int cnt = 0; cnt < nodeList.getLength(); cnt++ )
				{
					String docId = "";
					node = nodeList.item(cnt);
					if( node.hasAttributes() )
					{
						docId = node.getAttributes().getNamedItem("Document_Id").getNodeValue();
					}
					childList = node.getChildNodes();
					String attachDocType = "";
					String docName = "";
					for( int cnt1 = 0; cnt1 < childList.getLength() ; cnt1++ )
					{
						childNode = childList.item(cnt1);
						if( childNode.getNodeName().equalsIgnoreCase( "docTypeAttach" ) )
						{
							attachDocType = checkNull( childNode.getNodeValue() );
							if( childNode.getFirstChild() != null )
							{
								attachDocType = checkNull( childNode.getFirstChild().getNodeValue() );
							}
						}
						else if( childNode.getNodeName().equalsIgnoreCase( "Name" ) )
						{
							docName = checkNull( childNode.getNodeValue() );
							if( childNode.getFirstChild() != null )
							{
								docName = checkNull( childNode.getFirstChild().getNodeValue() );
							}
						}
					}
					System.out.println("attachDocType - ["+ attachDocType +"], docId - ["+ docId +"], docName - ["+ docName +"]");
					if ( docType.length() > 0 )
					{
						if ( attachDocType.length() > 0 && attachDocType.equals( docType ) )
						{
							docIdMap.put( docId, docName );
						}
					}
					else
					{
						docIdMap.put( docId, docName );
					}
				}
			}
			System.out.println("docIdMap - "+ docIdMap);
		}
		catch (DOMException e) 
		{
			e.printStackTrace();
		}
		return docIdMap;
	}
	
	/**
	 * Set Content Type as per file type
	 * 
	 * @param byteArray
	 * @param fileType
	 * @param response
	 */
	private void setContentType( String fileName, String fileType, HttpServletResponse response ) 
	{
		try 
		{
			response.setHeader( "Content-disposition", "filename = \"" + fileName + "\"");
			if(fileType.equalsIgnoreCase("pdf"))
			{
			    response.setContentType( "application/pdf; charset="+CommonConstants.ENCODING );
			}
			else if(fileType.equalsIgnoreCase("bmp"))
			{
				response.setContentType( "image/bmp" );
			}
			else if(fileType.equalsIgnoreCase("txt") || fileType.equalsIgnoreCase("dtd") || fileType.equalsIgnoreCase("java"))
			{
			    response.setContentType( "text/plain; charset="+CommonConstants.ENCODING );
			}
			else if(fileType.equalsIgnoreCase("html") || fileType.equalsIgnoreCase("htm"))
			{
			    response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("doc")  || fileType.equalsIgnoreCase("odt") )
			{
			    response.setContentType( "application/msword; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("xls"))
			{
			    response.setContentType( "application/msexcel; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("gif"))
			{
				response.setContentType( "image/gif" );
			}
			else if (fileType.equalsIgnoreCase("ai"))
			{
			    response.setContentType( "application/postscript; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("abs"))
			{
				response.setContentType( "audio/x-mpeg" );
			}
			else if (fileType.equalsIgnoreCase("bin") || fileType.equalsIgnoreCase("exe"))
			{
			    response.setContentType( "application/octet-stream; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("class"))
			{
			    response.setContentType( "application/java; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("jpe") || fileType.equalsIgnoreCase("jpg") || fileType.equalsIgnoreCase("jpeg"))
			{
				response.setContentType( "image/jpeg" );
			}
			else if (fileType.equalsIgnoreCase("mpg") || fileType.equalsIgnoreCase("mpeg"))
			{
				response.setContentType( "video/mpeg" );
			}
			else if (fileType.equalsIgnoreCase("pic") || fileType.equalsIgnoreCase("pict") || fileType.equalsIgnoreCase("pict"))
			{
				response.setContentType( "image/pict" );
			}
			else if (fileType.equalsIgnoreCase("aif") || fileType.equalsIgnoreCase("aifc") || fileType.equalsIgnoreCase("aiff") )
			{
				response.setContentType( "audio/x-aiff" );
			}
			else if (fileType.equalsIgnoreCase("aim"))
			{
				response.setContentType( "application/x-aim" );
			}
			else if (fileType.equalsIgnoreCase("art"))
			{
				response.setContentType( "image/x-jg" );
			}
			else if (fileType.equalsIgnoreCase("asf") || fileType.equalsIgnoreCase("asx"))
			{
				response.setContentType( "video/x-ms-asf" );
			}
			else if (fileType.equalsIgnoreCase("avi"))
			{
				response.setContentType( "video/x-msvideo" );
			}
			else if (fileType.equalsIgnoreCase("avx"))
			{
				response.setContentType( "video/x-rad-screenplay" );
			}
			else if (fileType.equalsIgnoreCase("body"))
			{
			    response.setContentType( "text/html; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("css"))
			{
			    response.setContentType( "text/css; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("dib"))
			{
				response.setContentType( "image/bmp" );
			}
			else if (fileType.equalsIgnoreCase("gz"))
			{
				response.setContentType( "application/x-gzip" );
			}
			else if (fileType.equalsIgnoreCase("jar"))
			{
				response.setContentType( "application/java-archive" );
			}
			else if (fileType.equalsIgnoreCase("js"))
			{
			    response.setContentType( "text/javascript; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("midi"))
			{
				response.setContentType( "audio/x-midi" );
			}
			else if (fileType.equalsIgnoreCase("rtf"))
			{
				response.setContentType( "application/rtf" );
			}
			else if (fileType.equalsIgnoreCase("rtx"))
			{
			    response.setContentType( "text/richtext; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("tif") || fileType.equalsIgnoreCase("tiff"))
			{
				response.setContentType( "image/tiff" );
			}
			else if (fileType.equalsIgnoreCase("xml") || fileType.equalsIgnoreCase("xsl"))
			{
			    response.setContentType( "text/xml; charset="+CommonConstants.ENCODING );
			}
			else if (fileType.equalsIgnoreCase("ppt"))
			{
				response.setContentType( "application/powerpoint" );
			}
			else if (fileType.equalsIgnoreCase("ppm"))
			{
				response.setContentType( "image/x-portable-pixmap" );
			}
			else if (fileType.equalsIgnoreCase("png"))
			{
				response.setContentType( "image/png" );
			}
			else if (fileType.equalsIgnoreCase("oda"))
			{
				response.setContentType( "application/oda" );
			}
			else if (fileType.equalsIgnoreCase("zip"))
			{
				response.setContentType( "application/zip" );
			}
			else
			{
			    response.setContentType( "application/octet-stream; charset="+CommonConstants.ENCODING );
			}
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
	}
	
	/**
	 * User Image write into ServletOutputStream if exist
	 *  
	 * @param response
	 * @return
	 */
	private String getUserImage( HttpServletResponse response )
	{
		String result = "";
		try 
		{
			String userId = "";
			if ( getUserInfo() != null ) 
			{
				userId = checkNull( getUserInfo().getLoginCode() );
			}
			if ( userId.length() > 0 )
			{
				String fileName = userId + ".png";
				String profileImagesPath = CommonConstants.APPLICATION_CONTEXT + "resource" + File.separator + "images" + File.separator + "users" + File.separator + fileName;
				File dir = new File( profileImagesPath );
				if( dir.exists() )
				{
					ServletOutputStream outputStream = response.getOutputStream();
					FileInputStream fis = new FileInputStream( profileImagesPath );
					byte[] buffer = new byte[(int) dir.length()];
					int length = 0;
					while ( (length = fis.read( buffer )) > 0 )
					{
						outputStream.write( buffer, 0, length );
					}
					fis.close();
					outputStream.flush();
					result = "success";
					response.setContentType( "image/png" );
					response.setBufferSize( buffer.length );
				}
				else
				{
					result = "User Image not found.";
				}
			}
			else
			{
				result = "Invalid User.";
			}
		}
		catch (FileNotFoundException e) 
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		catch (IOException e) 
		{
			e.printStackTrace();
			result = "Exception : "+ e.getMessage();
		}
		
		return result;
	}
	//Added by Prasad on 26/05/16 [Adding User Image and Attachment related options- T16DSUN001] END
	
	//Added by Prasad on 29/11/16 [for adding follow up actions] START
	/**
	 * Add follow up actions
	 * 
	 * @param userId
	 * @param editorId
	 * @param tranId
	 * @param objName
	 */
	private void addFollowUpAction( String userId, String editorId, String tranId, String objName, ServletContext context )
	{
		try 
		{
			String pendingWrkflwMapKey = userId + "~" + editorId;
			String pendingWrkflwMapValue = objName + "~" + tranId;
			Map<String, String> pendingWrkflwMap = new HashMap<String, String>();
			if ( context.getAttribute( "pendingWrkflwMap" ) != null )
			{
				pendingWrkflwMap = (Map<String, String>) context.getAttribute( "pendingWrkflwMap" );
				if ( pendingWrkflwMap != null )
				{
					pendingWrkflwMap.put( pendingWrkflwMapKey, pendingWrkflwMapValue );
				}
				AppConnectParm appConnect = new AppConnectParm();
				InitialContext ctx = new InitialContext( appConnect.getProperty() );
				E12FollowUpActionLocal followUpActionLocal = (E12FollowUpActionLocal) ctx.lookup( "ibase/E12FollowUpActionEJB/local" );
				followUpActionLocal.followUpAction( pendingWrkflwMapKey, context );
			}
			System.out.println("pendingWrkflwMap - "+ context.getAttribute( "pendingWrkflwMap" ));
		}
		catch (Exception e) 
		{
			System.out.println( "Exception - "+ e.getMessage() );
			e.printStackTrace();
		}
	}
	//Added by Prasad on 29/11/16 [for adding follow up actions] END
	
	//Added by Parikshit on 09/03/17 [to get employee details] START
	private String getEmployeeDtl( JSONObject resultDtlJson ) throws ITMException, NamingException  
	{
		try 
		{
			ExtServiceRemote extServices = (ExtServiceRemote) getInitialContext().lookup("ibase/ExtServiceEJB/remote");
			HashMap<String, String> resultMap = extServices.getEmployeeDetails( getUserInfo());

			if( resultMap.size() > 0 )
			{
				for ( Map.Entry<String, String> entry : resultMap.entrySet() )
				{
					resultDtlJson.put( entry.getKey(), entry.getValue() );
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception in getEmployeeDtl "+e.getMessage());
			e.printStackTrace();
		}
		System.out.println( "resultDtlJson-["+ resultDtlJson +"]" );
		return resultDtlJson.toString();
	}
	//Added by Parikshit on 09/03/17 [to get employee details] END
	
	//Changed by Prasad on 13/04/17 [to generate new tokenId] START
	/**
	 * get new tokenId after login successful
	 * 
	 * @param userCode
	 * @return
	 */
	private String generateNewTokenId( String userCode )
	{
		String tokenId = userCode + ":" + UUID.randomUUID().toString().toUpperCase();
		if ( tokenId.length() > 30 )
		{
			tokenId = tokenId.substring( 0, 30 );
		}
		return tokenId;
	}
	//Changed by Prasad on 13/04/17 [to generate new tokenId] END
	
	//Added by Umakanta Das on 05/MAY/2017 [ A16LSUN004 ] [ Receive request from third party mobile app and return Pay slip data with json format ]Start
	/**
	 * This method return Pay slip data with json format.
	 * 
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param dataFormat
	 * @param apiUrl
	 * @param token
	 * @param guid
	 * @param apIPwd
	 * @param imei
	 * @param appId
	 * @param projectName
	 * @return return Pay slip data with json format
	 * @throws BaseException
	 * @throws Exception
	 */
	@POST
	@Path("/getPaySlipData")
	@Produces(MediaType.APPLICATION_JSON)
	public Response getPaySlipDataClient( @FormParam("USERCODE") String userCode, @FormParam("PASSWORD") String password,
			@FormParam("ISPWDENCRYPT") String isPwdEncrypt, @FormParam("DATAFORMAT") String dataFormat,  @FormParam("URL") String apiUrl,
			@FormParam("TOKEN") String token, @FormParam("GUID") String guid,  @FormParam("APIPwd") String apIPwd, 
			@FormParam("IMEI") String imei, @FormParam("AppID") String appId, @FormParam("ProjectName") String projectName,
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		JSONObject responseJson = new JSONObject();
		JSONObject resultJson = new JSONObject();
		HashMap empInfoListMap = new HashMap();
		ConnDriver connDriver =  new ConnDriver();
		Connection conn = null; 
		PreparedStatement pStmt = null;
		ResultSet rst = null;
		String result = "";
		String params = "";
		String sql = "";
		try 
		{
			params = request.getQueryString();
			if ( checkNull( params ).length() == 0 )
			{
				StringBuffer paramString = new StringBuffer();
				paramString.append("USERCODE="+ userCode);
				paramString.append("&PASSWORD="+ password);
				paramString.append("&ISPWDENCRYPT="+ isPwdEncrypt);
				paramString.append("&DATAFORMAT="+ dataFormat);
				paramString.append("&URL="+ apiUrl);
				paramString.append("&Token="+ token);
				paramString.append("&APIPwd="+ apIPwd);
				paramString.append("&GUID="+ guid);
				paramString.append("&IMEI="+ imei);
				paramString.append("&AppID="+ appId);
				paramString.append("&ProjectName="+ projectName);
				params = paramString.toString();

			}
			System.out.println("params - " + params);
			if ( request.isSecure() )
			{
				userCode =   checkNull( userCode );
				password =  checkNull( password ) ;
				isPwdEncrypt = checkNull( isPwdEncrypt ).length() > 0 ? checkNull( isPwdEncrypt ) : "false";
				if ( "true".equalsIgnoreCase(isPwdEncrypt ) )
				{
					userCode =  decrypt( userCode );
					password = decrypt( password );
				}
				dataFormat = checkNull( dataFormat );
				apiUrl = checkNull( apiUrl );
				token = checkNull( token );
				apIPwd = checkNull( apIPwd );
				guid = checkNull( guid );
				imei = checkNull( imei );
				appId = checkNull( appId );
				projectName = checkNull( projectName );

				String isValidLogin = "false";

				if ( isValidDataFormat( dataFormat ) )
				{
					if ( userCode.length() > 0 )
					{
						conn = connDriver.getConnectDB( "DriverITM" );
						conn.setAutoCommit( false ); 
						isValidLogin = getAuthStatus( request, userCode, password, "", "I", "false" );
						if ( "VALID".equalsIgnoreCase( isValidLogin ) )
						{
							String empCode = "";
							String periodCode = "";
							String year = "";
							String mongth = "";
							String resStatus = "";
							String remarks = "";
							String empcodeDB = "";
							String deptDescr = "";
							String empName = "";
							String addr1 = "";
							String addr2 = "";
							String addr3 = "";
							String city = "";
							String curPin = "";
							String bnkName = "";
							String bnkAcNo = "";
							String empSite = "";
							String finentity = "";
							String prtSeq1 = "";
							String adCode1 = "";
							String lveCode = "";
							String logo = "";
							String desgn = "";
							String location = "";
							String status = "";
							String bankDet = "";
							String paytable = "";
							String grades = "";
							String cadre = "";
							String paysite = "";
							String panNo = "";
							String shDescr = "";
							String shDescr1 = "";
							String adCode = "";
							String prtSeq = "";
							String emppfno = "";
							String remark = "";
							String payMode = "";
							String headQtr = "";
							String periodDescr = "";
							String code = "";
							String propdays = "";
							

							int empCnt = 0;
							int empCntResign = 0;

							double amt = 0.0d;
							double amtBal1 = 0.0d;
							double avalidlve = 0.0d;
							double balLve = 0.0d;
							double workDays = 0.0d;
							double woffDays = 0.0d;
							double paidDays = 0.0d;
							double absdays = 0.0d;
							double totEarn = 0.0d;
							double totDedu = 0.0d;
							double netPaid = 0.0d;
							double mrndoff = 0.0d;
							double projAmt = 0.0d;
							double payAmt = 0.0d;
							double diffAmt = 0.0d;
							double totaldays = 0.0d;;
							double lwp = 0.0d;;

							request.getSession().setAttribute( "USER_INFO", getUserInfo() );
							JSONObject resultDtlJson = new JSONObject();
							resultDtlJson.put( "Token", token );
							try 
							{
								StringBuffer responseBuff = new StringBuffer();
								JSONObject paySlipServiceReqJson = new JSONObject();
								paySlipServiceReqJson.put( "Token", token );
								paySlipServiceReqJson.put( "APIPwd", apIPwd );
								paySlipServiceReqJson.put( "GUID", guid );
								paySlipServiceReqJson.put( "IMEI", imei );
								paySlipServiceReqJson.put( "AppID", appId );
								paySlipServiceReqJson.put( "ProjectName", projectName );
								URL url = new URL( apiUrl );
								HttpURLConnection urlConn = ( HttpURLConnection ) url.openConnection();
								urlConn.setRequestMethod("POST");
								urlConn.setDoInput(true);
								urlConn.setDoOutput(true);
								urlConn.setRequestProperty("Content-Type", "application/json");
								OutputStream outputStream = (urlConn.getOutputStream());
								outputStream.write( paySlipServiceReqJson.toString().getBytes() );
								outputStream.flush();  
								outputStream.close();  
								/*if (urlConn.getResponseCode() != 200)
									{
										throw new RuntimeException("Failed : HTTP error code : ["+ urlConn.getResponseCode()+"]");
									}*/
								BufferedReader br = new BufferedReader( new InputStreamReader( ( urlConn.getInputStream() ) ) );
								String output = "";
								System.out.println("Output from Server .... \n");
								while ( ( output = br.readLine() ) != null ) 
								{
									responseBuff.append( output );
								}
								JSONObject paySlipServiceResJson = new JSONObject( responseBuff.toString() );
								empCode = checkNull( paySlipServiceResJson.getJSONObject("d").getString("MetisCode") );
								year = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Year") );
								mongth = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Month") );
								periodCode = year+mongth;
								resStatus = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Status") );
								remarks = checkNull( paySlipServiceResJson.getJSONObject("d").getString("Remarks") );

								if ( urlConn != null )
								{
									urlConn.disconnect();
								}
							} 
							catch (MalformedURLException e)
							{
								e.printStackTrace();

							} 
							catch (IOException e)
							{
								e.printStackTrace();
							}

							if ( "Success".equalsIgnoreCase( resStatus ) )
							{
								if ( empCode.length() > 0 )
								{
									sql = " SELECT COUNT(*) AS EMP_COUNT FROM EMPLOYEE WHERE EMP_CODE = ? ";
									pStmt = conn.prepareStatement( sql );
									pStmt.setString( 1 , empCode );
									rst = pStmt.executeQuery();
									if( rst.next() )
									{
										empCnt = rst.getInt("EMP_COUNT");					
									}
									if ( rst != null )
									{
										rst.close();
										rst = null;
									}
									if ( pStmt != null )
									{
										pStmt.close();
										pStmt = null;
									}

									if ( empCnt > 0 )
									{
										sql = " SELECT COUNT(*) AS EMP_COUNT__RESIGN FROM EMPLOYEE WHERE EMP_CODE = ? AND RELIEVE_DATE IS NULL ";
										pStmt = conn.prepareStatement( sql );
										pStmt.setString( 1 , empCode );
										rst = pStmt.executeQuery();
										if( rst.next() )
										{
											empCntResign = rst.getInt("EMP_COUNT__RESIGN");					
										}
										if ( rst != null )
										{
											rst.close();
											rst = null;
										}
										if ( pStmt != null )
										{
											pStmt.close();
											pStmt = null;
										}

										if ( empCntResign > 0 )
										{
											sql = "";
											sql = " SELECT EMPLOYEE.EMP_CODE empcode,DEPARTMENT.SH_DESCR deptDescr,"//EMPLOYEE.EMP_CODE, "//EMP_CODE should be remove TODO
													+" EMPLOYEE.NAME_PREFIX || ' ' || TRIM(EMPLOYEE.EMP_FNAME) || ' ' || "
													+" TRIM(EMPLOYEE.EMP_MNAME) || ' ' || TRIM(EMPLOYEE.EMP_LNAME) "
													+" AS EMP_NAME,employee.cur_add1 addr1, employee.cur_add2 addr2, "
													+" NVL(employee.cur_add3,'') addr3,EMPLOYEE.CUR_CITY city,"
													+" EMPLOYEE.CUR_PIN pin,STATE.DESCR state, "
													+" BANK.BANK_NAME bnkName,EMPLOYEE.BANK_ACCT bnkAcNo,PAYROLL.SITE_CODE__WORK empSite, "
													+" SITE.FIN_ENTITY finentity, "
													+" (select VAR_VALUE from payrparm where var_name = 'LOGO_PATH' AND PRD_CODE =	'999999') || trim(SITE.FIN_ENTITY)||'.gif' AS LOGO, " 
													+" PAYROLL.WORK_DAYS workdays, PAYROLL.PAID_DAYS paiddays,PAYROLL.WOFF_DAYS woffdays,PAYROLL.ABS_DAYS absdays,"
													+" PAYROLL.REMARKS remarks,EMPLOYEE.PAY_MODE payMode,PAYROLL.DESIGNATION desgn,"
													+" STATION.DESCR HQ,PERIOD.DESCR periodDescr, PERIOD.code,GENCODES.descr location, "
													+" (case when EMPLOYEE.CONFIRMED = 'Y' then 'CONFIRMED' when EMPLOYEE.PROBATION = 'Y' then 'PROBATION' else 'TRAINEE' end) status, "
													+" ddf_company_pf(payroll.site_code__pay,employee.pf_no) AS emppfno, "
													+" ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','EARN')) AS as_mtot_earn, "
													+" ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','DEDN')) AS as_mtot_dedu, "
													+" ddf_payslip_payroll( ? , employee.emp_code, HRAPPL_GET_ENV('999999','NETWR')) AS as_mnetpaid, "														
													+" ddf_payslip_payroll( ? ,employee.emp_code,HRAPPL_GET_ENV('999999','RNDOFF_AD')) AS as_mrndoff, "
													+" ddf_bank_details(employee.emp_code,payroll.voucher_no) AS as_bank_det, "
													+" PAYROLL.PAY_TABLE AS as_paytable,PAYROLL.grade AS as_grades,PAYROLL.cadre AS as_cadre, "
													+" PAYROLL.SITE_CODE__WORK AS as_paysite, "
													+" employee.it_no AS PAN_NO "
													+" FROM PERIOD,EMPLOYEE,PAYROLL,DEPARTMENT,SITE,BANK,STATE,STATION,GENCODES "
													+" WHERE PAYROLL.PRD_CODE = PERIOD.CODE "
													+" AND PAYROLL.EMP_CODE = EMPLOYEE.EMP_CODE "
													+" AND department.dept_code(+) = payroll.dept_code "
													+" AND site.site_code = payroll.site_code__pay "
													+" AND bank.bank_code(+) = employee.bank_code "
													+" AND state.state_code(+) = employee.cur_state "
													+" AND station.stan_code(+) = employee.stan_code__hq "
													+" AND PERIOD.CODE = ? "
													+" AND EMPLOYEE.EMP_CODE = ? "
													+" AND PAYROLL.VOUCHER_NO IS NOT NULL "
													+" AND gencodes.fld_name(+) = 'GEO_LOC' "
													+" AND gencodes.mod_name(+) = 'X' "
													+" AND gencodes.fld_value(+) = site.geo_loc ";
											//" AND ddf_hr_sal_bonus_display( $P{as_empcode},$P{as_sal_period},$P{as_user_id},'SSEMP' ) = 'Y' ";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , periodCode );
											pStmt.setString( 3 , periodCode );
											pStmt.setString( 4 , periodCode );
											pStmt.setString( 5 , periodCode );
											pStmt.setString( 6 , empCode );
											rst = pStmt.executeQuery();
											if ( rst.next() )
											{
												empcodeDB = checkNull( rst.getString("empcode") );
												deptDescr = checkNull( rst.getString("deptDescr") );
												empName = checkNull( rst.getString("EMP_NAME") );
												addr1 = checkNull( rst.getString("addr1") );
												addr2 = checkNull( rst.getString("addr2") );
												addr3 = checkNull( rst.getString("addr3") );
												city = checkNull( rst.getString("city") );
												curPin = checkNull( rst.getString("pin") );
												bnkName = checkNull( rst.getString("bnkName") );
												bnkAcNo = checkNull( rst.getString("bnkAcNo") );
												empSite = checkNull( rst.getString("empSite") );
												finentity = checkNull( rst.getString("finentity") );								
												logo = checkNull( rst.getString("LOGO") );
												workDays =  rst.getDouble("workdays");
												paidDays =  rst.getDouble("paiddays");
												woffDays =  rst.getDouble("woffdays");
												absdays =  rst.getDouble("absdays");
												remark = checkNull( rst.getString("remarks") );
												payMode = checkNull( rst.getString("payMode") );
												desgn = checkNull( rst.getString("desgn") );
												headQtr = checkNull( rst.getString("HQ") );
												periodDescr = checkNull( rst.getString("periodDescr") );
												code = checkNull( rst.getString("code") );
												location = checkNull( rst.getString("location") );
												status = checkNull( rst.getString("status") );
												emppfno =  checkNull( rst.getString("emppfno") );
												totEarn = rst.getDouble("as_mtot_earn");
												totDedu = rst.getDouble("as_mtot_dedu");
												netPaid = rst.getDouble("as_mnetpaid");
												mrndoff =  rst.getDouble("as_mrndoff");
												bankDet = checkNull( rst.getString("as_bank_det") );
												paytable = checkNull( rst.getString("as_paytable") );
												grades = checkNull( rst.getString("as_grades") );
												cadre = checkNull( rst.getString("as_cadre") );
												paysite = checkNull( rst.getString("as_paysite") );
												panNo = checkNull( rst.getString("PAN_NO") );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											//Modified by Umakanta Das on 06-JUN-2017[]Start
											Attd_eSalarySlip attdeSalarySlip = new Attd_eSalarySlip();
											propdays = checkNull( attdeSalarySlip.getPropDays( periodCode, "Y", empCode, paytable, grades, cadre, paysite  ) );
											totaldays = Double.parseDouble( propdays );
											//Modified by Umakanta Das on 06-JUN-2017[]Start
											lwp = totaldays - paidDays;
											//empInfoListMap.put( "Token", token );
											empInfoListMap.put( "EMP_CODE", empcodeDB );
											empInfoListMap.put( "DEPT_DESCR", deptDescr );
											empInfoListMap.put( "EMP_NAME", empName );
											empInfoListMap.put( "ADDR1", addr1 );
											empInfoListMap.put( "ADDR2", addr2 );
											empInfoListMap.put( "ADDR3", addr3 );
											empInfoListMap.put( "CITY", city );
											empInfoListMap.put( "PIN", curPin );
											empInfoListMap.put( "BNK_NAME", bnkName );
											empInfoListMap.put( "BNK_AC__NO", bnkAcNo );
											empInfoListMap.put( "EMP_SITE", empSite );
											empInfoListMap.put( "FINENTITY", finentity );
											empInfoListMap.put( "LOGO", logo );
											empInfoListMap.put( "WORK_DAYS", workDays );
											empInfoListMap.put( "PAID_DAYS", paidDays );
											empInfoListMap.put( "WOFF_DAYS", woffDays );
											empInfoListMap.put( "ABS_DAYS", absdays );
											//Modified by Umakanta Das on 06-JUN-2017[]Start
											empInfoListMap.put( "TOTAL_DAYS", totaldays );
											empInfoListMap.put( "LWP", lwp );
											//Modified by Umakanta Das on 06-JUN-2017[]End
											empInfoListMap.put( "REMARK", remark );
											empInfoListMap.put( "PAY_MODE", payMode );
											empInfoListMap.put( "DESGN", desgn );
											empInfoListMap.put( "HQ", headQtr );
											empInfoListMap.put( "PERIOD_DESCR", periodDescr );
											empInfoListMap.put( "CODE", code );
											empInfoListMap.put( "LOCATION", location );
											empInfoListMap.put( "STATUS", status );
											empInfoListMap.put( "EMP_PF__NO", emppfno );
											empInfoListMap.put( "MRND_OFF", mrndoff );
											empInfoListMap.put( "BANK_DET", bankDet );
											empInfoListMap.put( "PAY_TABLE", paytable );
											empInfoListMap.put( "GRADES", grades );
											empInfoListMap.put( "CADRE", cadre );
											empInfoListMap.put( "PAY_SITE", paysite );
											empInfoListMap.put( "PAN_NO", panNo );

											resultDtlJson.put( "EMPLOYEE_INFO", empInfoListMap );
											resultDtlJson.put( "TOTAL_EARNINGS", totEarn );
											resultDtlJson.put( "TOTAL_DEDUCATION", totDedu );
											resultDtlJson.put( "NET_PAID", netPaid );

											ArrayList deductionList = new ArrayList();
											sql = "";
											sql = " SELECT ALLWDEDN.SH_DESCR sh_descr,PAYARR_DET.AMOUNT amt,ALLWDEDN.PRT_SEQ prt1_seq,ALLWDEDN.AD_CODE ad1_code, "
													+" PAYARR_DET.AMT_BAL amt1_bal "
													+" FROM PAYARR_DET,ALLWDEDN "
													+" WHERE ALLWDEDN.AD_CODE = PAYARR_DET.AD_CODE "
													+" AND payarr_det.prd_code = ? "
													+" AND payarr_det.emp_code = ? "
													+" AND payarr_det.payable = 'D' AND payarr_det.amount != 0 AND payarr_det.ad_code != 'ROFF' "
													+" ORDER BY prt1_seq,sh_descr ";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , empCode );
											rst = pStmt.executeQuery();
											while ( rst.next() )
											{
												shDescr = checkNull( rst.getString("sh_descr") );
												amt = rst.getDouble("amt"); 
												prtSeq1 = checkNull( rst.getString("prt1_seq") );
												adCode1 = checkNull( rst.getString("ad1_code") );
												amtBal1 = rst.getDouble("amt1_bal");
												HashMap deductionMap = new HashMap();
												deductionMap.put( "SH_DESCR__DEDN", shDescr );
												deductionMap.put( "AMT__DEDN", amt );
												deductionMap.put( "PRT_SEQ__DEDN", prtSeq1 );
												deductionMap.put( "AD_CODE__DEDN", adCode1 );
												deductionMap.put( "AMT_BAL_DEDN", amtBal1 );

												deductionList.add( deductionMap );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											resultDtlJson.put( "DEDUCTION_INFO", deductionList );
											ArrayList leaveList = new ArrayList();
											sql = "";
											sql = " SELECT REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 1) lve_code, "
													+" REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 2) AVAILED_LVE, "
													+" REGEXP_SUBSTR(t.LVE_DETAIL, '[^ ]+', 1, 3) BAL_LVE "
													+" FROM (SELECT REPLACE(TRIM(LVE_DET) ,'-',' ') LVE_DETAIL "
													+" FROM (select regexp_substr(m.lve_cols,'[^, ]+',1,level) as LVE_DET "
													+" from (SELECT REPLACE(TRIM(lve_DESC) ,'*',' ') lve_cols "
													+" FROM (SELECT REPLACE(TRIM(lve_code) ,'>','') lve_desc "
													+" FROM (SELECT REPLACE(TRIM(LVE_DET) ,'<','') lve_code "
													+" FROM (select regexp_substr(my.str,'[^,]+',1,level) as LVE_DET "
													+" from (SELECT fn_r_get_lve_descr( ? , ?, ?, ? ) as str FROM DUAL) "
													+" my connect by level <= length(regexp_replace(TRIM(my.str),'[^, ]+')) + 1)))) "
													+" m connect by level <= length(regexp_replace(m.lve_cols,'[^, ]+')) + 1))T"; 
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , empCode );
											pStmt.setString( 3 , empSite );
											pStmt.setString( 4 , userCode );
											rst = pStmt.executeQuery();
											while ( rst.next() )
											{
												lveCode = checkNull( rst.getString("lve_code") );
												avalidlve = rst.getDouble("AVAILED_LVE"); 
												balLve =  rst.getDouble("BAL_LVE") ;
												HashMap leaveMap = new HashMap();
												leaveMap.put( "LVE_CODE", lveCode );
												leaveMap.put( "AVALID_LVE", avalidlve );
												leaveMap.put( "BAL_LVE", balLve );

												leaveList.add( leaveMap );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											resultDtlJson.put( "LEAVE_INFO", leaveList );
											ArrayList arrearList = new ArrayList();
											sql = "";
											sql = " SELECT SUM(PROJ_AMT) AS PROJ_AMT,sh_descr,ad_code,SUM(pay_amt) AS PAY_AMT,SUM(diff_amt) AS DIFF_AMT,prt_seq "
													+" FROM ( "
													+" SELECT (case nvl(allwdedn.print_opt,'M') when 'M' then payroll_projdet.amount "
													+"  else round(payroll_projdet.amount / payroll_projhdr.paid_days,2) end) AS PROJ_AMT, "
													+" allwdedn.sh_descr AS SH_DESCR,payroll_projdet.ad_code AS AD_CODE,0 AS PAY_AMT,0 AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ "
													+" FROM payroll_projdet,allwdedn,payroll_projhdr "
													+" WHERE allwdedn.ad_code = payroll_projdet.ad_code "
													+" AND payroll_projhdr.prd_code = payroll_projdet.prd_code "
													+" AND payroll_projhdr.emp_code = payroll_projdet.emp_code "
													+" AND payroll_projdet.prd_code = ? "
													+" AND payroll_projdet.emp_code = ? "
													+" AND payroll_projdet.payable = 'A' "
													+" UNION ALL "
													+" SELECT 0 AS PROJ_AMT,allwdedn.sh_descr AS SH_DESCR,PAYROLLDET.ad_code AS AD_CODE,payrolldet.amount AS PAY_AMT, "
													+" 0 AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ "
													+" FROM payrolldet,allwdedn "
													+" WHERE allwdedn.ad_code = PAYROLLDET.ad_code "
													+" AND PAYROLLDET.prd_code = ? "
													+" AND PAYROLLDET.emp_code = ? "
													+" AND PAYROLLDET.payable = 'A' "
													+" UNION ALL "
													+" SELECT 0 AS PROJ_AMT,allwdedn.sh_descr AS SH_DESCR,arreardet.ad_code AS AD_CODE,0 AS PAY_AMT, "
													+" arreardet.diff_amt AS DIFF_AMT,allwdedn.prt_seq AS PRT_SEQ "
													+" FROM arreardet,allwdedn,arrears "
													+" WHERE allwdedn.ad_code = arreardet.ad_code "
													+" AND arrears.prd_code = arreardet.prd_code "
													+" AND arrears.emp_code = arreardet.emp_code "
													+" AND arrears.prd_code__acc = arreardet.prd_code__acc "
													+" AND arrears.voucher_no IS NOT NULL "
													+" AND arreardet.prd_code__acc = ? "
													+" AND arreardet.emp_code = ? "
													+" AND arreardet.payable = 'A' "
													+" ) "
													+" GROUP BY sh_descr,ad_code,prt_seq "
													+" HAVING SUM(proj_amt) != 0 OR SUM(diff_amt) != 0 OR SUM(pay_amt) != 0 "
													+" ORDER BY prt_seq,sh_descr";
											pStmt = conn.prepareStatement( sql );
											pStmt.setString( 1 , periodCode );
											pStmt.setString( 2 , empCode );
											pStmt.setString( 3 , periodCode );
											pStmt.setString( 4 , empCode );
											pStmt.setString( 5 , periodCode );
											pStmt.setString( 6 , empCode );
											rst = pStmt.executeQuery();
											while ( rst.next() )
											{
												projAmt = rst.getDouble("PROJ_AMT");
												shDescr1 = checkNull( rst.getString("sh_descr") ); 
												adCode =  checkNull( rst.getString("ad_code") ); 
												payAmt =  rst.getDouble("PAY_AMT");
												diffAmt =  rst.getDouble("DIFF_AMT");
												prtSeq =  checkNull( rst.getString("prt_seq") );
												HashMap arrearMap = new HashMap();
												arrearMap.put( "PROJ_AMT", projAmt );
												arrearMap.put( "SH_DESCR1", shDescr1 );
												arrearMap.put( "AD_CODE", adCode );
												arrearMap.put( "PAY_AMT", payAmt );
												arrearMap.put( "DIFF_AMT", diffAmt );
												arrearMap.put( "PRT_SEQ", prtSeq );

												arrearList.add( arrearMap );
											}
											if ( rst != null )
											{
												rst.close();
												rst = null;
											}
											if ( pStmt != null )
											{
												pStmt.close();
												pStmt = null;
											}
											
											resultDtlJson.put( "EARNINGS_INFO", arrearList );
											result = resultDtlJson.toString();
											if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
											{
												result = genericUtility.jsonToXMLString( result );
											}

											resultJson.put( "Status", "success" );
											resultJson.put( "Remarks", "success" );
										}
										else
										{
											result = "Employee already resigned.";
											resultJson.put( "Status", "Failure" );
											resultJson.put( "Remarks", "Employee already resigned." );
										}
									}
									else
									{
										resultJson.put( "Status", "Failure" );
										result = "Employee code does not exist in employee master";
										resultJson.put( "Remarks", "Employee code does not exist in employee master." );
									}
								}
								else
								{
									resultJson.put( "Status", "Failure" );
									resultJson.put( "Remarks", "Employee code can not be blank." );
									result = "Employee code can not be blank";
								}
							}
							else
							{
								result = remarks;
								resultJson.put( "Status", "Failure" );
								resultJson.put( "Remarks", remarks ); 
							}
						}
						else
						{
							result = isValidLogin;
							resultJson.put( "Status", "Failure" );
							resultJson.put( "Remarks", isValidLogin );
						}
					}
					else
					{
						result = "Please enter username.";
						resultJson.put( "Status", "Failure" );
						resultJson.put( "Remarks", "Please enter username." );
					}
				}
				else
				{
					result = "Please enter valid Data Format.";
					resultJson.put( "Status", "Failure" );
					resultJson.put( "Remarks", "Please enter valid Data Format." );
				}
			}
			else
			{
				result = "This option is only available with 'Https'.";
				resultJson.put( "Status", "Failure" );
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception : authenticateUser : "+ e.getMessage() );
			resultJson.put( "Status", "Failure" );
			resultJson.put( "Remarks", "Something went wrong." );
			result = getStackTrace(e);
		}
		finally
		{
			if ( conn != null )
			{
				if ( rst != null )
				{
					rst.close();
					rst = null;
				}
				if ( pStmt != null )
				{
					pStmt.close();
					pStmt = null;
				}
				conn.close();
				conn = null;
			}
			result = checkNull( result );
			if ( result.indexOf( "<Errors>" ) != -1 )
			{
				resultJson.put( "Status", "Failure" );
				resultJson.put( "Remarks", "Something went wrong." );
			}
			else if ( result.indexOf( "Exception" ) != -1 )
			{
				resultJson.put( "Status", "Failure" );
				resultJson.put( "Remarks", "Something went wrong." );
			}
			String responseType = ""+ resultJson.get( "Status" );
			try 
			{
				String logResult = generateExtServiceLog( request, "", "getPaySlipData", params, responseType, result, getUserInfo() );
				System.out.println("logResult - ["+ logResult +"]");
			}
			catch (Exception e) 
			{
				e.printStackTrace();
			}
			resultJson.put( "results", result );
			responseJson.put( "Response", resultJson );
			result = responseJson.toString();
			if ( ! "JSON".equalsIgnoreCase( dataFormat ) )
			{
				result = genericUtility.jsonToXMLString( result );
				result = genericUtility.remAllXmlDec( result );
			}
		}
		return Response.status(200).entity( result ).build();
	}
	//Added by Umakanta Das on 05-MAY-2017 [ A16LSUN004 ] [ To decript data as per encrypted data on mobile app.]Start
	/**
	 * This Metod returns decrypt value.
	 * @param CIPHER_TEXT
	 * @return decrypt value
	 */
	private  String  decrypt( String CIPHER_TEXT )
	{
		String IV =   "07000000000000000000000000000008";
		String SALT = "07000000000000000000000000000008";
		int KEY_SIZE = 128;
		int ITERATION_COUNT = 10000;
		String PASSPHRASE = "sunpharmametis";
		String decrypt = decrypt(SALT, IV, PASSPHRASE, CIPHER_TEXT, ITERATION_COUNT, KEY_SIZE );
		return decrypt;
	}

	private String decrypt( String salt, String iv, String passphrase, String ciphertext, int iterationCount, int keySize ) 
	{
		try 
		{
			SecretKey key = generateKey( salt, passphrase , iterationCount, keySize );
			byte[] decrypted = doFinal( Cipher.DECRYPT_MODE, key, iv, base64(ciphertext) );
			return new String(decrypted, "UTF-8");
		}
		catch ( UnsupportedEncodingException e ) 
		{
			throw fail(e);
		}
	}

	private SecretKey generateKey( String salt, String passphrase, int iterationCount, int keySize )
	{
		try
		{
			SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
			KeySpec spec = new PBEKeySpec(passphrase.toCharArray(), hex(salt), iterationCount, keySize);
			SecretKey key = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
			return key;
		}
		catch (Exception e) 
		{
			e.printStackTrace();
			return null;
		}
	}

	public static byte[] base64(String str) 
	{
		return DatatypeConverter.parseBase64Binary(str);
	}

	public static String hex(byte[] bytes) 
	{
		return DatatypeConverter.printHexBinary(bytes);
	}

	public static byte[] hex(String str) 
	{
		return DatatypeConverter.parseHexBinary(str);
	}

	private IllegalStateException fail(Exception e) 
	{
		return new IllegalStateException(e);
	}

	private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes)
	{
		try 
		{
			Cipher cipher;

			cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
			cipher.init(encryptMode, key, new IvParameterSpec(hex(iv)));
			return cipher.doFinal(bytes);

		}
		catch (Exception e) {
			e.printStackTrace();
			throw fail(e);
		}
	}
	//Added by Umakanta Das on 05-MAY-2017 [ A16LSUN004 ] [ To decript data as per encrypted data on mobile app.]End
	//Added by Umakanta Das on 05/MAY/2017 [ A16LSUN004 ] [ Receive request from third party mobile app and return Pay slip data with json format ]End
}