package proteus.ecm.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.json.JSONException;
import org.json.JSONObject;

import ibase.utility.BaseException;
import ibase.utility.UserInfoBean;
import proteus.ecm.cache.CacheManager;
import proteus.ecm.cache.bean.ECMUserTracker;
import proteus.ecm.cache.dao.CategoryCache;
import proteus.ecm.cache.dao.ProductCache;
import proteus.ecm.cache.dao.UserActivityCache;
import proteus.ecm.hibernate.bean.ECMItemRating;
import proteus.ecm.hibernate.bean.EntityAddress;
import proteus.ecm.hibernate.bean.EntityPayMethod;
import proteus.ecm.hibernate.bean.ItemDetails;
import proteus.ecm.hibernate.bean.ItemMaster;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.bean.UserProfile;
import proteus.ecm.hibernate.dao.CategoryDAO;
import proteus.ecm.hibernate.dao.ProductDAO;
import proteus.ecm.hibernate.dao.UserActivityDAO;

@Path("/feeds/{siteCode}")
public class UserActivityService {
	
	String successResponse = "{\"message\": \"Added / Deleted / Updated successfully.\", \"status\": \"Success\" } ";
	
	@Context
	HttpServletRequest request; // The proxy of Request will be injected into this singleton
	UserActivityCache userActivityCache = new UserActivityCache();
	CategoryCache categoryCache = new CategoryCache();
	ProductCache productCache = new ProductCache();
	
	private CategoryDAO categoryDao = new CategoryDAO();	
	private UserActivityDAO userDAO = new UserActivityDAO();
	private ProductDAO productDao = new ProductDAO();
	
	@PathParam("siteCode") String siteCode;
	
	@GET
	@Path("/cart")
	@Produces({ "application/json" })
	public List<ItemDetails> getCartItems() {
		List<ItemDetails> items = null;
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
		ECMUserTracker userBean = userActivityCache.getCachedUserData(uniqueId, cacheName);
		if( userBean != null ){
			Map<String, String> cartMap = userBean.getCartProducts();
			System.out.println("Inside getCartItem > cartMap >" + cartMap );
			items = categoryCache.getCachedItemsDetail( new ArrayList<String>(userBean.getCartProducts().keySet()), cacheName );
			System.out.println("B4 getCartItem > items >" + items);
			
			if(items != null)
			{
				for (ItemDetails itemMaster : items) 
				{
					String ic = itemMaster.getItemCode();
					String quantity = cartMap.get(ic);
					itemMaster.setItemQuantity(quantity);
				}
			}
		}
		
		System.out.println("Inside getCartItem > items >" + items);
		return items;
	}

	@POST
	@Path("/cart")
	@Produces({ "application/json" })
	@Consumes({ "application/json" })
	public Response addCartItem(String cartData) throws JSONException {
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
//		String siteCode = getSiteCode();
		ItemDetails itemDetail ;
		
		
        JSONObject RequestData = new JSONObject(cartData);
		
        System.out.println(cartData);
        
		String itemCode = RequestData.getString("itemCode");
		String quantity = RequestData.getString("itemQuantity");
		
		//Check User (Guest/Authorised)
		HttpSession session = request.getSession();
		Object userObj = session.getAttribute( "USER_INFO" ); //Chitra
		if(userObj != null)
		{
			userDAO.insertOrUpdate(uniqueId, siteCode, itemCode, UserActivityDAO.ADD_CART, quantity, null);
		}
		userActivityCache.storeCartItem(itemCode, quantity, uniqueId, cacheName);
		
		itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
		if (itemDetail == null) 
		{
			System.out.println("\n Prepare ItemDetails for " + itemCode);
			productDao.prepareItemDetails(cacheName, siteCode, itemCode);
			
			itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
			
			String itemRatings = productDao.getRatingDetails(siteCode, itemCode);
			itemDetail.setItemRatings(itemRatings);
		}
		itemDetail.setItemQuantity(quantity);
		
		return Response.status(200).entity(itemDetail).build();
	}

	@DELETE
	@Path("/cart/{itemCode}")
	@Produces({ "application/json" })
	public Response removeCartItem(@PathParam("itemCode") String itemCode) {
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
//		String siteCode = getSiteCode();
		ItemDetails itemDetail = new ItemDetails();
		
		//Check User (Guest/Authorised)
		HttpSession session = request.getSession();
		Object userObj = session.getAttribute( "USER_INFO" ); //chitra
		if(userObj != null)
		{
			userDAO.deleteUserData(uniqueId, siteCode, itemCode, UserActivityDAO.ADD_CART);
		}
		userActivityCache.removeCartItem(itemCode, uniqueId, cacheName);
		
		itemDetail.setItemCode(itemCode);
		
		return Response.status(200).entity(itemDetail).build();
	}
	
	@DELETE
	@Path("/cart")
	@Produces({ "application/json" })
	public Response removeCartItem() {
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();

		userActivityCache.removeCartItem("ALL", uniqueId, cacheName);

		return Response.status(200).entity(successResponse).build();
	}

	@GET
	@Path("/recentview")
	@Produces({ "application/json" })
	public List<ItemDetails> getRecentViewItems() {
		
		List<ItemDetails> items = null;
		
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
		ECMUserTracker userBean = userActivityCache.getCachedUserData(uniqueId, cacheName);
		        
		if( userBean != null ){
			Map<String, String> cartMap = userBean.getCartProducts();
			System.out.println("Inside getRecentView > cartMap >" + cartMap );
			items = categoryCache.getCachedItemsDetail( new ArrayList<String>(userBean.getBrowsedProducts().keySet()), cacheName );
			System.out.println("B4 getRecentView > items >" + items);
			
			if(items != null)
			{
				for (ItemDetails itemMaster : items) 
				{
					String ic = itemMaster.getItemCode();
				}
			}
		}
		
		System.out.println("Inside getRecentViewItems > items >" + items);
		return items;
	}
	
	@POST
	@Path("/recentview/{itemCode}")
	@Produces({ "application/json" })
	public Response storeRecentViewItem(@PathParam("itemCode") String itemCode) {

		System.out.println("Inside RecentView Post Method");
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
//		String siteCode = getSiteCode();
		
		String extraDetails = ""; //TODO
		
		//Check User (Guest/Authorised)
		HttpSession session = request.getSession();
		Object userObj = session.getAttribute( "USER_INFO" ); //chitra
		Date activityDate = new Date();
		if(userObj != null)
		{
			userDAO.insertOrUpdate(uniqueId, siteCode, itemCode, UserActivityDAO.RECENT_VIEW, extraDetails, activityDate);
		}
		
		userActivityCache.storeRecentViewItem(itemCode, activityDate, cacheName, uniqueId);
        
		return Response.status(200).entity(successResponse).build();
	}

	@GET
	@Path("/wishlist")
	@Produces({ "application/json" })
	public List<ItemDetails> getWishlistItems() {
		
		List<ItemDetails> items = null;
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
		ECMUserTracker userBean = userActivityCache.getCachedUserData(uniqueId, cacheName);
		if( userBean != null ){
			Map<String, String> wishlistMap = userBean.getCartProducts();
			System.out.println("Inside getWishlistItem > wishlistMap >" + wishlistMap );
			items = categoryCache.getCachedItemsDetail( new ArrayList<String>(userBean.getWishlistedProducts().keySet()), cacheName );
			System.out.println("B4 getWishlistItem > items >" + items);
			
			if(items != null)
			{
				for (ItemDetails itemMaster : items) 
				{
					String ic = itemMaster.getItemCode();
				}
			}
		}
		System.out.println("Inside getWishlistItems > items >" + items);
		return items;
	}
	
	@POST
	@Path("/wishlist/{itemCode}")
	@Produces({ "application/json" })
	public Response storeWishlistItem(@PathParam("itemCode") String itemCode) {

		System.out.println("Inside Wishlist Post Method");
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
		
//		String siteCode = getSiteCode();
		
		String extraDetails = ""; //TODO
		
		//Check User (Guest/Authorised)
		HttpSession session = request.getSession();
		Object userObj = session.getAttribute( "USER_INFO" ); //chitra 
		if(userObj != null)
		{
			userDAO.insertOrUpdate(uniqueId, siteCode, itemCode, UserActivityDAO.WISHLIST, extraDetails, null);
		}
		
		userActivityCache.storeWishlistItem(itemCode, extraDetails, cacheName, uniqueId);

		return Response.status(200).entity(successResponse).build();
	}
	
	@DELETE
	@Path("/wishlist/{itemCode}")
	@Produces({ "application/json" })
	public Response removeWishlistItem(@PathParam("itemCode") String itemCode) {
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
//		String siteCode = getSiteCode();
		
		//Check User (Guest/Authorised)
		HttpSession session = request.getSession();
		Object userObj = session.getAttribute( "USER_INFO" ); //chitra 
		if(userObj != null)
		{
			userDAO.deleteUserData(uniqueId, siteCode, itemCode, UserActivityDAO.WISHLIST);
		}
		
		userActivityCache.removeWishlistItem(itemCode, uniqueId, cacheName);

		return Response.status(200).entity(successResponse).build();
	}
	
	@DELETE
	@Path("/wishlist")
	@Produces({ "application/json" })
	public Response clearWishlist() {
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();

		userActivityCache.removeWishlistItem("ALL", uniqueId, cacheName);

		return Response.status(200).entity(successResponse).build();
	}
	
	@POST
	@Path("/update/likes/{itemCode}")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response updateLikes(@PathParam("itemCode") String itemCode, String data) throws JSONException {
		
        JSONObject RequestData = new JSONObject(data);
        System.out.println(RequestData);
        
//        String siteCode = getSiteCode();
        String reviewBy = RequestData.getString("userId");
        String usefulCnt = RequestData.getString("productUsfulCnt");
        String notUsefulCnt = RequestData.getString("productNotUsfulCnt");
        
        userDAO.updateLikes(itemCode, siteCode, reviewBy, usefulCnt, notUsefulCnt);
        return Response.status(200).entity(successResponse).build();
	}
	
	@POST
	@Path("/userdata")
	@Produces({ "application/xml", "application/json" })
	public Response fetchUserData(){
		UserActivityDAO userData = new UserActivityDAO();
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
//        String siteCode = getSiteCode();
        System.out.println("User Name from session:["+uniqueId+"]");
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        
        userData.storeSessionData(uniqueId, sessionId, cacheName, siteCode);
        userData.storeUserCache(uniqueId, siteCode, cacheName);
		
        return Response.status(200).entity( getResponseMessage("Stored User Data In Cache Successfully","Success") ).build();
	}
	
	@POST
	@Path("/review")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response addReview(String data) throws JSONException {
		
        JSONObject reviewData = new JSONObject(data);
        System.out.println(reviewData);
        Date date = new Date();
        
//        String siteCode = getSiteCode();
        String itemCode = reviewData.getString("item_code");
        String reviewBy = getUniqueId();
        int productRating = Integer.parseInt(reviewData.getString("productRating"));
        String productRemarks = reviewData.getString("productRemarks");
        String productComments = reviewData.getString("productComments");
        
        userDAO.addReview(siteCode, itemCode, reviewBy, productRating, productRemarks, productComments, date);
        
		return Response.status(200).entity( getResponseMessage("Review Inserted","Success") ).build();
	}
	
	@GET
	@Path("/review/{itemCode}")
	@Produces({ "application/json" })
	public ECMItemRating getUserReview(@PathParam("itemCode") String itemCode) {
		
		String uniqueId = getUniqueId();
//		String siteCode = getSiteCode();
		
		ECMItemRating userReview= userDAO.getUserReview(uniqueId, itemCode, siteCode);
		
		return userReview;
	}
	
	@DELETE
	@Path("/review/{itemCode}")
	@Produces({ "application/json" })
	public Response removeUserReview(@PathParam("itemCode") String itemCode) {
		
		String uniqueId = getUniqueId();
//		String siteCode = getSiteCode();
		
		userDAO.removeUserReview(uniqueId, itemCode, siteCode);
		
		return Response.status(200).entity( getResponseMessage("Review Deleted","Success") ).build();
	}
	
	/*
	 * 
	 * Address Screen
	 * 
	 */

	@GET
	@Path("/addresses")
	@Produces({ "application/json" })
	public List<EntityAddress>  getAddresses() {
        String userId = getUniqueId();
		System.out.println("Inside getAddresses in userActivity service >> " + userId);
		List<EntityAddress> listAddresses = new ArrayList<EntityAddress> ();  
		listAddresses = userDAO.getAddresses(userId);
		System.out.println("Inside getAddresses in userActivity service List " +listAddresses);
		return listAddresses;
	}
	
	//NOT in USE
	@GET
	@Path("/address/{lineNo}")
	@Produces({ "application/json" })
	public EntityAddress getAddress(@PathParam("lineNo")String lineNo) {
        String userId = getUniqueId();
		System.out.println("Inside getAddress in userActivity service userId[" + userId + "] id[" + lineNo + "]");
		EntityAddress address = userDAO.getAddress(userId, lineNo);
		System.out.println("Inside getAddress in userActivity service address" +address);
		return address;
	}
	
	@POST
	@Path("/address")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response saveAddress(String data) throws JSONException {
		
        JSONObject addressData = new JSONObject(data);
        String userId = getUniqueId();
        System.out.println("Inside saveAddress in userActivity service" + addressData);
        System.out.println("Inside saveAddress in userActivity service >> " + userId);

        userDAO.saveAddress(userId, addressData);
	    
		return Response.status(200).entity( getResponseMessage("Address saved successfully", "Success")).build();	
	}
	
	@DELETE
	@Path("/address/{lineNo}")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response deleteAddress(@PathParam("lineNo") String lineNo) throws JSONException {
		System.out.println("Inside delete address, lineNo" + lineNo);
		String userId = getUniqueId();

		this.userDAO.deleteAddress(userId, lineNo);

		return Response.status(200).entity(getResponseMessage("Address Delete successfully", "Success")).build();
	}
	
	/*
	 * 
	 * Profile Screen
	 * 
	 */

	@GET
	@Path("/profile")
	@Produces({ "application/json" })
	public UserProfile getProfile() throws JSONException {
		String userId = getUniqueId();
		UserProfile userProfile =  userDAO.getProfile(userId);
		System.out.println("getProfile userProfile" + userProfile);
		return userProfile;
	}
	
	//http://192.168.0.220:9090/ecm/service/feeds/profile
	@POST
	@Path("/profile")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response saveProfile(String data) throws JSONException {
		System.out.println("Inside saveProfile in userActivity service" + data);
        JSONObject reviewData = new JSONObject(data);
        String userId = getUniqueId();
		userDAO.saveProfile(userId, reviewData);
		
		return Response.status(200).entity( getResponseMessage("Stored User Data In Cache Successfully","Success") ).build();
	}
	
	/*
	 * 
	 * Payment Cards Screen
	 * 
	 */
	
	@GET
	@Path("/cards")
	@Produces({ "application/json" })
	public List<EntityPayMethod> getCards() {
		System.out.println("Inside getCards in userActivity service");
		String userId = getUniqueId();
		
		List<EntityPayMethod> cardsList = userDAO.getCards(userId);
		
		return cardsList;
	}
	
	//NOT in USE
	@GET
	@Path("/card/{id}")
	@Produces({ "application/json" })
	public String getCard(@PathParam("id")String id) {

		return null;
	}
	
	
	@DELETE
	@Path("/card/{lineNo}")
	@Produces({ "application/json" })
	public Response deleteCard(@PathParam("lineNo")String lineNo) {
		System.out.println("Inside delete card in userActivity service, lineNo:"+lineNo);
		String userId = getUniqueId();
		
		userDAO.deleteCard(userId, lineNo);
		
		return Response.status(200).entity( getResponseMessage("Deleted card Successfully","Success") ).build();
	}
	
	@POST
	@Path("/card")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response saveCard(String data) throws JSONException {
		System.out.println("Inside saveCard in userActivity service");
        JSONObject cardData = new JSONObject(data);
        System.out.println(cardData);
        String userId = getUniqueId();
        
        userDAO.saveCard(userId, cardData);
        
		return Response.status(200).entity( getResponseMessage("Stored card Successfully","Success") ).build();
	}
	
	/*
	 * 
	 * My Review Screen - For My Orders
	 * 
	 */
	
	@GET
	@Path("/myreviews")
	@Produces({ "application/json" })
	public List<ECMItemRating> getProductReviews() {
		System.out.println("Inside getProductReviews in userActivity service");
		List<ECMItemRating> listReviews = new ArrayList();  
		listReviews = userDAO.getProductReviews();
		System.out.println("Inside getProductReviews in userActivity service List " +listReviews);
		return null;
	}
	
	@GET
	@Path("/myreview/{id}")
	@Produces({ "application/json" })
	public ECMItemRating getProductReview(@PathParam("id")String id) {
		System.out.println("Inside getProductReview in userActivity service");
		ECMItemRating review = userDAO.getPrductReview(id);
		//  orderData = orderDao.getOrder(orderNo);
		System.out.println("Inside getProductReview in userActivity service riview" +review);
		return review;
	}
	
	@POST
	@Path("/myreview")
	@Consumes({ "application/json" })
	@Produces({ "application/json" })
	public Response saveProductReview(String data) throws JSONException {
		System.out.println("Inside saveProductReview in userActivity service");
		String xmlResponse = "";
	    xmlResponse = userDAO.saveProductReview(data);
		System.out.println(" xmlResponse in auth_user" + xmlResponse);
		System.out.println("Response saveOrder xmlResponse" +xmlResponse.toString());
		return Response.status(200).entity( getResponseMessage("Stored Review Successfully","Success") ).build();
	}
	
	
	
	/*
	 * 
	 * Common Functions
	 * 
	 */

//	private String getCacheName() {
//		HttpSession session = request.getSession();
//		Object siteObj = session.getAttribute("CURRENT_SITE");
//		if (siteObj != null && siteObj instanceof SiteMaster) {
//			SiteMaster site = (SiteMaster) siteObj;
//			String cacheName = "CACHE_" + site.getSiteCode();
//			System.out.println("Setting siteCode[" + site.getSiteCode() + "] siteTranDB[" + site.getTranDB() + "]");
//			System.out.println("getCacheName [" + cacheName + "]");
//			return cacheName;
//		} else {
//			System.out.println("\n getCacheName DEFAULT[" + CacheManager.SYSTEM_CACHE_NAME + "]");
//			return CacheManager.SYSTEM_CACHE_NAME;
//		}
//	}
	
	private String getCacheName() 
	{
		HttpSession session = request.getSession();
		//Object siteObj = session.getAttribute("CURRENT_SITE");
		//if( siteObj != null && siteObj instanceof SiteMaster )
		if(siteCode!= null)
		{
			//SiteMaster site = (SiteMaster) siteObj;
			String cacheName = "CACHE_" + siteCode;
			System.out.println("Setting siteCode[" + siteCode + "]"); 
			System.out.println("getCacheName ["+cacheName+"]");
			return cacheName;
		}
		else
		{
			System.out.println("\n getCacheName DEFAULT["+CacheManager.SYSTEM_CACHE_NAME+"]");
			return CacheManager.SYSTEM_CACHE_NAME;
		}
	}
	
	private String getUniqueId() {
		String uniqueId = null;		
		HttpSession session = request.getSession();
		Object auth_user = session.getAttribute("AUTH_USER");
		Object userObj = session.getAttribute( "USER_INFO" ); 
	    System.out.println(" userObj >>[" + userObj + "]Instance of:["+  (userObj instanceof UserInfoBean) +"]");
		if(userObj != null)
	    {
			try {
				UserInfoBean userInfo;
				userInfo = new UserInfoBean( userObj.toString() );
				uniqueId = userInfo.getLoginCode();
			} catch (BaseException e) {
				e.printStackTrace();
			}
	    }
	    else if(auth_user != null)
		{
			uniqueId = "" + (String)auth_user;
		}
		else
		{
			uniqueId = "" + session.getId();
		}
		System.out.println("UNIQUE ID: ["+uniqueId+"]");
		return uniqueId;		
	}
	
//	private String getSiteCode(){
//		HttpSession session = request.getSession();
//		Object siteObj = session.getAttribute("CURRENT_SITE");
//		if( siteObj != null && siteObj instanceof SiteMaster )
//		{
//			SiteMaster site = (SiteMaster) siteObj;
//			System.out.println("getSiteCode ["+site.getSiteCode()+"]");
//			return site.getSiteCode();
//		}
//		return null;
//	}
	
	private JSONObject getResponseMessage(String successResponse, String status)
	{
		JSONObject respMessage = new JSONObject();
		try 
		{
			respMessage.put("message", successResponse);
			respMessage.put("status", status);
		} 
		catch (JSONException e) 
		{
			e.printStackTrace();
		}
		return respMessage;
	}
}
