package proteus.ecm.hibernate.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.query.Query;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import proteus.ecm.cache.dao.CategoryCache;
import proteus.ecm.cache.dao.ProductCache;
import proteus.ecm.cache.dao.SystemCache;
import proteus.ecm.hibernate.bean.ECMCategory;
import proteus.ecm.hibernate.bean.ECMItemRating;
import proteus.ecm.hibernate.bean.ECMSubCategory;
import proteus.ecm.hibernate.bean.ItemAttribute;
import proteus.ecm.hibernate.bean.ItemAttributeVal;
import proteus.ecm.hibernate.bean.ItemDetails;
import proteus.ecm.hibernate.bean.ItemMaster;
import proteus.ecm.hibernate.bean.ItemType;
import proteus.ecm.hibernate.bean.SiteItem;
import proteus.ecm.hibernate.util.HibernateUtil;

public class ProductDAO {
	
	private SystemCache systemCache = new SystemCache();
	private ProductCache productCache = new ProductCache();
	private CategoryCache categoryCache = new CategoryCache();
	
	private String siteTranDB = "DEFAULT";
	
	public void prepareItemDetails(String cacheName, String siteCode, String itemCode) 
	{
		String ecmTemplate = "Default";
		String prodAttributes = null;
		String keyAttributes = null;
		ItemDetails itemDetails = new ItemDetails();
		try 
		{
			//SiteItem siteItem = systemCache.getCachedSiteItem(siteCode, itemCode, CacheManager.SYSTEM_CACHE_NAME);
			SiteItem siteItem = systemCache.getCachedSiteItem(siteCode, itemCode, cacheName);
			if( siteItem != null )
			{
				String siteScatCode = siteItem.getScatCode();// This May Be CATEGORY CODE or SUB CATEGORY CODE 
				System.out.println("prepareItemDetails for siteScatCode ["+siteScatCode+"]siteItem["+siteItem+"] ");
				ECMSubCategory itemSubCategory = categoryCache.getCachedSubCategory(siteScatCode, cacheName);
				if( itemSubCategory != null )
				{
					String catCode = itemSubCategory.getCatCode();
					System.out.println("prepareItemDetails for catCode ["+catCode+"]itemSubCategory["+itemSubCategory+"] ");
					
					ECMCategory itemCategory = categoryCache.getCachedCategory(catCode, cacheName);
					System.out.println("prepareItemDetails for catCode ["+catCode+"]itemCategory["+itemCategory+"] ");
					
					itemDetails.setItemCategory(new JSONObject(itemCategory).toString());
					itemDetails.setItemSubCategory(new JSONObject(itemSubCategory).toString());
					
					ecmTemplate = itemSubCategory.getEcmTemplate();
					prodAttributes = itemSubCategory.getProdAttrib();
					keyAttributes = itemSubCategory.getKeyAttrib();
				}
				else if( itemSubCategory == null  )
				{
					ECMCategory itemCategory = categoryCache.getCachedCategory(siteScatCode, cacheName);
					System.out.println("prepareItemDetails No Subcategory for scatCode ["+siteScatCode+"]itemCategory["+itemCategory+"] ");
					
					itemDetails.setItemCategory(new JSONObject(itemCategory).toString());
					itemDetails.setItemSubCategory(null);
					
					ecmTemplate = itemCategory.getEcmTemplate();
					prodAttributes = itemCategory.getProdAttrib();
					keyAttributes = itemCategory.getKeyAttrib();
				}
			}
			System.out.println("ecmTemplate[" + ecmTemplate + "] prodAttributes[" + prodAttributes + "] keyAttributes[" + keyAttributes + "]");
			ItemMaster itemMaster = productCache.getCachedItem( itemCode, cacheName );
			if( itemMaster != null )
			{
				fetchItemType(cacheName, itemMaster.getItemType());
				itemDetails.setItemCode(itemCode);
				itemDetails = buildItemDetailHeader(cacheName, itemMaster, itemDetails);
				itemDetails = buildItemDetail1(cacheName, itemMaster, itemDetails);
				itemDetails = buildItemDetail2(cacheName, itemMaster, itemDetails);
				
				String itemAttributes = buildProdAttributes(prodAttributes, cacheName, itemMaster);
				itemDetails.setItemAttributes(itemAttributes);
				
				String itemVariants = buildKeyAttributes(keyAttributes, cacheName, itemMaster);
				itemDetails.setItemVariants(itemVariants);
			}
			
			System.out.println("prepareItemDetails for itemDetails ["+itemDetails+"]");
			productCache.storeItemDetail(itemDetails, cacheName);
			
		}
		catch (Exception e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			 e.printStackTrace();
		}
	}
	
	private ItemDetails buildItemDetailHeader(String cacheName, ItemMaster itemMaster, ItemDetails itemDetails) throws JSONException 
	{
		System.out.println( "buildItemDetailHeader itemMaster[" + itemMaster + "]" );
		int minDiscnt = 5;
		int maxDiscnt = 15;
		double itemDiscount = minDiscnt + (int)(Math.random() * ((maxDiscnt - minDiscnt) + 1)) ;
		double itemCostRate = getCostRate( itemMaster );
		double itemDiscountPrice = ( itemCostRate * itemDiscount ) / 100 ;
		double itemDiscountedRate = itemCostRate - itemDiscountPrice;
		System.out.println( "itemCostRate :[" + itemCostRate + "] itemDiscount :[" + itemDiscount + "] itemDiscountPrice ["+itemDiscountPrice+"]itemDiscountedRate :[" + itemDiscountedRate + "]");
		JSONObject itemHeader = new JSONObject();
		itemHeader.put("itemShDescr", itemMaster.getShDescr());
		itemHeader.put("itemDescr", itemMaster.getDescr());
		itemHeader.put("itemOverview", "Item Overview Details");
		itemHeader.put("itemCostRate", itemCostRate);
		itemHeader.put("itemDiscount", itemDiscount);
		itemHeader.put("itemDiscountedRate", itemDiscountedRate);
		
		itemDetails.setItemHeader(itemHeader.toString());
		return itemDetails;
	}
	
	private double getCostRate(ItemMaster itemMaster) 
	{
		//TODO - Get rate from Pricelist
		double costRate = 0.0;
		costRate = pickRate(itemMaster.getPriceList(), itemMaster.getItemCode());   
		System.out.println("getCostRate[" + costRate + "]" );
		if( costRate == 0.0 )
		{
			int minPrice = 100;
			int maxPrice = 1000;
			costRate = minPrice + (int)(Math.random() * ((maxPrice - minPrice) + 1)) ;
			System.out.println("costRate is 0.0 [" + costRate + "]" );
		}
		return costRate;
	}
	
	private ItemDetails buildItemDetail1(String cacheName, ItemMaster itemMaster, ItemDetails itemDetails) throws JSONException 
	{
		return itemDetails;
	}

	private ItemDetails buildItemDetail2(String cacheName, ItemMaster itemMaster, ItemDetails itemDetails) throws JSONException 
	{
		return itemDetails;
	}
	
	private List<String> getAttributeList(String attributeCSV){
		if(attributeCSV == null)
			return null;
		
		List<String> phAttributeList = new ArrayList<String>();
		List<String> phAttribList = Arrays.asList(attributeCSV.split(",")); // 1,2, 3-5, 25 ==> [1,2,3,4,5,25]
		System.out.println("Given string"+phAttribList);
		for( String phAttribStr : phAttribList ){
			
			if (phAttribStr.contains("-"))
			{
				int firstVal = Integer.parseInt(String.valueOf(phAttribStr.charAt(0)));
				int lastVal = Integer.parseInt(String.valueOf(phAttribStr.charAt(2)));
				
				for(int j = firstVal; j <= lastVal; j++){
					phAttributeList.add("PH" + j);
				}
			}
			else
			{
				phAttributeList.add("PH" + phAttribStr);
			}
		}
		System.out.println("List After Process"+phAttributeList);
		return phAttributeList;
	}
	
	private String buildProdAttributes(String prodAttributes, String cacheName, ItemMaster itemMaster) 
	{
		JSONArray attribObjArray = new JSONArray();
		try
		{
			List<String> attribList = getAttributeList(prodAttributes);
			if( attribList == null ) {
				return "";
			}
			ItemType itemType = productCache.getCachedItemType(itemMaster.getItemType(), cacheName);
			HashMap<String, String> itemTypeAttribs = itemType.getPhyAttribMap();
			HashMap<String, String> itemMasterAttribs = itemMaster.getPhyAttribMap();
			
			for (String attribCode : attribList) {
				String itemAttribName = itemTypeAttribs.get(attribCode);
				String itemAttribValue = itemMasterAttribs.get(attribCode);
				
				ItemAttribute itemAttribute = productCache.getCachedItemAttribs(itemAttribName, cacheName);
				JSONObject attribObj = new JSONObject();
				attribObj.put( "label", itemAttribute.getShDescr() );
				attribObj.put( "value", itemAttribValue );
				attribObj.put( "descr", itemAttribute.getDescr() );
				
				System.out.println("buildProdAttributes itemMaster>>" + attribObj);
				attribObjArray.put(attribObj);
			}
		}
		catch(Exception e)
		{
			System.out.println("buildProdAttributes Exception : " + e.getMessage());
			e.printStackTrace();
		}
		
		return attribObjArray.toString();
	}

	private String buildKeyAttributes(String keyAttributes, String cacheName, ItemMaster itemMaster) 
	{
		JSONObject itemVariantData = new JSONObject();
		
		JSONArray attributeOptions = new JSONArray();
		JSONArray attributes = new JSONArray();
		JSONObject products = new JSONObject();
		
		//JSONArray attribObjArray = new JSONArray();
		try
		{
			List<String> attribList = getAttributeList(keyAttributes);
			if( attribList == null || itemMaster.getProductCode() == null ) {
				return "";
			}
			/*
			ItemType itemType = productCache.getCachedItemType(itemMaster.getItemType(), cacheName);
			HashMap<String, String> itemTypeAttribs = itemType.getPhyAttribMap();
			HashMap<String, String> itemMasterAttribs = itemMaster.getPhyAttribMap();
			
			for (String attribCode : attribList) 
			{
				String itemAttribName = itemTypeAttribs.get(attribCode);
				String itemAttribValue = itemMasterAttribs.get(attribCode);
				
				ItemAttribute itemAttribute = productCache.getCachedItemAttribs(itemAttribName, cacheName);
				JSONObject attribObj = new JSONObject();
				attribObj.put( "label", itemAttribute.getShDescr() );
				attribObj.put( "value", itemAttribValue );
				attribObj.put( "descr", itemAttribute.getDescr() );
				
				JSONArray variantArray = new JSONArray();
				List<ItemMaster> items = productCache.getCachedItemsByProduct(itemMaster.getProductCode(), cacheName);
				for (ItemMaster prodItemMaster : items) {
					String prodItemAttribValue = prodItemMaster.getPhyAttribMap().get(attribCode);
					JSONObject prodAttribObj = new JSONObject();
					prodAttribObj.put( "value", prodItemAttribValue );
					prodAttribObj.put( "itemCode", prodItemMaster.getItemCode() );
					variantArray.put(prodAttribObj);
					System.out.println("buildKeyAttributes prodItemMaster>>" + prodAttribObj);
				}
				attribObj.put( "variants", variantArray );
				
				System.out.println("buildKeyAttributes itemMaster>>" + attribObj);
				attribObjArray.put(attribObj);
			}
			*/
			
			ItemType itemType = productCache.getCachedItemType(itemMaster.getItemType(), cacheName);
			HashMap<String, String> itemTypeAttribs = itemType.getPhyAttribMap();
			//HashMap<String, String> itemMasterAttribs = itemMaster.getPhyAttribMap();
			
			List<ItemMaster> items = productCache.getCachedItemsByProduct(itemMaster.getProductCode(), cacheName);
			LinkedHashMap<String, ArrayList<String>> itemAttribValMap = new LinkedHashMap<String, ArrayList<String>>();
			
			int idx = 0;
			for (String attribCode : attribList) 
			{
				String itemAttribName = itemTypeAttribs.get(attribCode);
				ItemAttribute itemAttribute = productCache.getCachedItemAttribs(itemAttribName, cacheName);

				ArrayList<String> prodItemAttribValList = new ArrayList<String>();
				JSONArray attributeOpt = new JSONArray();
				for (ItemMaster prodItemMaster : items) {
					String prodItemAttribValue = prodItemMaster.getPhyAttribMap().get(attribCode);
					if( prodItemAttribValue != null && prodItemAttribValList.indexOf(prodItemAttribValue) == -1 )
					{
						prodItemAttribValList.add(prodItemAttribValue);
						//attributeOpt.put(new JSONObject().put("value", prodItemAttribValue).put("itemCode", prodItemMaster.getItemCode()));
						attributeOpt.put(new JSONObject().put("value", prodItemAttribValue));
					}
				}
				itemAttribValMap.put(attribCode, prodItemAttribValList);
				attributeOptions.put(attributeOpt);

				JSONObject attribObj = new JSONObject();
				String attribName = attribCode.replace("PH", "PHY_ATTRIB_");
				attribObj.put( "attribName", attribName );
				attribObj.put( "name", itemAttribName );
				attribObj.put( "label", itemAttribute.getShDescr() );
				attribObj.put( "descr", itemAttribute.getDescr() );
				if( prodItemAttribValList.size() == 0 )
				{
					attribObj.put( "index", -1 );
				}
				else
				{
					attribObj.put( "index", idx );
				}
				idx++;
				attributes.put(attribObj);

				System.out.println("buildKeyAttributes [" + attribCode + "]>>attributes[" + attributes + "]prodItemAttribVal["+prodItemAttribValList+"] itemAttribValMap["+ itemAttribValMap+"]");
			}
			itemVariantData.put("attributes", attributes);
			itemVariantData.put("attributeOptions", attributeOptions);
			
			for (String attribCode : attribList) 
			{
				ArrayList<String> prodItemAttribValList = itemAttribValMap.get(attribCode);
				
				for (ItemMaster prodItemMaster : items) {
					String itemCode = prodItemMaster.getItemCode();
					String prodItemAttribValue = prodItemMaster.getPhyAttribMap().get(attribCode);
					
					int index = prodItemAttribValList.indexOf(prodItemAttribValue);
										
					JSONArray prodArr = null;
					if( products.has(itemCode) ){
						prodArr = products.getJSONArray(itemCode);
					}
					else {
						prodArr = new JSONArray();
					}
					prodArr.put(index);
					products.put(itemCode, prodArr);
					System.out.println("buildKeyAttributes [" + attribCode + "]>> itemCode["+ itemCode+"]index[" + index + "]prodArr["+prodArr+"]");
				}
			}
			itemVariantData.put("products", products);
		}
		catch(Exception e)
		{
			System.out.println("buildProdAttributes Exception : " + e.getMessage());
			e.printStackTrace();
		}
		
		return itemVariantData.toString();
	}
	
	private void fetchItemType(String cacheName, String itemType) 
	{	
		System.out.println("Inside fetchItemType for cacheName : [" + cacheName + "]itemType ["+itemType+"]");
		try 
		{
			ItemType itemTypeCacheObj = productCache.getCachedItemType(itemType, cacheName);
			System.out.println(" fetchItemType >itemTypeCacheObj> " + itemTypeCacheObj );
			if( itemTypeCacheObj != null ) {
				return;
			}
			
			List<ItemType> itemTypesList = null;
			
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			
			Query query = session.createQuery("FROM ItemType WHERE itemType = :itemType " );
			query.setParameter("itemType", itemType);
			
			itemTypesList = query.getResultList();
			System.out.println("fetchItemType for itemType  ["+query+"] itemTypesList : [" + itemTypesList + "]");
			
			ItemType itemTypeObj = ( itemTypesList != null ) ? itemTypesList.get(0) : null;
			if(itemTypeObj != null)
			{
				HashMap<String, String> phyAttribMap = itemTypeObj.getPhyAttribMap();
				
				System.out.println("fetchItemType phyAttribMap["+phyAttribMap+"]");
				for (Iterator<String> iterator = phyAttribMap.keySet().iterator() ; iterator.hasNext();) {
					String key = iterator.next();
					String phAttribName = phyAttribMap.get(key);
					fetchAttributes( cacheName, phAttribName ); 
				}
				
				productCache.storeItemType(cacheName, itemTypeObj);
			}
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		catch (Exception e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
	}

	private void fetchAttributes(String cacheName, String phyAttrib) 
	{	
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ItemAttribute WHERE attribCode = '" + phyAttrib + "'");
			
			List<ItemAttribute> itemAttributesList = query.getResultList();
			System.out.println("fetchAttributes for phyAttrib ["+phyAttrib+"]");
			
			ItemAttribute itemAttributeObj = ( itemAttributesList != null && !itemAttributesList.isEmpty() ) ? itemAttributesList.get(0) : null;
			if(itemAttributeObj != null)
			{
				Query query1 = session.createQuery("FROM ItemAttributeVal WHERE attribCode = '" + phyAttrib + "'");
				List<ItemAttributeVal> attributeList = query1.getResultList();
				productCache.storeItemAttribValues(cacheName, attributeList);
				productCache.storeItemAttribs(cacheName, itemAttributeObj);
			}
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		catch (Exception e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
	}

	public String getRatingDetails(String siteCode, String itemCode) throws JSONException
	{
		//{ 1 : 10 },{ 2 : 15 },{ 3 : 30 },{ 4 : 25 },{ 5 : 50 }
		JSONObject ratingDetail = new JSONObject();
		try
		{
			List<ECMItemRating> itemRevRateList = new ArrayList<ECMItemRating>();
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			System.out.println("product cache item code:["+itemCode+"]");
			itemCode = itemCode.trim();
			System.out.println("product cache item code trim:["+itemCode+"]");

			// 2. Create Query
			
			Query query = session.createQuery("FROM ECMItemRating WHERE siteCode = '" + siteCode + "' AND itemCode = '" + itemCode + "' ");
			//Query query = session.createQuery("FROM ECMItemRating WHERE siteCode = :siteCode AND itemCode = :itemCode ");
			//query.setParameter("siteCode" , siteCode);
			//query.setParameter("itemCode" , itemCode);
			
			itemRevRateList = query.getResultList();
			System.out.println("getRatingDetails for itemCode ["+itemCode+"]siteCode["+siteCode+"] items : [" + itemRevRateList + "]");
			
			session.close();
			int numOfReviews = 0;
			int numOfRatings = 0;
			int ratings[] = { 0, 0, 0, 0, 0 };// 4,5,8,10,25
			for( ECMItemRating ecmItemRating :itemRevRateList )
			{
				int rating = ecmItemRating.getRating();
				if( rating > 0 )
				{
					int idx = rating - 1;
					ratings[idx] = ratings[idx] + 1;
				}
				if( ecmItemRating.getRemarks() != null && ecmItemRating.getRemarks().trim().length() > 0 )
				{
					numOfReviews++;
				}
				System.out.println( "rating :[" + rating + "] ratings :[" + ratings + "] numOfReviews :[" + numOfReviews + "]");
			}
			
			JSONObject ratingJson = new JSONObject();
			for (int i = 0; i < ratings.length; i++) 
			{
				System.out.println( ( i + 1 ) + " : " + ratings[i] + ",");
				String key = "RATING_" + ( i + 1 );
				String value = String.valueOf( ratings[i] );
				ratingJson.put(key, value);
				numOfRatings+=ratings[i];
			}
			
			ratingDetail.put("RATINGS", ratingJson);
			ratingDetail.put("AVG_RATING", calcAvgRating(ratings));
			ratingDetail.put("NO_OF_REVIEWS", numOfReviews);
			ratingDetail.put("NO_OF_RATINGS", numOfRatings);
			
			System.out.println("getRatingDetails ratingDetail[" + ratingDetail + "]");
		} 
		catch (HibernateException e) 
		{
			System.out.println("getRatingDetails HibernateException :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			System.out.println("getRatingDetails Exception :");
			System.out.println(e.getMessage());
			e.printStackTrace();
		}
		return ratingDetail.toString();
	}
	
	private double calcAvgRating(int[] ratings) 
	{
		double avgRating = 0.0;
		int weightRating = 0;
		int sumOfRating = 0;
		for (int i = 0; i < ratings.length; i++) 
		{
			 sumOfRating += ratings[i];
	         weightRating += ( i + 1 ) * ratings[i];
	         System.out.println( "calcAvgRating ratings: [" + ratings[i] + "] sumOfRating: [" + sumOfRating + "] weightRating: [" + weightRating + "]" );
	    }
		if( sumOfRating > 0 ) 
		{
			avgRating = ( weightRating / sumOfRating );
		}
        System.out.println( "calcAvgRating avgRating: [" + avgRating + "]" );
		return avgRating;
	}
	
/*
	//Template Wise Product Detail Data 
	private ItemDetails buildItemDetails(String cacheName, String ecmTemplate, ItemDetails itemDetails) 
	{
		ItemMaster itemMaster = productCache.getCachedItem( itemDetails.getItemCode(), cacheName );
		System.out.println( "buildItemDetails itemMaster[" + itemMaster + "]" );
		System.out.println("The items deatails for ecmTemplate : " + ecmTemplate);
		if ("ecm-handicraft".equalsIgnoreCase(ecmTemplate)) 
		{
			itemDetails.setItemDetail1(getHandicraftData(1, itemMaster, cacheName));
			itemDetails.setItemDetail2(getHandicraftData(2, itemMaster, cacheName));
			System.out.println("Implemented......");
		} 
		else if ("ecm-food".equalsIgnoreCase(ecmTemplate)) 
		{
			System.out.println("Not Implemented Yet !");
		} 
		else if ("ecm-outing".equalsIgnoreCase(ecmTemplate)) 
		{
			System.out.println("Not Implemented Yet !");
		} 
		else if ("ecm-celebration".equalsIgnoreCase(ecmTemplate)) 
		{
			System.out.println("Not Implemented Yet !");
		}
		return itemDetails;
	}
	
	private String getHandicraftData(int detail, ItemMaster itemMaster, String cacheName) 
	{
		String itemDetails = "";
		try 
		{
			switch(detail)
			{
				case 1:
					JSONObject detail1 = new JSONObject();
					JSONObject sellerInformation = new JSONObject();
					sellerInformation.put("name", "StoneCrafts");
					sellerInformation.put("address", "Vidyavihar");
					detail1.put("sellerInfo", sellerInformation);

					String description = "Made up of white stone";
					detail1.put("description", description);

					JSONObject shortDetails = new JSONObject();
					shortDetails.put("material", "made of white stone");
					shortDetails.put("craftedBy", "HandiCrafted");
					shortDetails.put("pattern", "Printed");
					shortDetails.put("type", "Short Sleve");
					detail1.put("shortDetails", shortDetails);

					String discountPeriod = "Discount valid till 31st July";
					detail1.put("validity", discountPeriod);

					detail1.put("discount", 2);

					JSONArray moreOffers = new JSONArray();
					moreOffers.put(new JSONObject().put("offer", "15% More off on ICICI Bank Credit Card"));
					moreOffers.put(new JSONObject().put("offer", "5% More off on PayTM"));
					moreOffers.put(new JSONObject().put("offer", "10% More Off on HDFC Bank Credit Card"));
					detail1.put("moreOffers", moreOffers);

					detail1.put("location", "Vidyavihar");

					detail1.put("freeDelivery", "5 to 6 Days");

					JSONArray serviceAvailable = new JSONArray();
					serviceAvailable.put(new JSONObject().put("service", "30 days Exchange Policy").put("serviceDeatils","Cash on Delivery"));
					serviceAvailable.put(new JSONObject().put("service", "Cash on Delivery").put("serviceDeatils", "Cash on Delivery"));
					detail1.put("serviceAvailable", serviceAvailable);

					itemDetails = detail1.toString();
					break;
					
				case 2:
					JSONObject detail2 = new JSONObject();
					String productOverview = "The stone elephant is made up of white stone marble which looks beautifull";
					detail2.put("productOverview", productOverview);
					ItemAttributeVal sizeAttribute = productCache.getCachedItemAttribValues("SIZE", itemMaster.getPhyAttribId1(), cacheName);//PH1
					ItemAttributeVal dimAttribute = productCache.getCachedItemAttribValues("DIMENSION", itemMaster.getPhyAttribId2(), cacheName);//PH2
					ItemAttributeVal colorAttribute = productCache.getCachedItemAttribValues("COLOR", itemMaster.getPhyAttribId3(), cacheName);//PH3

					JSONObject allProductDetail = new JSONObject();
					allProductDetail.put("brand", "Artificial india Ltd");
					allProductDetail.put("sku", itemMaster.getItemCode());
					allProductDetail.put("type", "Stone Handicrafts");
					allProductDetail.put("weight", itemMaster.getGrossWeight());
					allProductDetail.put("material", "white stones");
					
					//allProductDetail.put("color","white");
					if( colorAttribute != null )
					{
						allProductDetail.put("color", colorAttribute.getShDescr());
					}
					//allProductDetail.put("size", "20 * 20 cm Large");
					if( sizeAttribute != null )
					{
						allProductDetail.put("size", sizeAttribute.getShDescr());
					}
					if( dimAttribute != null)
					{
						allProductDetail.put("dimension", dimAttribute.getShDescr());
					}
					allProductDetail.put("packageContent", "Elephant Stone Handicrafts 1 pc");
					allProductDetail.put("care", "Clean by dry clothes");
					detail2.put("productDetails", allProductDetail);

					String returnPolicy = "Does not return after buy";
					detail2.put("returnPolicy", returnPolicy);

					String termsAndCondition = "The image represnt actual product For warranty related claim please contact to brand service center";
					detail2.put("termsAndCondition", termsAndCondition);
					itemDetails = detail2.toString();
					break;
				default:
					System.out.println("getHandicraftData DEFAULT CASE:????");
			}
			
		} catch (JSONException e) {
			System.out.println("getHandicraftData JSONException >>" + e.getMessage());
			e.printStackTrace();
		}

		catch (Exception e) {
			System.out.println("getHandicraftData Exception >>" + e.getMessage());
			e.printStackTrace();
		}
		return itemDetails.toString();
	}
	
	private String getOutingData() 
	{
		JSONObject itemDetails = new JSONObject();
		try 
		{
			JSONObject detail1 = new JSONObject();
			JSONObject sellerInformation = new JSONObject();
			sellerInformation.put("name", "Aqua Drivers");
			sellerInformation.put("address", "Vidyavihar");
			detail1.put("hostInfo", sellerInformation);

			String OverView = "A Squad Which Offers Diving in a sea";
			detail1.put("OverView", OverView);

			JSONObject packageInclude = new JSONObject();
			packageInclude.put("include", "activities");
			packageInclude.put("include", "Trainer");
			detail1.put("packageInclude", packageInclude);

			String discountPeriod = "Discount valid till 15th July to 18th July";
			detail1.put("discountPeriod", discountPeriod);

			JSONArray moreOffers = new JSONArray();
			moreOffers.put(new JSONObject().put("offer", "15% More Off on ICICI Bank Credit Card"));
			moreOffers.put(new JSONObject().put("offer", "5% More Off on PayTM"));
			moreOffers.put(new JSONObject().put("offer", "10% More Off on HDFC Bank Credit Card"));
			detail1.put("moreOffers", moreOffers);

			detail1.put("location", "Vidyavihar");

			itemDetails.put("detail1", detail1);

			JSONObject detail2 = new JSONObject();
			String productDescription = "The Aqua divers are one of the most famous diving campaing which give tarinig how to dive in a water and share their experience on diving";
			detail2.put("productDescription", productDescription);

			JSONArray actionPerformed = new JSONArray();
			actionPerformed.put(new JSONObject().put("actionPerformed",
					"kudava caves a series of 13th caves out of rock by buddhists can be visited to see ancient carving"));
			actionPerformed.put(new JSONObject().put("actionPerformed",
					"A 4th century fort Tala stands in the middle of the forest and overlook the hilly region"));
			actionPerformed.put(new JSONObject().put("actionPerformed",
					"There are manny waterfalls to see which looks beautifull when the fall from the hillyregion"));
			actionPerformed.put(new JSONObject().put("actionPerformed", "Devi kedddar Jenni hills"));
			actionPerformed.put(new JSONObject().put("actionPerformed", "Bhira Dam"));
			detail2.put("actionPerformed", actionPerformed);

			JSONArray activityPerformed = new JSONArray();
			activityPerformed.put(new JSONObject().put("activity", "Rafting"));
			activityPerformed.put(new JSONObject().put("activity", "Kayaking"));
			activityPerformed.put(new JSONObject().put("activity", "Boating"));
			activityPerformed.put(new JSONObject().put("activity", "Campaing"));
			activityPerformed.put(new JSONObject().put("activity", "Scuba Diving"));
			detail2.put("activityPerformed", activityPerformed);

			JSONArray transportFacility = new JSONArray();
			transportFacility.put(new JSONObject().put("transportFacility", "Private Vehicle"));
			transportFacility.put(new JSONObject().put("transportFacility", "Bus"));
			transportFacility.put(new JSONObject().put("transportFacility", "Boat"));
			detail2.put("transportFacility", transportFacility);

			JSONArray thingsToCarry = new JSONArray();
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Swimming Costume"));
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Dry Towel"));
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Pen Drive Or memorycard to take pictures"));
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Swimming caps for ladies"));
			detail2.put("thingsToCarry", thingsToCarry);

			String advisory = "Reach the site on prescribed time";
			detail2.put("advisory", advisory);

			String cancellationPollicy = "The schemes are provided by the respective sellers and hence cancellationPolicy are also descided by them";
			detail2.put("cancellationPollicy", cancellationPollicy);

			String termsAndCondition = "The image represnt actual product For warranty related claim please contact to brand service center";
			detail2.put("termsAndCondition", termsAndCondition);

			itemDetails.put("detail2", detail2);
		}
		catch (JSONException e) {
			System.out.println("getOutingData JSONException >>" + e.getMessage());
			e.printStackTrace();
		}
		catch (Exception e) {
			System.out.println("getOutingData Exception >>" + e.getMessage());
			e.printStackTrace();
		}
		return itemDetails.toString();
	}

	private String getFoodData() 
	{
		JSONObject itemDetails = new JSONObject();
		try 
		{
			JSONObject detail1 = new JSONObject();

			JSONObject sellerInformation = new JSONObject();
			sellerInformation.put("name", "Chef Sunil Gurg");
			sellerInformation.put("address", "Vidyavihar");
			detail1.put("sellerInfo", sellerInformation);

			String productSpeciality = "Making a Food with supb flavours that you can never imagine it";
			detail1.put("productSpeciality", productSpeciality);

			String Cuisine = "Mughlai";
			detail1.put("Cuisine", Cuisine);

			String Taste = "Spicy";
			detail1.put("Taste", Taste);

			JSONObject dayAndTime = new JSONObject();
			dayAndTime.put("day", "Mon to Fri");
			dayAndTime.put("time", "11AM to 4PM");
			detail1.put("dayAndTime", dayAndTime);

			detail1.put("location", "Vidyavihar");

			itemDetails.put("detail1", detail1);

			JSONObject detail2 = new JSONObject();

			String ProductDescription = "The Food Is a type of Mughlai which taste superb but it is very spicy but it is best in all types of food so just check it out and try how it is";
			detail2.put("ProductDescription", ProductDescription);

			JSONArray ingredients = new JSONArray();
			ingredients.put(new JSONObject().put("ingredient", "Butter"));
			ingredients.put(new JSONObject().put("ingredient", "Coriander Leaves"));
			ingredients.put(new JSONObject().put("ingredient", "Ginger"));
			ingredients.put(new JSONObject().put("ingredient", "Tomatoes"));
			ingredients.put(new JSONObject().put("ingredient", "Turmeric Powder"));
			ingredients.put(new JSONObject().put("ingredient", "Cumin Powder"));
			ingredients.put(new JSONObject().put("ingredient", "Melon Seeds"));
			ingredients.put(new JSONObject().put("ingredient", "Garam Masala"));
			ingredients.put(new JSONObject().put("ingredient", "Garlic"));
			ingredients.put(new JSONObject().put("ingredient", "Mint Leaves"));
			ingredients.put(new JSONObject().put("ingredient", "Coriander Seeds Powder"));
			ingredients.put(new JSONObject().put("ingredient", "Chopped Cashews"));
			ingredients.put(new JSONObject().put("ingredient", "Dried Fenugreek Leaves"));
			ingredients.put(new JSONObject().put("ingredient", "Dried Fenugreek Leaves"));
			detail2.put("ingredients", ingredients);

			JSONArray Preferences = new JSONArray();
			Preferences.put(new JSONObject().put("Free", "Gluten Free"));
			Preferences.put(new JSONObject().put("Free", "Nuts Free"));

			detail2.put("Preferences", Preferences);

			String cancellationPollicy = "The schemes are provided by the respective sellers and hence cancellationPolicy are also descided by them";
			detail2.put("cancellationPollicy", cancellationPollicy);

			String termsAndCondition = "The image represnt actual product For warranty related claim please contact to brand service center";
			detail2.put("termsAndCondition", termsAndCondition);

			itemDetails.put("detail2", detail2);

		}
		catch (JSONException e) {
			System.out.println("getFoodData JSONException >>" + e.getMessage());
			e.printStackTrace();
		}
		catch (Exception e) {
			System.out.println("getFoodData Exception >>" + e.getMessage());
			e.printStackTrace();
		}
		return itemDetails.toString();
	}

	private String getCelebrationData() 
	{
		JSONObject itemDetails = new JSONObject();
		try 
		{
			JSONObject detail1 = new JSONObject();

			JSONObject sellerInformation = new JSONObject();
			sellerInformation.put("name", "MCC College of Arts");
			sellerInformation.put("address", "Vidyavihar");
			detail1.put("sellerInformation", sellerInformation);

			String celebrationOverview = "The all tradition are celebrated with full of enjoyment fun and masti you will enjoy the function as never before";
			detail1.put("celebrationOverview", celebrationOverview);

			JSONObject dateAndTime = new JSONObject();
			dateAndTime.put("date", "15th July to 18th July");
			dateAndTime.put("time", "11AM to 4PM");
			detail1.put("dateAndTime", dateAndTime);

			JSONObject includes = new JSONObject();
			includes.put("includes", "Activities");
			includes.put("includes", "Guides");
			detail1.put("includes", includes);

			detail1.put("location", "Vidyavihar");

			itemDetails.put("detail1", detail1);

			JSONObject detail2 = new JSONObject();

			String productDescription = "The Aqua divers are one of the most famous diving campaing which give tarinig how to dive in a water and share their experience on diving";
			detail2.put("productDescription", productDescription);

			JSONArray attractions = new JSONArray();
			attractions.put(new JSONObject().put("Attractions", "Traditional Food"));
			attractions.put(new JSONObject().put("Attractions", "Celebrity"));
			attractions.put(new JSONObject().put("Attractions", "Bollywood Songs"));
			attractions.put(new JSONObject().put("Attractions", "Festival related Games"));
			attractions.put(new JSONObject().put("Attractions", "Bhang"));
			attractions.put(new JSONObject().put("Attractions", "Rain dance"));
			detail2.put("Attractions", attractions);

			JSONArray activities = new JSONArray();
			activities.put(new JSONObject().put("Activities", "Traditional Dance"));
			activities.put(new JSONObject().put("Activities", "Hena Mehandi on Hands"));
			activities.put(new JSONObject().put("Activities", "Singing Bollywood Songs"));
			activities.put(new JSONObject().put("Activities", "Playing with natural colors"));
			activities.put(new JSONObject().put("Activities", "Wearing Traditional clothes"));
			detail2.put("Attractions", activities);

			JSONArray thingsToCarry = new JSONArray();
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Swimming Costume"));
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Dry Towel"));
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Pen Drive Or memorycard to take pictures"));
			thingsToCarry.put(new JSONObject().put("thingsToCarry", "Punjabi dress for ladies"));
			detail2.put("thingsToCarry", thingsToCarry);

			String advisory = "Reach the site on prescribed time";
			detail2.put("advisory", advisory);

			String cancellationPollicy = "The schemes are provided by the respective sellers and hence cancellationPolicy are also descided by them";
			detail2.put("cancellationPollicy", cancellationPollicy);

			String termsAndCondition = "The image represnt actual product For warranty related claim please contact to brand service center";
			detail2.put("termsAndCondition", termsAndCondition);

			itemDetails.put("detail2", detail2);

		}
		catch (JSONException e) {
			System.out.println("getCelebrationData JSONException >>" + e.getMessage());
			e.printStackTrace();
		}
		catch (Exception e) {
			System.out.println("getCelebrationData Exception >>" + e.getMessage());
			e.printStackTrace();
		}
		return itemDetails.toString();
	}
	
*/	
	
	
    /**
     * Returns the rate as double 
     *
     * @param     priceList  The price list for which type is to be identified
     * @param     trDate  The date on which the price list to be a valid
     * @param     itemCode  The item code for which the rate is to be obtained
     * @param	  conn   JDBC Database connection
     * @return    the rate as double
     * @see       
     */
	private double pickRate(String priceList,String itemCode)
	{
		System.out.println("@@@@@--------------[pickRate]--[(String priceList,String trDate,String itemCode)]-called------------------------------");

		PreparedStatement pstmt = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs = null;
		ResultSet rs2 = null;
		ResultSet rs3 = null;
		java.sql.Timestamp tranDate = null;
		String sql = "";
		String priceListParent = "";
		String siteCode = "";
		String locCode = "";
		String lotSl = "";
		String listType = "";
		double rate = 0.0;
		Connection conn = null;
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			ConnDriver connDriver = new ConnDriver();
			System.out.println("Inside processRequest transDB  else");
			conn = connDriver.getConnectDB( "DriverITM" );
			connDriver = null;
			conn.setAutoCommit( false );
			sql = " select list_type from pricelist_mst where price_list = ? " ;
			pstmt = conn.prepareStatement(sql);	
			pstmt.setString(1,priceList);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				listType = rs.getString("list_type");
			}
			rs.close();
			rs =  null;
			pstmt.close();
			pstmt = null;
			System.out.println("List Type:-["+listType+"]");

			String trDate = genericUtility.getValidDateString(new Date(),  genericUtility.getApplDateFormat());
			System.out.println("trDate 1[" + trDate + "]");
			trDate = genericUtility.getValidDateString(trDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat());
			System.out.println("trDate 2[" + trDate + "]");
			tranDate = java.sql.Timestamp.valueOf(trDate + " 00:00:00");
			System.out.println("trDate 3[" + trDate + "]");
		}
		catch(Exception e)
		{
			System.out.println("Exception...[pickRate] "+sql+e.getMessage());
			e.printStackTrace();
		}

		if(listType.trim().equals("L"))        // replace listType instead of list by cpatil on 10-oct-12
		{
			rate = 0;
			System.out.println("Inside type ::-<L>-::");
			try
			{//try 1
				sql = "SELECT RATE FROM PRICELIST "
						+ "WHERE PRICE_LIST = '"+priceList+"' "
						+ "AND ITEM_CODE = '"+itemCode+"' "
						+ "AND LIST_TYPE = ? "
						+ "AND EFF_FROM <= ? "
						+ "AND VALID_UPTO >= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,listType);    				 
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rate = rs.getDouble(1);
					rs.close(); 
					pstmt.close(); 
					rs = null;  
					pstmt = null; 
				}
				else
				{

					try
					{
						rs.close();
						pstmt.close(); 
						rs = null;  
						pstmt = null; 
						sql = "SELECT (CASE WHEN PRICE_LIST__PARENT IS NULL THEN '' ELSE PRICE_LIST__PARENT END) "
								+ "FROM pricelist_mst WHERE PRICE_LIST = '"+priceList+"' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							priceListParent = rs.getString(1) == null ?"":rs.getString(1);
							if(priceListParent.trim().length() > 0)
							{
								try
								{
									sql = "SELECT RATE FROM PRICELIST "
											+ "WHERE PRICE_LIST = '"+priceListParent+"' "
											+ "AND ITEM_CODE = '"+itemCode+"' "
											+ "AND LIST_TYPE = ? "
											+ "AND EFF_FROM <= ? "
											+ "AND VALID_UPTO >= ?";
									pstmt2 = conn.prepareStatement(sql);
									pstmt2.setString(1,listType);    		
									pstmt2.setTimestamp(2,tranDate);
									pstmt2.setTimestamp(3,tranDate);
									rs2 = pstmt2.executeQuery();
									if(rs2.next())
									{
										rate = rs2.getDouble(1);
										rs2.close(); 
										pstmt2.close(); 
										rs2 =null; 
										pstmt2 = null;  
									}
									else
									{
										rs2.close(); 
										pstmt2.close(); 
										rs2 =null; 
										pstmt2 = null;  
										return -1;	
									}

									if(rate > 0)
									{
										priceList = priceListParent ;
									}
									else
									{
										priceList = priceListParent ;	
										priceListParent = "";
									}

								}
								catch(Exception e)
								{
									e.printStackTrace();
									System.out.println("throw new ITMException(e);");
								}
							}

						}

						if (rs != null )
						{
							rs.close();
							rs = null;
						}
						if (pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}

					}
					catch(Exception e)
					{
						System.out.println("Exception...[pickRate] "+sql+e.getMessage());
						e.printStackTrace();
						System.out.println("throw new ITMException(e);");
					}
				}

				if (rs != null )
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}


			}
			catch(Exception e)
			{
				System.out.println("Exception...[pickRate] "+sql+e.getMessage());
				e.printStackTrace();
				System.out.println("throw new ITMException(e);");
			}
		}
		if(listType.trim().equals("F"))       				 // replace listType instead of list by cpatil on 10-oct-12
		{
			System.out.println("Inside type ::-<F>-::");
			try
			{
				sql = "SELECT RATE FROM PRICELIST "
						+ "WHERE PRICE_LIST = '"+priceList+"' "
						+ "AND ITEM_CODE = '"+itemCode+"' "
						+ "AND LIST_TYPE = ? "
						+ "AND EFF_FROM <= ? "
						+ "AND VALID_UPTO >= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,listType);    	
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rate = rs.getDouble(1);
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				else
				{

					try
					{
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						sql = "SELECT (CASE WHEN PRICE_LIST__PARENT IS NULL THEN '' ELSE PRICE_LIST__PARENT END) "
								+ "FROM pricelist_mst WHERE PRICE_LIST = '"+priceList+"' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							priceListParent = rs.getString(1);
						}
						rs.close();
						pstmt.close(); 
						rs = null; 
						pstmt = null; 
						if((priceListParent == null) || (priceListParent.trim().length() == 0))
						{
							priceListParent = "";
							return -1;
						}
						if(priceListParent.trim().length() > 0)
						{
							try
							{
								sql = "SELECT RATE FROM PRICELIST "
										+ "WHERE PRICE_LIST = '"+priceListParent+"' "
										+ "AND ITEM_CODE = '"+itemCode+"' "
										+ "AND LIST_TYPE = ? "
										+ "AND EFF_FROM <= ? "
										+ "AND VALID_UPTO >= ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,listType);    		
								pstmt.setTimestamp(2,tranDate);
								pstmt.setTimestamp(3,tranDate);
								rs2 = pstmt.executeQuery();
								if(rs2.next())
								{
									rate = rs2.getDouble(1);
									rs2.close(); 
									pstmt.close(); 
									rs2 = null; 
									pstmt = null; 
								}
								else
								{
									rs2.close(); 
									pstmt.close(); 
									rs2 = null; 
									pstmt = null; 
									return -1;	
								}
							}
							catch(Exception e)
							{
								System.out.println("Exception...[pickRate] "+sql+e.getMessage());
								e.printStackTrace();
								System.out.println("throw new ITMException(e);");
							}
						}
					}
					catch(Exception e)
					{
						System.out.println("Exception...[pickRate] "+sql+e.getMessage());
						e.printStackTrace();
						System.out.println("throw new ITMException(e);");
					}
				}

				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception...[pickRate] "+sql+e.getMessage());
				e.printStackTrace();
				System.out.println("throw new ITMException(e);");
			}
		}

		if(listType.trim().equals("D")) //DISPATCH                 				 // replace listType instead of list by cpatil on 10-oct-12
		{
			rate = 0;
			try
			{
				sql = "SELECT RATE FROM PRICELIST "
						+ "WHERE PRICE_LIST = '"+priceList+"' "
						+ "AND ITEM_CODE = '"+itemCode+"' "
						+ "AND LIST_TYPE = ? "
						+ "AND EFF_FROM <= ? "
						+ "AND VALID_UPTO >= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,listType); 
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				rs = pstmt.executeQuery();				
				if(rs.next())
				{
					rate = rs.getDouble(1);
					rs.close(); 
					pstmt.close(); 
					rs = null; 
					pstmt = null; 
				}
				else
				{

					try
					{
						rs.close(); 
						pstmt.close(); 
						rs = null; 
						pstmt = null; 
						sql = "SELECT (CASE WHEN PRICE_LIST__PARENT IS NULL THEN '' ELSE PRICE_LIST__PARENT END) "
								+ "FROM pricelist_mst WHERE PRICE_LIST = '"+priceList+"' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							priceListParent = rs.getString(1);
							System.out.println("The priceListParent is .... "+priceListParent);
						}
						rs.close(); 
						pstmt.close(); 
						rs = null; 
						pstmt = null; 
						if((priceListParent == null) || (priceListParent.trim().length() == 0))
						{
							priceListParent = "";
							return -1;
						}
						if(priceListParent.trim().length() > 0)//1
						{
							try
							{
								sql = "SELECT RATE FROM PRICELIST "
										+ "WHERE PRICE_LIST = '"+priceListParent+"' "
										+ "AND ITEM_CODE = '"+itemCode+"' "
										+ "AND LIST_TYPE = ? "
										+ "AND EFF_FROM <= ? "
										+ "AND VALID_UPTO >= ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,listType);    				 
								pstmt.setTimestamp(2,tranDate);
								pstmt.setTimestamp(3,tranDate);
								rs2 = pstmt.executeQuery();
								if(rs2.next())
								{
									rate = rs2.getDouble(1);
									rs2.close(); 
									pstmt.close(); 
									rs2 = null; 
									pstmt = null; 
								}
								else
								{

									try
									{
										rs2.close();
										pstmt.close(); 
										rs2 = null; 
										pstmt = null; 
										sql = "SELECT RATE FROM PRICELIST "
												+ "WHERE PRICE_LIST = '"+priceList+"' "
												+ "AND ITEM_CODE = '"+itemCode+"' "
												+ "AND LIST_TYPE = ? "
												//	+ "AND LOT_NO__FROM <= '"+lotNo+"' "    //commented by cpatil on 10-oct-12
												//	+ "AND LOT_NO__TO >= '"+lotNo+"' "       //commented by cpatil on 10-oct-12 
												+ "AND EFF_FROM <= ? "
												+ "AND VALID_UPTO >= ?";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1,listType);    				
										pstmt.setTimestamp(2,tranDate);
										pstmt.setTimestamp(3,tranDate);
										rs2 = pstmt.executeQuery();
										if(rs2.next())
										{
											rate = rs2.getDouble(1);
											rs2.close();
											pstmt.close(); 
											rs2 = null; 
											pstmt = null; 
										}
										else
										{

											try
											{
												rs2.close();
												pstmt.close(); 
												rs2 = null; 
												pstmt = null; 
												sql = "SELECT (CASE WHEN PRICE_LIST__PARENT IS NULL THEN '' ELSE PRICE_LIST__PARENT END) "
														+ "FROM pricelist_mst WHERE PRICE_LIST = '"+priceList+"' ";
												pstmt = conn.prepareStatement(sql);
												rs2 = pstmt.executeQuery();
												if (rs2.next())
												{
													priceListParent = rs2.getString(1);
												}
												rs2.close();
												pstmt.close(); 
												rs2 = null; 
												pstmt = null; 
												if((priceListParent == null) || (priceListParent.trim().length() == 0))
												{
													priceListParent = "";
													return -1;
												}
												if(priceListParent.trim().length() > 0)//2
												{
													try
													{
														sql = "SELECT RATE FROM PRICELIST "
																+ "WHERE PRICE_LIST = '"+priceListParent+"' "
																+ "AND ITEM_CODE = '"+itemCode+"' "
																+ "AND LIST_TYPE = ? "
																//+ "AND LOT_NO__FROM <= '"+lotNo+"' "        //commented by cpatil on 10-oct-12
																//+ "AND LOT_NO__TO >= '"+lotNo+"' "          //commented by cpatil on 10-oct-12
																+ "AND EFF_FROM <= ? "
																+ "AND VALID_UPTO >= ?";
														pstmt = conn.prepareStatement(sql);
														pstmt.setString(1,listType);    				
														pstmt.setTimestamp(2,tranDate);
														pstmt.setTimestamp(3,tranDate);
														rs3 = pstmt.executeQuery();
														if(rs3.next())
														{
															rate = rs3.getDouble(1);
															rs3.close(); 
															pstmt.close(); 
															rs3 = null; 
															pstmt = null; 
														}
														else
														{
															rs3.close(); 
															pstmt.close(); 
															rs3 = null; 
															pstmt = null; 
															return -1;
														}
													}
													catch(Exception e)
													{
														e.printStackTrace();
														System.out.println("throw new ITMException(e);");
													}
												}
											}
											catch(Exception e)
											{
												e.printStackTrace();
												System.out.println("throw new ITMException(e);");
											}
										}

									}
									catch(Exception e)
									{
										e.printStackTrace();
										System.out.println("throw new ITMException(e);");
									}
								}

							}
							catch(Exception e)
							{
								e.printStackTrace();
								System.out.println("throw new ITMException(e);");
							}
						}

					}
					catch(Exception e)
					{
						e.printStackTrace();
						System.out.println("throw new ITMException(e);");
					}
				}
				if(rs != null )
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.clearParameters();
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				System.out.println("throw new ITMException(e);");
			}										
		}

		if(listType.trim().equals("B"))//BATCH PRICE			// replace listType instead of list by cpatil on 10-oct-12

		{
			rate = 0;
			try
			{				
				sql = "SELECT RATE FROM PRICELIST "
						+ "WHERE PRICE_LIST = '"+priceList+"' "
						+ "AND ITEM_CODE = '"+itemCode+"' "
						+ "AND LIST_TYPE = ? "
						//+ "AND LOT_NO__FROM <= '"+lotNo+"' "           //commented by cpatil on 10-oct-12
						//+ "AND LOT_NO__TO >= '"+lotNo+"' "             //commented by cpatil on 10-oct-12
						+ "AND EFF_FROM <= ? "
						+ "AND VALID_UPTO >= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,listType);    				
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					rate = rs.getDouble(1);
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				else
				{				
					try
					{
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						sql = "SELECT (CASE WHEN PRICE_LIST__PARENT IS NULL THEN '' ELSE PRICE_LIST__PARENT END) "
								+ "FROM pricelist_mst WHERE PRICE_LIST = '"+priceList+"' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{							
							priceListParent = rs.getString(1);	
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if((priceListParent == null) || (priceListParent.trim().length() == 0))
							{
								priceListParent = "";								
							}
							if(priceListParent.trim().length() > 0)
							{
								try
								{
									sql = "SELECT RATE FROM PRICELIST "
											+ "WHERE PRICE_LIST = '"+priceListParent+"' "
											+ "AND ITEM_CODE = '"+itemCode+"' "
											+ "AND LIST_TYPE = ? "
											//+ "AND LOT_NO__FROM <= '"+lotNo+"' "          //commented by cpatil on 10-oct-12
											//+ "AND LOT_NO__TO >= '"+lotNo+"' "            //commented by cpatil on 10-oct-12
											+ "AND EFF_FROM <= ? "
											+ "AND VALID_UPTO >= ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,listType);    				
									pstmt.setTimestamp(2,tranDate);
									pstmt.setTimestamp(3,tranDate);
									rs2 = pstmt.executeQuery();
									if(rs2.next())
									{
										rate = rs2.getDouble(1);
										rs2.close();
										rs2 = null;
										pstmt.close();
										pstmt = null;
									}
									else
									{
										rs2.close();
										rs2 = null;
										pstmt.close();
										pstmt = null;
										return -1;
									}
									if(rate > 0)
									{
										priceList = priceListParent ;
									}
									else
									{
										priceList = priceListParent ;	
										priceListParent = "";
									}
								}
								catch(Exception e)
								{
									e.printStackTrace();
									System.out.println("throw new ITMException(e);");
								}
							}
						} 						

					}
					catch(Exception e)
					{
						e.printStackTrace();
						System.out.println("throw new ITMException(e);");
					}
				}

			}
			catch(Exception e)
			{

				e.printStackTrace();
				System.out.println("throw new ITMException(e);");
			}
		}

		//type = listType;       	// commented and replace listType instead of list by cpatil on 10-oct-12

		if((listType.trim().equals("M")) || (listType.trim().equals("N"))) // Discount PRICE    		// replace listType instead of list by cpatil on 10-oct-12

		{
			rate = 0;
			System.out.println("Inside type ::-<M><N>-::");
			try
			{
				sql = "SELECT RATE FROM PRICELIST "
						+ "WHERE PRICE_LIST = '"+priceList+"' "
						+ "AND ITEM_CODE = '"+itemCode+"' "
						+ "AND LIST_TYPE = ? "       				// replace listType instead of list by cpatil on 10-oct-12
						+ "AND EFF_FROM <= ? "
						+ "AND VALID_UPTO >= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,listType);    				
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				rs = pstmt.executeQuery();
				System.out.println("Rate sql ..."+sql);
				if(rs.next())
				{
					rate = rs.getDouble(1);
					rs.close(); 
					pstmt.close(); 
					rs = null;  
					pstmt = null; 
				}
				else
				{
					try
					{
						rs.close(); 
						pstmt.close(); 
						rs = null;  
						pstmt = null; 
						sql = "SELECT (CASE WHEN PRICE_LIST__PARENT IS NULL THEN '' ELSE PRICE_LIST__PARENT END) "
								+ "FROM pricelist_mst WHERE PRICE_LIST = '"+priceList+"' ";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							priceListParent = rs.getString(1);
						}
						rs.close(); 
						pstmt.close(); 
						rs = null;  
						pstmt = null; 
						if((priceListParent == null) || (priceListParent.trim().length() == 0))
						{
							priceListParent = "";
							return -1;
						}
						if(priceListParent.trim().length() > 0)
						{
							//type = getPriceListType(priceList,conn);  		// commented by cpatil on 10-oct-12
							sql = "SELECT LIST_TYPE FROM PRICELIST_MST WHERE PRICE_LIST = '"+priceListParent+"' ";
							pstmt = conn.prepareStatement(sql);
							rs2 = pstmt.executeQuery();
							if(rs2.next())
							{
								listType = rs2.getString(1);
								rs2.close(); 
								pstmt.close(); 
								rs2 = null;  
								pstmt = null; 
							}

							try
							{
								sql = "SELECT RATE FROM PRICELIST "
										+ "WHERE PRICE_LIST = '"+priceListParent+"' "
										+ "AND ITEM_CODE = '"+itemCode+"' "
										+ "AND LIST_TYPE = ? "   // replace listType instead of list by cpatil on 10-oct-12
										+ "AND EFF_FROM <= ? "
										+ "AND VALID_UPTO >= ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,listType);    				
								pstmt.setTimestamp(2,tranDate);
								pstmt.setTimestamp(3,tranDate);
								rs2 = pstmt.executeQuery();
								System.out.println("The priceListParent sql .. "+sql);
								if(rs2.next())
								{
									rate = rs2.getDouble(1);
									rs2.close(); 
									pstmt.close(); 
									rs2 = null;  
									pstmt = null; 
								}
								else
								{
									rs2.close(); 
									pstmt.close(); 
									rs2 = null;  
									pstmt = null; 
									return -1;	
								}
							}
							catch(Exception e)
							{
								System.out.println("Exception...[pickRate] "+sql+e.getMessage());
								e.printStackTrace();
								System.out.println("throw new ITMException(e);");
							}
						}
					}
					catch(Exception e)
					{
						System.out.println("Exception...[pickRate] "+sql+e.getMessage());
						e.printStackTrace();
						System.out.println("throw new ITMException(e);");
					}
				}

			}
			catch(Exception e)
			{
				System.out.println("Exception...[pickRate] "+sql+e.getMessage());
				e.printStackTrace();
				System.out.println("throw new ITMException(e);");
			}
		} 

		if(listType.trim().equals("I")) //Inventory          // replace listType instead of list by cpatil on 10-oct-12

		{
			rate = 0;
			if ((lotSl == null) || (lotSl.trim().length() == 0))
			{
				System.out.println("Inside type ::-<I>-::");
				try
				{
					sql = "SELECT RATE FROM STOCK "
							+ "WHERE ITEM_CODE = '"+itemCode+"' "
							+ "AND SITE_CODE = '"+siteCode+"' "
							+ "AND LOC_CODE = '"+locCode+"' ";
					//+ "AND LOT_NO = '"+lotNo+"'";          //commented by cpatil on 10-oct-12
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						rate = rs.getDouble(1);
						System.out.println("Rate is .*...."+rate);
					}
					rs.close(); 
					pstmt.close(); 
					rs = null;  
					pstmt = null; 
				}
				catch(Exception e)
				{
					System.out.println("Exception...[pickRate] "+sql+e.getMessage());
					e.printStackTrace();
					System.out.println("throw new ITMException(e);");
				}
			}
			else
			{
				try
				{
					sql = "SELECT RATE FROM STOCK "
							+ "WHERE ITEM_CODE = '"+itemCode+"' "
							+ "AND SITE_CODE = '"+siteCode+"' "
							+ "AND LOC_CODE = '"+locCode+"' "
							//+ "AND LOT_NO = '"+lotNo+"' "        //commented by cpatil on 10-oct-12
							+ "AND LOT_SL = '"+lotSl+"'";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						rate = rs.getDouble(1);
					}
					rs.close(); 
					pstmt.close(); 
					rs = null;  
					pstmt = null; 
				}
				catch(Exception e)
				{
					System.out.println("Exception...[pickRate] "+sql+e.getMessage());
					e.printStackTrace();
					System.out.println("throw new ITMException(e);");
				}
			}
		}
		return(rate);
	}

}
