package proteus.ecm.hibernate.bean;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Indexed;
import org.json.JSONObject;

@Indexed
@XmlRootElement(name = "itemDetails")
public class ItemDetails implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;

	private String itemCode;
	private String itemQuantity;
	private String itemCategory; // JSON String
	private String itemSubCategory; // JSON String
	private String itemHeader; // JSON String
	private String itemDetail1; // JSON String : offers - bank offers, discount info. ; services - Deliveries etc.
	private String itemDetail2; // JSON String : policies - return, delivery policies; terms & conditions etc.
	private String itemVariants; // JSON String
	private String itemAttributes; // JSON String
	private String productStatus; // JSON String
	private String itemRatings; // JSON String
	
	public ItemDetails() {
		
	}

	public String getItemCode() {
		return itemCode;
	}

	@XmlElement
	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getItemQuantity() {
		return itemQuantity;
	}

	@XmlElement
	public void setItemQuantity(String itemQuantity) {
		this.itemQuantity = itemQuantity;
	}

	public String getItemCategory() {
		return itemCategory;
	}

	@XmlElement
	public void setItemCategory(String itemCategory) {
		this.itemCategory = itemCategory;
	}

	public String getItemSubCategory() {
		return itemSubCategory;
	}

	@XmlElement
	public void setItemSubCategory(String itemSubCategory) {
		this.itemSubCategory = itemSubCategory;
	}

	public String getItemHeader() {
		return itemHeader;
	}

	@XmlElement
	public void setItemHeader(String itemHeader) {
		this.itemHeader = itemHeader;
	}

	public String getProductStatus() {
		return productStatus;
	}

	@XmlElement
	public void setProductStatus(String productStatus) {
		this.productStatus = productStatus;
	}

	public String getItemDetail1() {
		return itemDetail1;
	}

	@XmlElement
	public void setItemDetail1(String itemDetail1) {
		this.itemDetail1 = itemDetail1;
	}

	public String getItemDetail2() {
		return itemDetail2;
	}

	@XmlElement
	public void setItemDetail2(String itemDetail2) {
		this.itemDetail2 = itemDetail2;
	}

	public String getItemRatings() {
		return itemRatings;
	}

	@XmlElement
	public void setItemRatings(String itemRatings) {
		this.itemRatings = itemRatings;
	}

	public String getItemVariants() {
		return itemVariants;
	}

	@XmlElement
	public void setItemVariants(String itemVariants) {
		this.itemVariants = itemVariants;
	}

	public String getItemAttributes() {
		return itemAttributes;
	}

	@XmlElement
	public void setItemAttributes(String itemAttributes) {
		this.itemAttributes = itemAttributes;
	}

	@Override
	public String toString(){
		return "\n ItemDetails.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
