package proteus.ecm.cache.dao;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.hibernate.bean.ECMCategory;
import proteus.ecm.hibernate.bean.ECMSubCategory;
import proteus.ecm.hibernate.bean.ItemDetails;
import proteus.ecm.hibernate.bean.ItemMaster;

public class CategoryCache 
{
	// #####################################################################
	//  ECMCategory
	// #####################################################################
	public void storeCategories(List<ECMCategory> categories, String cacheName )
	{
		System.out.println("Inside storeCategories >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );

			Object obj = cache.get("TOTAL_CATEGORY");
			JSONObject catCodes = null;
			if( obj != null )
			{
				catCodes = (JSONObject) obj;
			}
			else
			{
				catCodes = new JSONObject();
			}

			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			for(ECMCategory category : categories)
			{
				cache.put(category.getCatCode(), category);
				
				JSONObject catObj = new JSONObject();
				catObj.put("catShDescr", category.getShDescr());
				catObj.put("catDescr", category.getDescr());
				catObj.put("catKeys", category.getKeyAttrib());
				catObj.put("count", 0);
				catObj.put("list", new JSONArray());
				
				catCodes.put(category.getCatCode(), catObj);
			}
			cache.put("TOTAL_CATEGORY", catCodes);
			
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException | JSONException e) 
		{
			System.out.println("storeCategories()----Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeCategories----\n");
			e.printStackTrace();
		}
	}

	// @RestService == > "/category"
	public List<ECMCategory> getCachedCategories( String cacheName )
	{
		System.out.println("Inside getCachedCategories >>" + cacheName);
		List<ECMCategory> categories = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(ECMCategory.class).build();
			System.out.println("getCachedCategories Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				categories = query.list();
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException  e) 
		{
			System.out.println("getCachedCategories()---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return categories;
	}

	// @RestService == > "/category/{catCode}"
	public ECMCategory getCachedCategory(String catCode, String cacheName) 
	{
		System.out.println("Inside getCachedCategory >>" + cacheName);
		ECMCategory category = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
			
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(ECMCategory.class).having("catCode").eq(catCode).toBuilder().build();
			System.out.println("getCachedCategory Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				List<ECMCategory> categories = query.list();
				if(categories != null && categories.size() > 0)
				{
					category = categories.get(0);
				}
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedCategory(catCode)---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return category; 
	}

	// #####################################################################
	//  ECMSubCategory
	// #####################################################################
	public void storeSubCategories(List<ECMSubCategory> subCategories, String cacheName )
	{
		System.out.println("Inside storeSubCategories >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			HashMap<String, JSONObject> subCatTotMap = new HashMap<String, JSONObject>();
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			for(ECMSubCategory subcategory : subCategories)
			{
				cache.put(subcategory.getScatCode(), subcategory);
				
				String key = subcategory.getCatCode();
				JSONObject catObj = subCatTotMap.get(key);
				
				if( catObj == null ){
					catObj = new JSONObject();
					catObj.put("count", 0);
					catObj.put("list", new JSONArray());
				}
				
				JSONArray list = catObj.getJSONArray("list");
				JSONObject scatObj = new JSONObject();
				scatObj.put("scatCode", subcategory.getScatCode());
				scatObj.put("scatShDescr", subcategory.getShDescr());
				scatObj.put("scatDescr", subcategory.getDescr());
				scatObj.put("scatKeys", subcategory.getKeyAttrib());
				scatObj.put("count", 0);
				scatObj.put("list", new JSONArray());
				list.put( scatObj );
				
				int cnt = catObj.getInt("count");
				if( cnt > 0 ) {
					cnt++;
				}
				else
				{
					cnt = 1;
				}
				catObj.put("count", cnt);
				catObj.put("list", list);
				subCatTotMap.put(key, catObj);
			}
			cache.put("TOTAL_SUBCATEGORY", subCatTotMap);
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException | JSONException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeSubCategories----\n");
			e.printStackTrace();
		}
	}

	// @RestService == > "/category/list"
	public List<ECMSubCategory> getCachedAllSubCategories(String cacheName)
	{
		System.out.println("Inside getCachedAllSubCategories >>" + cacheName);
		List<ECMSubCategory> subCategories = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(ECMSubCategory.class).build();
			System.out.println("getCachedAllSubCategories Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				subCategories = query.list();
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedAllSubCategories() -----------Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] getCachedCategories----\n");
			e.printStackTrace();
		}
		return subCategories;
	}
	
	// @RestService == > "/category/{catCode}/list"
	public List<ECMSubCategory> getCachedSubCategories(String catCode, String cacheName)
	{
		System.out.println("Inside getCachedSubCategories >>" + cacheName);
		List<ECMSubCategory> subCategories = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(ECMSubCategory.class).having("catCode").eq(catCode).toBuilder().build();
			System.out.println("getCachedSubCategories Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				subCategories = query.list();
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedSubCategories(catCode) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return subCategories;
	}
	
	// @RestService == > "/category/list/{scatCode}"
	public ECMSubCategory getCachedSubCategory(String scatCode, String cacheName) 
	{
		System.out.println("Inside getCachedSubCategory >>" + cacheName);
		ECMSubCategory subCategory = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			
			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(ECMSubCategory.class).having("scatCode").eq(scatCode).toBuilder().build();
			System.out.println("getCachedSubCategory Query Result Size:" + query.getResultSize());
			
			if( query.getResultSize() > 0)
			{
				// Execute the query
				List<ECMSubCategory> subCategories = query.list();
				if(subCategories != null && subCategories.size() > 0)
				{
					subCategory = subCategories.get(0);
				}
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedSubCategory(scatCode) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return subCategory; 
	}

	
	// @RestService == > "/category/itemlist/{scatCode}"
	public List<ItemMaster> getCachedItems(String siteCode, String scatCode, String cacheName)
	{
		System.out.println("Inside getCachedItems scatCode >> " + scatCode + " cacheName >>" + cacheName);
		List<ItemMaster> cachedItems = null;
		try 
		{
			List<String> scatCodeList = new ArrayList<String>();
			scatCodeList.add(scatCode);
			
			SystemCache systemCache = new SystemCache();
			//List<String> itemCodeList = systemCache.getSiteItemsByScatCode(siteCode, scatCodeList, CacheManager.SYSTEM_CACHE_NAME);
			List<String> itemCodeList = systemCache.getSiteItemsByScatCode(siteCode, scatCodeList, cacheName);
			cachedItems = getCachedItems(itemCodeList, cacheName);
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItems(scatCode) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedItems; 
	}

	public void storeItems(List<ItemMaster> items, String scatCode, String cacheName) 
	{
		System.out.println("Inside storeItems >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName+""+scatCode);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			for(ItemMaster itemMaster : items)
			{
				cache.put(scatCode+"_"+itemMaster.getItemCode(), itemMaster);
			}
			tm.commit();
			
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeSubCategories----\n");
			e.printStackTrace();
		}
	}

	public List<ItemMaster> getCachedTrendingItems(String siteCode, String cacheName) 
	{
		System.out.println("Inside getCachedItems >>" + cacheName);
		List<ItemMaster> cachedTrendingItems = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			System.out.println("\n cache.containsKey(TRENDING_ITEMS) ==> " + cache.containsKey("TRENDING_ITEMS"));
			if( cache.get("TRENDING_ITEMS") != null )
			{
				cachedTrendingItems = (List<ItemMaster>) cache.get("TRENDING_ITEMS");
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedTrendingItems() ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("getCachedTrendingItems() ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedTrendingItems; 
	}
	
	public void storeTrendingItems(List<ItemMaster> items, String cacheName) 
	{
		System.out.println("Inside storeTrendingItems >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put("TRENDING_ITEMS", items);
			tm.commit();
			
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeTrendingItems----\n");
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("storeTrendingItems() ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
	}
	
	public List<ItemMaster> getCachedItems(List<String> itemCodeList, String cacheName) 
	{
		System.out.println("Inside getCachedItems itemCodeList >> " + itemCodeList + " cacheName >>" + cacheName);
		List<ItemMaster> cachedItems = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			if( itemCodeList != null && !itemCodeList.isEmpty() )
			{
				Cache cache = CacheManager.getInstance().getCache( cacheName );
				QueryFactory queryFactory = Search.getQueryFactory(cache);
				// Construct a query 
				org.infinispan.query.dsl.Query query = queryFactory.from(ItemMaster.class).having("item_code").in(itemCodeList).toBuilder().build();
				System.out.println("getCachedItems Query Result Size:" + query.getResultSize());
			
				if( query.getResultSize() > 0)
				{
					// Execute the query
					cachedItems = query.list();
					System.out.println("cachedItems by query in getCachedItems" +cachedItems);
				}
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItems(itemCodeList) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedItems; 
	}
	
	public List<ItemDetails> getCachedItemsDetail(List<String> itemCodeList, String cacheName) 
	{
		System.out.println("Inside getCachedItems itemCodeList >> " + itemCodeList + " cacheName >>" + cacheName);
		List<ItemDetails> cachedItems = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			if( itemCodeList != null && !itemCodeList.isEmpty() )
			{
				Cache cache = CacheManager.getInstance().getCache( cacheName );
				QueryFactory queryFactory = Search.getQueryFactory(cache);
				// Construct a query 
				org.infinispan.query.dsl.Query query = queryFactory.from(ItemDetails.class).having("itemCode").in(itemCodeList).toBuilder().build();
				System.out.println("getCachedItems Query Result Size:" + query.getResultSize());
			
				if( query.getResultSize() > 0)
				{
					// Execute the query
					cachedItems = query.list();
					System.out.println("cachedItems by query in getCachedItems" +cachedItems);
				}
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItems(itemCodeList) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedItems; 
	}

	public List<ItemMaster> getCachedItems(Map<String, Date> browsedItems, String cacheName) 
	{
		List<ItemMaster> cachedItems = null;
		try 
		{
			List<String> itemCodeList = new ArrayList<String>(browsedItems.keySet());
			System.out.println("Inside getCachedItems itemCodeList >> browsedItems " + itemCodeList + " cacheName >>" + cacheName);
			cachedItems = getCachedItems(itemCodeList, cacheName);
			
			cachedItems = sortByValues(itemCodeList, cachedItems);
			
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItems(itemCodeList) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedItems; 
	}
	
	// TODO
	//private List<ItemMaster> sortByValues(Map<String, Date> map, List<ItemMaster> cachedItemList) 
	private List<ItemMaster> sortByValues(List<String> sortedItemCodelist, List<ItemMaster> cachedItemList) 
	{
		List<ItemMaster> cachedItems = new ArrayList<ItemMaster>();
		for (String itemCode : sortedItemCodelist) 
		{
			for (ItemMaster item : cachedItemList) 
			{
				if ( itemCode.equals(item.getItemCode() )) 
				{
					cachedItems.add(item);
					System.out.println("Found in Sorted Key Iteration" + itemCode);
					break;
				}
			}
		}
		//System.out.println("Sorted ItemCode List: "+sortedItemCodelist);
		//System.out.println("Before :::" + cachedItemList);
		System.out.println("After sortByValues :::" + cachedItems);
		return cachedItems;
	}

	
	public JSONArray getCachedStats(String cacheName, String siteCode)
	{
		System.out.println("Inside getCachedStats >>" + cacheName);
		JSONArray categorySummary = new JSONArray();
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			Object catSummaryObj = cache.get("CAT_SUMMARY");
			if( catSummaryObj == null ) {
				createCategorySummay(cacheName, siteCode);
				catSummaryObj = cache.get("CAT_SUMMARY");
			}
			categorySummary = (JSONArray)catSummaryObj;
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedStats()----Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "]");
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			System.out.println("getCachedStats()----Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "]");
			e.printStackTrace();
		}
		return categorySummary;
	}
			
	private void createCategorySummay(String cacheName, String siteCode)
	{
		System.out.println("Inside createCategorySummay >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			
			JSONArray categorySummary = new JSONArray();
			
			JSONObject totalCategory = (JSONObject) cache.get("TOTAL_CATEGORY");
			HashMap<String, JSONObject> subCatTotMap = (HashMap<String, JSONObject>) cache.get("TOTAL_SUBCATEGORY");
			HashMap<String, JSONObject> itemsTotMap = (HashMap<String, JSONObject>) cache.get("TOTAL_ITEMS");
			itemsTotMap = updateCachedItems( siteCode, cacheName, itemsTotMap );
			
			for (Iterator<String> iterator = totalCategory.keys(); iterator.hasNext();) {
				String catCode = iterator.next();
				JSONObject catObj = totalCategory.getJSONObject(catCode);
				JSONObject catSubObj = subCatTotMap.get(catCode);
				System.out.println("catObj["+ catObj + "]");
				System.out.println("scatObj["+ catSubObj + "]");
				
				if( catSubObj != null )
				{
					JSONArray newCatSubObjArr = new JSONArray();
					JSONArray catSubObjArr = catSubObj.getJSONArray("list");
					int len = catSubObjArr.length();
					for( int idx = 0; idx < len; idx++ ){
						JSONObject subCatObj = catSubObjArr.getJSONObject(idx);
						
						String scatCode = subCatObj.getString("scatCode");
						JSONObject itemsObj = itemsTotMap.get(scatCode);
						
						subCatObj.put( "count", itemsObj.getInt("count") );
						subCatObj.put( "list", itemsObj.getJSONArray("list") );
						
						newCatSubObjArr.put(subCatObj);
					}
					catObj.put( "count", catSubObj.getInt("count") );
					catObj.put( "list", newCatSubObjArr );
					catObj.put( "subcategory", true );
				}
				else
				{
					JSONObject itemsObj = itemsTotMap.get(catCode);
					catObj.put( "count", itemsObj.getInt("count") );
					catObj.put( "list", itemsObj.getJSONArray("list") );
					catObj.put( "subcategory", false );
				}
				totalCategory.put(catCode, catObj);
				catObj.put("catCode", catCode);
				categorySummary.put(catObj);
			}

			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();

			cache.put("CAT_SUMMARY", categorySummary);
			
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("createCategorySummay()----Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "]");
			e.printStackTrace();
		}
		catch (Exception e) 
		{
			System.out.println("createCategorySummay()----Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "]");
			e.printStackTrace();
		}
	}

	private HashMap<String, JSONObject> updateCachedItems(String siteCode, String cacheName, HashMap<String, JSONObject> itemsTotMap) throws JSONException 
	{
		for (Iterator<String> iterator = itemsTotMap.keySet().iterator(); iterator.hasNext();) {
			String scatCode =  iterator.next();
			
			List<ItemMaster> cachedItems = getCachedItems(siteCode, scatCode, cacheName);
			
			JSONObject itemsObj = itemsTotMap.get(scatCode);
			JSONArray itemArr = new JSONArray();
			
			JSONObject itemObj = itemsObj.getJSONObject("list");
			for(ItemMaster itemMaster : cachedItems ) 
			{
				String itemCode = itemMaster.getItemCode();
				JSONObject itemChObj = itemObj.getJSONObject(itemCode) ;
				if( itemChObj == null )
				{
					itemChObj = new JSONObject();
				}
				itemChObj.put("itemCode", itemMaster.getItemCode());
				itemChObj.put("shDescr", itemMaster.getShDescr());
				itemChObj.put("descr", itemMaster.getDescr());
				
				itemArr.put(itemChObj);
			}
			System.out.println(" updateCachedItems itemArr["+ itemArr + "]" );
			itemsObj.put("list", itemArr);
			itemsTotMap.put(scatCode, itemsObj);
		}
		System.out.println(" updateCachedItems itemsTotMap["+ itemsTotMap + "]" );
		return itemsTotMap;
	}


}
