<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version='1.0'
    xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!-- <xsl:output media-type="text/html" encoding="UTF-8"/> -->
  
  <xsl:variable name="totalNum" select="response/result/@numFound"/>
  <xsl:variable name="j" select="aditi"/>
  
  <xsl:template match='/'>
    <Root>
	<data>
	 <div id="scroll">
	 <span class="result"><xsl:value-of select="concat('About ',$totalNum,' results found')"/></span>
	     <xsl:apply-templates select="response/result/doc"/>
	</div>
	</data>
	<page>
	<numFound><xsl:value-of select="$totalNum"/></numFound>
	</page>
	<facet>
		<xsl:apply-templates select="response/lst[@name='facet_counts']"/>
	</facet>
	</Root>
  </xsl:template>
  
  <xsl:template match="doc">
  <ul  class="liststyle">
  <li><span><xsl:value-of select="concat('SC CODE IS : ',str[@name='ID'])" /></span></li>
  <li><xsl:value-of select="concat('NAME OF CUSTOMER : ',str[@name='FIRST NAME'],'   ', str[@name='MIDDLE NAME'] ,'   ',str[@name='LAST NAME'])"/> </li>
  <li><b><xsl:value-of select="concat('GENDER : ')"/></b><xsl:value-of select="str[@name='GENDER']"/><b><xsl:value-of select="concat('  CITY : ')"/></b><xsl:value-of select="str[@name='City']"/><b><xsl:value-of select="concat('   STATE CODE : ')"/></b><xsl:value-of select="str[@name='State']"/></li>
  <li><b><xsl:value-of select="concat('ROUTE ID : ')"/></b><xsl:value-of select="str[@name='ROUTE-ID']"/><b><xsl:value-of select="concat('  STATUS : ')"/></b><xsl:value-of select="str[@name='STATUS']"/><b><xsl:value-of select="concat('   REPLY ID : ')"/></b><xsl:value-of select="str[@name='REPLY']"/><b><xsl:value-of select="concat('   ITEM SERIES : ')"/></b><xsl:value-of select="str[@name='ITEM-SERIES']"/></li>
  <li><b><xsl:value-of select="concat('SALES PERSONS DETAILS : ')"/></b></li>
  <li><b><xsl:value-of select="concat('SALES PERSON CODE : ')"/></b><xsl:value-of select="str[@name='SALES PERSON']"/><b><xsl:value-of select="concat('  SP NAME : ')"/></b><xsl:value-of select="str[@name='SP NAME']"/><b><xsl:value-of select="concat('   SH NAME : ')"/></b><xsl:value-of select="str[@name='SH NAME']"/><b><xsl:value-of select="concat('   SP TYPE : ')"/></b><xsl:value-of select="str[@name='SP TYPE']"/></li>
  <li><b><xsl:value-of select="concat('LOCALITY CODE : ')"/></b><xsl:value-of select="str[@name='Locality']"/><b><xsl:value-of select="concat('  DESCRIPTION : ')"/></b><xsl:value-of select="str[@name='DESCRIPTION']"/></li>
  <!--<xsl:value-of select="concat('myText:', /*/properties/property[@name='report']/@value)" />-->
  </ul>
  <!--<tr>
      <td><xsl:value-of select="str[@name='ID']"/></td>
      <td><xsl:value-of select="str[@name='ROUTE-ID']"/></td>
	  <td><xsl:value-of select="str[@name='REPLY']"/></td>
	  <td><xsl:value-of select="str[@name='STATUS']"/></td>
	  <td><xsl:value-of select="str[@name='ITEM-SERIES']"/></td>
	  <td><xsl:value-of select="str[@name='FIRST NAME']"/></td>
	  <td><xsl:value-of select="str[@name='MIDDLE NAME']"/></td>
      <td><xsl:value-of select="str[@name='LAST NAME']"/></td>
	  <td><xsl:value-of select="str[@name='GENDER']"/></td>
	  <td><xsl:value-of select="str[@name='SALES PERSON']"/></td>
	  <td><xsl:value-of select="str[@name='CITY']"/></td>
	  <td><xsl:value-of select="str[@name='STATE-CODE']"/></td>
	  <td><xsl:value-of select="str[@name='SP NAME']"/></td>
	  <td><xsl:value-of select="str[@name='DESCRIPTION']"/></td>
	  </tr>-->
  </xsl:template>

<xsl:template match="lst[@name='facet_fields']">
	<xsl:for-each select="lst">
	<xsl:variable name="forId" select="@name"/>
	<!-- Create table for facet search text box with auto complete -->
	<xsl:element name="table">
	<xsl:attribute name="id"><xsl:value-of select="concat($forId,'_TB')"/></xsl:attribute>
	<xsl:attribute name="cellspacing"><xsl:text>0</xsl:text></xsl:attribute>
	<xsl:attribute name="cellpadding"><xsl:text>0</xsl:text></xsl:attribute>
	<xsl:element name="tr">
		<xsl:element name="td">
		<xsl:attribute name="colspan"><xsl:text>2</xsl:text></xsl:attribute>
		<label>
		<xsl:value-of select="$forId"/>
		</label>
		</xsl:element>
	</xsl:element>
		<xsl:element name="tr">
			<xsl:element name="td">
			<xsl:attribute name="width"><xsl:text>80%</xsl:text></xsl:attribute>
			<div class="input">
				<xsl:element name="input">
				<xsl:attribute name="id"><xsl:value-of select="$forId"/></xsl:attribute>
				<xsl:attribute name="type"><xsl:value-of select="concat('text')"/></xsl:attribute>
				<!--<xsl:attribute name="placeholder"><xsl:value-of select="$forId"/></xsl:attribute>
				<xsl:attribute name="class"><xsl:text>ui-autocomplete-input</xsl:text></xsl:attribute>-->
				<!--<xsl:attribute name="onfocus"><xsl:text>gotFocus(this)</xsl:text></xsl:attribute>
				<xsl:attribute name="onkeyup"><xsl:text>getAutocompleteData(this,event)</xsl:text></xsl:attribute>-->
				</xsl:element><!-- end of input element-->
			</div>
			</xsl:element><!-- end of td element-->
			<xsl:element name="td">
			<xsl:attribute name="width"><xsl:text>20%</xsl:text></xsl:attribute>
			<xsl:attribute name="style"><xsl:text>vertical-align: bottom;</xsl:text></xsl:attribute>
			<xsl:element name="button">
				<xsl:attribute name="class"><xsl:text>Facet_Click</xsl:text></xsl:attribute>
				<xsl:attribute name="id"><xsl:value-of select="concat($forId,'_BUTTON')"/></xsl:attribute>
			</xsl:element>
		</xsl:element>
		</xsl:element><!-- end of tr element-->	
	</xsl:element>
	<!-- End of table for facet search text box with auto complete -->
	<xsl:element name="ul">
		<xsl:attribute name="id"><xsl:value-of select="concat($forId,'_UL')"/></xsl:attribute>
		<xsl:for-each select="int">
		<xsl:variable name="val" select="."/>
		<xsl:if test="$val &gt;0" >
			<xsl:element name="li">
			<xsl:variable name="key" select="@name"/>
			<xsl:variable name="keyvalue" select="."/>
			<xsl:attribute name="id"><xsl:value-of select="$key"/></xsl:attribute>			
				<xsl:text><xsl:value-of select="concat($key,'-(',$keyvalue,')')"/></xsl:text>
			</xsl:element>
		  </xsl:if>
		</xsl:for-each>
	</xsl:element>
    </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
