import { Component, Input, ViewChild, Attribute, ElementRef, Renderer } from '@angular/core';
import { NgModel } from '@angular/forms';
import { ValueAccessorBase } from '../form';
export class BBTextAreaComponent extends ValueAccessorBase {
    constructor(elementRef, renderer, validator) {
        super();
        this.validator = validator;
        this.bbRows = 3; //default value for rows
        this.bbColoumn = 12; //default value for column
        this.bbResize = 'none';
        this.bbDirection = 'ltr'; //direction of text rtl,ltr
        this.uxDesign = 'UX3';
        this.bbPlaceholder = '';
        this.bbRequired = false;
        this.value = '';
        this.bbDisabled = false;
        this.bbMaxlength = 524288; //default value for maxlength
        this.bbMinlength = 0; //default value for minlength
        this.bbReadOnly = false;
        this.bbAutofocus = false;
        this.bbAutoexpand = false;
        this.requiredMessage = 'This field is required';
        this.bbExpression = /^/;
        this.invalidMessage = 'Invalid Input';
        this.bbLabel = '';
        this.bbLabelPostion = "top";
        this.customErrorMessages = {
            'required': () => this.requiredMessage,
            'minlength': (params) => 'The min number of characters is ' + params.requiredLength,
            'maxlength': (params) => 'The max allowed number of characters is ' + params.requiredLength,
            'email': (params) => params.message,
            'password': (params) => params.message,
            'phone': (params) => params.message
        };
        renderer.listen(elementRef.nativeElement, 'keydown', (event) => {
            // Do something with 'event'
            if (this.bbAutoexpand)
                this.autosize();
        });
    }
    autosize() {
        let el = this.textArea.nativeElement;
        setTimeout(function () {
            el.style.height = 'auto';
            el.style.padding = '0';
            // for box-sizing other than "content-box" use:
            // el.style.cssText = '-moz-box-sizing:content-box';
            //   console.log("el style",el.style);
            el.style.height = el.scrollHeight + 'px';
        }, 0);
    }
    validate(c) {
        if (!this.validator) {
            return;
        }
        if (!c.value) {
            this.errors = null;
            return;
        }
        const isValidText = this.bbExpression.test(c.value);
        const message = {
            'textarea': {
                'message': this.invalidMessage
            }
        };
        if (!isValidText) {
            this.errors = message;
        }
        else {
            this.errors = null;
        }
        return isValidText ? null : message;
    }
}
BBTextAreaComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-textarea',
                template: `
      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX3'"> 
      		<md-form-field>
      			<textarea #textArea #textarea="ngModel" mdInput [(ngModel)]="value" [placeholder]="bbPlaceholder" [required]="bbRequired" [disabled]="bbDisabled" [value]="value" [maxLength]="bbMaxlength" [minLength]="bbMinlength" [style.resize]="bbResize" [style.direction]="bbDirection" [rows]="bbRows" [cols]="bbColoumn" [readOnly]="bbReadOnly"  [autofocus]="bbAutofocus">
      			</textarea>
      			<md-hint>
      				<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      			</md-hint>
      		</md-form-field>	
      	</span>
	
      	<span *ngSwitchCase="'UX2'">
      		<span  [ngClass]="{'labelPostion':bbLabelPostion === 'top'}">{{bbLabel}}</span>
      		<textarea #textArea #textarea="ngModel"  [(ngModel)]="value" [required]="bbRequired" [disabled]="bbDisabled" [value]="value" [maxLength]="bbMaxlength" [minLength]="bbMinlength" [style.resize]="bbResize" [style.direction]="bbDirection" [rows]="bbRows" [cols]="bbColoumn" [readOnly]="bbReadOnly"  [autofocus]="bbAutofocus">
      	    </textarea>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
      	</span>
	
      	<span *ngSwitchCase="'UX1'">
      		<textarea #textArea #textarea="ngModel"  [(ngModel)]="value"  [placeholder]="bbPlaceholder"  [required]="bbRequired" [disabled]="bbDisabled" [value]="value" [maxLength]="bbMaxlength" [minLength]="bbMinlength" [style.resize]="bbResize" [style.direction]="bbDirection" [rows]="bbRows" [cols]="bbColoumn" [readOnly]="bbReadOnly"  [autofocus]="bbAutofocus">
      	    </textarea>
      		<validation [control]="model" [errors]="errors" [errorMessages]="customErrorMessages"></validation>
		
      	</span>
      </span>
    `,
                styles: [`
      .labelPostion{
      display: table;
      }
    `]
            },] },
];
/** @nocollapse */
BBTextAreaComponent.ctorParameters = () => [
    { type: ElementRef, },
    { type: Renderer, },
    { type: undefined, decorators: [{ type: Attribute, args: ["validator",] },] },
];
BBTextAreaComponent.propDecorators = {
    'textArea': [{ type: ViewChild, args: ['textArea',] },],
    'model': [{ type: ViewChild, args: [NgModel,] },],
    'align': [{ type: Input, args: ['align',] },],
    'bbRows': [{ type: Input, args: ['rows',] },],
    'bbColoumn': [{ type: Input, args: ['cols',] },],
    'bbResize': [{ type: Input, args: ['resize',] },],
    'bbDirection': [{ type: Input, args: ['direction',] },],
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'uxTheme': [{ type: Input, args: ['uxTheme',] },],
    'bbPlaceholder': [{ type: Input, args: ['placeholder',] },],
    'bbRequired': [{ type: Input, args: ['required',] },],
    'value': [{ type: Input, args: ['value',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
    'bbMaxlength': [{ type: Input, args: ['maxlength',] },],
    'bbMinlength': [{ type: Input, args: ['minlength',] },],
    'bbReadOnly': [{ type: Input, args: ['readOnly',] },],
    'bbAutofocus': [{ type: Input, args: ['autofocus',] },],
    'bbAutoexpand': [{ type: Input, args: ['autoexpand',] },],
    'requiredMessage': [{ type: Input, args: ['requiredMessage',] },],
    'bbExpression': [{ type: Input, args: ['expression',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'bbLabel': [{ type: Input, args: ['label',] },],
    'bbLabelPostion': [{ type: Input, args: ['labelPosition',] },],
};
//# sourceMappingURL=bb-text-area.component.js.map