import { Component, Directive, Input, ContentChildren, ElementRef, forwardRef, Output, EventEmitter } from '@angular/core';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
import { ValueAccessorBase } from '../form/value-accessor';
let _uniqueIdCounter = 0;
export const BB_SELECT_CONTROL_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(() => BBSelect),
    multi: true
};
export class BBSelect extends ValueAccessorBase {
    constructor() {
        super(...arguments);
        this.uxDesign = 'UX3';
        this.bbPlaceholder = 'Select';
        this.bbRequired = false;
        this.bbDisableRipple = false;
        this.bbMultiple = false;
        this.bbChange = new EventEmitter();
        this.bbOnOpen = new EventEmitter();
        this.bbOnClose = new EventEmitter();
    }
    ngAfterContentInit() {
        console.log('optionGroups', this.options);
        this.options.forEach(alertInstance => console.log(alertInstance));
    }
}
BBSelect.decorators = [
    { type: Component, args: [{
                selector: 'bb-select',
                template: `
      <span [ngSwitch]="uxDesign">
      	<span *ngSwitchCase="'UX1'">
      		<select [(ngModel)]="value" (change)="bbChange.emit();" (onOpen)="bbOnOpen.emit();" (onClose)="bbOnClose.emit();" [required]="bbRequired" [multiple]="bbMultiple">
      			<option *ngFor="let option of options" [value]="option.bbValue" [disabled]="option.bbDisabled">
      				{{option.viewValue}}
      			</option>
      		</select>
      	</span>
	
      	<span *ngSwitchCase="'UX3'">
      		<md-select [(ngModel)]="value" (change)="bbChange.emit();" (onOpen)="bbOnOpen.emit();" (onClose)="bbOnClose.emit();" [required]="bbRequired" [floatPlaceholder]="bbFloatPlaceholder" [placeholder]="bbPlaceholder" [multiple]="bbMultiple" [disableRipple]="bbDisableRipple" [panelClass]="bbPanelClass">
      			<md-option *ngFor="let option of options" [value]="option.bbValue" [disabled]="option.bbDisabled">
      				{{option.viewValue}}
      			</md-option>
      		</md-select>
      	</span>
	
      	<ng-template #content><ng-content></ng-content></ng-template>
      </span>
    `,
                styles: [`

    `],
                providers: [BB_SELECT_CONTROL_VALUE_ACCESSOR]
            },] },
];
/** @nocollapse */
BBSelect.ctorParameters = () => [];
BBSelect.propDecorators = {
    'options': [{ type: ContentChildren, args: [forwardRef(() => BBOption),] },],
    'uxDesign': [{ type: Input, args: ['uxDesign',] },],
    'bbPlaceholder': [{ type: Input, args: ['placeholder',] },],
    'bbRequired': [{ type: Input, args: ['required',] },],
    'bbFloatPlaceholder': [{ type: Input, args: ['floatPlaceholder',] },],
    'bbValue': [{ type: Input, args: ['value',] },],
    'bbDisableRipple': [{ type: Input, args: ['disableRipple',] },],
    'bbPanelClass': [{ type: Input, args: ['panelClass',] },],
    'bbMultiple': [{ type: Input, args: ['multiple',] },],
    'bbChange': [{ type: Output },],
    'bbOnOpen': [{ type: Output },],
    'bbOnClose': [{ type: Output },],
};
export class BBOption {
    constructor(_element) {
        this._element = _element;
        this._uniqueId = `bb-option-${_uniqueIdCounter++}`;
        this.bbId = this._uniqueId;
        this.bbDisabled = false;
    }
    _getHostElement() {
        return this._element.nativeElement;
    }
    get viewValue() {
        return (this._getHostElement().textContent || '').trim();
    }
}
BBOption.decorators = [
    { type: Directive, args: [{
                selector: 'bb-option'
            },] },
];
/** @nocollapse */
BBOption.ctorParameters = () => [
    { type: ElementRef, },
];
BBOption.propDecorators = {
    'bbValue': [{ type: Input, args: ['value',] },],
    'bbId': [{ type: Input, args: ['id',] },],
    'bbDisabled': [{ type: Input, args: ['disabled',] },],
};
//# sourceMappingURL=bb-choice.component.js.map