import { Component, OnInit, EventEmitter, Input, Output } from '@angular/core';

@Component({
  selector: 'rating',
  templateUrl: './rating.component.html',
  styleUrls: ['./rating.component.css']
})
export class RatingComponent implements OnInit {

    private range:Array<number> = [5,4,3,2,1];
    private overallRatings:Array<number> = [25,10,7,3,1];
    @Input() rate:number;
    @Input() isResponsive = false;
    @Input() ratingDetail;
    @Input() isSmallRatings;
    @Output() updateRate= new EventEmitter();
    @Output() filterBy= new EventEmitter();
    totalRatings = 0;
    keys;
    temp;
    
    constructor() { }

    ngOnInit() {
        if(this.ratingDetail)
        {
            this.overallRatings.forEach(( rating, i ) => {
                this.totalRatings = this.totalRatings + rating;
            });   
        }
    }
    
    update(value:number) {
        if((this.temp == 1) && value == 1)
        {
            console.log('rate = 1',this.rate,value);
            this.rate = 0;
            this.temp = this.rate;
            this.updateRate.next(0);
        }
        else
        {
            console.log('rate != 1',this.rate,value);
            this.rate = value;
            this.temp = this.rate;
            this.updateRate.next(value);
        }    
    }
    
    reset(){
        if(this.isResponsive){
            this.temp = this.rate;
            this.rate = 0;
        }
    }
    
    setPrevious(){
        if(this.isResponsive){
            this.rate = this.temp;
        }
    }
}
