import { Component, OnInit, Input, Output, EventEmitter, OnChanges } from '@angular/core';

@Component( {
    selector: 'ecm-variants',
    templateUrl: './ecm-variants.component.html',
    styleUrls: ['./ecm-variants.component.css']
})
export class EcmVariantsComponent implements OnChanges{

    @Input( 'itemCode' ) itemCode: string;
    @Input( 'itemVariants' ) itemVariants;
    @Output() selected = new EventEmitter();
    @Input( 'interactive' ) interactive: boolean = true;
    enterpise = localStorage.getItem( 'ENTERPRISE' ); 
    currentVariants;
    traceData: any;
    availableDates: Array<string> = [];
    availableTimings: Array<string> = [];
    availableSizes: Array<string> = [];
    availableColors: Array<string> = [];
    date_selected;
    time_selected;
    size_selected;
    color_selected;
    timeVar;

    constructor() { }

    ngOnChanges() {
        console.log( 'OnInit Item Variants and itemcode', this.itemVariants, this.itemCode );
        if(this.itemVariants.products){
            this.fetchAttributes();
        }
    }

    fetchAttributes() {
        
        this.currentVariants = this.itemVariants.products[this.itemCode];
        console.log( 'data in fetch currentVariants', this.currentVariants );
        console.log( this.itemVariants.products, this.currentVariants );
        this.itemVariants.attributes.forEach( keyAttribute => {

            if ( keyAttribute.index >= 0 ) {
                if ( keyAttribute.label == 'Date' ) {
                    this.date_selected = this.currentVariants[this.getVarIndex( 'Date' )];
                    this.itemVariants.attributeOptions[keyAttribute.index].forEach( variant => {
                        if ( variant.value ) {
                            this.availableDates.push( variant );
                        }
                    });
                }

                if ( keyAttribute.label == 'Time' ) {
                    this.time_selected = this.currentVariants[this.getVarIndex( 'Time' )];
                    this.itemVariants.attributeOptions[keyAttribute.index].forEach( variant => {
                        if ( variant.value ) {
                            this.availableTimings.push( variant );
                        }
                    });
                }
                if ( keyAttribute.label == 'Size' ) {
                    this.size_selected = this.currentVariants[this.getVarIndex( 'Size' )];
                    this.itemVariants.attributeOptions[keyAttribute.index].forEach( variant => {
                        if ( variant.value ) {
                            this.availableSizes.push( variant );
                        }
                    });
                }

                if ( keyAttribute.label == 'Color' ) {
                    this.color_selected = this.currentVariants[this.getVarIndex( 'Color' )];
                    this.itemVariants.attributeOptions[keyAttribute.index].forEach( variant => {
                        if ( variant.value ) {
                            this.availableColors.push( variant );
                        }
                    });
                }
            }
        });

    }

    getVarIndex( variant ) {
        let selectedVariant = this.itemVariants.attributes.find( keyAttribute => keyAttribute.label === variant );
        if ( !selectedVariant )
            return -1;
        return selectedVariant.index;
    }

    loadItem( index, variant ) {
        let varIndex;
        let currentVariants;
        
        if(this.size_selected != index)
        {    
            varIndex = this.getVarIndex( variant );
            currentVariants = this.simpleClone( this.currentVariants );
            currentVariants[varIndex] = index;
            console.log( 'loadItem index:[' + index + ']variant:[' + variant + ']varIndex[' + varIndex + ']', currentVariants );
    
            let itemCode;
            let keys = Object.keys( this.itemVariants.products );
            //items.find(x => x.itemCode === this.itemCode);
            keys.forEach( product => {
    
                let variants = this.itemVariants.products[product];
                console.log( 'loadItem variants:[', variants, currentVariants );
                if ( this.compare( currentVariants, variants ) ) {
                    if ( product != this.itemCode ) {
                        itemCode = product;
                        console.log( 'compare  product:[' + product + ']' );
                    }
                }
            });
            
    
            if ( itemCode ) {
                this.selected.emit( itemCode );
            }
        }
    }
    dispDateFormat = 'dd MMM yyyy - EEEE';
    dispTimeFormat = 'hh:mm a';
    toDate( dateStr ) {
        var parts = dateStr.split( "-" );
        return new Date( parts[2], parts[1] - 1, parts[0] );
    }

    toTime( timeStr ) {
        var parts = timeStr.split( ":" );
        var d = new Date();
        this.timeVar = new Date( d.getFullYear(), d.getMonth(), d.getDay(), parts[0], parts[1], 0, 0 );
        return new Date( d.getFullYear(), d.getMonth(), d.getDay(), parts[0], parts[1], 0, 0 );
    }

    compare( array1, array2 ) {
        if ( array1.length != array2.length )
            return false;
        else {
            for ( let i = 0; i < array1.length; i++ ) {
                if ( array1[i] != array2[i] )
                    return false;
            }
            return true;
        }
    }

    simpleClone( obj: any ) {
        return Object.assign( [], obj );
    }

}
