import { Component, OnInit, Input, Output, ViewChild, ElementRef, Inject, HostListener } from '@angular/core';
import { MdDialog, MdDialogRef, MD_DIALOG_DATA } from '@angular/material';

declare var disableScroll: any;
declare var enableScroll: any;

@Component({
  selector: 'ecm-panel',
  templateUrl: './ecm-panel.component.html',
  styleUrls: ['./ecm-panel.component.css']
})
export class EcmPanelComponent implements OnInit {

    
    @ViewChild( 'rightSlidePanel' ) rightSlidePanel: ElementRef;
    @ViewChild( 'overlayPanel' ) overlayPanel: ElementRef;
    @ViewChild( 'bgGlass' ) bgGlass: ElementRef;
    panelData:any;
    panelType:any;
//  dialogRef: MdDialogRef<ECMDialog>;
  
  constructor(/* public dialog: MdDialog */) { }

  ngOnInit() {
  }
  
  openTime:any;
  
  open(panelData){
      console.log('in open dialog event Ch' , panelData); 
      this.panelData = panelData;
      this.panelType = panelData.type;
      if( this.panelType == 'overlay' )
      {
          this.showOverlayPanel();
      }
      else if ( this.panelType == 'inplace' )
      {
          this.showSidePanel();
      }
      else
      {
          
      }
  }
  
  close(){
//      this.dialogRef.close();
      if( this.panelType == 'overlay' )
      {
          this.hideOverlayPanel();
      }
      else if ( this.panelType == 'inplace' )
      {
          this.hideSidePanel();
      }
      else
      {
          
      }
  }
  
  updatePosition(dialogPos){
//      this.dialogRef.updatePosition(dialogPos);
  }
  
  
  updateSize(dialogSize){
//      this.dialogRef.updateSize(dialogSize.width, dialogSize.height);
  }

  private showSidePanel() {
      this.openTime = new Date();
      this.rightSlidePanel.nativeElement.style.display = "block";
      this.rightSlidePanel.nativeElement.style.width = this.panelData.width;
      this.rightSlidePanel.nativeElement.style.height = this.panelData.height;
      this.rightSlidePanel.nativeElement.style.left = this.panelData.left;
      if(this.panelData.option == 'MENU_OPT')
          this.rightSlidePanel.nativeElement.style.borderRadius = "0px";
      else 
          this.rightSlidePanel.nativeElement.style.borderRadius = "5px";
      
      if(this.panelData.option == 'CART_OPT')
          this.rightSlidePanel.nativeElement.style.maxHeight = "390px";
      else 
          this.rightSlidePanel.nativeElement.style.maxHeight = "";
      
      var el = document.querySelectorAll(".square-button");
      if(this.panelData.option == 'MENU_OPT')
          el[0].classList.add('onSelect');
      if(this.panelData.option == 'CART_OPT')
          el[1].classList.add('onSelect');
      if(this.panelData.option == 'USER_OPT')
          el[2].classList.add('onSelect');
      
      disableScroll();
  }

  private hideSidePanel() {
      this.rightSlidePanel.nativeElement.style.display = "none";
      var el = document.querySelectorAll(".square-button");
      if(this.panelData.option == 'MENU_OPT')
          el[0].classList.remove('onSelect');
      if(this.panelData.option == 'CART_OPT')
          el[1].classList.remove('onSelect');
      if(this.panelData.option == 'USER_OPT')
          el[2].classList.remove('onSelect');
      
      enableScroll();
  }

  private showOverlayPanel() {
      this.overlayPanel.nativeElement.style.display = "block";
      this.overlayPanel.nativeElement.style.width = this.panelData.width;
      this.overlayPanel.nativeElement.style.height = this.panelData.height;
      this.overlayPanel.nativeElement.style.left = this.panelData.left;
      this.bgGlass.nativeElement.style.display = "block";
            
      //document.body.style.overflow = "hidden";
      disableScroll();
  }

  private hideOverlayPanel() {
      this.overlayPanel.nativeElement.style.display = "none";
      this.bgGlass.nativeElement.style.display = "none";
      document.body.style.overflow = "visible";
      enableScroll();
  }
  
  @HostListener('document:click', ['$event'])
  clickout(event) {
    let isVisible = this.rightSlidePanel.nativeElement.style.display == 'block';
    if( isVisible ) {
      let diff = new Date().getMilliseconds() - this.openTime.getMilliseconds();
      if( diff > 300 || diff < 0 )  {
          if( ! this.rightSlidePanel.nativeElement.contains(event.target)) {
            this.hideSidePanel();  
          }
      }
    }
  }

}


