import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';

import {Card} from '../../user-card/card-manager/card.model';
import {SavedCardAction} from '../actions';

export type CardState = Card[];

const initialState: CardState = [];

export default function (state = initialState, action: Action): CardState {
    switch (action.type) {
        case SavedCardAction.LOAD_SAVED_CARDS_SUCCESS: {
            console.log('reducer--payload',action.payload);
            return action.payload;
        }
        case SavedCardAction.ADD_NEW_CARD_SUCCESS: {
            return [...state, action.payload];
        }
        case SavedCardAction.DELETE_CARD_SUCCESS: {
            return state.filter(card => {
                return card.lineNo !== action.payload.lineNo;
            });
        }
        case SavedCardAction.RESET_CARD: {
            return initialState;
        }
        default: {
            return state;
        }
    }
}