import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';

import { ItemDetail } from '../../ecm-model/product-detail-model';
import {ItemActions} from '../actions';
import * as _ from 'lodash';

export type ItemListState = ItemDetail[];

const initialState: ItemListState = [];

export default function (state = initialState, action: Action): ItemListState {
    switch (action.type){
        case ItemActions.LOAD_ITEM_SUCCESS: {
            return action.payload;
        }
        case ItemActions.RESET_ITEM_LIST: {
            return initialState;
        }
        default: {
            return state;
        }
    }
}