import {Action} from '@ngrx/store';

import {Category} from '../../ecm-model/category-model';
import {CategoryActions} from '../actions';

export type CategoryState = Category;
const initialState: CategoryState = {
        catCode: '',
        descr: '',
        shDescr: '',
        curRank: '',
        catLink: '',
        ecmTemplate: ''
}; 

export default function (state = initialState, action: Action): CategoryState {
    switch (action.type) {
        case CategoryActions.RESET_BLANK_CATEGORY: {
            return initialState;
        }
        case CategoryActions.GET_CATEGORY_SUCCESS: {
            return action.payload;
        }
        default: {
            return state;
        }
    }
}