import {Injectable} from '@angular/core';
import {Effect, Actions} from '@ngrx/effects';

import {AppState} from '../reducers';
import {ReviewAction} from '../actions';
//import {EcmCartService} from '../../ecm-view/ecm-cart/ecm-cart.service';
import 'rxjs/add/operator/switchMap';

@Injectable()
export class ReviewsEffects {
    constructor (
        private update$: Actions,
        private reviewActions: ReviewAction,
//        private svc: EcmCartService,
    ) {}

    @Effect() loadReviews$ = this.update$
        .ofType(ReviewAction.LOAD_REVIEWS)
//        .switchMap(() => this.svc.fetchCartItems())
        .map(userReview => this.reviewActions.loadReviewsSuccess(userReview));

    
    @Effect() updateReviews$ = this.update$
        .ofType(ReviewAction.UPDATE_REVIEWS)
        .map(action => action.payload)
//        .switchMap(item => this.svc.updateCart(item))
        .map(userReview => this.reviewActions.updateReviewsSuccess(userReview));

    @Effect() deleteReviews$ = this.update$
        .ofType(ReviewAction.DELETE_REVIEWS)
        .map(action => action.payload)
//        .switchMap(item => this.svc.deleteCartItem(item))
        .map(userReview => this.reviewActions.deleteReviewsSuccess(userReview));
    
}
