import { Component, OnInit, Input, Output, EventEmitter, ViewChild, ElementRef } from '@angular/core';
import { Router,ActivatedRoute } from '@angular/router';
import { Http } from '@angular/http';
import { Observable } from 'rxjs/Observable';

import { ItemDetail } from '../../ecm-model/product-detail-model';
import { EcmTemplateInterface } from './ecm-template.component';
import { EcmRecentViewComponent } from '../../ecm-view/ecm-recent-view/ecm-recent-view.component';

import { Store } from '@ngrx/store';
import { AppState } from '../../ecm-store/reducers';

import { EcmCartComponent } from '../../ecm-view/ecm-cart/ecm-cart.component';
import { Item } from '../../ecm-model/product-model';

@Component( {
    selector: 'ecm-outing',
    templateUrl: './ecm-general.component.html',
    styleUrls: ['./ecm-general.component.css']
})
export class EcmOutingComponent implements OnInit, EcmTemplateInterface {
    
    @Input() itemDetail: ItemDetail;
    @Output() scrollToReviews = new EventEmitter();
    @Output() doActivity = new EventEmitter();
    @ViewChild( 'recentView' ) recentView: EcmRecentViewComponent;
    @Input() inWishlist: boolean = false;
    @ViewChild('itemDetails') itemDetails: ElementRef;
    enterpise = localStorage.getItem( 'ENTERPRISE' );
     
    counterValue = 1;
    itemPrice = 1000;
    total = this.itemPrice;
    userActionUrl= '/ecm/service/feeds/cart';
    itemCode;
    myCity;
    wishlistItems: Observable<Item[]>;
    
    overview = "Located near the Huda City Metro Station, Appu Ghar is nestled in the entertainment district of Gurgaon. With its adrenaline-pumping water rides, Appu Ghar is the perfect destination to level-up your Summer adventure game. You can plan to go with your family or friends and enjoy a dip or two in the clean waterparks. Indulge in a memorable mini-vacation with finest adventure activities coupled with an overwhelming dose of music, dance and fun. If you love water rides high and are prepared to go any lengths to get a much-needed rush, then you shouldn't miss some of the best rides of Appu Ghar, which are: (1) Monsoon Mania - Rejoice to the splashes of water on your head at the rain dance area and feel alive while you are dancing with your loved ones.";
    
    attractions: Array<string> = [];
    activities: Array<string> = [];
    transportation: Array<string> = [];
    thingsToCarry: Array<string> = [];
    advisory: Array<string> = [];

    
    constructor( private route: ActivatedRoute, private router: Router,   private http: Http,  private store: Store<AppState> ) { }
    ngOnInit() {
        console.log( "Item data in Outing " + JSON.stringify(this.itemDetail) );
        console.log( "ngOnInit EcmOutingComponent Object Keys : " + Object.keys( this.itemDetail ) )
        console.log( this.itemDetail );
        
        this.itemCode = this.itemDetail.itemCode;
        this.fetchAttributes();
        console.log('attributes-->',this.attractions,this.activities,this.transportation,this.advisory,this.thingsToCarry);

        this.myCity = localStorage.getItem('mycity');
        
        this.wishlistItems = this.store.select('wishlistItems');
        this.wishlistItems.subscribe( wishlistItems => {
            if(wishlistItems.find(x => x.itemCode === this.itemDetail.itemCode))
                this.inWishlist = true;
            else
                this.inWishlist = false;
        } );
        
    }
    
    ngAfterViewInit(){
        this.recentView.ngOnInit();
    }
    
    ngOnDestroy() {
        if( this.recentView )
          this.recentView.doDestroy( this.itemDetail.itemCode );
    }

    increment() {
        this.counterValue += 1;
        this.total = this.counterValue * this.itemPrice;
    }

    decrement() {
        this.counterValue -= 1;
        this.total = this.total - this.itemPrice;
    }

    disable() {
        console.log( this.counterValue );
        if ( this.counterValue == 1 )
            return true;
        else
            return false;
    }
    
    addToWishlist() {
        this.doActivity.emit( { activity: 'ADD_WISHLIST', data: { 'item': this.itemDetail }, 'caller': this, 'callBack': 'changeStatus' });
    }
    
    removeFromWishlist() {
        this.inWishlist = false;
        this.doActivity.emit( { activity: 'REMOVE_WISHLIST', data: { 'item': this.itemDetail } });
    }
    
    fetchAttributes(){
        this.itemDetail.itemAttributes.forEach(attribute => {
           if(attribute.label == 'Attractions')
               this.attractions = attribute.value.split(',');
           if(attribute.label == 'Activities'){
               if(attribute.value){
                   this.activities.push(attribute.value);
               }
           }
           if(attribute.label == 'Transportations')
               this.transportation = attribute.value.split(',');
           if(attribute.label == 'Things to Carry')
               this.thingsToCarry = attribute.value.split(',');
           if(attribute.label == 'Advisory')
               this.advisory = attribute.value.split(',');           
        });
    }
    
    loadItem(itemCode){
        console.log('selected itemCode',itemCode);
        this.router.navigate(['/detail',itemCode]);
    }
    
    scrollToItemDetails() {
        let offsetTop = this.itemDetails.nativeElement.offsetTop;
        window.scrollTo(0, offsetTop + 60); 
    }
    
    getCSV(value:string){
        let attributeValue: Array<string> = [];
        attributeValue = value.split(',');
        
        return attributeValue;
    }
    
    scrollToReview(){
        if(this.itemDetail.itemRatings.NO_OF_REVIEWS != 0)
            this.scrollToReviews.emit();
    }
    
}