package proteus.ecm.service;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.utility.BaseException;
import ibase.utility.UserInfoBean;
import proteus.ecm.cache.CacheManager;
import proteus.ecm.hibernate.bean.ECMOrder;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.dao.ECMOrderDAO;
import proteus.ecm.hibernate.dao.UserActivityDAO;

@Path("/")
public class OrderService {
   private ECMOrderDAO orderDao = new ECMOrderDAO();
   private UserActivityDAO userDAO = new UserActivityDAO();
   @Context
   HttpServletRequest request; // The proxy of Request will be injected into this singleton
   
   @Context 
   ServletContext context;

   @GET 
   @Path("/order") 
   @Produces(MediaType.APPLICATION_JSON) 
   public ECMOrder getOrder(@PathParam("orderno")String orderNo) { 
	  System.out.println("orderNo  " +orderNo);
	  ECMOrder orderData = orderDao.getOrder(orderNo);
	  System.out.println("order  Data getOrder" +orderData);
	  return orderData;
   }  
   
   @GET 
   @Path("/orders") 
   @Produces(MediaType.APPLICATION_JSON) 
   public List<ECMOrder> getOrderList()  { 
	  List<ECMOrder> listOrder = new ArrayList<ECMOrder>(); 
	  String loginCode = getUniqueId();
	  System.out.println(" loginCode in orders >>[" + loginCode + "]" );
	  listOrder = orderDao.getOrderList(loginCode);
	  System.out.println("list of Order getOrderList[ " +listOrder+"]");
	  return listOrder;
   } 
   
	@POST
	@Path("/order")
	@Produces({ "application/json" })
	public Response saveOrder(String data,@QueryParam("tokenid") String tokenid) throws JSONException {
		String xmlResponse = "";
		JSONObject RequestData = new JSONObject(data);
		String cacheName = getCacheName();
		String uniqueId = getUniqueId();
		String siteCode = getSiteCode();
		JSONArray checData = RequestData.getJSONArray("orderedItems");
		System.out.println("Response Delete cart items after placeOrder checData" +checData);
		System.out.println("Response saveOrder cacheName" +cacheName);
		System.out.println("Response saveOrder uniqueId" +uniqueId);
		HttpSession session = request.getSession();
		Object contexObject = context.getAttribute( "pendingWrkflwMap" );
		System.out.println("contexObject inside order service - "+contexObject );
		Object userObj = session.getAttribute( "USER_INFO" ); 
		System.out.println(" userObj >>[" + userObj + "]" );
		if(userObj != null)
		{
			UserInfoBean userInfo;
			try {
				userInfo = new UserInfoBean( userObj.toString() );
				uniqueId = userInfo.getLoginCode();
				System.out.println(" userInfo >>[" + userInfo + "]" );
				orderDao.setUserInfo( userInfo );
			} catch (BaseException e) {
				e.printStackTrace();
			}
			xmlResponse = orderDao.saveOrder( uniqueId, cacheName, data, siteCode,"", contexObject);
			System.out.println(" xmlResponse in auth_user[" + xmlResponse + "]");
			/*	 StringBuffer requestUrl = this.request.getRequestURL();
		    String Url = requestUrl.substring(0, requestUrl.indexOf("/ecm"));
		    System.out.println("Request URL After: [" + Url);
			try
			{
				 StringBuffer sb = new StringBuffer();
				 sb.append( "ACTION=" ).append( "A" );
				 sb.append( "&OBJNAME=" ).append( "ecm_order" );
				 sb.append( "&INPUT_STR=" ).append( URLEncoder.encode(xmlResponse) );
				 sb.append( "&TOKEN_ID=" ).append( tokenid );
				 sb.append( "&DATA_FORMAT=JSON" );
				 
				 String strUrl = "/ibase/rest/E12ExtService/callSystemAction?" + sb.toString();
				 URL url = new URL(Url + strUrl);
			     System.out.println("PlaceOrder url \n" + url);
			     xmlResponse = IOUtils.toString(url);
			     System.out.println("PlaceOrder Response \n" + xmlResponse);
			     xmlResponse = getResponseMessage("Order Placed successfully", "Success");
			}
			catch(Exception se)
			{
				System.out.println("Auth Exception: " + se.getMessage());
				se.printStackTrace(System.out);
				return Response.status(200).entity( "Auth Exception: " + se.getMessage() ).build();
			} */
		}
		else {
			xmlResponse = getResponseMessage("Please login", "Unauthorized");
		}
	    System.out.println(" xmlResponse\n" + xmlResponse);
		System.out.println("Response saveOrder xmlResponse" +xmlResponse.toString());
		
		for(int i=0; i<checData.length(); i++) 
		{
			System.out.println("the delete2"+checData.getJSONObject(i).getString("itemCode"));
			this.userDAO.deleteUserData(uniqueId, siteCode, checData.getJSONObject(i).getString("itemCode"), UserActivityDAO.ADD_CART);
		}
		
		
		return Response.status(200).entity( xmlResponse).build();
	}
	
	private String getUniqueId() {
		String uniqueId = null;		
		HttpSession session = request.getSession();
		Object auth_user = session.getAttribute("AUTH_USER");
		Object userObj = session.getAttribute( "USER_INFO" ); 
	    System.out.println(" userObj >>[" + userObj + "]" );
	    System.out.println("Inside save Order getUniqueId auth_user"+auth_user);
	    if(userObj != null)
	    {
			try {
				UserInfoBean userInfo;
				userInfo = new UserInfoBean( userObj.toString() );
				uniqueId = userInfo.getLoginCode();
			} catch (BaseException e) {
				e.printStackTrace();
			}
	    }
	    else if(auth_user != null)
		{
			uniqueId = "" + (String)auth_user;
		}
		else
		{
			uniqueId = "" + session.getId();
		}
		System.out.println("UNIQUE ID: ["+uniqueId+"]");
		return uniqueId;		
	}
	
	private String getCacheName() {
		System.out.println("Inside save Order getCacheName");
		HttpSession session = request.getSession();
		System.out.println("Inside getCacheName HttpSession");
		Object siteObj = session.getAttribute("CURRENT_SITE");
		System.out.println("Inside getCacheName siteObj");
		if (siteObj != null && siteObj instanceof SiteMaster) {
			SiteMaster site = (SiteMaster) siteObj;
			String cacheName = "CACHE_" + site.getSiteCode();
			System.out.println("Setting siteCode[" + site.getSiteCode() + "] siteTranDB[" + site.getTranDB() + "]");
			System.out.println("getCacheName [" + cacheName + "]");
			return cacheName;
		}
		else {
			System.out.println("\n getCacheName DEFAULT[" + CacheManager.SYSTEM_CACHE_NAME + "]");
			return CacheManager.SYSTEM_CACHE_NAME;
		}
	}
	  
	private String getResponseMessage(String successResponse, String status) {
		JSONObject responseJson = new JSONObject();
	    JSONObject respMessage = new JSONObject();
	    try
	    {
	      respMessage.put("results", successResponse);
	      respMessage.put("status", status);
	      responseJson.put("Response", respMessage);
	    }
	    catch (JSONException e)
	    {
	      e.printStackTrace();
	    }
	    return responseJson.toString();
	 }
	  
	 private String getSiteCode() {
		System.out.println("Inside get site code ");
		HttpSession session = request.getSession();
		Object siteObj = session.getAttribute("CURRENT_SITE");
		System.out.println("Inside get site code "+siteObj);
		if( siteObj != null && siteObj instanceof SiteMaster )
		{
			SiteMaster site = (SiteMaster) siteObj;
			System.out.println("getSiteCode ["+site.getSiteCode()+"]");
			return site.getSiteCode();
		}
		return null;
	}
	 
	 
	 /*chitranga start*/
	   @GET 
	   @Path("/customers") 
	//   @Path("/customers/{autokey}")
	   @Produces(MediaType.APPLICATION_JSON) 
	  // public List<String> getCustomerList()  { 
	   public String getCustomerList(@QueryParam("autokey") String autokey) throws JSONException  { 
		    String userType;	
		    String siteCode;	
		    String entityCode = null;	
/*		    List<String> listCustomer = new ArrayList<String>(); */		
		    JSONObject  autoSuggestJson = new JSONObject();
		    
		    String listCustomer = null;
		    HttpSession session = request.getSession();
			Object auth_user = session.getAttribute("AUTH_USER");
			Object userObj = session.getAttribute( "USER_INFO" ); 
		    System.out.println(" userObj in getCustomerList >>[" + userObj + "]" );
		    if(userObj != null)
		    {
				try {
					UserInfoBean userInfo;
					userInfo = new UserInfoBean( userObj.toString() );
					orderDao.setUserInfo( userInfo );
					userType = userInfo.getUserType();
					entityCode = userInfo.getEntityCode();
				    siteCode = userInfo.getSiteCode();
				    System.out.println(" userType in getCustomerList >>[" + userType + "]");
				    System.out.println(" entityCode in getCustomerList >>[" + entityCode + "]");
				    System.out.println(" siteCode in getCustomerList >>[" + siteCode + "]");
   
				    listCustomer = orderDao.getCustomerList(userType,entityCode,siteCode);
                    System.out.println("listCustomer listCustomer"+listCustomer);
                	JSONArray customerListArray = new JSONArray(listCustomer);
                	
                	autoSuggestJson.put("chipMetadata", "<custName>(<custCode>)");
                	autoSuggestJson.put("suggestMetaData", "<custName> (<custCode> Bill To - <custCodeBil>) ");
                	//autoSuggestJson.put("imgUrl", "http://192.168.0.234:9090/ibase/resource/images/users/BASE.png");
                	autoSuggestJson.put("valueField", "custCode");     
                	autoSuggestJson.put("details", customerListArray);
                	

				    }catch (BaseException e) {
					 e.printStackTrace();
				 }
		    }
		  System.out.println("list of autoSuggestJson[ " +autoSuggestJson+"]");
		  System.out.println("list of autoSuggestJson getOrderList[ " +autoSuggestJson.toString()+"]");

		  return autoSuggestJson.toString();
	   } 
	   

	   
}