package proteus.ecm.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import ibase.utility.BaseException;
import ibase.utility.UserInfoBean;
import proteus.ecm.cache.CacheManager;
import proteus.ecm.cache.bean.ECMUserTracker;
import proteus.ecm.cache.dao.CategoryCache;
import proteus.ecm.cache.dao.ProductCache;
import proteus.ecm.cache.dao.UserActivityCache;
import proteus.ecm.hibernate.bean.ECMCategory;
import proteus.ecm.hibernate.bean.ECMParm;
import proteus.ecm.hibernate.bean.ECMSubCategory;
import proteus.ecm.hibernate.bean.ItemDetails;
import proteus.ecm.hibernate.bean.ItemMaster;
import proteus.ecm.hibernate.bean.SiteMaster;
import proteus.ecm.hibernate.dao.CategoryDAO;
import proteus.ecm.hibernate.dao.ProductDAO;
import proteus.ecm.hibernate.dao.SystemMasterDAO;

@Path("/{siteCode}/category")
public class CategoryService 
{
    @Context
    HttpServletRequest request; // The proxy of Request will be injected into this singleton

    private SystemMasterDAO masterDAO = new SystemMasterDAO();
    private CategoryDAO categoryDao = new CategoryDAO();
    private CategoryCache categoryCache = new CategoryCache();
	private ProductDAO productDao = new ProductDAO();
	private ProductCache productCache = new ProductCache();
	
	@PathParam("siteCode") String siteCode;
	
	
	@GET
	@Path("/")
	@Produces({ "application/xml", "application/json" })
	public List<ECMCategory> getCategories() 
	{
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getCachedCategories");
		List<ECMCategory> categories = categoryCache.getCachedCategories( cacheName );
		if( categories == null )
		{
			System.out.println("\n Populate All Categories for " + siteCode);
			if( siteCode == null )
			{
				categoryDao.fetchAllCategories( cacheName );
			}
			else
			{
				categoryDao.fetchAllCategories(cacheName, siteCode);
			}
			categories = categoryCache.getCachedCategories( cacheName );
		}
		return categories;
	}
	

	@GET
	@Path("{catCode}")
	@Produces({ "application/json" })
	public ECMCategory getCategory(@PathParam("catCode") String catCode) 
	{
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getCachedCategory");
		ECMCategory category = categoryCache.getCachedCategory(catCode, cacheName);
		if( category == null )
		{
			System.out.println("\n Populate All Categories for (catCode)");
			//categoryDao.fetchCategory(catCode);
			System.out.println("\n Populate All Categories for " + siteCode);
			if( siteCode == null )
			{
				categoryDao.fetchAllCategories( cacheName );
			}
			else
			{
				categoryDao.fetchAllCategories(cacheName, siteCode);
			}
			category = categoryCache.getCachedCategory(catCode, cacheName);
		}
		return category;
	}
	
	@GET
	@Path("/{catCode}/list")
	@Produces({ "application/json" })
	public List<ECMSubCategory> getSubCategories(@PathParam("catCode") String catCode) 
	{
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getCachedSubCategories(catCode) for " + siteCode);
		List<ECMSubCategory> subCategories = categoryCache.getCachedSubCategories(catCode, cacheName);
		if( subCategories == null )
		{
			System.out.println("\n Populate All SubCategories for (catCode)");
			//categoryDao.fetchAllSubCategories(catCode);
			if( siteCode == null )
			{
				categoryDao.fetchAllSubCategories( cacheName );
			}
			else
			{
				categoryDao.fetchAllSubCategories(cacheName, siteCode);
			}
			subCategories = categoryCache.getCachedSubCategories(catCode, cacheName);
		}
		return subCategories;
	}

	@GET
	@Path("/list")
	@Produces({ "application/xml", "application/json" })
	public List<ECMSubCategory> getSubCategories() 
	{
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getCachedSubCategories()");
		List<ECMSubCategory> subCategories = categoryCache.getCachedAllSubCategories( cacheName );
		
		if( subCategories == null )
		{
			System.out.println("\n Populate All SubCategories() for " + siteCode);
			if( siteCode == null )
			{
				categoryDao.fetchAllSubCategories( cacheName );
			}
			else
			{
				categoryDao.fetchAllSubCategories(cacheName, siteCode);
			}
			subCategories = categoryCache.getCachedAllSubCategories( cacheName );
		}
		return subCategories;
	}

	@GET
	@Path("/list/{scatCode}")
	@Produces({ "application/json" })
	public ECMSubCategory getSubCategory(@PathParam("scatCode") String scatCode) 
	{
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getCachedSubCategory(scatCode)");
		ECMSubCategory subCategory = categoryCache.getCachedSubCategory(scatCode, cacheName);
		if( subCategory == null )
		{
			System.out.println("\n Populate All SubCategories for (scatCode) for " + siteCode);
			//categoryDao.fetchSubCategory(scatCode);
			if( siteCode == null )
			{
				categoryDao.fetchAllSubCategories( cacheName );
			}
			else
			{
				categoryDao.fetchAllSubCategories(cacheName, siteCode);
			}
			subCategory = categoryCache.getCachedSubCategory(scatCode, cacheName);
		}
		return subCategory;
	}
	
	
	@GET
	@Path("/itemlist/{scatCode}")
	@Produces({ "application/json" })
	//public List<ItemDetails> getItems(@PathParam("scatCode") String scatCode) throws JSONException 
	public Response getItems(@PathParam("scatCode") String scatCode) throws JSONException 
	{
		JSONArray itemDetails = new JSONArray();
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getItems(scatCode)");
		List<ItemMaster> items = categoryCache.getCachedItems(siteCode, scatCode, cacheName);
	
		if (items == null) 
		{
			System.out.println("\n Populate All ITEMS for (siteCode) for " + siteCode);
			categoryDao.fetchAllItems(cacheName, siteCode, scatCode);
			items = categoryCache.getCachedItems(siteCode, scatCode, cacheName);
		}
		if(items != null)
		{
			JSONArray optionObjArr = null;
			for(ItemMaster item: items)
			{
				String itemCode = item.getItemCode();
				ItemDetails itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
				if (itemDetail == null) 
				{
					System.out.println("\n Prepare ItemDetails for " + itemCode);
					productDao.prepareItemDetails(cacheName, siteCode, itemCode);
					
					itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
					
					String itemRatings = productDao.getRatingDetails(siteCode, itemCode);
					itemDetail.setItemRatings(itemRatings);
					
				}
				itemDetails.put(new JSONObject(itemDetail));
				System.out.println("ItemDeatil for item list" + itemDetails);
				//For Facet Data Creation
				if( optionObjArr == null )
				{
					String facetDataStr = null;
					ECMSubCategory ecmSubCategory = categoryCache.getCachedSubCategory(scatCode, cacheName);
					if( ecmSubCategory == null  )
					{
						ECMCategory ecmCategory = categoryCache.getCachedCategory(scatCode, cacheName);
						facetDataStr = getFacetData(scatCode, "local2do", ecmCategory.getKeyAttrib() );
					}
					else
					{
						facetDataStr = getFacetData(scatCode, "local2do", ecmSubCategory.getKeyAttrib() );
					}
					
					if( facetDataStr != null && !"false".equalsIgnoreCase( facetDataStr ))
					{
						JSONObject facetData = new JSONObject(facetDataStr);
						System.out.println("JSONObject facetData [" + facetData + "]");
						JSONObject facetFields = facetData.getJSONObject("facet_counts").getJSONObject("facet_fields");
						System.out.println("JSONObject facetFields [" + facetFields + "]");
						
						String itemVariant= itemDetail.getItemVariants();
						System.out.println("itemVariant In Response Method "+itemVariant); 
						if(itemVariant != null && itemVariant.trim().length() > 0)
						{
							optionObjArr = new JSONArray();
							JSONObject resItemVariant = new JSONObject(itemVariant);
							JSONArray attributes = resItemVariant.getJSONArray("attributes");
							for(int i = 0; i < attributes.length(); i++)
							{
								JSONObject attrKeyValue = attributes.getJSONObject(i); 
								System.out.println("attrKeyValue --> "+attrKeyValue);
								int count = 0;
								int index = attrKeyValue.getInt("index");
								String name = attrKeyValue.getString("name");
								System.out.println("attributes  id "+index +"name-->"+name);
								if(index != -1)
								{
									String attribName = attrKeyValue.getString("attribName");
									System.out.println("FacetData"+attribName+">>>"+facetFields.getJSONArray(attribName));
									attrKeyValue.put("facetData", facetFields.getJSONArray(attribName));
									optionObjArr.put(attrKeyValue);
								}
							}
						}
					}
				}
			}
			//itemDetails.put(new JSONObject().put("filterOptions", optionObjArr));
			if( optionObjArr != null )
			{
				itemDetails.put(new JSONObject().put("filterOptions", optionObjArr));
			}
			else
			{
				itemDetails.put(new JSONObject().put("filterOptions", new JSONArray()));
			}
		}
		//return itemDetails;
		return Response.status(200).entity(itemDetails.toString()).build();
	}

	@GET
	@Path("/current-trends")
	@Produces({ "application/xml", "application/json" })
	public List<ItemDetails> getTrendingItems() throws JSONException 
	{
		String topRank = "1";
		ECMParm ecmParam =  masterDAO.fetchEcmParms("top_cat_rank", true).get("top_cat_rank");
		List<ItemDetails> itemDetails = null;
		System.out.println("getTrendingItems ecmParam[" + ecmParam + "]");
		if( ecmParam != null )
		{
			topRank = ecmParam.getVarValue();
		}
		
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getTrendingItems()");
		List<ItemMaster> trendItems = categoryCache.getCachedTrendingItems(siteCode, cacheName);
		if (trendItems == null) 
		{
			System.out.println("\n Populate Trending ITEMS for " + siteCode);
			categoryDao.fetchTrendingItems(topRank, siteCode, cacheName);
			trendItems = categoryCache.getCachedTrendingItems(siteCode, cacheName);
		}
		if(trendItems != null)
		{
			itemDetails = new ArrayList<ItemDetails>();
			for(ItemMaster item: trendItems)
			{
				String itemCode = item.getItemCode();
				ItemDetails itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
				if (itemDetail == null) 
				{
					System.out.println("\n Prepare ItemDetails for " + itemCode);
					productDao.prepareItemDetails(cacheName, siteCode, itemCode);
					
					itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
					System.out.println("itemDetail["+itemDetail+"]");
					
					String itemRatings = productDao.getRatingDetails(siteCode, itemCode);
					itemDetail.setItemRatings(itemRatings);
				}
				itemDetails.add(itemDetail);
			}
		}
		System.out.println("\n Return getTrendingItems()" + itemDetails);
		return itemDetails;
	}
	
	@GET
	@Path("/detail/{itemCode}")
	@Produces({ "application/json" })
	public ItemDetails getItemDetail(@PathParam("itemCode") String itemCode) throws JSONException 
	{
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		String uniqueId = getUniqueId();
		Boolean inCart = false;
		Boolean inWishlist = false;
		itemCode = String.format("%-10s", itemCode);
		
		System.out.println("\n getItemDetail(itemCode)");
		ItemDetails itemDetails = productCache.getCachedItemDetail(itemCode, cacheName);
		if (itemDetails == null) 
		{
			System.out.println("\n Prepare ItemDetails for " + itemCode);
			productDao.prepareItemDetails(cacheName, siteCode, itemCode);
			
			itemDetails = productCache.getCachedItemDetail(itemCode, cacheName);
		}
		// Temporary by Prajyot
		UserActivityCache userActivityCache = new UserActivityCache();
		ECMUserTracker userBean = userActivityCache.getCachedUserData(uniqueId, cacheName);
		if(userBean != null)
		{	
		 inCart = userBean.getCartProducts().keySet().contains(itemCode);
		 inWishlist = userBean.getWishlistedProducts().keySet().contains(itemCode);
		}
		JSONObject productStatus = new JSONObject();
		
		if(inCart)
			productStatus.put("inCart", "Y");
		else
			productStatus.put("inCart", "N");
		
		if(inWishlist)
			productStatus.put("inWishlist", "Y");
		else
			productStatus.put("inWishlist", "N");
		
		productStatus.put("inStock", "Y");
		
		itemDetails.setProductStatus(productStatus.toString());
		System.out.println("productStatus" +productStatus.toString());
		
		String itemRatings = productDao.getRatingDetails(siteCode, itemCode);
		itemDetails.setItemRatings(itemRatings);
		
		return itemDetails;
	}
	
	@GET
	@Path("/related/{scatCode}")
	@Produces({ "application/xml", "application/json" })
	public List<ItemDetails> getRelatedItems(@PathParam("scatCode") String scatCode) 
	{
		//TODO - Need to implement logic for suggestions.
		
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		List<ItemDetails> itemDetails = null;
		System.out.println("\n getItems(scatCode)");
		List<ItemMaster> items = categoryCache.getCachedItems(siteCode, scatCode, cacheName);
		if (items == null) 
		{
			System.out.println("\n Populate All ITEMS for (siteCode) for " + siteCode);
			categoryDao.fetchAllItems(cacheName, siteCode, scatCode);
			items = categoryCache.getCachedItems(siteCode, scatCode, cacheName);
		}

		if(items != null)
		{
			itemDetails = new ArrayList<ItemDetails>();
			for(ItemMaster item: items)
			{
				String itemCode = item.getItemCode();
				ItemDetails itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
				if (itemDetail == null) 
				{
					System.out.println("\n Prepare ItemDetails for " + itemCode);
					productDao.prepareItemDetails(cacheName, siteCode, itemCode);
					
					itemDetail = productCache.getCachedItemDetail(itemCode, cacheName);
					System.out.println("itemDetail["+itemDetail+"]");
				}
				itemDetails.add(itemDetail);
			}
		}
		return itemDetails;
	}
	/*
	private String getSiteCode() 
	{
		HttpSession session = request.getSession();
		Object siteObj = session.getAttribute("CURRENT_SITE");
		if( siteObj != null && siteObj instanceof SiteMaster )
		{
			SiteMaster site = (SiteMaster) siteObj;
			System.out.println("getSiteCode ["+site.getSiteCode()+"]");
			return site.getSiteCode();
		}
		return null;
	}
	*/
	private String getCacheName() 
	{
		HttpSession session = request.getSession();
		Object siteObj = session.getAttribute("CURRENT_SITE");
		if( siteObj != null && siteObj instanceof SiteMaster )
		{
			SiteMaster site = (SiteMaster) siteObj;
			String cacheName = "CACHE_" + site.getSiteCode();
			System.out.println("Setting siteCode[" + site.getSiteCode() + "] siteTranDB[" + site.getTranDB() + "]"); 
			System.out.println("getCacheName ["+cacheName+"]");
			return cacheName;
		}
		else
		{
			System.out.println("\n getCacheName DEFAULT["+CacheManager.SYSTEM_CACHE_NAME+"]");
			return CacheManager.SYSTEM_CACHE_NAME;
		}
	}
	
	private String getUniqueId() {
		String uniqueId = null;		
		HttpSession session = request.getSession();
		Object auth_user = session.getAttribute("AUTH_USER");
		Object userObj = session.getAttribute( "USER_INFO" ); 
	    System.out.println(" userObj >>[" + userObj + "]" );
	    if(userObj != null)
	    {
			try {
				UserInfoBean userInfo;
				userInfo = new UserInfoBean( userObj.toString() );
				uniqueId = userInfo.getLoginCode();
			} catch (BaseException e) {
				e.printStackTrace();
			}
	    }
	    else if(auth_user != null)
		{
			uniqueId = "" + (String)auth_user;
		}
		else
		{
			uniqueId = "" + session.getId();
		}
		System.out.println("UNIQUE ID: ["+uniqueId+"]");
		return uniqueId;		
	}

	
	@GET
	@Path("/summary")
	@Produces({ "application/xml", "application/json" })
	public Response getSideMenus() 
	{
		JSONObject respObj = new JSONObject();
		String cacheName = getCacheName();
		//String siteCode = getSiteCode();
		System.out.println("\n getSideMenus()");
		try 
		{
			/*
			List<ECMCategory> categories = categoryCache.getCachedCategories( cacheName );
			JSONArray categoryArray = new JSONArray();
			for(ECMCategory category : categories)
			{
				JSONObject catObj = new JSONObject();
				catObj.put("catCode", category.getCatCode());
				catObj.put("shDescr", category.getShDescr());
				categoryArray.put(catObj);
			}
			
			List<ECMSubCategory> subCategories = categoryCache.getCachedAllSubCategories( cacheName );
			JSONArray subCategoryArray = new JSONArray();
			for(ECMSubCategory subcategory : subCategories)
			{
				JSONObject subCatObj = new JSONObject();
				String catCode = subcategory.getCatCode();
				String scatCode = subcategory.getScatCode();
				subCatObj.put("catCode", catCode);
				subCatObj.put("scatCode", scatCode);
				subCatObj.put("shDescr", subcategory.getShDescr());
				List<ItemMaster> items = categoryCache.getCachedItems(siteCode, scatCode, cacheName);
				if( items != null ){
					JSONArray itemsArray = new JSONArray();
					for(ItemMaster item : items){
						JSONObject itemObj = new JSONObject();
						itemObj.put("itemCode", item.getItemCode());
						itemObj.put("descr", item.getShDescr());
						
						itemsArray.put(itemObj);
					}
					subCatObj.put("items", itemsArray);
				}
				subCategoryArray.put(subCatObj);
			}
			
			respObj.put("catList", categoryArray);
			respObj.put("subCatList", subCategoryArray);
			*/
			JSONArray statsObj = categoryCache.getCachedStats(cacheName, siteCode);
			respObj.put("summary", statsObj);
			
			System.out.println("**************************************************");
			System.out.println("\n getSideMenus(respObj)" + respObj);
			System.out.println("**************************************************");
		} 
		catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return Response.status(200).entity(respObj.toString()).build();
	}
	
	
	private String getFacetData(String scatcode, String CORE_NAME, String keyAttributes) 
	{
		try 
		{
			String xmlResponse = "false";
			HashMap<String,ECMParm> ecmParamData = masterDAO.fetchEcmParms("solr_url", true);
			ECMParm solrUrlParam = ecmParamData.get("solr_url");
			System.out.println("solrUrlParam SOLR_URL : [" + solrUrlParam + "]");
			if( solrUrlParam != null && solrUrlParam.getVarValue() != null )
			{
				String solrURL = solrUrlParam.getVarValue();
				System.out.println("SOLR_URL : [" + solrURL + "]");
				solrURL = solrURL.endsWith("/") ? solrURL : solrURL + "/"; 
				solrURL = solrURL + CORE_NAME + "/select";
				
				SolrQuery solrQuery = new SolrQuery();
				solrQuery.setQuery(scatcode);
				solrQuery.setFacet(true);
				solrQuery.set("wt", "json");
				solrQuery.setFacetMinCount(1);
				solrQuery.setRows(0);
				
				List<String> attribList = getAttributeList(keyAttributes);
				if( attribList != null )
				{
					String[] attribArr = {};
					solrQuery.addFacetField( attribList.toArray( attribArr) );
					System.out.println("keyAttributes: [\n"+keyAttributes + "]" + attribList + "<attribList>" + attribArr);
				}
				System.out.println("solrURL["+solrURL+"]");
				String urlQueryString = ClientUtils.toQueryString(solrQuery, true);	
				System.out.println("urlQueryString: [\n"+urlQueryString);
				
				URL url = new URL(solrURL + urlQueryString);
				String strUrl=url.toString();
				
				int index=strUrl.indexOf("&amp;");
				System.out.println("index["+index+"]");
				strUrl=strUrl.replaceAll("&amp;", "&");
				System.out.println("strUrl111["+strUrl+"]");
				
				URL url1 = new URL(strUrl);
				System.out.println("SolrUrl 529 ---------["+ url1 );
				
				xmlResponse = org.apache.commons.io.IOUtils.toString(url1);
				System.out.println("Category Service xmlResponse["+xmlResponse+"]");
				
			}
			return xmlResponse;
		}
		catch (Exception e) 
		{
			System.out.println("Exception in setConnection:"+e.getMessage());
			return  "false";
		}
	}
	
	private List<String> getAttributeList(String attributeCSV){
		if(attributeCSV == null)
			return null;
		
		List<String> phAttributeList = new ArrayList<String>();
		List<String> phAttribList = Arrays.asList(attributeCSV.split(",")); // 1,2, 3-5, 25 ==> [1,2,3,4,5,25]
		System.out.println("Given string"+phAttribList);
		for( String phAttribStr : phAttribList ){
			
			if (phAttribStr.contains("-"))
			{
				int firstVal = Integer.parseInt(String.valueOf(phAttribStr.charAt(0)));
				int lastVal = Integer.parseInt(String.valueOf(phAttribStr.charAt(2)));
				
				for(int j = firstVal; j <= lastVal; j++){
					phAttributeList.add("PHY_ATTRIB_" + j);
				}
			}
			else
			{
				phAttributeList.add("PHY_ATTRIB_" + phAttribStr);
			}
		}
		System.out.println("List After Process"+phAttributeList);
		return phAttributeList;
	}
}
