package proteus.ecm.hibernate.dao;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.HibernateException;
import org.hibernate.query.Query;
import org.hibernate.Session;

import proteus.ecm.cache.dao.CategoryCache;
import proteus.ecm.cache.dao.SystemCache;
import proteus.ecm.hibernate.bean.ECMCategory;
import proteus.ecm.hibernate.bean.ECMSubCategory;
import proteus.ecm.hibernate.bean.ItemMaster;
import proteus.ecm.hibernate.util.HibernateUtil;

public class CategoryDAO 
{
	private String siteTranDB = "DEFAULT";
	private CategoryCache categoryCache = new CategoryCache();
	private SystemCache systemCache = new SystemCache();
	
	// @RestService == > "/category"
	//public List<ECMCategory> getCategories() 
	public void fetchAllCategories(String cacheName) 
	{
		List<ECMCategory> categories = new ArrayList<ECMCategory>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("from ECMCategory ORDER BY catCode ");
			categories = query.list();
			
			categoryCache.storeCategories(categories, cacheName);
			
			System.out.println("fetchAllCategories Categories selected \n categories : [" + categories + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		//return categories;
	}

	public void fetchAllCategories(String cacheName, String siteCode) 
	{
		List<ECMCategory> categories = new ArrayList<ECMCategory>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ECMCategory WHERE catCode IN ( "
																				+ " SELECT esc.catCode "
																				+ " FROM ECMSubCategory esc, SiteItem si "
																				+ " WHERE esc.scatCode = si.scatCode  "
																				+ " AND si.siteCode = :siteCode "
																				+ " AND si.ecmType IN (1, 2, 3)"
																				+ " )"
																				+ " ORDER BY catCode ");
			query.setParameter("siteCode", siteCode);
			categories = query.getResultList();
			
			categoryCache.storeCategories(categories, cacheName);

			System.out.println("fetchAllCategories by 1" + siteCode + " Categories selected \n categories : [" + categories + "]");

			/* For fetching Category which has no subCategory */
			categories = null;
			query = session.createQuery("FROM ECMCategory ec WHERE ec.catCode IN ( "
																		+ " SELECT si.scatCode "
																		+ " FROM SiteItem si "
																		+ " WHERE si.scatCode = ec.catCode "
																		+ " AND si.siteCode = :siteCode "
																		+ " AND si.ecmType IN (1, 2, 3) "
																		+ " )"
																		+ " ORDER BY ec.catCode ");
			query.setParameter("siteCode", siteCode);
			categories = query.getResultList();
			
			categoryCache.storeCategories(categories, cacheName);
			
			System.out.println("fetchAllCategories by 2" + siteCode + " Categories selected \n categories : [" + categories + "]");
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		//return categories;
	}

	// @RestService == > "/category/{catCode}"
	//public ECMCategory getCategory(String catCode) 
/*
	public void fetchCategory(String catCode, String cacheName) 
	{
		ECMCategory category = new ECMCategory();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("from ECMCategory where CAT_CODE = :catCode");
			query.setParameter("catCode", catCode);
			List<ECMCategory> categories = query.list();
			System.out.println("\n\n Categories selected \n catCode : [" + catCode + "] \n categories : [" + categories + "]");
			category = categories.get(0);
			System.out.println("\n\n category selected \n category : [" + category + "]");
			
			categoryCache.storeCategories(categories, cacheName);
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("getCategory return category" + category);
		//return category;
	}
*/
	// @RestService == > "/category/list"
	//public List<ECMSubCategory> getSubCategories() 
	public void fetchAllSubCategories(String cacheName) 
	{
		List<ECMSubCategory> subcategories = new ArrayList<ECMSubCategory>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("from ECMSubCategory ORDER BY catCode, scatCode ");
			subcategories = query.getResultList();
			
			categoryCache.storeSubCategories(subcategories, cacheName);
			
			System.out.println("fetchAllSubCategories SubCategories selected : [" + subcategories + "]");
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		//return subcategories;
	}
	
	public void fetchAllSubCategories(String cacheName, String siteCode) 
	{
		List<ECMSubCategory> subcategories = new ArrayList<ECMSubCategory>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			Query query = session.createQuery("FROM ECMSubCategory WHERE scatCode IN ("
																					+ " SELECT scatCode FROM SiteItem "
																					+ " WHERE siteCode = :siteCode "
																					+ " AND ecmType IN (1, 2, 3) "
																					+ ")"
																					+ " ORDER BY catCode, scatCode ");
			query.setParameter("siteCode", siteCode);
			subcategories = query.getResultList();
			
			categoryCache.storeSubCategories(subcategories, cacheName);
			
			System.out.println("fetchAllSubCategories by " + siteCode + " SubCategories selected : [" + subcategories + "]");
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		//return subcategories;
	}

	public void fetchAllItems(String cacheName, String siteCode) 
	{
		List<ItemMaster> items = new ArrayList<ItemMaster>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			
			//select item_code, descr, sh_descr from item where item_code in (select item_code from siteitem where site_code = 'L2D01' and scat_code = 'SCAT000003' );
			//select doc_id, file_type_attach from doc_transaction_link where ref_ser = 'M-ITEM' and ref_id in (select item_code from siteitem where site_code = 'L2D01' and scat_code = 'SCAT000003' );
			Query query = session.createQuery("FROM ItemMaster WHERE item_code IN ("
																					+ " SELECT itemCode FROM SiteItem "
																					+ " WHERE siteCode = :siteCode "
																					+ " AND ecmType IN (1, 2, 3) "
																					+ ")"
																					+ " ORDER BY item_code ");
			query.setParameter("siteCode", siteCode);
			items = query.getResultList();
			
			categoryCache.storeItems(items, "ALL", cacheName);
			System.out.println("fetchAllItems by siteCode ["+siteCode+"]scatCode[ALL] items : [" + items + "]");
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}

	// @RestService == > "/category/itemlist/{scatCode}"
	public void fetchAllItems(String cacheName, String siteCode, String scatCode) 
	{

		List<ItemMaster> items = new ArrayList<ItemMaster>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			
			//select item_code, descr, sh_descr from item where item_code in (select item_code from siteitem where site_code = 'L2D01' and scat_code = 'SCAT000003' );
			//select doc_id, file_type_attach from doc_transaction_link where ref_ser = 'M-ITEM' and ref_id in (select item_code from siteitem where site_code = 'L2D01' and scat_code = 'SCAT000003' );
			Query query = session.createQuery("FROM ItemMaster WHERE item_code IN ("
																					+ " SELECT itemCode FROM SiteItem "
																					+ " WHERE siteCode = :siteCode "
																					+ " AND scatCode = :scatCode "
																					+ " AND ecmType IN (1, 2, 3) "
																					+ ")"
																					+ " ORDER BY item_code ");
			query.setParameter("siteCode", siteCode);
			query.setParameter("scatCode", scatCode);
			items = query.getResultList();
			
			categoryCache.storeItems(items, scatCode, cacheName);
			System.out.println("fetchAllItems by siteCode ["+siteCode+"]scatCode["+scatCode+"] items : [" + items + "]");
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}

	public void fetchTrendingItems(String topRank, String siteCode, String cacheName)
	{
		List<ItemMaster> items = new ArrayList<ItemMaster>();
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();

			// 2. Create Query
			
			//select item_code, descr, sh_descr from item where item_code in (select item_code from siteitem where site_code = 'L2D01' and scat_code = 'SCAT000003' );
			//select doc_id, file_type_attach from doc_transaction_link where ref_ser = 'M-ITEM' and ref_id in (select item_code from siteitem where site_code = 'L2D01' and scat_code = 'SCAT000003' );
			Query query = session.createQuery(" SELECT item FROM ItemMaster item, SiteItem si, ECMSubCategory esc "
											+ " WHERE si.scatCode = esc.scatCode "
											+ " AND si.itemCode = item.item_code "
											+ " AND esc.curRank < :curRank "
											+ " AND si.siteCode = :siteCode "
											+ " AND si.ecmType IN (1, 2, 3) "
											+ " ORDER BY item.item_code ");
			
			query.setParameter("siteCode", siteCode);
			query.setParameter("curRank", Integer.parseInt(topRank) );			
			items = query.getResultList();
			
			System.out.println("fetchAllItems by siteCode ["+siteCode+"]topRank["+topRank+"] items : [" + items + "]");
			categoryCache.storeTrendingItems(items, cacheName);
			
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
	}
	
	public ECMCategory getCategory(String siteCode, String catCode, String cacheName) 
	{
		System.out.println("\n Inside CategoryDAO  getCachedCategory");
		ECMCategory category = categoryCache.getCachedCategory(catCode, cacheName);
		if( category == null )
		{
			System.out.println("\n Inside CategoryDAO Populate All Categories for " + siteCode);
			if( siteCode == null )
			{
				fetchAllCategories( cacheName );
			}
			else
			{
				fetchAllCategories(cacheName, siteCode);
			}
			category = categoryCache.getCachedCategory(catCode, cacheName);
		}
		return category;
	}
	
	public ECMSubCategory getSubCategory(String siteCode, String scatCode, String cacheName) 
	{
		System.out.println("\n Inside CategoryDAO getCachedSubCategory(scatCode)");
		ECMSubCategory subCategory = categoryCache.getCachedSubCategory(scatCode, cacheName);
		if( subCategory == null )
		{
			System.out.println("\n Inside CategoryDAO  Populate All SubCategories for (scatCode) for " + siteCode);
			//categoryDao.fetchSubCategory(scatCode);
			if( siteCode == null )
			{
				fetchAllSubCategories( cacheName );
			}
			else
			{
				fetchAllSubCategories(cacheName, siteCode);
			}
			subCategory = categoryCache.getCachedSubCategory(scatCode, cacheName);
		}
		return subCategory;
	}
	

}
