package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "ECM_SUB_CATEGORY")
@XmlRootElement(name = "SubCategory")
public class ECMSubCategory implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="SCAT_CODE")
	private String scatCode;

	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="CAT_CODE")
	private String catCode;

	@Column(name="CUR_RANK")
	private int curRank;
	
	@Column(name="DESCR")
	private String descr;
	
	@Column(name="SH_DESCR")
	private String shDescr;
	
	@Column(name="ECM_TEMPLATE")
	private String ecmTemplate;
	
	@Column(name="PROD_ATTRIB")	
	private String prodAttrib;
	 
	@Column(name="KEY_ATTRIB")	
	private String keyAttrib;
	
	public ECMSubCategory() {
	}

	public ECMSubCategory(String scatCode, String catCode, int curRank, String descr, String shDescr,
			String ecmTemplate, String prodAttrib, String keyAttrib) {
		this.scatCode = scatCode;
		this.catCode = catCode;
		this.curRank = curRank;
		this.descr = descr;
		this.shDescr = shDescr;
		this.ecmTemplate = ecmTemplate;
		this.prodAttrib = prodAttrib;
		this.keyAttrib = keyAttrib;
	}

	public int getCurRank() {
		return curRank;
	}

	@XmlElement
	public void setCurRank(int curRank) {
		this.curRank = curRank;
	}

	public String getCatCode() {
		return catCode;
	}

	@XmlElement
	public void setCatCode(String catCode) {
		this.catCode = catCode;
	}

	public String getScatCode() {
		return scatCode;
	}

	@XmlElement
	public void setScatCode(String scatCode) {
		this.scatCode = scatCode;
	}

	public String getDescr() {
		return descr;
	}

	@XmlElement
	public void setDescr(String descr) {
		this.descr = descr;
	}

	public String getShDescr() {
		return shDescr;
	}

	@XmlElement
	public void setShDescr(String shDescr) {
		this.shDescr = shDescr;
	}

	public String getEcmTemplate() {
		return ecmTemplate;
	}

	@XmlElement
	public void setEcmTemplate(String ecmTemplate) {
		this.ecmTemplate = ecmTemplate;
	}
	
	public String getProdAttrib() {
		return prodAttrib;
	}

	public void setProdAttrib(String prodAttrib) {
		this.prodAttrib = prodAttrib;
	}

	public String getKeyAttrib() {
		return keyAttrib;
	}

	public void setKeyAttrib(String keyAttrib) {
		this.keyAttrib = keyAttrib;
	}

	@Override
	public String toString(){
		return "\n ECMSubCategory.toString >> [" + new JSONObject(this).toString() + "]";
	}
	
}
