package proteus.ecm.cache.dao;

import java.util.List;

import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;

import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;

import proteus.ecm.cache.CacheManager;
import proteus.ecm.hibernate.bean.ItemAttribute;
import proteus.ecm.hibernate.bean.ItemAttributeVal;
import proteus.ecm.hibernate.bean.ItemDetails;
import proteus.ecm.hibernate.bean.ItemMaster;
import proteus.ecm.hibernate.bean.ItemType;
import proteus.ecm.hibernate.dao.ProductDAO;

public class ProductCache 
{

	public void storeItemDetail(ItemDetails itemDetails, String cacheName) 
	{
		System.out.println("Inside storeTrendingItems >>" + cacheName);
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) 
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				// cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache(cacheName);
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			cache.put( itemDetails.getItemCode(), itemDetails);
			tm.commit();
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException | HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause() + "] storeTrendingItems----\n");
			e.printStackTrace();
		} 
		catch (Exception e) 
		{
			System.out.println("storeTrendingItems() ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
	}

	// @RestService == > "/category/detail/{itemCode}"
	public ItemDetails getCachedItemDetail(String itemCode, String cacheName) 
	{
		System.out.println("Inside getCachedItemDetail >>" + cacheName);
		ItemDetails itemDetails = null;
		ProductDAO productDAO = new ProductDAO();
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) 
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				// cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}

			Cache cache = CacheManager.getInstance().getCache(cacheName);

			QueryFactory queryFactory = Search.getQueryFactory(cache);

			// Construct a query
			org.infinispan.query.dsl.Query query = queryFactory.from(ItemDetails.class).having("itemCode").eq(itemCode).toBuilder().build();
			System.out.println("getCachedItemDetail Query Result Size:" + query.getResultSize());

			if (query.getResultSize() > 0) 
			{
				// Execute the query
				List<ItemDetails> itemDetailsList = query.list();
				if (itemDetailsList != null && itemDetailsList.size() > 0) 
				{
					itemDetails = itemDetailsList.get(0);
				}
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItemDetail(itemCode) ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
		return itemDetails;
	}
	
	public void storeItemType(String cacheName, ItemType itemType) 
	{
		System.out.println("Inside storeItemType >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			String cacheKey = itemType.getItemType();
			System.out.println("storeItemType cacheKey --"+ cacheKey +"--" + itemType +"--");
			cache.put(cacheKey, itemType);
			tm.commit();
			
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeItemType----\n");
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("storeItemType() ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
	}

	public ItemType getCachedItemType(String itemType , String cacheName) 
	{
		ItemType itemTypeObj = null; 
		System.out.println("Inside getCachedItemType >>" + cacheName + " itemType[" + itemType + "]");
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) 
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				// cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache(cacheName);
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query 
			org.infinispan.query.dsl.Query query = queryFactory.from(ItemType.class).having("itemType").eq(itemType).toBuilder().build();
			System.out.println("getCachedItemType ItemType Query Result Size:" + query.getResultSize());
			if( query.getResultSize() > 0)
			{
				List<ItemType> cachedItemTypes = query.list();
				System.out.println("cachedItemTypes by query in getCachedItemType" +cachedItemTypes);
				itemTypeObj = cachedItemTypes.get(0);
			}
		}
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItemType(itemCode) ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
		return itemTypeObj;
	}
	
	public void storeItemAttribs(String cacheName, ItemAttribute itemAttrib) 
	{
		System.out.println("Inside storeItemAttribs >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			String cacheKey = itemAttrib.getAttribCode();
			System.out.println("storeItemAttribs cacheKey --"+ cacheKey +"--" + itemAttrib +"--");
			cache.put(cacheKey, itemAttrib);
			tm.commit();
			
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeItemAttribs----\n");
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("storeItemAttribs() ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
	}
	
	public ItemAttribute getCachedItemAttribs(String attribCode, String cacheName) 
	{
		ItemAttribute attribObj = null; 
		System.out.println("Inside getCachedItemAttribs >>" + cacheName + " attribCode >>" + attribCode);
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) 
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				// cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache(cacheName);
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query 
			org.infinispan.query.dsl.Query query = queryFactory.from(ItemAttribute.class).having("attribCode").eq(attribCode).toBuilder().build();
			System.out.println("getCachedItemAttribs ItemType Query Result Size:" + query.getResultSize());
			if( query.getResultSize() > 0)
			{
				List<ItemAttribute> cachedItemAttribs = query.list();
				System.out.println("Return by query in getCachedItemAttribs" +cachedItemAttribs);
				attribObj = cachedItemAttribs.get(0);
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItemAttribs(attribCode) ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
		return attribObj;
	}
	
	public void storeItemAttribValues(String cacheName, List<ItemAttributeVal> attributeList) 
	{
		System.out.println("Inside storeItemAttribValues >>" + cacheName);
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			TransactionManager tm = cache.getAdvancedCache().getTransactionManager();
			tm.begin();
			for( ItemAttributeVal itemAttrVal: attributeList) 
			{
				String cacheKey = itemAttrVal.getAttribCode() + "_" + itemAttrVal.getAttribId();
				System.out.println("storeItemAttribValues cacheKey --"+ cacheKey +"--" + itemAttrVal +"--");
				cache.put( cacheKey, itemAttrVal);
			}
			tm.commit();
			
		} 
		catch (SecurityException | IllegalStateException | RollbackException | HeuristicMixedException
				| HeuristicRollbackException | NotSupportedException | SystemException | CacheException e) 
		{
			System.out.println("Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() + "] storeItemAttribValues----\n");
			e.printStackTrace();
		}
		catch (Exception e)
		{
			System.out.println("storeItemAttribValues() ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
	}

	public ItemAttributeVal getCachedItemAttribValues(String attribCode, String attribId, String cacheName) 
	{
		ItemAttributeVal attributeVal = null; 
		attribCode = checkNull(attribCode);
		attribId = checkNull(attribId);
		System.out.println("Inside getCachedItemAttribValues >>" + cacheName + " attribCode >>" + attribCode + " attribId >>" + attribId);
		try 
		{
			if (!CacheManager.getInstance().cacheExists(cacheName)) 
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				// cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			Cache cache = CacheManager.getInstance().getCache(cacheName);
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query 
			org.infinispan.query.dsl.Query query = queryFactory.from(ItemAttributeVal.class).having("attribCode").eq(attribCode).and().having("attribId").eq(attribId).toBuilder().build();
			System.out.println("getCachedItemAttribValues ItemType Query Result Size:" + query.getResultSize());
			if( query.getResultSize() > 0)
			{
				List<ItemAttributeVal> cachedAttribValues = query.list();
				System.out.println("Return by query in getCachedItemAttribValues" +cachedAttribValues);
				attributeVal = cachedAttribValues.get(0);
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItemAttribValues(attribCode) ---- Exception type : " + e.getClass().getName() + "]" + e + "[" + e.getCause());
			e.printStackTrace();
		}
		return attributeVal;
	}
	
	public ItemMaster getCachedItem(String itemCode, String cacheName)
	{
		System.out.println("Inside getCachedItem itemCode >> " + itemCode + " cacheName >>" + cacheName);
		ItemMaster cachedItem = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query 
			org.infinispan.query.dsl.Query query = queryFactory.from(ItemMaster.class).having("item_code").eq(itemCode).toBuilder().build();
			System.out.println("getCachedItem Query Result Size:" + query.getResultSize());
		
			// Execute the query
			List<ItemMaster> cachedItems = query.list();
			System.out.println("cachedItems by query in getCachedItem" +cachedItems);
			cachedItem = ( cachedItems != null ) ? cachedItems.get(0) : null;
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItems(scatCode) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedItem; 
	}
	
	public List<ItemMaster> getCachedItemsByProduct(String productCode, String cacheName) 
	{
		System.out.println("Inside getCachedItemsByProduct productCode >> " + productCode + " cacheName >>" + cacheName);
		List<ItemMaster> cachedItems = null;
		try 
		{
			if( ! CacheManager.getInstance().cacheExists(cacheName) )
			{
				System.out.printf("\n Using System default Cache as Requested Cache \"%s\" is not configured", cacheName);
				//cacheName = CacheManager.SYSTEM_CACHE_NAME;
				CacheManager.createInstance(cacheName);
			}
			
			Cache cache = CacheManager.getInstance().getCache( cacheName );
			QueryFactory queryFactory = Search.getQueryFactory(cache);
			// Construct a query 
			org.infinispan.query.dsl.Query query = queryFactory.from(ItemMaster.class).having("product_code").eq(productCode).toBuilder().orderBy("item_code", SortOrder.ASC).build();
			System.out.println("getCachedItemsByProduct Query Result Size:" + query.getResultSize());
		
			if( query.getResultSize() > 0)
			{
				// Execute the query
				cachedItems = query.list();
				System.out.println("cachedItems by query in getCachedItemsByProduct" +cachedItems);
			}
		} 
		catch (SecurityException | IllegalStateException | CacheException e) 
		{
			System.out.println("getCachedItemsByProduct(productCode) ---- Exception type : " + e.getClass().getName() + "]"+e+"[" + e.getCause() );
			e.printStackTrace();
		}
		return cachedItems; 
	}
	

	private String checkNull(String value) 
	{
		if( value != null && value.trim().length() > 0 )
		{
			return value;
		}
		return "";
	}
}
