import { Component, OnInit, OnChanges, DoCheck, Input, ViewEncapsulation, ViewChild  } from '@angular/core';
import { DatePipe } from '@angular/common';
import { Profile } from '../profile.model';
import { FormControl } from '@angular/forms';
import { NgForm, NgModel, FormBuilder, FormGroup, NgModelGroup, Validators } from '@angular/forms';

@Component({
  selector: 'profile-screen',
  templateUrl: './profile-screen.component.html',
  styleUrls: ['./profile-screen.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class ProfileScreenComponent implements OnInit, DoCheck, OnChanges {

    @Input() editMode : string = 'V';
    @Input() profileData : Profile;
    @ViewChild('userProfile') userProfieForm: NgForm;
    birthDate: string;
    
  constructor() { }

  ngOnInit() { }

  ngDoCheck(){
      var datePipe = new DatePipe("en-US");
      if( !this.birthDate  )  this.birthDate = this.profileData.birthDate;
      //console.log('doCheck this.birthDate', this.birthDate , 'this.profileData.birthDate', this.profileData.birthDate);
      try
      {
          this.profileData.birthDate = datePipe.transform(this.birthDate, 'dd/MM/yyyy');
      }
      catch(e)
      {
          let dt = this.toDate(this.birthDate);
          this.birthDate = datePipe.transform(dt, 'yyyy-MM-dd');
          //console.log('datePipe.transform >1>', dt , this.birthDate);
          //console.log( 'datePipe.transform >3> yyyy-MM-dd ', datePipe.transform(dt, 'yyyy-MM-dd hh:mm:ss.0') );
      }
  }

  ngOnChanges() {
      this.birthDate = null;
      // console.log('ngOnChanges this.birthDate', this.birthDate , 'this.profileData.birthDate', this.profileData.birthDate);
  }
  
  //TODO : Common Function
  toDate(dateStr) {
      var parts = dateStr.split("/");
      return new Date(parts[2], parts[1] - 1, parts[0]);
  }
}
