import { Component, OnInit, ViewEncapsulation, Output, EventEmitter } from '@angular/core';
import { Router, ActivatedRoute } from '@angular/router';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/observable/fromEvent';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/debounceTime';

import { Store } from '@ngrx/store';
import { AppState } from '../ecm-store/reducers';
import { CartActions } from '../ecm-store/actions';

import { Breadcrumbs } from '../ecm-breadcrumbs/ecm-breadcrumbs.component';

@Component({
  selector: 'my-profile',
  templateUrl: './my-profile.component.html',
  styleUrls: ['./my-profile.component.css'],
  encapsulation: ViewEncapsulation.None
})
export class MyProfileComponent implements OnInit {
	
	clientWidth: number;

    @Output() onDiscard : EventEmitter<string>  = new EventEmitter<string>();

    navLinks: Links[]
    
    userData: any;

    constructor(private router: Router , private route: ActivatedRoute, public breadcrumbSerivce: Breadcrumbs) {
        this.navLinks = [
            { name: 'Profile Info', navLink: 'userprofile', isOpen: false },
            { name: 'Manage Address', navLink: 'useraddress', isOpen: false },
            { name: 'Change Password', navLink: 'chgpassword', isOpen: false },
            { name: 'Saved Cards', navLink: 'usercard', isOpen: false },
       //     { name: 'My Reviews', navLink: 'userreview', isOpen: false }
        ];
    }

    ngOnInit() { 
        var userInfo = localStorage.getItem( 'userInfo' );
        console.log( 'EcmUserOptionComponent getUserInfo ::' + userInfo );
        if ( userInfo !== 'undefined' && userInfo !== null && userInfo !== 'null' ) {
            this.userData = JSON.parse( userInfo );
        }
        console.log("the user data is ",this.userData);
        
    	this.clientWidth = document.documentElement.clientWidth;
    	RESIZE_EVENT.subscribe(data => {
            this.clientWidth = data.width;
            //console.log('this.clientWidth['+this.clientWidth+']this.clientHeight['+this.clientHeight+']');
        });
    	
    	//to open first link by default in desktop view
    	if( this.clientWidth > 640 ){
    	    this.selectLink(this.navLinks[0]);
    	}
    	
        let breadcrumb = [{label: 'Home', url: '/home'}, {label: 'My Profile', url: 'javascript:void(0)'}];
        this.breadcrumbSerivce.breadcrumbs = breadcrumb;
    }
    
   selectLink (link: Links) {
	  let navLink = link.navLink;
	  if( this.checkEditorStatus() ) {
    	for(let l of this.navLinks )
    	{
    		if( l.navLink == navLink ) 
    		{
    			l.isOpen = true;
    		}
    		else 
    		{
    			l.isOpen = false;
    		}
    	}
    	console.log("navLink >>" , navLink, this.navLinks);
		this.router.navigate(['/myprofile', {outlets: { 'profile' :[navLink] } } ], { relativeTo: this.route, skipLocationChange: true } );
      }
    }
    
    
    checkEditorStatus() : boolean {
        let cacheId = localStorage.getItem('editorId');
        if( cacheId ) {
            let choice = window.confirm("Discard current changes ?");
            console.log('choice', choice);
            if( choice ) {
                localStorage.removeItem('editorId');
                this.onDiscard.emit(cacheId);
                console.log('cacheId element >>' , cacheId);
            }
            return choice;
        }
        return true;
    }
    
    lowercase(str : string) : string{
        if( str )
            return str.toLowerCase();
        else 
            return str;
    }
    
}

class Links {
    name: string;
    navLink: string;
    isOpen: boolean;
}


const RESIZE_EVENT = Observable.fromEvent(window, 'resize')
    .map(() => {
        return { 'width' : document.documentElement.clientWidth, 'height' : document.documentElement.clientHeight };
    })
    .debounceTime(200);