import { Injectable } from '@angular/core';
import { Http, Response, Headers, RequestOptions } from '@angular/http';
import { Observable } from 'rxjs/Observable';
import 'rxjs/add/operator/catch';
import 'rxjs/add/operator/map';
import { Store } from '@ngrx/store';
import { AppState } from '../../ecm-store/reducers';
import { HostUrlService } from '../../host-url.service';
import { Item } from '../../ecm-model/product-model';
    

@Injectable()
export class EcmWishListService   {
 //   private wishListUrl = '/ecm/service/feeds/L2D01/wishlist';  // URL to web service
    private wishListUrl = '/ecm/service/feeds';
    wishListItems: Item[];
    public itemCode;

    constructor( private http: Http, private store: Store<AppState>,public hostUrlService : HostUrlService ) { }


    setWishlistItems() {
        this.fetchWishlistItems().subscribe(
            data => {
                this.wishListItems = data;
                if ( data && data != null ) {
                    this.wishListItems.forEach( item => {
                        //this.store.dispatch( { type: ADD_TO_WISHLIST, payload: item });
                    })
                }
            });
    }

    fetchWishlistItems(): Observable<Item[]> {
         console.log('hostUrl: inside wishlist service fetchWishlistItems['+ this.hostUrlService.hostUrl+this.wishListUrl+']');
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });
        let siteCode = localStorage.getItem('SITE_CODE'); 

        return this.http.get( this.hostUrlService.hostUrl+this.wishListUrl + '/' + siteCode + '/wishlist'  , options )
            .map( (res) => this.extractData(res) )
            .catch( this.handleError );
    }
    
    addToWishlist(itemCode) {
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });
        let siteCode = localStorage.getItem('SITE_CODE'); 
        
       return this.http.post( this.hostUrlService.hostUrl+this.wishListUrl + '/' + siteCode + '/wishlist' +'/' + itemCode , options)
                   .map( (res) => this.extractData(res) );
    }
    
    deleteWishlistItem(itemCode) {
        let headers = new Headers( { 'Content-Type': 'application/json' });
        let options = new RequestOptions( { headers: headers });
        let siteCode = localStorage.getItem('SITE_CODE');
        
        return this.http.delete( this.hostUrlService.hostUrl+this.wishListUrl + '/' + siteCode + '/wishlist' + '/' + itemCode, options)
                    .map( (res) => this.extractData(res) );
    }

    private extractData( res: Response ) {
        let respJson = res.json();
        console.log( 'extracData', respJson );
        if ( respJson != null ) {
            for ( let key of Object.keys( respJson ) ) {
                console.log( "getItemDetail itemDetail ==> key: " + key )
                let data = respJson[key];

                try {
                    respJson[key] = JSON.parse( data );
                    console.log( "getItemDetail itemDetail try : " + respJson[key] );
                }
                catch ( e ) {
                    console.log( "getItemDetail itemDetail ==> key: ", data, typeof data === 'object' )
                    if ( typeof data === 'object' )
                        respJson[key] = this.formatObject( data );
                    else
                        respJson[key] = data;
                    console.log( "getItemDetail itemDetail catch : " + respJson[key] );
                }
            }
            console.log( 'extractData[' + JSON.stringify( respJson ) + ']' );
        }
        return respJson || {};
    }

    formatObject( respJson: any ) {

        console.log( 'formatObject', respJson );
        if ( respJson != null ) {
            for ( let key of Object.keys( respJson ) ) {
                console.log( "formatObject itemDetail ==> key: " + key )
                let data = respJson[key];
                try {
                    respJson[key] = JSON.parse( data );
                    console.log( "formatObject itemDetail try : " + respJson[key] );
                }
                catch ( e ) {
                    respJson[key] = data;
                    console.log( "formatObject itemDetail catch : " + respJson[key] );
                }
            }
            console.log( 'formatObject[' + JSON.stringify( respJson ) + ']' );
        }
        return respJson || {};
    }

    private handleError( error: Response | any ) {
        // In a real world app, we might use a remote logging infrastructure
        let errMsg: string;
        if ( error instanceof Response ) {
            const body = error.json() || '';
            const err = body.error || JSON.stringify( body );
            errMsg = `${error.status} - ${error.statusText || ''} ${err}`;
        } else {
            errMsg = error.message ? error.message : error.toString();
        }
        console.error( 'Service handleError:' + errMsg );
        return Observable.throw( errMsg );
    }
    getItemCode() {
        console.log("getItems"+this.itemCode);
      return this.itemCode;
    }
    
    setItemCode(itemCode) {
     
     this.itemCode = itemCode;
           console.log("setItems"+this.itemCode);
    }
}
