import { Component, Input, ViewChild, OnChanges } from '@angular/core';

import { ItemDetail } from '../../ecm-model/product-detail-model';
import {EcmRelatedItemService} from './ecm-related-item.service';
import { Item } from '../../ecm-model/product-model';
import { EcmCarouselComponent } from '../../ecm-carousel/ecm-carousel.component';

declare var reinitFlickity: any;

@Component({
  selector: 'ecm-related-items',
  templateUrl: './ecm-related-items.component.html',
  styleUrls: ['./ecm-related-items.component.css'],
  providers: [EcmRelatedItemService]
})
export class EcmRelatedItemsComponent implements OnChanges {
  
  @Input() scatCode;
  
  relatedItems: ItemDetail[];
  errorMessage: string;
    
  constructor(private relatedItemService:EcmRelatedItemService) { }
 
  getRelatedItems(scatCode: string) {
      
      this.relatedItemService.getRelatedItems(scatCode).subscribe(
              relatedItems => {
          this.relatedItems = relatedItems;
          reinitFlickity();
          
          console.log('comp relatedItems[' +  JSON.stringify( relatedItems ) + '] \n this.relatedItems[' +  JSON.stringify( this.relatedItems ) + ']');
        },
        error =>  {
          this.errorMessage = <any>error;
          console.log('comp errorMessage[' + this.errorMessage + ']');
        });
  }
  
  ngOnChanges(){
      console.log("OnChanges of ecm-related-items called");
      this.getRelatedItems(this.scatCode);
  }

}
