import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';

import {ItemDetail} from '../../ecm-model/product-detail-model';
import {WishListActions} from '../actions';
import * as _ from 'lodash';

export type WishListState = ItemDetail[];

const initialState: WishListState = [];

export default function (state = initialState, action: Action): WishListState {
    switch (action.type){
        case WishListActions.LOAD_WISHLIST_ITEMS_SUCCESS: {
            return action.payload;
        }
        case WishListActions.ADD_TO_WISHLIST_SUCCESS: {
            return [...state, action.payload];
        }
        case WishListActions.DELETE_WISHLIST_ITEM_SUCCESS: {
            return state.filter(item => {
                return item.itemCode !== action.payload.itemCode;
            });
        }
        case WishListActions.RESET_WISHLIST: {
            return initialState;
        }
        default: {
            return state;
        }
    }
}