import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';

import {MenuActions} from '../actions';
import * as _ from 'lodash';

export type MenuState = any[];

const initialState: MenuState = [];

export default function (state = initialState, action: Action): MenuState {
    switch (action.type){
        case MenuActions.LOAD_MENU_SUCCESS: {
            return action.payload;
        }
        case MenuActions.RESET_MENU: {
            return initialState;
        }
        default: {
            return state;
        }
    }
}