import {Action} from '@ngrx/store';

import {ItemDetail} from '../../ecm-model/product-detail-model';
import {ItemActions} from '../actions';

export type ItemState = ItemDetail;
const initialState: ItemState = {
        itemCode: '',
        itemQuantity: 0,
        itemCategory: '',
        itemSubCategory: '',
        itemHeader: '', 
        itemDetail1: '', 
        itemDetail2: '', 
        itemRatings: '', 
        itemVariants: '',
        itemAttributes: [],
        productStatus: ''
};

export default function (state = initialState, action: Action): ItemState {
    switch (action.type) {
        case ItemActions.RESET_BLANK_ITEM: {
            return initialState;
        }
        case ItemActions.GET_ITEM_SUCCESS: {
            return action.payload;
        }
        default: {
            return state;
        }
    }
}