import {Action} from '@ngrx/store';
import {Observable} from 'rxjs/Observable';

import {Category} from '../../ecm-model/category-model';
import {CategoryActions} from '../actions';
import * as _ from 'lodash';

export type CategoryListState = Category[];

const initialState: CategoryListState = [];

export default function (state = initialState, action: Action): CategoryListState {
    switch (action.type){
        case CategoryActions.LOAD_CATEGORY_SUCCESS: {
            return action.payload;
        }
        case CategoryActions.RESET_CATEGORY_LIST: {
            return initialState;
        }
        default: {
            return state;
        }
    }
}