import {Injectable} from '@angular/core';
import {Effect, Actions} from '@ngrx/effects';

import {AppState} from '../reducers';
import {ProfileActions} from '../actions';
import {ProfileInfoService} from '../../user-profile/profile-info.service';
import 'rxjs/add/operator/switchMap';


@Injectable()
export class  ProfileEffects {
    constructor (
        private update$: Actions,
        private profileActions: ProfileActions,
        private svc: ProfileInfoService,
    ) {}

    @Effect() loadUserInfo$ = this.update$
        .ofType(ProfileActions.LOAD_USER_INFO)
        .switchMap(() => this.svc.fetchUserInfo())
        .map(user => this.profileActions.loadProfileSuccess(user));

    
    @Effect() updateUserInfo$ = this.update$
        .ofType(ProfileActions.UPDATE_USER_INFO)
        .map(action => action.payload)
        .switchMap(user => this.svc.updateUserInfo(user));
       // .map(user => this.profileActions.updateUserInfoSuccess(user));

    
}
