import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {ItemDetail} from '../../ecm-model/product-detail-model';

@Injectable()
export class WishListActions {
    static LOAD_WISHLIST_ITEMS = '[WISHLIST] Load WISHLIST Items';
    loadWishlistItems(): Action {
        return {
            type: WishListActions.LOAD_WISHLIST_ITEMS
        };
    }
    
    static LOAD_WISHLIST_ITEMS_SUCCESS = '[WISHLIST] Load WISHLIST Items Success';
    loadWishlistItemsSuccess(wishlistItems): Action {
        console.log('[Cart] Load Wishlist Items Success',wishlistItems.length);
        
        if(!wishlistItems.length)
        {
            wishlistItems = [];
        }
        return {
            type: WishListActions.LOAD_WISHLIST_ITEMS_SUCCESS,
            payload: wishlistItems
        };
        
    }
    
    static ADD_TO_WISHLIST = '[WISHLIST] Add to WISHLIST';
    addToWishlist(wishlistItem): Action {
        return {
            type: WishListActions.ADD_TO_WISHLIST,
            payload: wishlistItem
        };
    }

    static ADD_TO_WISHLIST_SUCCESS = '[WISHLIST] Add to WISHLIST Success';
    addToWishlistSuccess(wishlistItem): Action {
        return {
            type: WishListActions.ADD_TO_WISHLIST_SUCCESS,
            payload: wishlistItem
        };
    }
    
    static DELETE_WISHLIST_ITEM = '[WISHLIST] Delete WISHLIST_ITEM';
    deleteWishlistItem(item): Action {
        return {
            type: WishListActions.DELETE_WISHLIST_ITEM,
            payload: item
        };
    }

    static DELETE_WISHLIST_ITEM_SUCCESS = '[WISHLIST] Delete WISHLIST Success';
    deleteWishlistItemSuccess(item): Action {
        return {
            type: WishListActions.DELETE_WISHLIST_ITEM_SUCCESS,
            payload: item
        };
    }
    
    static RESET_WISHLIST = '[WISHLIST] Reset WISHLIST';
    resetWishlist(): Action {
        return {
            type: WishListActions.RESET_WISHLIST
        };
    }
}