import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {Profile} from '../../user-profile/profile-manager/profile.model';

@Injectable()
export class ProfileActions {
    
    static LOAD_USER_INFO = '[userInfo] Load Profile';
    loadProfile(): Action {
        console.log('Prajyot Initiate...');
        return {
            type: ProfileActions.LOAD_USER_INFO
        };
    }
    
    static LOAD_USER_INFO_SUCCESS = '[userInfo] Load Profile Success';
    loadProfileSuccess(user): Action {
        
        console.log('Prajyot Success...', user);
        return {
            type: ProfileActions.LOAD_USER_INFO_SUCCESS,
            payload: user
        };
        
    }
    
    static UPDATE_USER_INFO = '[userInfo] Update userInfo';
    updateUserInfo(user): Action {
        return {
            type: ProfileActions.UPDATE_USER_INFO,
            payload: user
        };
    }

    static UPDATE_USER_INFO_SUCCESS = '[userInfo] Update userInfo Success';
    updateUserInfoSuccess(user): Action {
        return {
            type: ProfileActions.UPDATE_USER_INFO_SUCCESS,
            payload: user
        };
    }
    
}
