import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

import {Address} from '../../user-address/address-manager/address.model';


export class AdressAction {
    
    static LOAD_ADDRESS = '[Address] Load Address';
    loadAddress(): Action {
        return {
            type: AdressAction.LOAD_ADDRESS
        };
    }
    
    static LOAD_ADDRESS_SUCCESS = '[Address] Load Address Success';
    loadAddressSuccess(userAddresses): Action {
        
        console.log('[Address] Load Address Success',userAddresses.length);
        
        if(!userAddresses.length)
        {
            userAddresses = [];
        }
        return {
            type: AdressAction.LOAD_ADDRESS_SUCCESS,
            payload: userAddresses
        };
    }
    
    static ADD_NEW_ADDRESS = '[Address] Add new Address';
    addNewAdddress(userAddress): Action {
        return {
            type: AdressAction.ADD_NEW_ADDRESS,
            payload: userAddress
        };
    }

    static ADD_NEW_ADDRESS_SUCCESS = '[Address] Add new Address Success';
    addNewAddressSuccess(userAddress): Action {
        return {
            type: AdressAction.ADD_NEW_ADDRESS_SUCCESS,
            payload: userAddress
        };
    }
    
    static UPDATE_ADDRESS = '[Address] Update Address';
    updateAddress(userAddress): Action {
        return {
            type: AdressAction.UPDATE_ADDRESS,
            payload: userAddress
        };
    }

    static UPDATE_ADDRESS_SUCCESS = '[Address] Update Address Success';
    updateAddressSuccess(userAddress): Action {
        return {
            type: AdressAction.UPDATE_ADDRESS_SUCCESS,
            payload: userAddress
        };
    }
    
    static DELETE_ADDRESS = '[Address] Delete Address';
    deleteAddress(userAddress): Action {
        return {
            type: AdressAction.DELETE_ADDRESS,
            payload: userAddress
        };
    }

    static DELETE_ADDRESS_SUCCESS = '[Address] Delete AddressSuccess';
    deleteAddressSuccess(userAddress): Action {
        return {
            type: AdressAction.DELETE_ADDRESS_SUCCESS,
            payload: userAddress
        };
    }
    
}
